/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.AuthConfirmationTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAuthConfirmationService;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.ScaAuthConfirmationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import java.util.EnumSet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareAuthConfirmationServiceImpl
implements MiddlewareAuthConfirmationService {
    private final SCAOperationService scaOperationService;
    private final DepositAccountPaymentService depositAccountPaymentService;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public AuthConfirmationTO verifyAuthConfirmationCode(String authorisationId, String authConfirmCode, String userLogin) {
        ScaAuthConfirmationBO authConfirmationBO = this.scaOperationService.verifyAuthConfirmationCode(authorisationId, authConfirmCode);
        return authConfirmationBO.isConfirm() ? this.buildAuthConfirmationTO(userLogin, authConfirmationBO) : new AuthConfirmationTO().success(false);
    }

    public AuthConfirmationTO completeAuthConfirmation(String authorisationId, boolean authCodeConfirmed, String userLogin) {
        ScaAuthConfirmationBO authConfirmationBO = this.scaOperationService.completeAuthConfirmation(authorisationId, authCodeConfirmed);
        if (authConfirmationBO.isConfirm()) {
            return this.buildAuthConfirmationTO(userLogin, authConfirmationBO);
        }
        AuthConfirmationTO confirmation = new AuthConfirmationTO().success(false);
        if (EnumSet.of(OpTypeBO.PAYMENT, OpTypeBO.CANCEL_PAYMENT).contains(authConfirmationBO.getOpTypeBO())) {
            TransactionStatusBO status = this.depositAccountPaymentService.updatePaymentStatus(authConfirmationBO.getOpId(), TransactionStatusBO.RJCT);
            confirmation.transactionStatus(TransactionStatusTO.valueOf((String)status.toString()));
        }
        return confirmation;
    }

    private AuthConfirmationTO buildAuthConfirmationTO(String userLogin, ScaAuthConfirmationBO authConfirmationBO) {
        AuthConfirmationTO confirmation = new AuthConfirmationTO().success(true);
        boolean authCompleted = this.scaOperationService.authenticationCompleted(authConfirmationBO.getOpId(), authConfirmationBO.getOpTypeBO());
        if (EnumSet.of(OpTypeBO.PAYMENT, OpTypeBO.CANCEL_PAYMENT).contains(authConfirmationBO.getOpTypeBO())) {
            if (authCompleted) {
                this.authCompleted(userLogin, authConfirmationBO, confirmation);
            } else if (this.multilevelScaEnable) {
                TransactionStatusBO status = this.depositAccountPaymentService.updatePaymentStatus(authConfirmationBO.getOpId(), TransactionStatusBO.PATC);
                confirmation.transactionStatus(TransactionStatusTO.valueOf((String)status.toString()));
            }
        } else if (OpTypeBO.CONSENT == authConfirmationBO.getOpTypeBO() && !authCompleted) {
            confirmation.partiallyAuthorised(this.multilevelScaEnable);
            confirmation.multilevelScaRequired(this.multilevelScaEnable);
        }
        return confirmation;
    }

    private void authCompleted(String userLogin, ScaAuthConfirmationBO authConfirmationBO, AuthConfirmationTO confirmation) {
        this.depositAccountPaymentService.updatePaymentStatus(authConfirmationBO.getOpId(), authConfirmationBO.getOpTypeBO() == OpTypeBO.PAYMENT ? TransactionStatusBO.ACTC : TransactionStatusBO.CANC);
        TransactionStatusBO status = authConfirmationBO.getOpTypeBO() == OpTypeBO.PAYMENT ? this.depositAccountPaymentService.executePayment(authConfirmationBO.getOpId(), userLogin) : TransactionStatusBO.CANC;
        confirmation.transactionStatus(TransactionStatusTO.valueOf((String)status.toString()));
    }

    public MiddlewareAuthConfirmationServiceImpl(SCAOperationService scaOperationService, DepositAccountPaymentService depositAccountPaymentService) {
        this.scaOperationService = scaOperationService;
        this.depositAccountPaymentService = depositAccountPaymentService;
    }
}

