/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.general.StepOperation;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.AisConsentBOMapper;
import de.adorsys.ledgers.middleware.impl.converter.AmountMapper;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseResolver;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.middleware.impl.service.message.PsuMessageResolver;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.DateTimeUtils;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareAccountManagementServiceImpl
implements MiddlewareAccountManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareAccountManagementServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private final UserMapper userMapper;
    private final DepositAccountService depositAccountService;
    private final DepositAccountTransactionService transactionService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentConverter paymentConverter;
    private final UserService userService;
    private final AisConsentBOMapper aisConsentMapper;
    private final SCAUtils scaUtils;
    private final AccessService accessService;
    private final AmountMapper amountMapper;
    private final PageMapper pageMapper;
    private final ScaResponseResolver scaResponseResolver;
    private final KeycloakTokenService tokenService;
    private final PsuMessageResolver messageResolver;
    @Value(value="${ledgers.token.lifetime.seconds.sca:10800}")
    private int scaTokenLifeTime;
    @Value(value="${ledgers.token.lifetime.seconds.full:7776000}")
    private int fullTokenLifeTime;
    @Value(value="${ledgers.sca.final.weight:100}")
    private int finalWeight;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public List<AccountDetailsTO> getAccountsByIbanAndCurrency(String iban, String currency) {
        return this.accountDetailsMapper.toAccountDetailsList(this.depositAccountService.getAccountsByIbanAndParamCurrency(iban, currency));
    }

    public void createDepositAccount(String userId, ScaInfoTO scaInfoTO, AccountDetailsTO depositAccount) {
        if (depositAccount.getCurrency() == null) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg("Can not create new account without currency set! Please set currency to continue.").build();
        }
        UserBO user = this.userService.findById(userId);
        this.checkPresentAccountsAndOwner(depositAccount.getIban(), user);
        DepositAccountBO createdAccount = this.depositAccountService.createNewAccount(this.accountDetailsMapper.toDepositAccountBO(depositAccount), user.getLogin(), user.getBranch());
        this.accessService.updateAccountAccessNewAccount(createdAccount, user, this.finalWeight, AccessTypeTO.OWNER);
    }

    public AccountDetailsTO getDepositAccountById(String accountId, LocalDateTime time, boolean withBalance) {
        DepositAccountDetailsBO accountDetailsBO = this.depositAccountService.getAccountDetailsById(accountId, time, true);
        return this.accountDetailsMapper.toAccountDetailsTO(accountDetailsBO);
    }

    public TransactionTO getTransactionById(String accountId, String transactionId) {
        TransactionDetailsBO transaction = this.depositAccountService.getTransactionById(accountId, transactionId);
        return this.paymentConverter.toTransactionTO(transaction);
    }

    public List<TransactionTO> getTransactionsByDates(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        log.info("Start retrieving transactions for {}", (Object)accountId);
        long start = System.nanoTime();
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = DateTimeUtils.getTimeAtEndOfTheDay((LocalDate)(dateTo == null ? today : dateTo));
        List transactions = this.depositAccountService.getTransactionsByDates(accountId, dateTimeFrom, dateTimeTo);
        log.info("Retrieved {} transactions in {} secs", (Object)transactions.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return this.paymentConverter.toTransactionTOList(transactions);
    }

    public CustomPageImpl<TransactionTO> getTransactionsByDatesPaged(String accountId, LocalDate dateFrom, LocalDate dateTo, CustomPageableImpl pageable) {
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = DateTimeUtils.getTimeAtEndOfTheDay((LocalDate)(dateTo == null ? today : dateTo));
        return this.pageMapper.toCustomPageImpl(this.depositAccountService.getTransactionsByDatesPaged(accountId, dateTimeFrom, dateTimeTo, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.paymentConverter::toTransactionTO));
    }

    public boolean confirmFundsAvailability(FundsConfirmationRequestTO request) {
        FundsConfirmationRequestBO requestBO = this.accountDetailsMapper.toFundsConfirmationRequestBO(request);
        return this.depositAccountService.confirmationOfFunds(requestBO);
    }

    public List<AccountDetailsTO> listDepositAccounts(String userId) {
        UserBO user = this.userService.findById(userId);
        return user.getAccountIds().stream().map(id -> this.depositAccountService.getAccountDetailsById(id, LocalDateTime.now(), true)).map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public List<AccountDetailsTO> listDepositAccountsByBranch(String userId) {
        UserBO user = this.userService.findById(userId);
        List depositAccounts = this.depositAccountService.findDetailsByBranch(user.getBranch());
        return this.accountDetailsMapper.toAccountDetailsTOList(depositAccounts);
    }

    public CustomPageImpl<AccountDetailsTO> listDepositAccountsByBranchPaged(String userId, String queryParam, boolean withBalance, CustomPageableImpl pageable) {
        UserBO user = this.userService.findById(userId);
        return this.pageMapper.toCustomPageImpl(this.depositAccountService.findDetailsByBranchPaged(user.getBranch(), queryParam, withBalance, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.accountDetailsMapper::toAccountDetailsTO));
    }

    public CustomPageImpl<AccountDetailsExtendedTO> getAccountsByBranchAndMultipleParams(String countryCode, String branchId, String branchLogin, String iban, Boolean blocked, CustomPageableImpl pageable) {
        Map branchIds = this.userService.findBranchIdsByMultipleParameters(countryCode, branchId, branchLogin);
        Page page = this.depositAccountService.findByBranchIdsAndMultipleParams(branchIds.keySet(), iban, blocked, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(d -> this.accountDetailsMapper.toAccountDetailsExtendedTO((DepositAccountBO)d, (String)branchIds.get(d.getBranch())));
        return this.pageMapper.toCustomPageImpl(page);
    }

    public String iban(String id) {
        return this.depositAccountService.readIbanById(id);
    }

    public SCAConsentResponseTO startAisConsent(ScaInfoTO scaInfoTO, String consentId, AisConsentTO aisConsent) {
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserLogin());
        boolean isScaRequired = user.hasSCA();
        String psuMessage = this.messageResolver.message(StepOperation.INITIATE_OPERATION_OBJECT, OpTypeBO.CONSENT, isScaRequired, this.aisConsentMapper.toAisConsentBO(aisConsent));
        BearerTokenTO token = isScaRequired ? this.tokenService.exchangeToken(scaInfoTO.getAccessToken(), Integer.valueOf(this.scaTokenLifeTime), "sca") : this.tokenService.exchangeToken(scaInfoTO.getAccessToken(), Integer.valueOf(this.fullTokenLifeTime), "full_access");
        ScaStatusTO scaStatus = isScaRequired ? ScaStatusTO.PSUAUTHENTICATED : ScaStatusTO.EXEMPTED;
        int scaWeight = user.resolveMinimalWeightForIbanSet(this.aisConsentMapper.toAisConsentBO(aisConsent).getUniqueIbans());
        SCAConsentResponseTO response = new SCAConsentResponseTO(consentId);
        this.scaResponseResolver.updateScaResponseFields(user, response, null, psuMessage, token, scaStatus, scaWeight);
        this.userService.storeConsent(this.aisConsentMapper.toAisConsentBO(aisConsent));
        return response;
    }

    public Set<String> getAccountsFromConsent(String consentId) {
        return this.userService.loadConsent(consentId).getUniqueIbans();
    }

    public SCAConsentResponseTO startPiisConsent(ScaInfoTO scaInfoTO, AisConsentTO aisConsent) {
        aisConsent.cleanupForPIIS();
        String psuMessage = this.messageResolver.message(StepOperation.INITIATE_OPERATION_OBJECT, OpTypeBO.PIIS_CONSENT, false, this.aisConsentMapper.toAisConsentBO(aisConsent));
        BearerTokenTO consentToken = this.tokenService.exchangeToken(scaInfoTO.getAccessToken(), Integer.valueOf(this.fullTokenLifeTime), "partial_access");
        return new SCAConsentResponseTO(consentToken, aisConsent.getId(), psuMessage);
    }

    public void depositCash(ScaInfoTO scaInfoTO, String accountId, AmountTO amount) {
        this.transactionService.depositCash(accountId, this.amountMapper.toAmountBO(amount), scaInfoTO.getUserLogin());
    }

    public AccountReportTO getAccountReport(String accountId) {
        long start = System.nanoTime();
        AccountDetailsTO details = this.getDepositAccountById(accountId, LocalDateTime.now(), true);
        log.info("Loaded details with balances in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        start = System.nanoTime();
        List<UserTO> users = this.userMapper.toUserTOList(this.userService.findUsersByIban(details.getIban()));
        log.info("Loaded users in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        return new AccountReportTO(details, users, this.multilevelScaEnable);
    }

    public boolean changeStatus(String accountId, boolean isSystemBlock) {
        DepositAccountBO account = this.depositAccountService.getAccountById(accountId);
        boolean lockStatusToSet = isSystemBlock ? !account.isSystemBlocked() : !account.isBlocked();
        this.depositAccountService.changeAccountsBlockedStatus(Collections.singleton(accountId), isSystemBlock, lockStatusToSet);
        return lockStatusToSet;
    }

    public void changeCreditLimit(String accountId, BigDecimal creditLimit) {
        this.depositAccountService.changeCreditLimit(accountId, creditLimit);
    }

    private void checkPresentAccountsAndOwner(String iban, UserBO user) {
        List accountsPresentByIban = this.depositAccountService.getAccountsByIbanAndParamCurrency(iban, "");
        if (CollectionUtils.isNotEmpty((Collection)accountsPresentByIban) && !user.getLogin().equals(((DepositAccountBO)accountsPresentByIban.get(0)).getName())) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg("The IBAN you're trying to create account for is already busy by another user").build();
        }
    }

    public MiddlewareAccountManagementServiceImpl(UserMapper userMapper, DepositAccountService depositAccountService, DepositAccountTransactionService transactionService, AccountDetailsMapper accountDetailsMapper, PaymentConverter paymentConverter, UserService userService, AisConsentBOMapper aisConsentMapper, SCAUtils scaUtils, AccessService accessService, AmountMapper amountMapper, PageMapper pageMapper, ScaResponseResolver scaResponseResolver, KeycloakTokenService tokenService, PsuMessageResolver messageResolver) {
        this.userMapper = userMapper;
        this.depositAccountService = depositAccountService;
        this.transactionService = transactionService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.paymentConverter = paymentConverter;
        this.userService = userService;
        this.aisConsentMapper = aisConsentMapper;
        this.scaUtils = scaUtils;
        this.accessService = accessService;
        this.amountMapper = amountMapper;
        this.pageMapper = pageMapper;
        this.scaResponseResolver = scaResponseResolver;
        this.tokenService = tokenService;
        this.messageResolver = messageResolver;
    }
}

