/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaDataInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.service.ScaChallengeDataResolver;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ScaResponseConverter {
    private final UserMapper userMapper;
    private final ScaChallengeDataResolver scaChallengeDataResolver;
    private final SCAOperationService scaOperationService;
    private final BearerTokenMapper tokenMapper;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public GlobalScaResponseTO mapResponse(SCAOperationBO operation, List<ScaUserDataBO> methods, String psuMessage, BearerTokenBO token, int scaWeight, String authConfirmationCode) {
        GlobalScaResponseTO response = new GlobalScaResponseTO();
        response.setOperationObjectId(operation.getOpId());
        response.setAuthorisationId(operation.getId());
        response.setExternalId(operation.getExternalId());
        response.setScaMethods(this.userMapper.toScaUserDataListTO(methods));
        response.setPsuMessage(psuMessage);
        response.setStatusDate(operation.getStatusTime());
        response.setBearerToken(this.tokenMapper.toBearerTokenTO(token));
        response.setExpiresInSeconds(operation.getValiditySeconds());
        response.setTan(operation.getTan());
        this.mapEnum(operation.getOpType(), OpTypeTO.class, arg_0 -> ((GlobalScaResponseTO)response).setOpType(arg_0));
        this.mapEnum(operation.getScaStatus(), ScaStatusTO.class, arg_0 -> ((GlobalScaResponseTO)response).setScaStatus(arg_0));
        if (response.getScaStatus() == ScaStatusTO.SCAMETHODSELECTED) {
            methods.stream().filter(m -> m.getId().equals(operation.getScaMethodId())).findFirst().map(this.userMapper::toScaUserDataTO).ifPresent(m -> response.setChallengeData(this.scaChallengeDataResolver.resolveScaChallengeData(m.getScaMethod()).getChallengeData(new ScaDataInfoTO(m, operation.getTan()))));
        }
        if (this.multilevelScaEnable) {
            response.setMultilevelScaRequired(scaWeight < 100);
            boolean completed = this.scaOperationService.authenticationCompleted(operation.getOpId(), operation.getOpType());
            response.setPartiallyAuthorised(!completed);
        }
        Optional.ofNullable(authConfirmationCode).ifPresent(arg_0 -> ((GlobalScaResponseTO)response).setAuthConfirmationCode(arg_0));
        return response;
    }

    private <T extends Enum<T>, R extends Enum<?>> void mapEnum(R mapped, Class<T> mapTo, Consumer<T> consumer) {
        Optional.ofNullable(mapped).map(Enum::name).map(n -> Enum.valueOf(mapTo, n)).ifPresent(consumer);
    }

    public ScaResponseConverter(UserMapper userMapper, ScaChallengeDataResolver scaChallengeDataResolver, SCAOperationService scaOperationService, BearerTokenMapper tokenMapper) {
        this.userMapper = userMapper;
        this.scaChallengeDataResolver = scaChallengeDataResolver;
        this.scaOperationService = scaOperationService;
        this.tokenMapper = tokenMapper;
    }
}

