/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.upload;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.impl.service.upload.ExpressionExecutionWrapper;
import de.adorsys.ledgers.middleware.impl.service.upload.PaymentGenerationService;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Currency;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadPaymentService {
    private static final Logger log = LoggerFactory.getLogger(UploadPaymentService.class);
    private final MiddlewarePaymentService middlewarePaymentService;
    private final PaymentGenerationService paymentGenerationService;

    public void uploadPayments(UploadedDataTO data, ScaInfoTO info) {
        if (data.isGeneratePayments()) {
            data.getUsers().stream().flatMap(u -> u.getAccountAccesses().stream()).forEach(u -> this.generateAndExecutePayments((AccountAccessTO)u, data, info));
        } else {
            data.getPayments().forEach(p -> ExpressionExecutionWrapper.execute(() -> {
                try {
                    SCAPaymentResponseTO payment = this.middlewarePaymentService.initiatePayment(info, p);
                    info.setBearerToken(new BearerTokenTO(null, null, 0, null, null, Collections.singleton("full_access")));
                    this.middlewarePaymentService.executePayment(info, payment.getPaymentId());
                }
                catch (Exception e) {
                    log.info("Seems payment already exist, skipping creation. {}", (Object)e.getMessage());
                }
            }));
        }
    }

    private void generateAndExecutePayments(AccountAccessTO access, UploadedDataTO data, ScaInfoTO info) {
        AccountBalanceTO debtorBalance = Optional.ofNullable((AccountBalanceTO)data.getBalances().get(access.getIban())).orElseGet(() -> this.buildAccountBalance(access.getIban(), Currency.getInstance("EUR"), BigDecimal.valueOf(100L)));
        Map<PaymentTypeTO, PaymentTO> payments = this.paymentGenerationService.generatePayments(debtorBalance, data.getBranch());
        payments.forEach((paymentType, payment) -> ExpressionExecutionWrapper.execute(() -> this.middlewarePaymentService.initiatePayment(info, payment)));
    }

    private AccountBalanceTO buildAccountBalance(String iban, Currency currency, BigDecimal amount) {
        AccountBalanceTO balance = new AccountBalanceTO();
        balance.setAmount(new AmountTO(currency, amount));
        balance.setIban(iban);
        return balance;
    }

    public UploadPaymentService(MiddlewarePaymentService middlewarePaymentService, PaymentGenerationService paymentGenerationService) {
        this.middlewarePaymentService = middlewarePaymentService;
        this.paymentGenerationService = paymentGenerationService;
    }
}

