/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.upload;

import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.impl.service.upload.ExpressionExecutionWrapper;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadDepositAccountService {
    private static final Logger log = LoggerFactory.getLogger(UploadDepositAccountService.class);
    private final MiddlewareAccountManagementService middlewareAccountService;

    public void uploadDepositAccounts(List<UserTO> users, Map<String, AccountDetailsTO> details, ScaInfoTO info) {
        if (CollectionUtils.isEmpty(users)) {
            return;
        }
        users.forEach(u -> this.createDepositAccount((UserTO)u, details, info));
    }

    private void createDepositAccount(UserTO user, Map<String, AccountDetailsTO> details, ScaInfoTO info) {
        user.getAccountAccesses().stream().filter(a -> details.containsKey(a.getIban())).map(a -> (AccountDetailsTO)details.get(a.getIban())).forEach(a -> ExpressionExecutionWrapper.execute(() -> {
            try {
                this.middlewareAccountService.createDepositAccount(user.getId(), info, a);
            }
            catch (Exception e) {
                log.info("Seems account is already present, skipping creation. {}", (Object)e.getMessage());
            }
        }));
    }

    public UploadDepositAccountService(MiddlewareAccountManagementService middlewareAccountService) {
        this.middlewareAccountService = middlewareAccountService;
    }
}

