/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.domain.um.ScaMethodTypeTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.ScaChallengeData;
import de.adorsys.ledgers.middleware.api.service.ScaChallengeDataResolver;
import de.adorsys.ledgers.middleware.impl.sca.AbstractScaChallengeData;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service
public class ScaChallengeDataResolverImpl<T extends AbstractScaChallengeData>
implements ScaChallengeDataResolver,
InitializingBean {
    private final Map<ScaMethodTypeTO, ScaChallengeData> container = new EnumMap<ScaMethodTypeTO, ScaChallengeData>(ScaMethodTypeTO.class);
    private final List<T> scaChallengeDataServices;

    public void afterPropertiesSet() {
        this.scaChallengeDataServices.forEach(service -> this.container.put(service.getScaMethodType(), (ScaChallengeData)service));
    }

    public ScaChallengeData resolveScaChallengeData(ScaMethodTypeTO scaMethodTypeTO) {
        return Optional.ofNullable(this.container.get(scaMethodTypeTO)).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.CAN_NOT_RESOLVE_SCA_CHALLENGE_DATA).devMsg("Can't resolve sca challenge data").build());
    }

    public ScaChallengeDataResolverImpl(List<T> scaChallengeDataServices) {
        this.scaChallengeDataServices = scaChallengeDataServices;
    }
}

