/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.StartScaOprTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRedirectScaService;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseConverter;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.ScaResponseMessageResolver;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareRedirectScaServiceImpl
implements MiddlewareRedirectScaService {
    private static final String NO_USER_MESSAGE = "No user message";
    @Value(value="${ledgers.sca.authCode.validity.seconds:180}")
    private int authCodeLifetime;
    private final UserService userService;
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final ScaResponseConverter scaResponseConverter;
    private final ScaResponseMessageResolver messageResolver;
    private final AccessService accessService;
    private final BearerTokenMapper bearerTokenMapper;

    public GlobalScaResponseTO startScaOperation(StartScaOprTO scaOpr, ScaInfoTO scaInfo) {
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        if (!user.hasSCA()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.SCA_UNAVAILABLE).devMsg("Sorry, but do not have any SCA Methods configured!").build();
        }
        OpTypeBO opType = OpTypeBO.valueOf((String)scaOpr.getOpType().name());
        int scaWeight = this.resolveWeightForOperation(opType, scaOpr.getOprId(), user);
        AuthCodeDataBO codeData = new AuthCodeDataBO(user.getLogin(), null, scaOpr.getOprId(), scaOpr.getExternalId(), NO_USER_MESSAGE, this.authCodeLifetime, opType, scaOpr.getAuthorisationId(), scaWeight);
        SCAOperationBO operation = this.scaOperationService.checkIfExistsOrNew(codeData);
        try {
            String message = this.messageResolver.updateMessage("", operation);
            BearerTokenBO bearerToken = this.bearerTokenMapper.toBearerTokenBO(scaInfo.getBearerToken());
            return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), message, bearerToken, scaWeight, null);
        }
        catch (MiddlewareModuleException e) {
            throw this.scaOperationService.updateFailedCount(operation.getId(), true);
        }
    }

    public GlobalScaResponseTO getMethods(String authorizationId, ScaInfoTO scaInfo) {
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(authorizationId);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), this.messageResolver.updateMessage("", operation), this.bearerTokenMapper.toBearerTokenBO(scaInfo.getBearerToken()), 0, null);
    }

    public GlobalScaResponseTO selectMethod(ScaInfoTO scaInfo) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(scaInfo.getAuthorisationId());
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        String psuMessage = "";
        int scaWeight = this.resolveWeightForOperation(operation.getOpType(), operation.getOpId(), user);
        AuthCodeDataBO data = new AuthCodeDataBO(user.getLogin(), scaInfo.getScaMethodId(), operation.getOpId(), null, psuMessage, this.authCodeLifetime, operation.getOpType(), operation.getId(), scaWeight);
        operation = this.scaOperationService.generateAuthCode(data, user, ScaStatusBO.SCAMETHODSELECTED);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), this.messageResolver.updateMessage(psuMessage, operation), this.bearerTokenMapper.toBearerTokenBO(scaInfo.getBearerToken()), scaWeight, null);
    }

    public GlobalScaResponseTO confirmAuthorization(ScaInfoTO scaInfo) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(scaInfo.getAuthorisationId());
        UserBO user = this.userService.findByLogin(scaInfo.getUserLogin());
        int scaWeight = this.resolveWeightForOperation(operation.getOpType(), operation.getOpId(), user);
        String psuMessage = this.messageResolver.getTemplate(operation);
        ScaValidationBO scaValidation = this.scaOperationService.validateAuthCode(scaInfo.getAuthorisationId(), operation.getOpId(), scaInfo.getAuthCode(), scaWeight);
        operation.setScaStatus(scaValidation.getScaStatus());
        boolean authenticationCompleted = this.scaOperationService.authenticationCompleted(operation.getOpId(), operation.getOpType());
        BearerTokenTO exchangeToken = this.accessService.exchangeTokenEndSca(authenticationCompleted, scaInfo.getAccessToken());
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), this.messageResolver.updateMessage(psuMessage, operation), this.bearerTokenMapper.toBearerTokenBO(exchangeToken), scaWeight, scaValidation.getAuthConfirmationCode());
    }

    public StartScaOprTO loadScaInformation(String authorizationId) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(authorizationId);
        return new StartScaOprTO(operation.getOpId(), OpTypeTO.valueOf((String)operation.getOpType().name()));
    }

    private int resolveWeightForOperation(OpTypeBO opType, String oprId, UserBO user) {
        return opType == OpTypeBO.CONSENT ? user.resolveMinimalWeightForIbanSet(this.userService.loadConsent(oprId).getUniqueIbans()) : user.resolveWeightForAccount(this.paymentService.getPaymentById(oprId).getAccountId());
    }

    public MiddlewareRedirectScaServiceImpl(UserService userService, DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, ScaResponseConverter scaResponseConverter, ScaResponseMessageResolver messageResolver, AccessService accessService, BearerTokenMapper bearerTokenMapper) {
        this.userService = userService;
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.scaResponseConverter = scaResponseConverter;
        this.messageResolver = messageResolver;
        this.accessService = accessService;
        this.bearerTokenMapper = bearerTokenMapper;
    }
}

