/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.service.DepositAccountCleanupService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakDataService;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRecoveryService;
import de.adorsys.ledgers.middleware.impl.converter.RecoveryPointMapperTO;
import de.adorsys.ledgers.sca.domain.RecoveryPointBO;
import de.adorsys.ledgers.sca.service.RecoveryPointService;
import de.adorsys.ledgers.um.api.service.UserService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareRecoveryPointServiceImpl
implements MiddlewareRecoveryService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareRecoveryPointServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private static final ExecutorService FIXED_THREAD_POOL = Executors.newFixedThreadPool(20);
    private final RecoveryPointService pointService;
    private final RecoveryPointMapperTO mapper;
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final DepositAccountCleanupService depositAccountCleanupService;
    private final KeycloakDataService keycloakDataService;

    public void createRecoveryPoint(String branchId, RecoveryPointTO recoveryPoint) {
        RecoveryPointBO recoveryPointBO = this.mapper.toBO(recoveryPoint);
        recoveryPointBO.setBranchId(branchId);
        this.pointService.createRecoveryPoint(recoveryPointBO);
    }

    public List<RecoveryPointTO> getAll(String branchId) {
        return this.mapper.toTOs(this.pointService.getAllByBranch(branchId));
    }

    public RecoveryPointTO getPointById(String branchId, Long id) {
        return this.mapper.toTO(this.pointService.getById(id.longValue(), branchId));
    }

    public void deleteById(String branchId, Long id) {
        this.pointService.deleteRecoveryPoint(id.longValue(), branchId);
    }

    @Transactional
    public void revertDatabase(String userId, long recoveryPointId) {
        long start = System.nanoTime();
        log.info("Started reverting state for {}", (Object)userId);
        RecoveryPointTO point = this.getPointById(userId, recoveryPointId);
        this.systemBlockBranch(userId, true);
        log.info("All branch data is LOCKED in {} seconds", (Object)((double)(System.nanoTime() - start) / 1.0E9));
        this.userService.findUsersByBranchAndCreatedAfter(userId, point.getRollBackTime()).forEach(user -> this.keycloakDataService.deleteUser(user.getLogin()));
        this.depositAccountCleanupService.rollBackBranch(userId, point.getRollBackTime());
        this.systemBlockBranch(userId, false);
        log.info("Reverted data and unlocked branch in {}s", (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    private void systemBlockBranch(String branchId, boolean statusToSet) {
        CompletableFuture.runAsync(() -> this.userService.setBranchBlockedStatus(branchId, true, statusToSet), FIXED_THREAD_POOL).thenRunAsync(() -> this.depositAccountService.changeAccountsBlockedStatus(branchId, true, statusToSet));
    }

    public MiddlewareRecoveryPointServiceImpl(RecoveryPointService pointService, RecoveryPointMapperTO mapper, UserService userService, DepositAccountService depositAccountService, DepositAccountCleanupService depositAccountCleanupService, KeycloakDataService keycloakDataService) {
        this.pointService = pointService;
        this.mapper = mapper;
        this.userService = userService;
        this.depositAccountService = depositAccountService;
        this.depositAccountCleanupService = depositAccountCleanupService;
        this.keycloakDataService = keycloakDataService;
    }
}

