/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.service.DepositAccountCleanupService;
import de.adorsys.ledgers.keycloak.client.api.KeycloakDataService;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareCleanupService;
import de.adorsys.ledgers.um.api.service.UserService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareCleanupServiceImpl
implements MiddlewareCleanupService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareCleanupServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private final UserService userService;
    private final DepositAccountCleanupService depositAccountCleanupService;
    private final KeycloakDataService keycloakDataService;

    public void deleteTransactions(String userId, UserRoleTO userRole, String accountId) {
        log.info("User {} attempting delete postings for account: {}", (Object)userId, (Object)accountId);
        long start = System.nanoTime();
        this.depositAccountCleanupService.deleteTransactions(accountId);
        log.info("Deleting postings for account: {} Successful, in {} seconds", (Object)accountId, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public void deleteAccount(String userId, UserRoleTO userRole, String accountId) {
        log.info("User {} attempting delete account: {}", (Object)userId, (Object)accountId);
        long start = System.nanoTime();
        this.depositAccountCleanupService.deleteAccount(accountId);
        log.info("Deleting account: {} Successful, in {} seconds", (Object)accountId, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public void deleteUser(String userId, UserRoleTO userRole, String userToDeleteId) {
        log.info("User {} attempting delete user: {}", (Object)userId, (Object)userToDeleteId);
        long start = System.nanoTime();
        String login = this.userService.findById(userToDeleteId).getLogin();
        this.depositAccountCleanupService.deleteUser(userToDeleteId);
        this.keycloakDataService.deleteUser(login);
        log.info("Deleting user: {} Successful, in {} seconds", (Object)userToDeleteId, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    @Transactional
    public void removeBranch(String userId, UserRoleTO userRole, String branchId) {
        log.info("User {} attempting delete branch {}", (Object)userId, (Object)branchId);
        long start = System.nanoTime();
        this.userService.findUserLoginsByBranch(branchId).forEach(arg_0 -> ((KeycloakDataService)this.keycloakDataService).deleteUser(arg_0));
        this.depositAccountCleanupService.deleteBranch(branchId);
        log.info("Deleting branch {} Successful, in {} seconds", (Object)branchId, (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start));
    }

    public MiddlewareCleanupServiceImpl(UserService userService, DepositAccountCleanupService depositAccountCleanupService, KeycloakDataService keycloakDataService) {
        this.userService = userService;
        this.depositAccountCleanupService = depositAccountCleanupService;
        this.keycloakDataService = keycloakDataService;
    }
}

