/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.service.EmailVerificationService;
import de.adorsys.ledgers.middleware.impl.config.EmailVerificationProperties;
import de.adorsys.ledgers.um.api.domain.EmailVerificationBO;
import de.adorsys.ledgers.um.api.domain.EmailVerificationStatusBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.service.ScaUserDataService;
import de.adorsys.ledgers.um.api.service.ScaVerificationService;
import de.adorsys.ledgers.util.exception.UserManagementErrorCode;
import de.adorsys.ledgers.util.exception.UserManagementModuleException;
import org.springframework.stereotype.Service;

@Service
public class EmailVerificationServiceImpl
implements EmailVerificationService {
    private static final EmailVerificationStatusBO STATUS_VERIFIED = EmailVerificationStatusBO.VERIFIED;
    private static final EmailVerificationStatusBO STATUS_PENDING = EmailVerificationStatusBO.PENDING;
    private final ScaVerificationService scaVerificationService;
    private final ScaUserDataService scaUserDataService;
    private final EmailVerificationProperties configProperties;

    public String createVerificationToken(String email) {
        EmailVerificationBO emailVerification;
        ScaUserDataBO scaUserDataBO = this.scaUserDataService.findByEmail(email);
        try {
            emailVerification = this.scaVerificationService.findByScaIdAndStatusNot(scaUserDataBO.getId(), STATUS_VERIFIED).updateExpiration();
        }
        catch (UserManagementModuleException e) {
            this.scaVerificationService.deleteByScaId(scaUserDataBO.getId());
            scaUserDataBO.setValid(false);
            this.scaUserDataService.updateScaUserData(scaUserDataBO);
            emailVerification = new EmailVerificationBO(scaUserDataBO);
        }
        this.scaVerificationService.updateEmailVerification(emailVerification);
        return emailVerification.getToken();
    }

    public void sendVerificationEmail(String token) {
        EmailVerificationBO emailVerificationBO = this.scaVerificationService.findByToken(token);
        ScaUserDataBO scaUserDataBO = emailVerificationBO.getScaUserData();
        this.scaVerificationService.sendMessage(this.configProperties.getTemplate().getSubject(), this.configProperties.getTemplate().getFrom(), scaUserDataBO.getMethodValue(), emailVerificationBO.formatMessage(this.configProperties.getTemplate().getMessage(), this.configProperties.getExtBasePath(), this.configProperties.getEndPoint(), emailVerificationBO.getToken(), emailVerificationBO.getExpiredDateTime()));
    }

    public void confirmUser(String token) {
        EmailVerificationBO emailVerification = this.scaVerificationService.findByTokenAndStatus(token, STATUS_PENDING);
        if (emailVerification.isExpired()) {
            throw UserManagementModuleException.builder().errorCode(UserManagementErrorCode.EXPIRED_TOKEN).devMsg(String.format("Verification token for email %s is expired for confirmation", emailVerification.getScaUserData().getMethodValue())).build();
        }
        ScaUserDataBO scaUserDataBO = this.scaUserDataService.findByEmail(emailVerification.getScaUserData().getMethodValue());
        scaUserDataBO.setValid(true);
        emailVerification.confirmVerification();
        this.scaVerificationService.updateEmailVerification(emailVerification);
        this.scaUserDataService.updateScaUserData(scaUserDataBO);
    }

    public EmailVerificationServiceImpl(ScaVerificationService scaVerificationService, ScaUserDataService scaUserDataService, EmailVerificationProperties configProperties) {
        this.scaVerificationService = scaVerificationService;
        this.scaUserDataService = scaUserDataService;
        this.configProperties = configProperties;
    }
}

