/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.keycloak.client.api.KeycloakTokenService;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AccessService {
    private final UserService userService;
    private final KeycloakTokenService tokenService;
    @Value(value="${ledgers.sca.final.weight:100}")
    private int finalWeight;
    @Value(value="${ledgers.token.lifetime.seconds.sca:10800}")
    private int scaTokenLifeTime;
    @Value(value="${ledgers.token.lifetime.seconds.full:7776000}")
    private int fullTokenLifeTime;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public void updateAccountAccessNewAccount(DepositAccountBO createdAccount, UserBO user, Integer scaWeight, AccessTypeTO accessType) {
        accessType = Optional.ofNullable(accessType).orElse(AccessTypeTO.OWNER);
        scaWeight = Optional.ofNullable(scaWeight).orElse(this.finalWeight);
        AccountAccessBO accountAccess = new AccountAccessBO(createdAccount.getIban(), createdAccount.getCurrency(), createdAccount.getId(), scaWeight.intValue(), AccessTypeBO.valueOf((String)accessType.name()));
        this.updateAccountAccess(user, accountAccess);
        if (StringUtils.isNotBlank((CharSequence)user.getBranch())) {
            UserBO branch = this.userService.findById(user.getBranch());
            this.updateAccountAccess(branch, accountAccess.setWeight(this.finalWeight));
        }
    }

    private void updateAccountAccess(UserBO user, AccountAccessBO access) {
        if (user.hasAccessToAccountWithId(access.getAccountId())) {
            user.updateExistingAccess(access);
        } else {
            user.addNewAccess(access);
        }
        this.userService.updateAccountAccess(user.getLogin(), user.getAccountAccesses());
    }

    public BearerTokenTO exchangeTokenStartSca(boolean scaRequired, String accessToken) {
        return scaRequired ? this.tokenService.exchangeToken(accessToken, Integer.valueOf(this.scaTokenLifeTime), "sca") : this.tokenService.exchangeToken(accessToken, Integer.valueOf(this.fullTokenLifeTime), "full_access");
    }

    public BearerTokenTO exchangeTokenEndSca(boolean authenticationCompleted, String accessToken) {
        String scope = this.multilevelScaEnable && !authenticationCompleted ? "partial_access" : "full_access";
        return this.tokenService.exchangeToken(accessToken, Integer.valueOf(this.fullTokenLifeTime), scope);
    }

    public AccessService(UserService userService, KeycloakTokenService tokenService) {
        this.userService = userService;
        this.tokenService = tokenService;
    }
}

