package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AccountTypeBO;
import de.adorsys.ledgers.deposit.api.domain.AccountUsageBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceTypeBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO.DepositAccountBOBuilder;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.BalanceTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.UsageTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-10-27T16:17:10+0000",
    comments = "version: 1.3.1.Final, compiler: javac, environment: Java 1.8.0_272 (Azul Systems, Inc.)"
)
@Component
public class AccountDetailsMapperImpl extends AccountDetailsMapper {

    @Override
    public AccountDetailsTO toAccountDetailsTO(DepositAccountBO details, List<BalanceBO> balances) {
        if ( details == null && balances == null ) {
            return null;
        }

        AccountDetailsTO accountDetailsTO = new AccountDetailsTO();

        if ( details != null ) {
            accountDetailsTO.setId( details.getId() );
            accountDetailsTO.setIban( details.getIban() );
            accountDetailsTO.setBban( details.getBban() );
            accountDetailsTO.setPan( details.getPan() );
            accountDetailsTO.setMaskedPan( details.getMaskedPan() );
            accountDetailsTO.setMsisdn( details.getMsisdn() );
            accountDetailsTO.setCurrency( details.getCurrency() );
            accountDetailsTO.setName( details.getName() );
            accountDetailsTO.setProduct( details.getProduct() );
            accountDetailsTO.setAccountType( accountTypeBOToAccountTypeTO( details.getAccountType() ) );
            accountDetailsTO.setBic( details.getBic() );
            accountDetailsTO.setLinkedAccounts( details.getLinkedAccounts() );
            accountDetailsTO.setUsageType( accountUsageBOToUsageTypeTO( details.getUsageType() ) );
            accountDetailsTO.setDetails( details.getDetails() );
            accountDetailsTO.setBlocked( details.isBlocked() );
            accountDetailsTO.setSystemBlocked( details.isSystemBlocked() );
            accountDetailsTO.setBranch( details.getBranch() );
        }
        if ( balances != null ) {
            accountDetailsTO.setBalances( balanceBOListToAccountBalanceTOList( balances ) );
        }
        accountDetailsTO.setAccountStatus( toAccountStatusTO(details) );

        return accountDetailsTO;
    }

    @Override
    public AccountDetailsExtendedTO toAccountDetailsExtendedTO(DepositAccountBO source, String branchLogin) {
        if ( source == null && branchLogin == null ) {
            return null;
        }

        AccountDetailsExtendedTO accountDetailsExtendedTO = new AccountDetailsExtendedTO();

        if ( source != null ) {
            accountDetailsExtendedTO.setId( source.getId() );
            accountDetailsExtendedTO.setIban( source.getIban() );
            accountDetailsExtendedTO.setBban( source.getBban() );
            accountDetailsExtendedTO.setPan( source.getPan() );
            accountDetailsExtendedTO.setMaskedPan( source.getMaskedPan() );
            accountDetailsExtendedTO.setMsisdn( source.getMsisdn() );
            accountDetailsExtendedTO.setCurrency( source.getCurrency() );
            accountDetailsExtendedTO.setName( source.getName() );
            accountDetailsExtendedTO.setProduct( source.getProduct() );
            accountDetailsExtendedTO.setAccountType( accountTypeBOToAccountTypeTO( source.getAccountType() ) );
            accountDetailsExtendedTO.setBic( source.getBic() );
            accountDetailsExtendedTO.setLinkedAccounts( source.getLinkedAccounts() );
            accountDetailsExtendedTO.setUsageType( accountUsageBOToUsageTypeTO( source.getUsageType() ) );
            accountDetailsExtendedTO.setDetails( source.getDetails() );
            accountDetailsExtendedTO.setBlocked( source.isBlocked() );
            accountDetailsExtendedTO.setSystemBlocked( source.isSystemBlocked() );
            accountDetailsExtendedTO.setBranch( source.getBranch() );
        }
        if ( branchLogin != null ) {
            accountDetailsExtendedTO.setBranchLogin( branchLogin );
        }

        return accountDetailsExtendedTO;
    }

    @Override
    public DepositAccountBO toDepositAccountBO(AccountDetailsTO source) {
        if ( source == null ) {
            return null;
        }

        DepositAccountBOBuilder depositAccountBO = DepositAccountBO.builder();

        depositAccountBO.id( source.getId() );
        depositAccountBO.iban( source.getIban() );
        depositAccountBO.bban( source.getBban() );
        depositAccountBO.pan( source.getPan() );
        depositAccountBO.maskedPan( source.getMaskedPan() );
        depositAccountBO.msisdn( source.getMsisdn() );
        depositAccountBO.currency( source.getCurrency() );
        depositAccountBO.name( source.getName() );
        depositAccountBO.product( source.getProduct() );
        depositAccountBO.accountType( accountTypeTOToAccountTypeBO( source.getAccountType() ) );
        depositAccountBO.bic( source.getBic() );
        depositAccountBO.linkedAccounts( source.getLinkedAccounts() );
        depositAccountBO.usageType( usageTypeTOToAccountUsageBO( source.getUsageType() ) );
        depositAccountBO.details( source.getDetails() );
        depositAccountBO.blocked( source.isBlocked() );
        depositAccountBO.systemBlocked( source.isSystemBlocked() );
        depositAccountBO.branch( source.getBranch() );

        return depositAccountBO.build();
    }

    @Override
    public List<AccountDetailsTO> toAccountDetailsTOList(List<DepositAccountDetailsBO> source) {
        if ( source == null ) {
            return null;
        }

        List<AccountDetailsTO> list = new ArrayList<AccountDetailsTO>( source.size() );
        for ( DepositAccountDetailsBO depositAccountDetailsBO : source ) {
            list.add( toAccountDetailsTO( depositAccountDetailsBO ) );
        }

        return list;
    }

    @Override
    public FundsConfirmationRequestBO toFundsConfirmationRequestBO(FundsConfirmationRequestTO source) {
        if ( source == null ) {
            return null;
        }

        FundsConfirmationRequestBO fundsConfirmationRequestBO = new FundsConfirmationRequestBO();

        fundsConfirmationRequestBO.setPsuId( source.getPsuId() );
        fundsConfirmationRequestBO.setPsuAccount( accountReferenceTOToAccountReferenceBO( source.getPsuAccount() ) );
        fundsConfirmationRequestBO.setInstructedAmount( amountTOToAmountBO( source.getInstructedAmount() ) );
        fundsConfirmationRequestBO.setCardNumber( source.getCardNumber() );
        fundsConfirmationRequestBO.setPayee( source.getPayee() );

        return fundsConfirmationRequestBO;
    }

    @Override
    public List<AccountDetailsTO> toAccountDetailsList(List<DepositAccountBO> source) {
        if ( source == null ) {
            return null;
        }

        List<AccountDetailsTO> list = new ArrayList<AccountDetailsTO>( source.size() );
        for ( DepositAccountBO depositAccountBO : source ) {
            list.add( depositAccountBOToAccountDetailsTO( depositAccountBO ) );
        }

        return list;
    }

    @Override
    public List<AccountReferenceBO> toAccountReferenceList(List<AccountAccessBO> source) {
        if ( source == null ) {
            return null;
        }

        List<AccountReferenceBO> list = new ArrayList<AccountReferenceBO>( source.size() );
        for ( AccountAccessBO accountAccessBO : source ) {
            list.add( accountAccessBOToAccountReferenceBO( accountAccessBO ) );
        }

        return list;
    }

    protected AccountTypeTO accountTypeBOToAccountTypeTO(AccountTypeBO accountTypeBO) {
        if ( accountTypeBO == null ) {
            return null;
        }

        AccountTypeTO accountTypeTO;

        switch ( accountTypeBO ) {
            case CACC: accountTypeTO = AccountTypeTO.CACC;
            break;
            case CASH: accountTypeTO = AccountTypeTO.CASH;
            break;
            case CHAR: accountTypeTO = AccountTypeTO.CHAR;
            break;
            case CISH: accountTypeTO = AccountTypeTO.CISH;
            break;
            case COMM: accountTypeTO = AccountTypeTO.COMM;
            break;
            case CPAC: accountTypeTO = AccountTypeTO.CPAC;
            break;
            case LLSV: accountTypeTO = AccountTypeTO.LLSV;
            break;
            case LOAN: accountTypeTO = AccountTypeTO.LOAN;
            break;
            case MGLD: accountTypeTO = AccountTypeTO.MGLD;
            break;
            case MOMA: accountTypeTO = AccountTypeTO.MOMA;
            break;
            case NREX: accountTypeTO = AccountTypeTO.NREX;
            break;
            case ODFT: accountTypeTO = AccountTypeTO.ODFT;
            break;
            case ONDP: accountTypeTO = AccountTypeTO.ONDP;
            break;
            case OTHR: accountTypeTO = AccountTypeTO.OTHR;
            break;
            case SACC: accountTypeTO = AccountTypeTO.SACC;
            break;
            case SLRY: accountTypeTO = AccountTypeTO.SLRY;
            break;
            case SVGS: accountTypeTO = AccountTypeTO.SVGS;
            break;
            case TAXE: accountTypeTO = AccountTypeTO.TAXE;
            break;
            case TRAN: accountTypeTO = AccountTypeTO.TRAN;
            break;
            case TRAS: accountTypeTO = AccountTypeTO.TRAS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountTypeBO );
        }

        return accountTypeTO;
    }

    protected UsageTypeTO accountUsageBOToUsageTypeTO(AccountUsageBO accountUsageBO) {
        if ( accountUsageBO == null ) {
            return null;
        }

        UsageTypeTO usageTypeTO;

        switch ( accountUsageBO ) {
            case PRIV: usageTypeTO = UsageTypeTO.PRIV;
            break;
            case ORGA: usageTypeTO = UsageTypeTO.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountUsageBO );
        }

        return usageTypeTO;
    }

    protected AmountTO amountBOToAmountTO(AmountBO amountBO) {
        if ( amountBO == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( amountBO.getCurrency() );
        amountTO.setAmount( amountBO.getAmount() );

        return amountTO;
    }

    protected BalanceTypeTO balanceTypeBOToBalanceTypeTO(BalanceTypeBO balanceTypeBO) {
        if ( balanceTypeBO == null ) {
            return null;
        }

        BalanceTypeTO balanceTypeTO;

        switch ( balanceTypeBO ) {
            case CLOSING_BOOKED: balanceTypeTO = BalanceTypeTO.CLOSING_BOOKED;
            break;
            case EXPECTED: balanceTypeTO = BalanceTypeTO.EXPECTED;
            break;
            case INTERIM_BOOKED: balanceTypeTO = BalanceTypeTO.INTERIM_BOOKED;
            break;
            case OPENING_BOOKED: balanceTypeTO = BalanceTypeTO.OPENING_BOOKED;
            break;
            case INTERIM_AVAILABLE: balanceTypeTO = BalanceTypeTO.INTERIM_AVAILABLE;
            break;
            case FORWARD_AVAILABLE: balanceTypeTO = BalanceTypeTO.FORWARD_AVAILABLE;
            break;
            case NONINVOICED: balanceTypeTO = BalanceTypeTO.NONINVOICED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + balanceTypeBO );
        }

        return balanceTypeTO;
    }

    protected AccountBalanceTO balanceBOToAccountBalanceTO(BalanceBO balanceBO) {
        if ( balanceBO == null ) {
            return null;
        }

        AccountBalanceTO accountBalanceTO = new AccountBalanceTO();

        accountBalanceTO.setAmount( amountBOToAmountTO( balanceBO.getAmount() ) );
        accountBalanceTO.setBalanceType( balanceTypeBOToBalanceTypeTO( balanceBO.getBalanceType() ) );
        accountBalanceTO.setLastChangeDateTime( balanceBO.getLastChangeDateTime() );
        accountBalanceTO.setReferenceDate( balanceBO.getReferenceDate() );
        accountBalanceTO.setLastCommittedTransaction( balanceBO.getLastCommittedTransaction() );

        return accountBalanceTO;
    }

    protected List<AccountBalanceTO> balanceBOListToAccountBalanceTOList(List<BalanceBO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountBalanceTO> list1 = new ArrayList<AccountBalanceTO>( list.size() );
        for ( BalanceBO balanceBO : list ) {
            list1.add( balanceBOToAccountBalanceTO( balanceBO ) );
        }

        return list1;
    }

    protected AccountTypeBO accountTypeTOToAccountTypeBO(AccountTypeTO accountTypeTO) {
        if ( accountTypeTO == null ) {
            return null;
        }

        AccountTypeBO accountTypeBO;

        switch ( accountTypeTO ) {
            case CACC: accountTypeBO = AccountTypeBO.CACC;
            break;
            case CASH: accountTypeBO = AccountTypeBO.CASH;
            break;
            case CHAR: accountTypeBO = AccountTypeBO.CHAR;
            break;
            case CISH: accountTypeBO = AccountTypeBO.CISH;
            break;
            case COMM: accountTypeBO = AccountTypeBO.COMM;
            break;
            case CPAC: accountTypeBO = AccountTypeBO.CPAC;
            break;
            case LLSV: accountTypeBO = AccountTypeBO.LLSV;
            break;
            case LOAN: accountTypeBO = AccountTypeBO.LOAN;
            break;
            case MGLD: accountTypeBO = AccountTypeBO.MGLD;
            break;
            case MOMA: accountTypeBO = AccountTypeBO.MOMA;
            break;
            case NREX: accountTypeBO = AccountTypeBO.NREX;
            break;
            case ODFT: accountTypeBO = AccountTypeBO.ODFT;
            break;
            case ONDP: accountTypeBO = AccountTypeBO.ONDP;
            break;
            case OTHR: accountTypeBO = AccountTypeBO.OTHR;
            break;
            case SACC: accountTypeBO = AccountTypeBO.SACC;
            break;
            case SLRY: accountTypeBO = AccountTypeBO.SLRY;
            break;
            case SVGS: accountTypeBO = AccountTypeBO.SVGS;
            break;
            case TAXE: accountTypeBO = AccountTypeBO.TAXE;
            break;
            case TRAN: accountTypeBO = AccountTypeBO.TRAN;
            break;
            case TRAS: accountTypeBO = AccountTypeBO.TRAS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accountTypeTO );
        }

        return accountTypeBO;
    }

    protected AccountUsageBO usageTypeTOToAccountUsageBO(UsageTypeTO usageTypeTO) {
        if ( usageTypeTO == null ) {
            return null;
        }

        AccountUsageBO accountUsageBO;

        switch ( usageTypeTO ) {
            case PRIV: accountUsageBO = AccountUsageBO.PRIV;
            break;
            case ORGA: accountUsageBO = AccountUsageBO.ORGA;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + usageTypeTO );
        }

        return accountUsageBO;
    }

    protected AccountReferenceBO accountReferenceTOToAccountReferenceBO(AccountReferenceTO accountReferenceTO) {
        if ( accountReferenceTO == null ) {
            return null;
        }

        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();

        accountReferenceBO.setIban( accountReferenceTO.getIban() );
        accountReferenceBO.setBban( accountReferenceTO.getBban() );
        accountReferenceBO.setPan( accountReferenceTO.getPan() );
        accountReferenceBO.setMaskedPan( accountReferenceTO.getMaskedPan() );
        accountReferenceBO.setMsisdn( accountReferenceTO.getMsisdn() );
        accountReferenceBO.setCurrency( accountReferenceTO.getCurrency() );

        return accountReferenceBO;
    }

    protected AmountBO amountTOToAmountBO(AmountTO amountTO) {
        if ( amountTO == null ) {
            return null;
        }

        AmountBO amountBO = new AmountBO();

        amountBO.setCurrency( amountTO.getCurrency() );
        amountBO.setAmount( amountTO.getAmount() );

        return amountBO;
    }

    protected AccountDetailsTO depositAccountBOToAccountDetailsTO(DepositAccountBO depositAccountBO) {
        if ( depositAccountBO == null ) {
            return null;
        }

        AccountDetailsTO accountDetailsTO = new AccountDetailsTO();

        accountDetailsTO.setId( depositAccountBO.getId() );
        accountDetailsTO.setIban( depositAccountBO.getIban() );
        accountDetailsTO.setBban( depositAccountBO.getBban() );
        accountDetailsTO.setPan( depositAccountBO.getPan() );
        accountDetailsTO.setMaskedPan( depositAccountBO.getMaskedPan() );
        accountDetailsTO.setMsisdn( depositAccountBO.getMsisdn() );
        accountDetailsTO.setCurrency( depositAccountBO.getCurrency() );
        accountDetailsTO.setName( depositAccountBO.getName() );
        accountDetailsTO.setProduct( depositAccountBO.getProduct() );
        accountDetailsTO.setAccountType( accountTypeBOToAccountTypeTO( depositAccountBO.getAccountType() ) );
        accountDetailsTO.setBic( depositAccountBO.getBic() );
        accountDetailsTO.setLinkedAccounts( depositAccountBO.getLinkedAccounts() );
        accountDetailsTO.setUsageType( accountUsageBOToUsageTypeTO( depositAccountBO.getUsageType() ) );
        accountDetailsTO.setDetails( depositAccountBO.getDetails() );
        accountDetailsTO.setBlocked( depositAccountBO.isBlocked() );
        accountDetailsTO.setSystemBlocked( depositAccountBO.isSystemBlocked() );
        accountDetailsTO.setBranch( depositAccountBO.getBranch() );

        return accountDetailsTO;
    }

    protected AccountReferenceBO accountAccessBOToAccountReferenceBO(AccountAccessBO accountAccessBO) {
        if ( accountAccessBO == null ) {
            return null;
        }

        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();

        accountReferenceBO.setIban( accountAccessBO.getIban() );
        accountReferenceBO.setCurrency( accountAccessBO.getCurrency() );

        return accountReferenceBO;
    }
}
