/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.middleware.api.domain.sca.GlobalScaResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaLoginOprTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareScaService;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseConverter;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.ScaResponseMessageResolver;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.ScaInfoBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.um.api.service.UserService;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareScaServiceImpl
implements MiddlewareScaService {
    private static final String NO_USER_MESSAGE = "No user message";
    @Value(value="${ledgers.default.token.lifetime.seconds:600}")
    private int defaultLoginTokenExpireInSeconds;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;
    private final UserService userService;
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final AccessService accessService;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    private final ScaResponseConverter scaResponseConverter;
    private final ScaResponseMessageResolver messageResolver;

    public GlobalScaResponseTO loginForOperation(ScaLoginOprTO loginOpr) {
        OpTypeBO opTypeBO = OpTypeBO.valueOf((String)loginOpr.getOpType().name());
        UserBO user = this.userService.findByLogin(loginOpr.getLogin());
        AuthCodeDataBO codeData = new AuthCodeDataBO(user.getLogin(), null, loginOpr.getOprId(), NO_USER_MESSAGE, this.defaultLoginTokenExpireInSeconds, opTypeBO, loginOpr.getAuthorisationId(), 0);
        SCAOperationBO operation = this.scaOperationService.checkIfExistsOrNew(codeData);
        try {
            BearerTokenBO token = this.proceedToLogin(loginOpr);
            return this.resolveLoginResponseForConsentLogin(operation, user, token);
        }
        catch (MiddlewareModuleException e) {
            throw this.scaOperationService.updateFailedCount(operation.getId(), true);
        }
    }

    public GlobalScaResponseTO getMethods(String authorizationId, String userId) {
        UserBO user = this.userService.findById(userId);
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(authorizationId);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), null, this.messageResolver.updateMessage(null, operation), null, 0, null);
    }

    public GlobalScaResponseTO selectMethod(ScaInfoTO scaInfo) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(scaInfo.getAuthorisationId());
        UserBO user = this.userService.findById(scaInfo.getUserId());
        String psuMessage = this.messageResolver.getTemplate(operation);
        int scaWeight = this.getScaWeight(operation.getOpType(), operation.getOpId(), user);
        AuthCodeDataBO data = new AuthCodeDataBO(user.getLogin(), scaInfo.getScaMethodId(), operation.getOpId(), psuMessage, this.defaultLoginTokenExpireInSeconds, operation.getOpType(), operation.getId(), scaWeight);
        operation = this.scaOperationService.generateAuthCode(data, user, ScaStatusBO.SCAMETHODSELECTED);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), operation.getOpType() == OpTypeBO.PAYMENT ? this.paymentService.getPaymentStatusById(operation.getOpId()) : null, this.messageResolver.updateMessage(psuMessage, operation), null, scaWeight, null);
    }

    public GlobalScaResponseTO confirmAuthorization(ScaInfoTO scaInfo) {
        SCAOperationBO operation = this.scaOperationService.loadAuthCode(scaInfo.getAuthorisationId());
        UserBO user = this.userService.findById(scaInfo.getUserId());
        int scaWeight = this.getScaWeight(operation.getOpType(), operation.getOpId(), user);
        String psuMessage = this.messageResolver.getTemplate(operation);
        ScaValidationBO scaValidation = this.scaOperationService.validateAuthCode(scaInfo.getAuthorisationId(), operation.getOpId(), scaInfo.getAuthCode(), scaWeight);
        operation.setScaStatus(scaValidation.getScaStatus());
        TransactionStatusBO transactionStatus = EnumSet.of(OpTypeBO.PAYMENT, OpTypeBO.CANCEL_PAYMENT).contains(operation.getOpType()) ? this.performPaymentConfirmation(operation, scaInfo.getUserLogin()) : null;
        BearerTokenBO token = this.resolveTokenConfirmation(this.scaInfoMapper.toScaInfoBO(scaInfo), operation);
        return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), transactionStatus, this.messageResolver.updateMessage(psuMessage, operation), token, scaWeight, scaValidation.getAuthConfirmationCode());
    }

    private BearerTokenBO resolveTokenConfirmation(ScaInfoBO scaInfo, SCAOperationBO operation) {
        AisConsentBO consent = operation.getOpType() == OpTypeBO.CONSENT ? this.userService.loadConsent(operation.getOpId()) : this.getAisConsentFromPayment(operation, scaInfo.getUserId());
        return this.authorizationService.consentToken(scaInfo, consent);
    }

    private AisConsentBO getAisConsentFromPayment(SCAOperationBO operation, String userLogin) {
        PaymentBO payment = this.paymentService.getPaymentById(operation.getOpId());
        return new AisConsentBO(payment.getDebtorAccount().getIban(), 0, true, userLogin);
    }

    private TransactionStatusBO performPaymentConfirmation(SCAOperationBO operation, String userLogin) {
        boolean authenticationCompleted = this.scaOperationService.authenticationCompleted(operation.getOpId(), operation.getOpType());
        if (authenticationCompleted) {
            if (operation.getOpType() == OpTypeBO.PAYMENT) {
                this.paymentService.updatePaymentStatus(operation.getOpId(), TransactionStatusBO.ACTC);
                return this.paymentService.executePayment(operation.getOpId(), userLogin);
            }
            return this.paymentService.cancelPayment(operation.getOpId());
        }
        if (this.multilevelScaEnable) {
            return this.paymentService.updatePaymentStatus(operation.getOpId(), TransactionStatusBO.PATC);
        }
        return this.paymentService.getPaymentById(operation.getOpId()).getTransactionStatus();
    }

    private GlobalScaResponseTO resolveLoginResponseForConsentLogin(SCAOperationBO operation, UserBO user, BearerTokenBO token) {
        if (!user.hasSCA()) {
            operation.setScaStatus(ScaStatusBO.EXEMPTED);
            return this.scaResponseConverter.mapResponse(operation, user.getScaUserData(), null, this.messageResolver.updateMessage(null, operation), token, 100, null);
        }
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), null, operation.getOpId(), NO_USER_MESSAGE, this.defaultLoginTokenExpireInSeconds, operation.getOpType(), operation.getId(), 100);
        SCAOperationBO scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUIDENTIFIED);
        return this.scaResponseConverter.mapResponse(scaOperationBO, user.getScaUserData(), null, this.messageResolver.updateMessage(null, operation), token, 100, null);
    }

    private int getScaWeight(OpTypeBO opType, String oprId, UserBO user) {
        return opType == OpTypeBO.LOGIN ? 100 : this.resolveWeightForOperation(opType, oprId, user);
    }

    private int resolveWeightForOperation(OpTypeBO opType, String oprId, UserBO user) {
        Set<String> ibans = opType == OpTypeBO.CONSENT ? this.userService.loadConsent(oprId).getAccess().getAllAccounts() : Collections.singleton(this.paymentService.getPaymentById(oprId).getDebtorAccount().getIban());
        return this.accessService.resolveScaWeightCommon(ibans, user.getAccountAccesses());
    }

    private BearerTokenBO proceedToLogin(ScaLoginOprTO loginOpr) {
        BearerTokenBO loginToken = Optional.ofNullable(this.authorizationService.authorise(loginOpr.getLogin(), loginOpr.getPin(), UserRoleBO.CUSTOMER, loginOpr.getOprId(), loginOpr.getAuthorisationId())).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("Unknown credentials.").build());
        return this.authorizationService.scaToken(loginToken.getAccessTokenObject().buildScaInfoBO());
    }

    public MiddlewareScaServiceImpl(UserService userService, DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, AccessService accessService, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService, ScaResponseConverter scaResponseConverter, ScaResponseMessageResolver messageResolver) {
        this.userService = userService;
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.accessService = accessService;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
        this.scaResponseConverter = scaResponseConverter;
        this.messageResolver = messageResolver;
    }
}

