/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentCoreDataTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.impl.config.PaymentProductsConfig;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseResolver;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCancelPolicy;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCoreDataPolicy;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.ScaInfoBO;
import de.adorsys.ledgers.um.api.domain.TokenUsageBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewarePaymentServiceImpl
implements MiddlewarePaymentService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewarePaymentServiceImpl.class);
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final DepositAccountService accountService;
    private final PaymentConverter paymentConverter;
    private final BearerTokenMapper bearerTokenMapper;
    private final SCAUtils scaUtils;
    private final PaymentCoreDataPolicy coreDataPolicy;
    private final AccessService accessService;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    private final ScaResponseResolver scaResponseResolver;
    private final PaymentProductsConfig paymentProductsConfig;
    private final AccountDetailsMapper detailsMapper;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public TransactionStatusTO getPaymentStatusById(String paymentId) {
        TransactionStatusBO paymentStatus = this.paymentService.getPaymentStatusById(paymentId);
        return TransactionStatusTO.valueOf((String)paymentStatus.name());
    }

    public SCAPaymentResponseTO initiatePaymentCancellation(ScaInfoTO scaInfoTO, String paymentId) {
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO paymentBO = this.loadPayment(paymentId);
        paymentBO.setRequestedExecutionTime(LocalTime.now().plusMinutes(10L));
        PaymentCancelPolicy.onCancel(paymentId, paymentBO.getTransactionStatus());
        return this.prepareScaAndResolveResponse(scaInfoTO, paymentBO, userBO, OpTypeBO.CANCEL_PAYMENT);
    }

    public SCAPaymentResponseTO initiatePayment(ScaInfoTO scaInfoTO, PaymentTO payment, PaymentTypeTO paymentType) {
        return this.checkPaymentAndPrepareResponse(scaInfoTO, this.paymentConverter.toPaymentBO(payment, paymentType));
    }

    private SCAPaymentResponseTO checkPaymentAndPrepareResponse(ScaInfoTO scaInfoTO, PaymentBO paymentBO) {
        this.validatePayment(paymentBO);
        paymentBO.updateDebtorAccountCurrency(this.getCheckedAccount(paymentBO).getCurrency());
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        TransactionStatusBO status = this.scaUtils.hasSCA(user) ? TransactionStatusBO.ACCP : TransactionStatusBO.ACTC;
        return this.prepareScaAndResolveResponse(scaInfoTO, this.persist(paymentBO, status), user, OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO executePayment(ScaInfoTO scaInfoTO, PaymentTO payment) {
        PaymentBO paymentBO = this.paymentConverter.toPaymentBO(payment);
        this.validatePayment(paymentBO);
        paymentBO.updateDebtorAccountCurrency(this.getCheckedAccount(paymentBO).getCurrency());
        paymentBO = this.persist(paymentBO, TransactionStatusBO.ACTC);
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        TransactionStatusBO status = this.paymentService.executePayment(paymentBO.getPaymentId(), user.getLogin());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setPaymentId(paymentBO.getPaymentId());
        response.setTransactionStatus(TransactionStatusTO.valueOf((String)status.name()));
        response.setPaymentType(PaymentTypeTO.valueOf((String)paymentBO.getPaymentType().name()));
        response.setPaymentProduct(paymentBO.getPaymentProduct());
        BearerTokenBO token = this.authorizationService.scaToken(new ScaInfoBO(user.getId(), user.getLogin(), TokenUsageBO.DIRECT_ACCESS, UserRoleBO.CUSTOMER));
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(token));
        response.setExpiresInSeconds(token.getExpires_in());
        response.setStatusDate(LocalDateTime.now());
        return response;
    }

    @NotNull
    private DepositAccountBO getCheckedAccount(PaymentBO paymentBO) {
        DepositAccountBO debtorAccount = this.checkAccountStatusAndCurrencyMatch(paymentBO.getDebtorAccount(), true, null);
        paymentBO.setAccountId(debtorAccount.getId());
        paymentBO.getTargets().forEach(t -> {
            try {
                DepositAccountBO acc = this.checkAccountStatusAndCurrencyMatch(t.getCreditorAccount(), false, t.getInstructedAmount().getCurrency());
                t.setCreditorAccount(acc.getReference());
            }
            catch (MiddlewareModuleException e) {
                if (EnumSet.of(MiddlewareErrorCode.ACCOUNT_DISABLED, MiddlewareErrorCode.CURRENCY_MISMATCH).contains(e.getErrorCode())) {
                    log.error(e.getDevMsg());
                    throw e;
                }
            }
            catch (DepositModuleException e) {
                log.info("Creditor account is located in another ASPSP");
            }
        });
        return debtorAccount;
    }

    private void validatePayment(PaymentBO paymentBO) {
        String msg = null;
        if (!paymentBO.isValidAmount()) {
            msg = "Instructed amount is invalid.";
        }
        if (this.paymentProductsConfig.isNotSupportedPaymentProduct(paymentBO.getPaymentProduct())) {
            msg = "Payment Product not Supported!";
        }
        if (msg != null) {
            throw MiddlewareModuleException.builder().devMsg(String.format("Payment validation failed! %s", msg)).errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).build();
        }
    }

    private SCAPaymentResponseTO prepareScaAndResolveResponse(ScaInfoTO scaInfoTO, PaymentBO payment, UserBO user, OpTypeBO opType) {
        boolean isScaRequired = this.scaRequired(user);
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        String authorisationId = this.scaUtils.authorisationId(scaInfoTO);
        String psuMessage = this.resolvePsuMessage(isScaRequired, payment, opType);
        BearerTokenTO token = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        ScaStatusTO scaStatus = this.scaResponseResolver.resolveScaStatus(scaInfoTO.getTokenUsage(), isScaRequired);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), payment.getDebtorAccount().getIban());
        this.scaResponseResolver.updateScaResponseFields(user, response, authorisationId, psuMessage, token, scaStatus, scaWeight);
        if (!isScaRequired) {
            this.executeExemptedInitiationOperation(payment, user, opType);
        } else {
            this.scaResponseResolver.prepareScaAndUpdateResponse(payment.getPaymentId(), response, authorisationId, psuMessage, scaWeight, user, opType);
        }
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    private void executeExemptedInitiationOperation(PaymentBO payment, UserBO user, OpTypeBO opType) {
        TransactionStatusBO transactionStatus = payment.getTransactionStatus();
        if (opType == OpTypeBO.PAYMENT) {
            transactionStatus = this.paymentService.executePayment(payment.getPaymentId(), user.getLogin());
        } else if (opType == OpTypeBO.CANCEL_PAYMENT) {
            transactionStatus = this.paymentService.cancelPayment(payment.getPaymentId());
        }
        payment.setTransactionStatus(transactionStatus);
    }

    private String resolvePsuMessage(boolean isScaRequired, PaymentBO payment, OpTypeBO opType) {
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        return isScaRequired ? paymentKeyData.getTanTemplate() : paymentKeyData.getExemptedTemplate();
    }

    private PaymentBO persist(PaymentBO paymentBO, TransactionStatusBO status) {
        if (paymentBO.getPaymentId() == null) {
            paymentBO.setPaymentId(Ids.id());
        }
        return this.paymentService.initiatePayment(paymentBO, status);
    }

    public PaymentTO getPaymentById(String paymentId) {
        PaymentBO paymentResult = this.paymentService.getPaymentById(paymentId);
        return this.paymentConverter.toPaymentTO(paymentResult);
    }

    public String iban(String paymentId) {
        return this.paymentService.readIbanByPaymentId(paymentId);
    }

    @Transactional(noRollbackFor={ScaModuleException.class})
    public SCAPaymentResponseTO authorizePayment(ScaInfoTO scaInfoTO, String paymentId) {
        return this.authorizeOperation(scaInfoTO, paymentId, null, OpTypeBO.PAYMENT);
    }

    @Transactional(noRollbackFor={ScaModuleException.class})
    public SCAPaymentResponseTO authorizeCancelPayment(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        return this.authorizeOperation(scaInfoTO, paymentId, cancellationId, OpTypeBO.CANCEL_PAYMENT);
    }

    public List<PaymentTO> getPendingPeriodicPayments(ScaInfoTO scaInfoTO) {
        List<AccountReferenceBO> referenceList = this.detailsMapper.toAccountReferenceList(this.scaUtils.userBO(scaInfoTO.getUserId()).getAccountAccesses());
        List payments = this.paymentService.getPaymentsByTypeStatusAndDebtor(PaymentTypeBO.PERIODIC, TransactionStatusBO.ACSP, referenceList);
        return this.paymentConverter.toPaymentTOList(payments);
    }

    private SCAPaymentResponseTO authorizeOperation(ScaInfoTO scaInfoTO, String paymentId, String cancellationId, OpTypeBO opType) {
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        String authorisationId = opType == OpTypeBO.PAYMENT ? scaInfoTO.getAuthorisationId() : cancellationId;
        ScaValidationBO scaValidationBO = this.validateAuthCode(scaInfoTO.getUserId(), payment, authorisationId, scaInfoTO.getAuthCode());
        if (this.scaOperationService.authenticationCompleted(paymentId, opType)) {
            if (opType == OpTypeBO.PAYMENT) {
                this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.ACTC);
                payment.setTransactionStatus(this.paymentService.executePayment(paymentId, scaInfoTO.getUserLogin()));
            } else {
                payment.setTransactionStatus(this.paymentService.cancelPayment(paymentId));
            }
        } else if (this.multilevelScaEnable) {
            payment.setTransactionStatus(this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.PATC));
        }
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setAuthConfirmationCode(scaValidationBO.getAuthConfirmationCode());
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        this.scaResponseResolver.updateScaResponseFields(userBO, response, authorisationId, paymentKeyData.getTanTemplate(), bearerToken, ScaStatusTO.valueOf((String)scaValidationBO.getScaStatus().toString()), scaWeight);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    public SCAPaymentResponseTO selectSCAMethodForPayment(ScaInfoTO scaInfoTO, String paymentId) {
        return this.selectSCAMethod(scaInfoTO, paymentId, null, OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO selectSCAMethodForCancelPayment(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        return this.selectSCAMethod(scaInfoTO, paymentId, cancellationId, OpTypeBO.CANCEL_PAYMENT);
    }

    private SCAPaymentResponseTO selectSCAMethod(ScaInfoTO scaInfoTO, String paymentId, String cancellationId, OpTypeBO opType) {
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO payment = this.loadPayment(paymentId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        String template = paymentKeyData.getTanTemplate();
        String authorisationId = opType == OpTypeBO.PAYMENT ? scaInfoTO.getAuthorisationId() : cancellationId;
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        this.scaResponseResolver.generateCodeAndUpdateResponse(paymentId, response, authorisationId, template, scaWeight, userBO, opType, scaInfoTO.getScaMethodId());
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        this.scaResponseResolver.updateScaResponseFields(userBO, response, authorisationId, template, bearerToken, ScaStatusTO.SCAMETHODSELECTED, scaWeight);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    public SCAPaymentResponseTO loadSCAForPaymentData(ScaInfoTO scaInfoTO, String paymentId) {
        return this.loadSca(scaInfoTO, paymentId, scaInfoTO.getAuthorisationId(), OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO loadSCAForCancelPaymentData(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        return this.loadSca(scaInfoTO, paymentId, cancellationId, OpTypeBO.CANCEL_PAYMENT);
    }

    private SCAPaymentResponseTO loadSca(ScaInfoTO scaInfoTO, String paymentId, String operationId, OpTypeBO opType) {
        SCAOperationBO scaOperation = this.scaOperationService.loadAuthCode(operationId);
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), payment.getDebtorAccount().getIban());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        this.scaResponseResolver.updateScaResponseFields(user, response, operationId, paymentKeyData.getTanTemplate(), bearerToken, ScaStatusTO.valueOf((String)scaOperation.getScaStatus().name()), scaWeight);
        this.scaResponseResolver.updateScaUserDataInResponse(user, scaOperation, (SCAResponseTO)response);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    private BearerTokenTO paymentAccountAccessToken(ScaInfoTO scaInfoTO, String iban) {
        AisConsentBO aisConsent = new AisConsentBO();
        AisAccountAccessInfoBO access = new AisAccountAccessInfoBO();
        aisConsent.setAccess(access);
        List<String> asList = Collections.singletonList(iban);
        access.setAccounts(asList);
        access.setTransactions(asList);
        access.setBalances(asList);
        aisConsent.setFrequencyPerDay(0);
        aisConsent.setRecurringIndicator(true);
        aisConsent.setUserId(scaInfoTO.getUserLogin());
        return this.bearerTokenMapper.toBearerTokenTO(this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), aisConsent));
    }

    private ScaValidationBO validateAuthCode(String userId, PaymentBO payment, String authorisationId, String authCode) {
        UserBO userBO = this.scaUtils.userBO(userId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        return this.scaOperationService.validateAuthCode(authorisationId, payment.getPaymentId(), authCode, scaWeight);
    }

    private PaymentBO loadPayment(String paymentId) {
        return this.paymentService.getPaymentById(paymentId);
    }

    private boolean scaRequired(UserBO user) {
        return this.scaUtils.hasSCA(user);
    }

    private DepositAccountBO checkAccountStatusAndCurrencyMatch(AccountReferenceBO reference, boolean isDebtor, Currency currency) {
        DepositAccountBO account = Optional.ofNullable(reference.getCurrency()).map(c -> this.accountService.getAccountByIbanAndCurrency(reference.getIban(), c)).orElseGet(() -> this.getAccountByIbanAndParamCurrencyErrorIfNotSingle(reference.getIban(), isDebtor, currency));
        if (!account.isEnabled()) {
            throw (MiddlewareModuleException)((Object)MiddlewareModuleException.blockedSupplier((MiddlewareErrorCode)MiddlewareErrorCode.ACCOUNT_DISABLED, (String)reference.getIban(), (boolean)account.isBlocked()).get());
        }
        return account;
    }

    private DepositAccountBO getAccountByIbanAndParamCurrencyErrorIfNotSingle(String iban, boolean isDebtor, Currency currency) {
        List accounts = this.accountService.getAccountsByIbanAndParamCurrency(iban, "");
        if (CollectionUtils.isEmpty((Collection)accounts) && !isDebtor) {
            return new DepositAccountBO(null, iban, null, null, null, null, currency, null, null, null, null, null, null, null, false, false, null, null);
        }
        if (accounts.size() != 1) {
            String msg = CollectionUtils.isEmpty((Collection)accounts) ? String.format("Account with IBAN: %s Not Found!", iban) : String.format("Initiation of payment for Account with IBAN: %s is impossible as it is a Multi-Currency-Account. %nPlease specify currency for sub-account to proceed.", iban);
            MiddlewareErrorCode errorCode = CollectionUtils.isEmpty((Collection)accounts) ? MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE : MiddlewareErrorCode.CURRENCY_MISMATCH;
            throw MiddlewareModuleException.builder().errorCode(errorCode).devMsg(msg).build();
        }
        return (DepositAccountBO)accounts.iterator().next();
    }

    public MiddlewarePaymentServiceImpl(DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, DepositAccountService accountService, PaymentConverter paymentConverter, BearerTokenMapper bearerTokenMapper, SCAUtils scaUtils, PaymentCoreDataPolicy coreDataPolicy, AccessService accessService, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService, ScaResponseResolver scaResponseResolver, PaymentProductsConfig paymentProductsConfig, AccountDetailsMapper detailsMapper) {
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.accountService = accountService;
        this.paymentConverter = paymentConverter;
        this.bearerTokenMapper = bearerTokenMapper;
        this.scaUtils = scaUtils;
        this.coreDataPolicy = coreDataPolicy;
        this.accessService = accessService;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
        this.scaResponseResolver = scaResponseResolver;
        this.paymentProductsConfig = paymentProductsConfig;
        this.detailsMapper = detailsMapper;
    }
}

