/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.policies;

import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import java.util.EnumSet;
import java.util.Set;

public class PaymentCancelPolicy {
    private static final Set<TransactionStatusTO> FINAL_STATUSES = EnumSet.of(TransactionStatusTO.ACSC, TransactionStatusTO.RJCT, TransactionStatusTO.CANC);

    private PaymentCancelPolicy() {
    }

    private static void onCancel(String paymentId, TransactionStatusTO originalTxStatus) {
        if (FINAL_STATUSES.contains(originalTxStatus)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format("Request for payment cancellation is forbidden as the payment with id:%s has status:%s", paymentId, originalTxStatus)).build();
        }
    }

    public static void onCancel(String paymentId, TransactionStatusBO originalTxStatus) {
        PaymentCancelPolicy.onCancel(paymentId, TransactionStatusTO.valueOf((String)originalTxStatus.name()));
    }
}

