package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AddressBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceTypeBO;
import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.domain.FrequencyCodeBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.PurposeCodeBO;
import de.adorsys.ledgers.deposit.api.domain.RemittanceInformationStructuredBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.BalanceTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PurposeCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-07-03T06:18:20+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_252 (Private Build)"
)
@Component
public class PaymentConverterImpl implements PaymentConverter {

    @Override
    public PaymentBO toPaymentBO(PaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        paymentBO.setPaymentId( payment.getPaymentId() );
        paymentBO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentBO.setPaymentType( paymentTypeTOToPaymentTypeBO( payment.getPaymentType() ) );
        paymentBO.setPaymentProduct( payment.getPaymentProduct() );
        paymentBO.setStartDate( payment.getStartDate() );
        paymentBO.setEndDate( payment.getEndDate() );
        paymentBO.setExecutionRule( payment.getExecutionRule() );
        paymentBO.setFrequency( frequencyCodeTOToFrequencyCodeBO( payment.getFrequency() ) );
        paymentBO.setDayOfExecution( payment.getDayOfExecution() );
        paymentBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( payment.getDebtorAccount() ) );
        paymentBO.setDebtorName( payment.getDebtorName() );
        paymentBO.setDebtorAgent( payment.getDebtorAgent() );
        paymentBO.setTransactionStatus( transactionStatusTOToTransactionStatusBO( payment.getTransactionStatus() ) );
        paymentBO.setTargets( paymentTargetTOListToPaymentTargetBOList( payment.getTargets() ) );
        paymentBO.setAccountId( payment.getAccountId() );

        return paymentBO;
    }

    @Override
    public PaymentBO toPaymentBO(PaymentTO payment, PaymentTypeTO paymentType) {
        if ( payment == null && paymentType == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        if ( payment != null ) {
            paymentBO.setPaymentId( payment.getPaymentId() );
            paymentBO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
            paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
            paymentBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
            paymentBO.setPaymentProduct( payment.getPaymentProduct() );
            paymentBO.setStartDate( payment.getStartDate() );
            paymentBO.setEndDate( payment.getEndDate() );
            paymentBO.setExecutionRule( payment.getExecutionRule() );
            paymentBO.setFrequency( frequencyCodeTOToFrequencyCodeBO( payment.getFrequency() ) );
            paymentBO.setDayOfExecution( payment.getDayOfExecution() );
            paymentBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( payment.getDebtorAccount() ) );
            paymentBO.setDebtorName( payment.getDebtorName() );
            paymentBO.setDebtorAgent( payment.getDebtorAgent() );
            paymentBO.setTransactionStatus( transactionStatusTOToTransactionStatusBO( payment.getTransactionStatus() ) );
            paymentBO.setTargets( paymentTargetTOListToPaymentTargetBOList( payment.getTargets() ) );
            paymentBO.setAccountId( payment.getAccountId() );
        }
        if ( paymentType != null ) {
            paymentBO.setPaymentType( paymentTypeTOToPaymentTypeBO( paymentType ) );
        }

        return paymentBO;
    }

    @Override
    public List<TransactionTO> toTransactionTOList(List<TransactionDetailsBO> transactions) {
        if ( transactions == null ) {
            return null;
        }

        List<TransactionTO> list = new ArrayList<TransactionTO>( transactions.size() );
        for ( TransactionDetailsBO transactionDetailsBO : transactions ) {
            list.add( toTransactionTO( transactionDetailsBO ) );
        }

        return list;
    }

    @Override
    public TransactionTO toTransactionTO(TransactionDetailsBO transaction) {
        if ( transaction == null ) {
            return null;
        }

        TransactionTO transactionTO = new TransactionTO();

        transactionTO.setAmount( amountBOToAmountTO( transaction.getTransactionAmount() ) );
        transactionTO.setTransactionId( transaction.getTransactionId() );
        transactionTO.setEntryReference( transaction.getEntryReference() );
        transactionTO.setEndToEndId( transaction.getEndToEndId() );
        transactionTO.setMandateId( transaction.getMandateId() );
        transactionTO.setCheckId( transaction.getCheckId() );
        transactionTO.setCreditorId( transaction.getCreditorId() );
        transactionTO.setBookingDate( transaction.getBookingDate() );
        transactionTO.setValueDate( transaction.getValueDate() );
        transactionTO.setExchangeRate( exchangeRateBOListToExchangeRateTOList( transaction.getExchangeRate() ) );
        transactionTO.setCreditorName( transaction.getCreditorName() );
        transactionTO.setCreditorAccount( accountReferenceBOToAccountReferenceTO( transaction.getCreditorAccount() ) );
        transactionTO.setCreditorAgent( transaction.getCreditorAgent() );
        transactionTO.setUltimateCreditor( transaction.getUltimateCreditor() );
        transactionTO.setDebtorName( transaction.getDebtorName() );
        transactionTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( transaction.getDebtorAccount() ) );
        transactionTO.setDebtorAgent( transaction.getDebtorAgent() );
        transactionTO.setUltimateDebtor( transaction.getUltimateDebtor() );
        transactionTO.setRemittanceInformationUnstructured( transaction.getRemittanceInformationUnstructured() );
        transactionTO.setRemittanceInformationStructured( remittanceInformationStructuredBOToRemittanceInformationStructuredTO( transaction.getRemittanceInformationStructured() ) );
        if ( transaction.getPurposeCode() != null ) {
            transactionTO.setPurposeCode( transaction.getPurposeCode().name() );
        }
        transactionTO.setBankTransactionCode( transaction.getBankTransactionCode() );
        transactionTO.setProprietaryBankTransactionCode( transaction.getProprietaryBankTransactionCode() );
        transactionTO.setBalanceAfterTransaction( balanceBOToAccountBalanceTO( transaction.getBalanceAfterTransaction() ) );

        return transactionTO;
    }

    @Override
    public ExchangeRateTO toExchangeRateTO(ExchangeRateBO exchangeRate) {
        if ( exchangeRate == null ) {
            return null;
        }

        ExchangeRateTO exchangeRateTO = new ExchangeRateTO();

        exchangeRateTO.setCurrency( exchangeRate.getCurrencyTo() );
        exchangeRateTO.setCurrencyFrom( exchangeRate.getCurrencyFrom() );
        exchangeRateTO.setRateFrom( exchangeRate.getRateFrom() );
        exchangeRateTO.setRateTo( exchangeRate.getRateTo() );
        exchangeRateTO.setRateDate( exchangeRate.getRateDate() );
        exchangeRateTO.setRateContract( exchangeRate.getRateContract() );

        return exchangeRateTO;
    }

    @Override
    public TransactionDetailsBO toTransactionDetailsBO(TransactionTO transaction) {
        if ( transaction == null ) {
            return null;
        }

        TransactionDetailsBO transactionDetailsBO = new TransactionDetailsBO();

        transactionDetailsBO.setTransactionAmount( amountTOToAmountBO( transaction.getAmount() ) );
        transactionDetailsBO.setTransactionId( transaction.getTransactionId() );
        transactionDetailsBO.setEntryReference( transaction.getEntryReference() );
        transactionDetailsBO.setEndToEndId( transaction.getEndToEndId() );
        transactionDetailsBO.setMandateId( transaction.getMandateId() );
        transactionDetailsBO.setCheckId( transaction.getCheckId() );
        transactionDetailsBO.setCreditorId( transaction.getCreditorId() );
        transactionDetailsBO.setBookingDate( transaction.getBookingDate() );
        transactionDetailsBO.setValueDate( transaction.getValueDate() );
        transactionDetailsBO.setExchangeRate( exchangeRateTOListToExchangeRateBOList( transaction.getExchangeRate() ) );
        transactionDetailsBO.setCreditorName( transaction.getCreditorName() );
        transactionDetailsBO.setCreditorAgent( transaction.getCreditorAgent() );
        transactionDetailsBO.setCreditorAccount( accountReferenceTOToAccountReferenceBO( transaction.getCreditorAccount() ) );
        transactionDetailsBO.setUltimateCreditor( transaction.getUltimateCreditor() );
        transactionDetailsBO.setDebtorName( transaction.getDebtorName() );
        transactionDetailsBO.setDebtorAgent( transaction.getDebtorAgent() );
        transactionDetailsBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( transaction.getDebtorAccount() ) );
        transactionDetailsBO.setUltimateDebtor( transaction.getUltimateDebtor() );
        transactionDetailsBO.setRemittanceInformationStructured( remittanceInformationStructuredTOToRemittanceInformationStructuredBO( transaction.getRemittanceInformationStructured() ) );
        transactionDetailsBO.setRemittanceInformationUnstructured( transaction.getRemittanceInformationUnstructured() );
        if ( transaction.getPurposeCode() != null ) {
            transactionDetailsBO.setPurposeCode( Enum.valueOf( PurposeCodeBO.class, transaction.getPurposeCode() ) );
        }
        transactionDetailsBO.setBankTransactionCode( transaction.getBankTransactionCode() );
        transactionDetailsBO.setProprietaryBankTransactionCode( transaction.getProprietaryBankTransactionCode() );
        transactionDetailsBO.setBalanceAfterTransaction( accountBalanceTOToBalanceBO( transaction.getBalanceAfterTransaction() ) );

        return transactionDetailsBO;
    }

    @Override
    public PaymentTO toPaymentTO(PaymentBO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentTO paymentTO = new PaymentTO();

        paymentTO.setPaymentId( payment.getPaymentId() );
        paymentTO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        paymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentTO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentTO.setPaymentType( paymentTypeBOToPaymentTypeTO( payment.getPaymentType() ) );
        paymentTO.setPaymentProduct( payment.getPaymentProduct() );
        paymentTO.setStartDate( payment.getStartDate() );
        paymentTO.setEndDate( payment.getEndDate() );
        paymentTO.setExecutionRule( payment.getExecutionRule() );
        paymentTO.setFrequency( frequencyCodeBOToFrequencyCodeTO( payment.getFrequency() ) );
        paymentTO.setDayOfExecution( payment.getDayOfExecution() );
        paymentTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( payment.getDebtorAccount() ) );
        paymentTO.setDebtorAgent( payment.getDebtorAgent() );
        paymentTO.setDebtorName( payment.getDebtorName() );
        paymentTO.setTransactionStatus( transactionStatusBOToTransactionStatusTO( payment.getTransactionStatus() ) );
        paymentTO.setTargets( paymentTargetBOListToPaymentTargetTOList( payment.getTargets() ) );
        paymentTO.setAccountId( payment.getAccountId() );

        return paymentTO;
    }

    protected PaymentTypeBO paymentTypeTOToPaymentTypeBO(PaymentTypeTO paymentTypeTO) {
        if ( paymentTypeTO == null ) {
            return null;
        }

        PaymentTypeBO paymentTypeBO;

        switch ( paymentTypeTO ) {
            case SINGLE: paymentTypeBO = PaymentTypeBO.SINGLE;
            break;
            case PERIODIC: paymentTypeBO = PaymentTypeBO.PERIODIC;
            break;
            case BULK: paymentTypeBO = PaymentTypeBO.BULK;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentTypeTO );
        }

        return paymentTypeBO;
    }

    protected FrequencyCodeBO frequencyCodeTOToFrequencyCodeBO(FrequencyCodeTO frequencyCodeTO) {
        if ( frequencyCodeTO == null ) {
            return null;
        }

        FrequencyCodeBO frequencyCodeBO;

        switch ( frequencyCodeTO ) {
            case DAILY: frequencyCodeBO = FrequencyCodeBO.DAILY;
            break;
            case WEEKLY: frequencyCodeBO = FrequencyCodeBO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeBO = FrequencyCodeBO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeBO = FrequencyCodeBO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeBO = FrequencyCodeBO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeBO = FrequencyCodeBO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeBO = FrequencyCodeBO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeBO = FrequencyCodeBO.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCodeBO = FrequencyCodeBO.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCodeTO );
        }

        return frequencyCodeBO;
    }

    protected AccountReferenceBO accountReferenceTOToAccountReferenceBO(AccountReferenceTO accountReferenceTO) {
        if ( accountReferenceTO == null ) {
            return null;
        }

        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();

        accountReferenceBO.setIban( accountReferenceTO.getIban() );
        accountReferenceBO.setBban( accountReferenceTO.getBban() );
        accountReferenceBO.setPan( accountReferenceTO.getPan() );
        accountReferenceBO.setMaskedPan( accountReferenceTO.getMaskedPan() );
        accountReferenceBO.setMsisdn( accountReferenceTO.getMsisdn() );
        accountReferenceBO.setCurrency( accountReferenceTO.getCurrency() );

        return accountReferenceBO;
    }

    protected TransactionStatusBO transactionStatusTOToTransactionStatusBO(TransactionStatusTO transactionStatusTO) {
        if ( transactionStatusTO == null ) {
            return null;
        }

        TransactionStatusBO transactionStatusBO;

        switch ( transactionStatusTO ) {
            case ACCC: transactionStatusBO = TransactionStatusBO.ACCC;
            break;
            case ACCP: transactionStatusBO = TransactionStatusBO.ACCP;
            break;
            case ACSC: transactionStatusBO = TransactionStatusBO.ACSC;
            break;
            case ACSP: transactionStatusBO = TransactionStatusBO.ACSP;
            break;
            case ACTC: transactionStatusBO = TransactionStatusBO.ACTC;
            break;
            case ACWC: transactionStatusBO = TransactionStatusBO.ACWC;
            break;
            case ACWP: transactionStatusBO = TransactionStatusBO.ACWP;
            break;
            case RCVD: transactionStatusBO = TransactionStatusBO.RCVD;
            break;
            case PDNG: transactionStatusBO = TransactionStatusBO.PDNG;
            break;
            case RJCT: transactionStatusBO = TransactionStatusBO.RJCT;
            break;
            case CANC: transactionStatusBO = TransactionStatusBO.CANC;
            break;
            case ACFC: transactionStatusBO = TransactionStatusBO.ACFC;
            break;
            case PATC: transactionStatusBO = TransactionStatusBO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatusTO );
        }

        return transactionStatusBO;
    }

    protected AmountBO amountTOToAmountBO(AmountTO amountTO) {
        if ( amountTO == null ) {
            return null;
        }

        AmountBO amountBO = new AmountBO();

        amountBO.setCurrency( amountTO.getCurrency() );
        amountBO.setAmount( amountTO.getAmount() );

        return amountBO;
    }

    protected AddressBO addressTOToAddressBO(AddressTO addressTO) {
        if ( addressTO == null ) {
            return null;
        }

        AddressBO addressBO = new AddressBO();

        addressBO.setStreet( addressTO.getStreet() );
        addressBO.setBuildingNumber( addressTO.getBuildingNumber() );
        addressBO.setCity( addressTO.getCity() );
        addressBO.setPostalCode( addressTO.getPostalCode() );
        addressBO.setCountry( addressTO.getCountry() );
        addressBO.setLine1( addressTO.getLine1() );
        addressBO.setLine2( addressTO.getLine2() );

        return addressBO;
    }

    protected PurposeCodeBO purposeCodeTOToPurposeCodeBO(PurposeCodeTO purposeCodeTO) {
        if ( purposeCodeTO == null ) {
            return null;
        }

        PurposeCodeBO purposeCodeBO;

        switch ( purposeCodeTO ) {
            case BKDF: purposeCodeBO = PurposeCodeBO.BKDF;
            break;
            case BKFE: purposeCodeBO = PurposeCodeBO.BKFE;
            break;
            case BKFM: purposeCodeBO = PurposeCodeBO.BKFM;
            break;
            case BKIP: purposeCodeBO = PurposeCodeBO.BKIP;
            break;
            case BKPP: purposeCodeBO = PurposeCodeBO.BKPP;
            break;
            case CBLK: purposeCodeBO = PurposeCodeBO.CBLK;
            break;
            case CDCB: purposeCodeBO = PurposeCodeBO.CDCB;
            break;
            case CDCD: purposeCodeBO = PurposeCodeBO.CDCD;
            break;
            case CDCS: purposeCodeBO = PurposeCodeBO.CDCS;
            break;
            case CDDP: purposeCodeBO = PurposeCodeBO.CDDP;
            break;
            case CDOC: purposeCodeBO = PurposeCodeBO.CDOC;
            break;
            case CDQC: purposeCodeBO = PurposeCodeBO.CDQC;
            break;
            case ETUP: purposeCodeBO = PurposeCodeBO.ETUP;
            break;
            case FCOL: purposeCodeBO = PurposeCodeBO.FCOL;
            break;
            case MTUP: purposeCodeBO = PurposeCodeBO.MTUP;
            break;
            case ACCT: purposeCodeBO = PurposeCodeBO.ACCT;
            break;
            case CASH: purposeCodeBO = PurposeCodeBO.CASH;
            break;
            case COLL: purposeCodeBO = PurposeCodeBO.COLL;
            break;
            case CSDB: purposeCodeBO = PurposeCodeBO.CSDB;
            break;
            case DEPT: purposeCodeBO = PurposeCodeBO.DEPT;
            break;
            case INTC: purposeCodeBO = PurposeCodeBO.INTC;
            break;
            case LIMA: purposeCodeBO = PurposeCodeBO.LIMA;
            break;
            case NETT: purposeCodeBO = PurposeCodeBO.NETT;
            break;
            case BFWD: purposeCodeBO = PurposeCodeBO.BFWD;
            break;
            case CCIR: purposeCodeBO = PurposeCodeBO.CCIR;
            break;
            case CCPC: purposeCodeBO = PurposeCodeBO.CCPC;
            break;
            case CCPM: purposeCodeBO = PurposeCodeBO.CCPM;
            break;
            case CCSM: purposeCodeBO = PurposeCodeBO.CCSM;
            break;
            case CRDS: purposeCodeBO = PurposeCodeBO.CRDS;
            break;
            case CRPR: purposeCodeBO = PurposeCodeBO.CRPR;
            break;
            case CRSP: purposeCodeBO = PurposeCodeBO.CRSP;
            break;
            case CRTL: purposeCodeBO = PurposeCodeBO.CRTL;
            break;
            case EQPT: purposeCodeBO = PurposeCodeBO.EQPT;
            break;
            case EQUS: purposeCodeBO = PurposeCodeBO.EQUS;
            break;
            case EXPT: purposeCodeBO = PurposeCodeBO.EXPT;
            break;
            case EXTD: purposeCodeBO = PurposeCodeBO.EXTD;
            break;
            case FIXI: purposeCodeBO = PurposeCodeBO.FIXI;
            break;
            case FWBC: purposeCodeBO = PurposeCodeBO.FWBC;
            break;
            case FWCC: purposeCodeBO = PurposeCodeBO.FWCC;
            break;
            case FWSB: purposeCodeBO = PurposeCodeBO.FWSB;
            break;
            case FWSC: purposeCodeBO = PurposeCodeBO.FWSC;
            break;
            case MARG: purposeCodeBO = PurposeCodeBO.MARG;
            break;
            case MBSB: purposeCodeBO = PurposeCodeBO.MBSB;
            break;
            case MBSC: purposeCodeBO = PurposeCodeBO.MBSC;
            break;
            case MGCC: purposeCodeBO = PurposeCodeBO.MGCC;
            break;
            case MGSC: purposeCodeBO = PurposeCodeBO.MGSC;
            break;
            case OCCC: purposeCodeBO = PurposeCodeBO.OCCC;
            break;
            case OPBC: purposeCodeBO = PurposeCodeBO.OPBC;
            break;
            case OPCC: purposeCodeBO = PurposeCodeBO.OPCC;
            break;
            case OPSB: purposeCodeBO = PurposeCodeBO.OPSB;
            break;
            case OPSC: purposeCodeBO = PurposeCodeBO.OPSC;
            break;
            case OPTN: purposeCodeBO = PurposeCodeBO.OPTN;
            break;
            case OTCD: purposeCodeBO = PurposeCodeBO.OTCD;
            break;
            case REPO: purposeCodeBO = PurposeCodeBO.REPO;
            break;
            case RPBC: purposeCodeBO = PurposeCodeBO.RPBC;
            break;
            case RPCC: purposeCodeBO = PurposeCodeBO.RPCC;
            break;
            case RPSB: purposeCodeBO = PurposeCodeBO.RPSB;
            break;
            case RPSC: purposeCodeBO = PurposeCodeBO.RPSC;
            break;
            case RVPO: purposeCodeBO = PurposeCodeBO.RVPO;
            break;
            case SBSC: purposeCodeBO = PurposeCodeBO.SBSC;
            break;
            case SCIE: purposeCodeBO = PurposeCodeBO.SCIE;
            break;
            case SCIR: purposeCodeBO = PurposeCodeBO.SCIR;
            break;
            case SCRP: purposeCodeBO = PurposeCodeBO.SCRP;
            break;
            case SHBC: purposeCodeBO = PurposeCodeBO.SHBC;
            break;
            case SHCC: purposeCodeBO = PurposeCodeBO.SHCC;
            break;
            case SHSL: purposeCodeBO = PurposeCodeBO.SHSL;
            break;
            case SLEB: purposeCodeBO = PurposeCodeBO.SLEB;
            break;
            case SLOA: purposeCodeBO = PurposeCodeBO.SLOA;
            break;
            case SWBC: purposeCodeBO = PurposeCodeBO.SWBC;
            break;
            case SWCC: purposeCodeBO = PurposeCodeBO.SWCC;
            break;
            case SWPT: purposeCodeBO = PurposeCodeBO.SWPT;
            break;
            case SWSB: purposeCodeBO = PurposeCodeBO.SWSB;
            break;
            case SWSC: purposeCodeBO = PurposeCodeBO.SWSC;
            break;
            case TBAS: purposeCodeBO = PurposeCodeBO.TBAS;
            break;
            case TBBC: purposeCodeBO = PurposeCodeBO.TBBC;
            break;
            case TBCC: purposeCodeBO = PurposeCodeBO.TBCC;
            break;
            case TRCP: purposeCodeBO = PurposeCodeBO.TRCP;
            break;
            case AGRT: purposeCodeBO = PurposeCodeBO.AGRT;
            break;
            case AREN: purposeCodeBO = PurposeCodeBO.AREN;
            break;
            case BEXP: purposeCodeBO = PurposeCodeBO.BEXP;
            break;
            case BOCE: purposeCodeBO = PurposeCodeBO.BOCE;
            break;
            case COMC: purposeCodeBO = PurposeCodeBO.COMC;
            break;
            case CPYR: purposeCodeBO = PurposeCodeBO.CPYR;
            break;
            case GDDS: purposeCodeBO = PurposeCodeBO.GDDS;
            break;
            case GDSV: purposeCodeBO = PurposeCodeBO.GDSV;
            break;
            case GSCB: purposeCodeBO = PurposeCodeBO.GSCB;
            break;
            case LICF: purposeCodeBO = PurposeCodeBO.LICF;
            break;
            case MP2B: purposeCodeBO = PurposeCodeBO.MP2B;
            break;
            case POPE: purposeCodeBO = PurposeCodeBO.POPE;
            break;
            case ROYA: purposeCodeBO = PurposeCodeBO.ROYA;
            break;
            case SCVE: purposeCodeBO = PurposeCodeBO.SCVE;
            break;
            case SERV: purposeCodeBO = PurposeCodeBO.SERV;
            break;
            case SUBS: purposeCodeBO = PurposeCodeBO.SUBS;
            break;
            case SUPP: purposeCodeBO = PurposeCodeBO.SUPP;
            break;
            case TRAD: purposeCodeBO = PurposeCodeBO.TRAD;
            break;
            case CHAR: purposeCodeBO = PurposeCodeBO.CHAR;
            break;
            case COMT: purposeCodeBO = PurposeCodeBO.COMT;
            break;
            case MP2P: purposeCodeBO = PurposeCodeBO.MP2P;
            break;
            case ECPG: purposeCodeBO = PurposeCodeBO.ECPG;
            break;
            case ECPR: purposeCodeBO = PurposeCodeBO.ECPR;
            break;
            case ECPU: purposeCodeBO = PurposeCodeBO.ECPU;
            break;
            case EPAY: purposeCodeBO = PurposeCodeBO.EPAY;
            break;
            case CLPR: purposeCodeBO = PurposeCodeBO.CLPR;
            break;
            case COMP: purposeCodeBO = PurposeCodeBO.COMP;
            break;
            case DBTC: purposeCodeBO = PurposeCodeBO.DBTC;
            break;
            case GOVI: purposeCodeBO = PurposeCodeBO.GOVI;
            break;
            case HLRP: purposeCodeBO = PurposeCodeBO.HLRP;
            break;
            case HLST: purposeCodeBO = PurposeCodeBO.HLST;
            break;
            case INPC: purposeCodeBO = PurposeCodeBO.INPC;
            break;
            case INPR: purposeCodeBO = PurposeCodeBO.INPR;
            break;
            case INSC: purposeCodeBO = PurposeCodeBO.INSC;
            break;
            case INSU: purposeCodeBO = PurposeCodeBO.INSU;
            break;
            case INTE: purposeCodeBO = PurposeCodeBO.INTE;
            break;
            case LBRI: purposeCodeBO = PurposeCodeBO.LBRI;
            break;
            case LIFI: purposeCodeBO = PurposeCodeBO.LIFI;
            break;
            case LOAN: purposeCodeBO = PurposeCodeBO.LOAN;
            break;
            case LOAR: purposeCodeBO = PurposeCodeBO.LOAR;
            break;
            case PENO: purposeCodeBO = PurposeCodeBO.PENO;
            break;
            case PPTI: purposeCodeBO = PurposeCodeBO.PPTI;
            break;
            case RELG: purposeCodeBO = PurposeCodeBO.RELG;
            break;
            case RINP: purposeCodeBO = PurposeCodeBO.RINP;
            break;
            case TRFD: purposeCodeBO = PurposeCodeBO.TRFD;
            break;
            case FORW: purposeCodeBO = PurposeCodeBO.FORW;
            break;
            case FXNT: purposeCodeBO = PurposeCodeBO.FXNT;
            break;
            case ADMG: purposeCodeBO = PurposeCodeBO.ADMG;
            break;
            case ADVA: purposeCodeBO = PurposeCodeBO.ADVA;
            break;
            case BCDM: purposeCodeBO = PurposeCodeBO.BCDM;
            break;
            case BCFG: purposeCodeBO = PurposeCodeBO.BCFG;
            break;
            case BLDM: purposeCodeBO = PurposeCodeBO.BLDM;
            break;
            case BNET: purposeCodeBO = PurposeCodeBO.BNET;
            break;
            case CBFF: purposeCodeBO = PurposeCodeBO.CBFF;
            break;
            case CBFR: purposeCodeBO = PurposeCodeBO.CBFR;
            break;
            case CCRD: purposeCodeBO = PurposeCodeBO.CCRD;
            break;
            case CDBL: purposeCodeBO = PurposeCodeBO.CDBL;
            break;
            case CFEE: purposeCodeBO = PurposeCodeBO.CFEE;
            break;
            case CGDD: purposeCodeBO = PurposeCodeBO.CGDD;
            break;
            case CORT: purposeCodeBO = PurposeCodeBO.CORT;
            break;
            case COST: purposeCodeBO = PurposeCodeBO.COST;
            break;
            case CPKC: purposeCodeBO = PurposeCodeBO.CPKC;
            break;
            case DCRD: purposeCodeBO = PurposeCodeBO.DCRD;
            break;
            case DSMT: purposeCodeBO = PurposeCodeBO.DSMT;
            break;
            case DVPM: purposeCodeBO = PurposeCodeBO.DVPM;
            break;
            case EDUC: purposeCodeBO = PurposeCodeBO.EDUC;
            break;
            case FACT: purposeCodeBO = PurposeCodeBO.FACT;
            break;
            case FAND: purposeCodeBO = PurposeCodeBO.FAND;
            break;
            case FCPM: purposeCodeBO = PurposeCodeBO.FCPM;
            break;
            case FEES: purposeCodeBO = PurposeCodeBO.FEES;
            break;
            case GOVT: purposeCodeBO = PurposeCodeBO.GOVT;
            break;
            case ICCP: purposeCodeBO = PurposeCodeBO.ICCP;
            break;
            case IDCP: purposeCodeBO = PurposeCodeBO.IDCP;
            break;
            case IHRP: purposeCodeBO = PurposeCodeBO.IHRP;
            break;
            case INSM: purposeCodeBO = PurposeCodeBO.INSM;
            break;
            case IVPT: purposeCodeBO = PurposeCodeBO.IVPT;
            break;
            case MCDM: purposeCodeBO = PurposeCodeBO.MCDM;
            break;
            case MCFG: purposeCodeBO = PurposeCodeBO.MCFG;
            break;
            case MSVC: purposeCodeBO = PurposeCodeBO.MSVC;
            break;
            case NOWS: purposeCodeBO = PurposeCodeBO.NOWS;
            break;
            case OCDM: purposeCodeBO = PurposeCodeBO.OCDM;
            break;
            case OCFG: purposeCodeBO = PurposeCodeBO.OCFG;
            break;
            case OFEE: purposeCodeBO = PurposeCodeBO.OFEE;
            break;
            case OTHR: purposeCodeBO = PurposeCodeBO.OTHR;
            break;
            case PADD: purposeCodeBO = PurposeCodeBO.PADD;
            break;
            case PTSP: purposeCodeBO = PurposeCodeBO.PTSP;
            break;
            case RCKE: purposeCodeBO = PurposeCodeBO.RCKE;
            break;
            case RCPT: purposeCodeBO = PurposeCodeBO.RCPT;
            break;
            case REBT: purposeCodeBO = PurposeCodeBO.REBT;
            break;
            case REFU: purposeCodeBO = PurposeCodeBO.REFU;
            break;
            case RENT: purposeCodeBO = PurposeCodeBO.RENT;
            break;
            case REOD: purposeCodeBO = PurposeCodeBO.REOD;
            break;
            case RIMB: purposeCodeBO = PurposeCodeBO.RIMB;
            break;
            case RPNT: purposeCodeBO = PurposeCodeBO.RPNT;
            break;
            case RRBN: purposeCodeBO = PurposeCodeBO.RRBN;
            break;
            case RVPM: purposeCodeBO = PurposeCodeBO.RVPM;
            break;
            case SLPI: purposeCodeBO = PurposeCodeBO.SLPI;
            break;
            case SPLT: purposeCodeBO = PurposeCodeBO.SPLT;
            break;
            case STDY: purposeCodeBO = PurposeCodeBO.STDY;
            break;
            case TBAN: purposeCodeBO = PurposeCodeBO.TBAN;
            break;
            case TBIL: purposeCodeBO = PurposeCodeBO.TBIL;
            break;
            case TCSC: purposeCodeBO = PurposeCodeBO.TCSC;
            break;
            case TELI: purposeCodeBO = PurposeCodeBO.TELI;
            break;
            case TMPG: purposeCodeBO = PurposeCodeBO.TMPG;
            break;
            case TPRI: purposeCodeBO = PurposeCodeBO.TPRI;
            break;
            case TPRP: purposeCodeBO = PurposeCodeBO.TPRP;
            break;
            case TRNC: purposeCodeBO = PurposeCodeBO.TRNC;
            break;
            case TRVC: purposeCodeBO = PurposeCodeBO.TRVC;
            break;
            case WEBI: purposeCodeBO = PurposeCodeBO.WEBI;
            break;
            case ANNI: purposeCodeBO = PurposeCodeBO.ANNI;
            break;
            case CAFI: purposeCodeBO = PurposeCodeBO.CAFI;
            break;
            case CFDI: purposeCodeBO = PurposeCodeBO.CFDI;
            break;
            case CMDT: purposeCodeBO = PurposeCodeBO.CMDT;
            break;
            case DERI: purposeCodeBO = PurposeCodeBO.DERI;
            break;
            case DIVD: purposeCodeBO = PurposeCodeBO.DIVD;
            break;
            case FREX: purposeCodeBO = PurposeCodeBO.FREX;
            break;
            case HEDG: purposeCodeBO = PurposeCodeBO.HEDG;
            break;
            case INVS: purposeCodeBO = PurposeCodeBO.INVS;
            break;
            case PRME: purposeCodeBO = PurposeCodeBO.PRME;
            break;
            case SAVG: purposeCodeBO = PurposeCodeBO.SAVG;
            break;
            case SECU: purposeCodeBO = PurposeCodeBO.SECU;
            break;
            case SEPI: purposeCodeBO = PurposeCodeBO.SEPI;
            break;
            case TREA: purposeCodeBO = PurposeCodeBO.TREA;
            break;
            case UNIT: purposeCodeBO = PurposeCodeBO.UNIT;
            break;
            case FNET: purposeCodeBO = PurposeCodeBO.FNET;
            break;
            case FUTR: purposeCodeBO = PurposeCodeBO.FUTR;
            break;
            case ANTS: purposeCodeBO = PurposeCodeBO.ANTS;
            break;
            case CVCF: purposeCodeBO = PurposeCodeBO.CVCF;
            break;
            case DMEQ: purposeCodeBO = PurposeCodeBO.DMEQ;
            break;
            case DNTS: purposeCodeBO = PurposeCodeBO.DNTS;
            break;
            case HLTC: purposeCodeBO = PurposeCodeBO.HLTC;
            break;
            case HLTI: purposeCodeBO = PurposeCodeBO.HLTI;
            break;
            case HSPC: purposeCodeBO = PurposeCodeBO.HSPC;
            break;
            case ICRF: purposeCodeBO = PurposeCodeBO.ICRF;
            break;
            case LTCF: purposeCodeBO = PurposeCodeBO.LTCF;
            break;
            case MAFC: purposeCodeBO = PurposeCodeBO.MAFC;
            break;
            case MARF: purposeCodeBO = PurposeCodeBO.MARF;
            break;
            case MDCS: purposeCodeBO = PurposeCodeBO.MDCS;
            break;
            case VIEW: purposeCodeBO = PurposeCodeBO.VIEW;
            break;
            case CDEP: purposeCodeBO = PurposeCodeBO.CDEP;
            break;
            case SWFP: purposeCodeBO = PurposeCodeBO.SWFP;
            break;
            case SWPP: purposeCodeBO = PurposeCodeBO.SWPP;
            break;
            case SWRS: purposeCodeBO = PurposeCodeBO.SWRS;
            break;
            case SWUF: purposeCodeBO = PurposeCodeBO.SWUF;
            break;
            case ADCS: purposeCodeBO = PurposeCodeBO.ADCS;
            break;
            case AEMP: purposeCodeBO = PurposeCodeBO.AEMP;
            break;
            case ALLW: purposeCodeBO = PurposeCodeBO.ALLW;
            break;
            case ALMY: purposeCodeBO = PurposeCodeBO.ALMY;
            break;
            case BBSC: purposeCodeBO = PurposeCodeBO.BBSC;
            break;
            case BECH: purposeCodeBO = PurposeCodeBO.BECH;
            break;
            case BENE: purposeCodeBO = PurposeCodeBO.BENE;
            break;
            case BONU: purposeCodeBO = PurposeCodeBO.BONU;
            break;
            case CCHD: purposeCodeBO = PurposeCodeBO.CCHD;
            break;
            case COMM: purposeCodeBO = PurposeCodeBO.COMM;
            break;
            case CSLP: purposeCodeBO = PurposeCodeBO.CSLP;
            break;
            case GFRP: purposeCodeBO = PurposeCodeBO.GFRP;
            break;
            case GVEA: purposeCodeBO = PurposeCodeBO.GVEA;
            break;
            case GVEB: purposeCodeBO = PurposeCodeBO.GVEB;
            break;
            case GVEC: purposeCodeBO = PurposeCodeBO.GVEC;
            break;
            case GVED: purposeCodeBO = PurposeCodeBO.GVED;
            break;
            case GWLT: purposeCodeBO = PurposeCodeBO.GWLT;
            break;
            case HREC: purposeCodeBO = PurposeCodeBO.HREC;
            break;
            case PAYR: purposeCodeBO = PurposeCodeBO.PAYR;
            break;
            case PEFC: purposeCodeBO = PurposeCodeBO.PEFC;
            break;
            case PENS: purposeCodeBO = PurposeCodeBO.PENS;
            break;
            case PRCP: purposeCodeBO = PurposeCodeBO.PRCP;
            break;
            case RHBS: purposeCodeBO = PurposeCodeBO.RHBS;
            break;
            case SALA: purposeCodeBO = PurposeCodeBO.SALA;
            break;
            case SSBE: purposeCodeBO = PurposeCodeBO.SSBE;
            break;
            case LBIN: purposeCodeBO = PurposeCodeBO.LBIN;
            break;
            case LCOL: purposeCodeBO = PurposeCodeBO.LCOL;
            break;
            case LFEE: purposeCodeBO = PurposeCodeBO.LFEE;
            break;
            case LMEQ: purposeCodeBO = PurposeCodeBO.LMEQ;
            break;
            case LMFI: purposeCodeBO = PurposeCodeBO.LMFI;
            break;
            case LMRK: purposeCodeBO = PurposeCodeBO.LMRK;
            break;
            case LREB: purposeCodeBO = PurposeCodeBO.LREB;
            break;
            case LREV: purposeCodeBO = PurposeCodeBO.LREV;
            break;
            case LSFL: purposeCodeBO = PurposeCodeBO.LSFL;
            break;
            case ESTX: purposeCodeBO = PurposeCodeBO.ESTX;
            break;
            case FWLV: purposeCodeBO = PurposeCodeBO.FWLV;
            break;
            case GSTX: purposeCodeBO = PurposeCodeBO.GSTX;
            break;
            case HSTX: purposeCodeBO = PurposeCodeBO.HSTX;
            break;
            case INTX: purposeCodeBO = PurposeCodeBO.INTX;
            break;
            case NITX: purposeCodeBO = PurposeCodeBO.NITX;
            break;
            case PTXP: purposeCodeBO = PurposeCodeBO.PTXP;
            break;
            case RDTX: purposeCodeBO = PurposeCodeBO.RDTX;
            break;
            case TAXS: purposeCodeBO = PurposeCodeBO.TAXS;
            break;
            case VATX: purposeCodeBO = PurposeCodeBO.VATX;
            break;
            case WHLD: purposeCodeBO = PurposeCodeBO.WHLD;
            break;
            case TAXR: purposeCodeBO = PurposeCodeBO.TAXR;
            break;
            case B112: purposeCodeBO = PurposeCodeBO.B112;
            break;
            case BR12: purposeCodeBO = PurposeCodeBO.BR12;
            break;
            case TLRF: purposeCodeBO = PurposeCodeBO.TLRF;
            break;
            case TLRR: purposeCodeBO = PurposeCodeBO.TLRR;
            break;
            case AIRB: purposeCodeBO = PurposeCodeBO.AIRB;
            break;
            case BUSB: purposeCodeBO = PurposeCodeBO.BUSB;
            break;
            case FERB: purposeCodeBO = PurposeCodeBO.FERB;
            break;
            case RLWY: purposeCodeBO = PurposeCodeBO.RLWY;
            break;
            case TRPT: purposeCodeBO = PurposeCodeBO.TRPT;
            break;
            case CBTV: purposeCodeBO = PurposeCodeBO.CBTV;
            break;
            case ELEC: purposeCodeBO = PurposeCodeBO.ELEC;
            break;
            case ENRG: purposeCodeBO = PurposeCodeBO.ENRG;
            break;
            case GASB: purposeCodeBO = PurposeCodeBO.GASB;
            break;
            case NWCH: purposeCodeBO = PurposeCodeBO.NWCH;
            break;
            case NWCM: purposeCodeBO = PurposeCodeBO.NWCM;
            break;
            case OTLC: purposeCodeBO = PurposeCodeBO.OTLC;
            break;
            case PHON: purposeCodeBO = PurposeCodeBO.PHON;
            break;
            case UBIL: purposeCodeBO = PurposeCodeBO.UBIL;
            break;
            case WTER: purposeCodeBO = PurposeCodeBO.WTER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + purposeCodeTO );
        }

        return purposeCodeBO;
    }

    protected RemittanceInformationStructuredBO remittanceInformationStructuredTOToRemittanceInformationStructuredBO(RemittanceInformationStructuredTO remittanceInformationStructuredTO) {
        if ( remittanceInformationStructuredTO == null ) {
            return null;
        }

        RemittanceInformationStructuredBO remittanceInformationStructuredBO = new RemittanceInformationStructuredBO();

        remittanceInformationStructuredBO.setReference( remittanceInformationStructuredTO.getReference() );
        remittanceInformationStructuredBO.setReferenceType( remittanceInformationStructuredTO.getReferenceType() );
        remittanceInformationStructuredBO.setReferenceIssuer( remittanceInformationStructuredTO.getReferenceIssuer() );

        return remittanceInformationStructuredBO;
    }

    protected PaymentTargetBO paymentTargetTOToPaymentTargetBO(PaymentTargetTO paymentTargetTO) {
        if ( paymentTargetTO == null ) {
            return null;
        }

        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();

        paymentTargetBO.setPaymentId( paymentTargetTO.getPaymentId() );
        paymentTargetBO.setEndToEndIdentification( paymentTargetTO.getEndToEndIdentification() );
        paymentTargetBO.setInstructedAmount( amountTOToAmountBO( paymentTargetTO.getInstructedAmount() ) );
        paymentTargetBO.setCreditorAccount( accountReferenceTOToAccountReferenceBO( paymentTargetTO.getCreditorAccount() ) );
        paymentTargetBO.setCreditorAgent( paymentTargetTO.getCreditorAgent() );
        paymentTargetBO.setCreditorName( paymentTargetTO.getCreditorName() );
        paymentTargetBO.setCreditorAddress( addressTOToAddressBO( paymentTargetTO.getCreditorAddress() ) );
        paymentTargetBO.setPurposeCode( purposeCodeTOToPurposeCodeBO( paymentTargetTO.getPurposeCode() ) );
        paymentTargetBO.setRemittanceInformationUnstructured( paymentTargetTO.getRemittanceInformationUnstructured() );
        paymentTargetBO.setRemittanceInformationStructured( remittanceInformationStructuredTOToRemittanceInformationStructuredBO( paymentTargetTO.getRemittanceInformationStructured() ) );

        return paymentTargetBO;
    }

    protected List<PaymentTargetBO> paymentTargetTOListToPaymentTargetBOList(List<PaymentTargetTO> list) {
        if ( list == null ) {
            return null;
        }

        List<PaymentTargetBO> list1 = new ArrayList<PaymentTargetBO>( list.size() );
        for ( PaymentTargetTO paymentTargetTO : list ) {
            list1.add( paymentTargetTOToPaymentTargetBO( paymentTargetTO ) );
        }

        return list1;
    }

    protected AmountTO amountBOToAmountTO(AmountBO amountBO) {
        if ( amountBO == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( amountBO.getCurrency() );
        amountTO.setAmount( amountBO.getAmount() );

        return amountTO;
    }

    protected List<ExchangeRateTO> exchangeRateBOListToExchangeRateTOList(List<ExchangeRateBO> list) {
        if ( list == null ) {
            return null;
        }

        List<ExchangeRateTO> list1 = new ArrayList<ExchangeRateTO>( list.size() );
        for ( ExchangeRateBO exchangeRateBO : list ) {
            list1.add( toExchangeRateTO( exchangeRateBO ) );
        }

        return list1;
    }

    protected AccountReferenceTO accountReferenceBOToAccountReferenceTO(AccountReferenceBO accountReferenceBO) {
        if ( accountReferenceBO == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( accountReferenceBO.getIban() );
        accountReferenceTO.setBban( accountReferenceBO.getBban() );
        accountReferenceTO.setPan( accountReferenceBO.getPan() );
        accountReferenceTO.setMaskedPan( accountReferenceBO.getMaskedPan() );
        accountReferenceTO.setMsisdn( accountReferenceBO.getMsisdn() );
        accountReferenceTO.setCurrency( accountReferenceBO.getCurrency() );

        return accountReferenceTO;
    }

    protected RemittanceInformationStructuredTO remittanceInformationStructuredBOToRemittanceInformationStructuredTO(RemittanceInformationStructuredBO remittanceInformationStructuredBO) {
        if ( remittanceInformationStructuredBO == null ) {
            return null;
        }

        RemittanceInformationStructuredTO remittanceInformationStructuredTO = new RemittanceInformationStructuredTO();

        remittanceInformationStructuredTO.setReference( remittanceInformationStructuredBO.getReference() );
        remittanceInformationStructuredTO.setReferenceType( remittanceInformationStructuredBO.getReferenceType() );
        remittanceInformationStructuredTO.setReferenceIssuer( remittanceInformationStructuredBO.getReferenceIssuer() );

        return remittanceInformationStructuredTO;
    }

    protected BalanceTypeTO balanceTypeBOToBalanceTypeTO(BalanceTypeBO balanceTypeBO) {
        if ( balanceTypeBO == null ) {
            return null;
        }

        BalanceTypeTO balanceTypeTO;

        switch ( balanceTypeBO ) {
            case CLOSING_BOOKED: balanceTypeTO = BalanceTypeTO.CLOSING_BOOKED;
            break;
            case EXPECTED: balanceTypeTO = BalanceTypeTO.EXPECTED;
            break;
            case INTERIM_BOOKED: balanceTypeTO = BalanceTypeTO.INTERIM_BOOKED;
            break;
            case OPENING_BOOKED: balanceTypeTO = BalanceTypeTO.OPENING_BOOKED;
            break;
            case INTERIM_AVAILABLE: balanceTypeTO = BalanceTypeTO.INTERIM_AVAILABLE;
            break;
            case FORWARD_AVAILABLE: balanceTypeTO = BalanceTypeTO.FORWARD_AVAILABLE;
            break;
            case NONINVOICED: balanceTypeTO = BalanceTypeTO.NONINVOICED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + balanceTypeBO );
        }

        return balanceTypeTO;
    }

    protected AccountBalanceTO balanceBOToAccountBalanceTO(BalanceBO balanceBO) {
        if ( balanceBO == null ) {
            return null;
        }

        AccountBalanceTO accountBalanceTO = new AccountBalanceTO();

        accountBalanceTO.setAmount( amountBOToAmountTO( balanceBO.getAmount() ) );
        accountBalanceTO.setBalanceType( balanceTypeBOToBalanceTypeTO( balanceBO.getBalanceType() ) );
        accountBalanceTO.setLastChangeDateTime( balanceBO.getLastChangeDateTime() );
        accountBalanceTO.setReferenceDate( balanceBO.getReferenceDate() );
        accountBalanceTO.setLastCommittedTransaction( balanceBO.getLastCommittedTransaction() );

        return accountBalanceTO;
    }

    protected ExchangeRateBO exchangeRateTOToExchangeRateBO(ExchangeRateTO exchangeRateTO) {
        if ( exchangeRateTO == null ) {
            return null;
        }

        ExchangeRateBO exchangeRateBO = new ExchangeRateBO();

        exchangeRateBO.setCurrencyFrom( exchangeRateTO.getCurrencyFrom() );
        exchangeRateBO.setRateFrom( exchangeRateTO.getRateFrom() );
        exchangeRateBO.setRateTo( exchangeRateTO.getRateTo() );
        exchangeRateBO.setRateDate( exchangeRateTO.getRateDate() );
        exchangeRateBO.setRateContract( exchangeRateTO.getRateContract() );

        return exchangeRateBO;
    }

    protected List<ExchangeRateBO> exchangeRateTOListToExchangeRateBOList(List<ExchangeRateTO> list) {
        if ( list == null ) {
            return null;
        }

        List<ExchangeRateBO> list1 = new ArrayList<ExchangeRateBO>( list.size() );
        for ( ExchangeRateTO exchangeRateTO : list ) {
            list1.add( exchangeRateTOToExchangeRateBO( exchangeRateTO ) );
        }

        return list1;
    }

    protected BalanceTypeBO balanceTypeTOToBalanceTypeBO(BalanceTypeTO balanceTypeTO) {
        if ( balanceTypeTO == null ) {
            return null;
        }

        BalanceTypeBO balanceTypeBO;

        switch ( balanceTypeTO ) {
            case CLOSING_BOOKED: balanceTypeBO = BalanceTypeBO.CLOSING_BOOKED;
            break;
            case EXPECTED: balanceTypeBO = BalanceTypeBO.EXPECTED;
            break;
            case INTERIM_BOOKED: balanceTypeBO = BalanceTypeBO.INTERIM_BOOKED;
            break;
            case OPENING_BOOKED: balanceTypeBO = BalanceTypeBO.OPENING_BOOKED;
            break;
            case INTERIM_AVAILABLE: balanceTypeBO = BalanceTypeBO.INTERIM_AVAILABLE;
            break;
            case FORWARD_AVAILABLE: balanceTypeBO = BalanceTypeBO.FORWARD_AVAILABLE;
            break;
            case NONINVOICED: balanceTypeBO = BalanceTypeBO.NONINVOICED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + balanceTypeTO );
        }

        return balanceTypeBO;
    }

    protected BalanceBO accountBalanceTOToBalanceBO(AccountBalanceTO accountBalanceTO) {
        if ( accountBalanceTO == null ) {
            return null;
        }

        BalanceBO balanceBO = new BalanceBO();

        balanceBO.setAmount( amountTOToAmountBO( accountBalanceTO.getAmount() ) );
        balanceBO.setBalanceType( balanceTypeTOToBalanceTypeBO( accountBalanceTO.getBalanceType() ) );
        balanceBO.setLastChangeDateTime( accountBalanceTO.getLastChangeDateTime() );
        balanceBO.setReferenceDate( accountBalanceTO.getReferenceDate() );
        balanceBO.setLastCommittedTransaction( accountBalanceTO.getLastCommittedTransaction() );

        return balanceBO;
    }

    protected PaymentTypeTO paymentTypeBOToPaymentTypeTO(PaymentTypeBO paymentTypeBO) {
        if ( paymentTypeBO == null ) {
            return null;
        }

        PaymentTypeTO paymentTypeTO;

        switch ( paymentTypeBO ) {
            case SINGLE: paymentTypeTO = PaymentTypeTO.SINGLE;
            break;
            case BULK: paymentTypeTO = PaymentTypeTO.BULK;
            break;
            case PERIODIC: paymentTypeTO = PaymentTypeTO.PERIODIC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentTypeBO );
        }

        return paymentTypeTO;
    }

    protected FrequencyCodeTO frequencyCodeBOToFrequencyCodeTO(FrequencyCodeBO frequencyCodeBO) {
        if ( frequencyCodeBO == null ) {
            return null;
        }

        FrequencyCodeTO frequencyCodeTO;

        switch ( frequencyCodeBO ) {
            case DAILY: frequencyCodeTO = FrequencyCodeTO.DAILY;
            break;
            case WEEKLY: frequencyCodeTO = FrequencyCodeTO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeTO = FrequencyCodeTO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeTO = FrequencyCodeTO.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCodeTO = FrequencyCodeTO.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCodeBO );
        }

        return frequencyCodeTO;
    }

    protected TransactionStatusTO transactionStatusBOToTransactionStatusTO(TransactionStatusBO transactionStatusBO) {
        if ( transactionStatusBO == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( transactionStatusBO ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatusBO );
        }

        return transactionStatusTO;
    }

    protected AddressTO addressBOToAddressTO(AddressBO addressBO) {
        if ( addressBO == null ) {
            return null;
        }

        AddressTO addressTO = new AddressTO();

        addressTO.setStreet( addressBO.getStreet() );
        addressTO.setBuildingNumber( addressBO.getBuildingNumber() );
        addressTO.setCity( addressBO.getCity() );
        addressTO.setPostalCode( addressBO.getPostalCode() );
        addressTO.setCountry( addressBO.getCountry() );
        addressTO.setLine1( addressBO.getLine1() );
        addressTO.setLine2( addressBO.getLine2() );

        return addressTO;
    }

    protected PurposeCodeTO purposeCodeBOToPurposeCodeTO(PurposeCodeBO purposeCodeBO) {
        if ( purposeCodeBO == null ) {
            return null;
        }

        PurposeCodeTO purposeCodeTO;

        switch ( purposeCodeBO ) {
            case BKDF: purposeCodeTO = PurposeCodeTO.BKDF;
            break;
            case BKFE: purposeCodeTO = PurposeCodeTO.BKFE;
            break;
            case BKFM: purposeCodeTO = PurposeCodeTO.BKFM;
            break;
            case BKIP: purposeCodeTO = PurposeCodeTO.BKIP;
            break;
            case BKPP: purposeCodeTO = PurposeCodeTO.BKPP;
            break;
            case CBLK: purposeCodeTO = PurposeCodeTO.CBLK;
            break;
            case CDCB: purposeCodeTO = PurposeCodeTO.CDCB;
            break;
            case CDCD: purposeCodeTO = PurposeCodeTO.CDCD;
            break;
            case CDCS: purposeCodeTO = PurposeCodeTO.CDCS;
            break;
            case CDDP: purposeCodeTO = PurposeCodeTO.CDDP;
            break;
            case CDOC: purposeCodeTO = PurposeCodeTO.CDOC;
            break;
            case CDQC: purposeCodeTO = PurposeCodeTO.CDQC;
            break;
            case ETUP: purposeCodeTO = PurposeCodeTO.ETUP;
            break;
            case FCOL: purposeCodeTO = PurposeCodeTO.FCOL;
            break;
            case MTUP: purposeCodeTO = PurposeCodeTO.MTUP;
            break;
            case ACCT: purposeCodeTO = PurposeCodeTO.ACCT;
            break;
            case CASH: purposeCodeTO = PurposeCodeTO.CASH;
            break;
            case COLL: purposeCodeTO = PurposeCodeTO.COLL;
            break;
            case CSDB: purposeCodeTO = PurposeCodeTO.CSDB;
            break;
            case DEPT: purposeCodeTO = PurposeCodeTO.DEPT;
            break;
            case INTC: purposeCodeTO = PurposeCodeTO.INTC;
            break;
            case LIMA: purposeCodeTO = PurposeCodeTO.LIMA;
            break;
            case NETT: purposeCodeTO = PurposeCodeTO.NETT;
            break;
            case BFWD: purposeCodeTO = PurposeCodeTO.BFWD;
            break;
            case CCIR: purposeCodeTO = PurposeCodeTO.CCIR;
            break;
            case CCPC: purposeCodeTO = PurposeCodeTO.CCPC;
            break;
            case CCPM: purposeCodeTO = PurposeCodeTO.CCPM;
            break;
            case CCSM: purposeCodeTO = PurposeCodeTO.CCSM;
            break;
            case CRDS: purposeCodeTO = PurposeCodeTO.CRDS;
            break;
            case CRPR: purposeCodeTO = PurposeCodeTO.CRPR;
            break;
            case CRSP: purposeCodeTO = PurposeCodeTO.CRSP;
            break;
            case CRTL: purposeCodeTO = PurposeCodeTO.CRTL;
            break;
            case EQPT: purposeCodeTO = PurposeCodeTO.EQPT;
            break;
            case EQUS: purposeCodeTO = PurposeCodeTO.EQUS;
            break;
            case EXPT: purposeCodeTO = PurposeCodeTO.EXPT;
            break;
            case EXTD: purposeCodeTO = PurposeCodeTO.EXTD;
            break;
            case FIXI: purposeCodeTO = PurposeCodeTO.FIXI;
            break;
            case FWBC: purposeCodeTO = PurposeCodeTO.FWBC;
            break;
            case FWCC: purposeCodeTO = PurposeCodeTO.FWCC;
            break;
            case FWSB: purposeCodeTO = PurposeCodeTO.FWSB;
            break;
            case FWSC: purposeCodeTO = PurposeCodeTO.FWSC;
            break;
            case MARG: purposeCodeTO = PurposeCodeTO.MARG;
            break;
            case MBSB: purposeCodeTO = PurposeCodeTO.MBSB;
            break;
            case MBSC: purposeCodeTO = PurposeCodeTO.MBSC;
            break;
            case MGCC: purposeCodeTO = PurposeCodeTO.MGCC;
            break;
            case MGSC: purposeCodeTO = PurposeCodeTO.MGSC;
            break;
            case OCCC: purposeCodeTO = PurposeCodeTO.OCCC;
            break;
            case OPBC: purposeCodeTO = PurposeCodeTO.OPBC;
            break;
            case OPCC: purposeCodeTO = PurposeCodeTO.OPCC;
            break;
            case OPSB: purposeCodeTO = PurposeCodeTO.OPSB;
            break;
            case OPSC: purposeCodeTO = PurposeCodeTO.OPSC;
            break;
            case OPTN: purposeCodeTO = PurposeCodeTO.OPTN;
            break;
            case OTCD: purposeCodeTO = PurposeCodeTO.OTCD;
            break;
            case REPO: purposeCodeTO = PurposeCodeTO.REPO;
            break;
            case RPBC: purposeCodeTO = PurposeCodeTO.RPBC;
            break;
            case RPCC: purposeCodeTO = PurposeCodeTO.RPCC;
            break;
            case RPSB: purposeCodeTO = PurposeCodeTO.RPSB;
            break;
            case RPSC: purposeCodeTO = PurposeCodeTO.RPSC;
            break;
            case RVPO: purposeCodeTO = PurposeCodeTO.RVPO;
            break;
            case SBSC: purposeCodeTO = PurposeCodeTO.SBSC;
            break;
            case SCIE: purposeCodeTO = PurposeCodeTO.SCIE;
            break;
            case SCIR: purposeCodeTO = PurposeCodeTO.SCIR;
            break;
            case SCRP: purposeCodeTO = PurposeCodeTO.SCRP;
            break;
            case SHBC: purposeCodeTO = PurposeCodeTO.SHBC;
            break;
            case SHCC: purposeCodeTO = PurposeCodeTO.SHCC;
            break;
            case SHSL: purposeCodeTO = PurposeCodeTO.SHSL;
            break;
            case SLEB: purposeCodeTO = PurposeCodeTO.SLEB;
            break;
            case SLOA: purposeCodeTO = PurposeCodeTO.SLOA;
            break;
            case SWBC: purposeCodeTO = PurposeCodeTO.SWBC;
            break;
            case SWCC: purposeCodeTO = PurposeCodeTO.SWCC;
            break;
            case SWPT: purposeCodeTO = PurposeCodeTO.SWPT;
            break;
            case SWSB: purposeCodeTO = PurposeCodeTO.SWSB;
            break;
            case SWSC: purposeCodeTO = PurposeCodeTO.SWSC;
            break;
            case TBAS: purposeCodeTO = PurposeCodeTO.TBAS;
            break;
            case TBBC: purposeCodeTO = PurposeCodeTO.TBBC;
            break;
            case TBCC: purposeCodeTO = PurposeCodeTO.TBCC;
            break;
            case TRCP: purposeCodeTO = PurposeCodeTO.TRCP;
            break;
            case AGRT: purposeCodeTO = PurposeCodeTO.AGRT;
            break;
            case AREN: purposeCodeTO = PurposeCodeTO.AREN;
            break;
            case BEXP: purposeCodeTO = PurposeCodeTO.BEXP;
            break;
            case BOCE: purposeCodeTO = PurposeCodeTO.BOCE;
            break;
            case COMC: purposeCodeTO = PurposeCodeTO.COMC;
            break;
            case CPYR: purposeCodeTO = PurposeCodeTO.CPYR;
            break;
            case GDDS: purposeCodeTO = PurposeCodeTO.GDDS;
            break;
            case GDSV: purposeCodeTO = PurposeCodeTO.GDSV;
            break;
            case GSCB: purposeCodeTO = PurposeCodeTO.GSCB;
            break;
            case LICF: purposeCodeTO = PurposeCodeTO.LICF;
            break;
            case MP2B: purposeCodeTO = PurposeCodeTO.MP2B;
            break;
            case POPE: purposeCodeTO = PurposeCodeTO.POPE;
            break;
            case ROYA: purposeCodeTO = PurposeCodeTO.ROYA;
            break;
            case SCVE: purposeCodeTO = PurposeCodeTO.SCVE;
            break;
            case SERV: purposeCodeTO = PurposeCodeTO.SERV;
            break;
            case SUBS: purposeCodeTO = PurposeCodeTO.SUBS;
            break;
            case SUPP: purposeCodeTO = PurposeCodeTO.SUPP;
            break;
            case TRAD: purposeCodeTO = PurposeCodeTO.TRAD;
            break;
            case CHAR: purposeCodeTO = PurposeCodeTO.CHAR;
            break;
            case COMT: purposeCodeTO = PurposeCodeTO.COMT;
            break;
            case MP2P: purposeCodeTO = PurposeCodeTO.MP2P;
            break;
            case ECPG: purposeCodeTO = PurposeCodeTO.ECPG;
            break;
            case ECPR: purposeCodeTO = PurposeCodeTO.ECPR;
            break;
            case ECPU: purposeCodeTO = PurposeCodeTO.ECPU;
            break;
            case EPAY: purposeCodeTO = PurposeCodeTO.EPAY;
            break;
            case CLPR: purposeCodeTO = PurposeCodeTO.CLPR;
            break;
            case COMP: purposeCodeTO = PurposeCodeTO.COMP;
            break;
            case DBTC: purposeCodeTO = PurposeCodeTO.DBTC;
            break;
            case GOVI: purposeCodeTO = PurposeCodeTO.GOVI;
            break;
            case HLRP: purposeCodeTO = PurposeCodeTO.HLRP;
            break;
            case HLST: purposeCodeTO = PurposeCodeTO.HLST;
            break;
            case INPC: purposeCodeTO = PurposeCodeTO.INPC;
            break;
            case INPR: purposeCodeTO = PurposeCodeTO.INPR;
            break;
            case INSC: purposeCodeTO = PurposeCodeTO.INSC;
            break;
            case INSU: purposeCodeTO = PurposeCodeTO.INSU;
            break;
            case INTE: purposeCodeTO = PurposeCodeTO.INTE;
            break;
            case LBRI: purposeCodeTO = PurposeCodeTO.LBRI;
            break;
            case LIFI: purposeCodeTO = PurposeCodeTO.LIFI;
            break;
            case LOAN: purposeCodeTO = PurposeCodeTO.LOAN;
            break;
            case LOAR: purposeCodeTO = PurposeCodeTO.LOAR;
            break;
            case PENO: purposeCodeTO = PurposeCodeTO.PENO;
            break;
            case PPTI: purposeCodeTO = PurposeCodeTO.PPTI;
            break;
            case RELG: purposeCodeTO = PurposeCodeTO.RELG;
            break;
            case RINP: purposeCodeTO = PurposeCodeTO.RINP;
            break;
            case TRFD: purposeCodeTO = PurposeCodeTO.TRFD;
            break;
            case FORW: purposeCodeTO = PurposeCodeTO.FORW;
            break;
            case FXNT: purposeCodeTO = PurposeCodeTO.FXNT;
            break;
            case ADMG: purposeCodeTO = PurposeCodeTO.ADMG;
            break;
            case ADVA: purposeCodeTO = PurposeCodeTO.ADVA;
            break;
            case BCDM: purposeCodeTO = PurposeCodeTO.BCDM;
            break;
            case BCFG: purposeCodeTO = PurposeCodeTO.BCFG;
            break;
            case BLDM: purposeCodeTO = PurposeCodeTO.BLDM;
            break;
            case BNET: purposeCodeTO = PurposeCodeTO.BNET;
            break;
            case CBFF: purposeCodeTO = PurposeCodeTO.CBFF;
            break;
            case CBFR: purposeCodeTO = PurposeCodeTO.CBFR;
            break;
            case CCRD: purposeCodeTO = PurposeCodeTO.CCRD;
            break;
            case CDBL: purposeCodeTO = PurposeCodeTO.CDBL;
            break;
            case CFEE: purposeCodeTO = PurposeCodeTO.CFEE;
            break;
            case CGDD: purposeCodeTO = PurposeCodeTO.CGDD;
            break;
            case CORT: purposeCodeTO = PurposeCodeTO.CORT;
            break;
            case COST: purposeCodeTO = PurposeCodeTO.COST;
            break;
            case CPKC: purposeCodeTO = PurposeCodeTO.CPKC;
            break;
            case DCRD: purposeCodeTO = PurposeCodeTO.DCRD;
            break;
            case DSMT: purposeCodeTO = PurposeCodeTO.DSMT;
            break;
            case DVPM: purposeCodeTO = PurposeCodeTO.DVPM;
            break;
            case EDUC: purposeCodeTO = PurposeCodeTO.EDUC;
            break;
            case FACT: purposeCodeTO = PurposeCodeTO.FACT;
            break;
            case FAND: purposeCodeTO = PurposeCodeTO.FAND;
            break;
            case FCPM: purposeCodeTO = PurposeCodeTO.FCPM;
            break;
            case FEES: purposeCodeTO = PurposeCodeTO.FEES;
            break;
            case GOVT: purposeCodeTO = PurposeCodeTO.GOVT;
            break;
            case ICCP: purposeCodeTO = PurposeCodeTO.ICCP;
            break;
            case IDCP: purposeCodeTO = PurposeCodeTO.IDCP;
            break;
            case IHRP: purposeCodeTO = PurposeCodeTO.IHRP;
            break;
            case INSM: purposeCodeTO = PurposeCodeTO.INSM;
            break;
            case IVPT: purposeCodeTO = PurposeCodeTO.IVPT;
            break;
            case MCDM: purposeCodeTO = PurposeCodeTO.MCDM;
            break;
            case MCFG: purposeCodeTO = PurposeCodeTO.MCFG;
            break;
            case MSVC: purposeCodeTO = PurposeCodeTO.MSVC;
            break;
            case NOWS: purposeCodeTO = PurposeCodeTO.NOWS;
            break;
            case OCDM: purposeCodeTO = PurposeCodeTO.OCDM;
            break;
            case OCFG: purposeCodeTO = PurposeCodeTO.OCFG;
            break;
            case OFEE: purposeCodeTO = PurposeCodeTO.OFEE;
            break;
            case OTHR: purposeCodeTO = PurposeCodeTO.OTHR;
            break;
            case PADD: purposeCodeTO = PurposeCodeTO.PADD;
            break;
            case PTSP: purposeCodeTO = PurposeCodeTO.PTSP;
            break;
            case RCKE: purposeCodeTO = PurposeCodeTO.RCKE;
            break;
            case RCPT: purposeCodeTO = PurposeCodeTO.RCPT;
            break;
            case REBT: purposeCodeTO = PurposeCodeTO.REBT;
            break;
            case REFU: purposeCodeTO = PurposeCodeTO.REFU;
            break;
            case RENT: purposeCodeTO = PurposeCodeTO.RENT;
            break;
            case REOD: purposeCodeTO = PurposeCodeTO.REOD;
            break;
            case RIMB: purposeCodeTO = PurposeCodeTO.RIMB;
            break;
            case RPNT: purposeCodeTO = PurposeCodeTO.RPNT;
            break;
            case RRBN: purposeCodeTO = PurposeCodeTO.RRBN;
            break;
            case RVPM: purposeCodeTO = PurposeCodeTO.RVPM;
            break;
            case SLPI: purposeCodeTO = PurposeCodeTO.SLPI;
            break;
            case SPLT: purposeCodeTO = PurposeCodeTO.SPLT;
            break;
            case STDY: purposeCodeTO = PurposeCodeTO.STDY;
            break;
            case TBAN: purposeCodeTO = PurposeCodeTO.TBAN;
            break;
            case TBIL: purposeCodeTO = PurposeCodeTO.TBIL;
            break;
            case TCSC: purposeCodeTO = PurposeCodeTO.TCSC;
            break;
            case TELI: purposeCodeTO = PurposeCodeTO.TELI;
            break;
            case TMPG: purposeCodeTO = PurposeCodeTO.TMPG;
            break;
            case TPRI: purposeCodeTO = PurposeCodeTO.TPRI;
            break;
            case TPRP: purposeCodeTO = PurposeCodeTO.TPRP;
            break;
            case TRNC: purposeCodeTO = PurposeCodeTO.TRNC;
            break;
            case TRVC: purposeCodeTO = PurposeCodeTO.TRVC;
            break;
            case WEBI: purposeCodeTO = PurposeCodeTO.WEBI;
            break;
            case ANNI: purposeCodeTO = PurposeCodeTO.ANNI;
            break;
            case CAFI: purposeCodeTO = PurposeCodeTO.CAFI;
            break;
            case CFDI: purposeCodeTO = PurposeCodeTO.CFDI;
            break;
            case CMDT: purposeCodeTO = PurposeCodeTO.CMDT;
            break;
            case DERI: purposeCodeTO = PurposeCodeTO.DERI;
            break;
            case DIVD: purposeCodeTO = PurposeCodeTO.DIVD;
            break;
            case FREX: purposeCodeTO = PurposeCodeTO.FREX;
            break;
            case HEDG: purposeCodeTO = PurposeCodeTO.HEDG;
            break;
            case INVS: purposeCodeTO = PurposeCodeTO.INVS;
            break;
            case PRME: purposeCodeTO = PurposeCodeTO.PRME;
            break;
            case SAVG: purposeCodeTO = PurposeCodeTO.SAVG;
            break;
            case SECU: purposeCodeTO = PurposeCodeTO.SECU;
            break;
            case SEPI: purposeCodeTO = PurposeCodeTO.SEPI;
            break;
            case TREA: purposeCodeTO = PurposeCodeTO.TREA;
            break;
            case UNIT: purposeCodeTO = PurposeCodeTO.UNIT;
            break;
            case FNET: purposeCodeTO = PurposeCodeTO.FNET;
            break;
            case FUTR: purposeCodeTO = PurposeCodeTO.FUTR;
            break;
            case ANTS: purposeCodeTO = PurposeCodeTO.ANTS;
            break;
            case CVCF: purposeCodeTO = PurposeCodeTO.CVCF;
            break;
            case DMEQ: purposeCodeTO = PurposeCodeTO.DMEQ;
            break;
            case DNTS: purposeCodeTO = PurposeCodeTO.DNTS;
            break;
            case HLTC: purposeCodeTO = PurposeCodeTO.HLTC;
            break;
            case HLTI: purposeCodeTO = PurposeCodeTO.HLTI;
            break;
            case HSPC: purposeCodeTO = PurposeCodeTO.HSPC;
            break;
            case ICRF: purposeCodeTO = PurposeCodeTO.ICRF;
            break;
            case LTCF: purposeCodeTO = PurposeCodeTO.LTCF;
            break;
            case MAFC: purposeCodeTO = PurposeCodeTO.MAFC;
            break;
            case MARF: purposeCodeTO = PurposeCodeTO.MARF;
            break;
            case MDCS: purposeCodeTO = PurposeCodeTO.MDCS;
            break;
            case VIEW: purposeCodeTO = PurposeCodeTO.VIEW;
            break;
            case CDEP: purposeCodeTO = PurposeCodeTO.CDEP;
            break;
            case SWFP: purposeCodeTO = PurposeCodeTO.SWFP;
            break;
            case SWPP: purposeCodeTO = PurposeCodeTO.SWPP;
            break;
            case SWRS: purposeCodeTO = PurposeCodeTO.SWRS;
            break;
            case SWUF: purposeCodeTO = PurposeCodeTO.SWUF;
            break;
            case ADCS: purposeCodeTO = PurposeCodeTO.ADCS;
            break;
            case AEMP: purposeCodeTO = PurposeCodeTO.AEMP;
            break;
            case ALLW: purposeCodeTO = PurposeCodeTO.ALLW;
            break;
            case ALMY: purposeCodeTO = PurposeCodeTO.ALMY;
            break;
            case BBSC: purposeCodeTO = PurposeCodeTO.BBSC;
            break;
            case BECH: purposeCodeTO = PurposeCodeTO.BECH;
            break;
            case BENE: purposeCodeTO = PurposeCodeTO.BENE;
            break;
            case BONU: purposeCodeTO = PurposeCodeTO.BONU;
            break;
            case CCHD: purposeCodeTO = PurposeCodeTO.CCHD;
            break;
            case COMM: purposeCodeTO = PurposeCodeTO.COMM;
            break;
            case CSLP: purposeCodeTO = PurposeCodeTO.CSLP;
            break;
            case GFRP: purposeCodeTO = PurposeCodeTO.GFRP;
            break;
            case GVEA: purposeCodeTO = PurposeCodeTO.GVEA;
            break;
            case GVEB: purposeCodeTO = PurposeCodeTO.GVEB;
            break;
            case GVEC: purposeCodeTO = PurposeCodeTO.GVEC;
            break;
            case GVED: purposeCodeTO = PurposeCodeTO.GVED;
            break;
            case GWLT: purposeCodeTO = PurposeCodeTO.GWLT;
            break;
            case HREC: purposeCodeTO = PurposeCodeTO.HREC;
            break;
            case PAYR: purposeCodeTO = PurposeCodeTO.PAYR;
            break;
            case PEFC: purposeCodeTO = PurposeCodeTO.PEFC;
            break;
            case PENS: purposeCodeTO = PurposeCodeTO.PENS;
            break;
            case PRCP: purposeCodeTO = PurposeCodeTO.PRCP;
            break;
            case RHBS: purposeCodeTO = PurposeCodeTO.RHBS;
            break;
            case SALA: purposeCodeTO = PurposeCodeTO.SALA;
            break;
            case SSBE: purposeCodeTO = PurposeCodeTO.SSBE;
            break;
            case LBIN: purposeCodeTO = PurposeCodeTO.LBIN;
            break;
            case LCOL: purposeCodeTO = PurposeCodeTO.LCOL;
            break;
            case LFEE: purposeCodeTO = PurposeCodeTO.LFEE;
            break;
            case LMEQ: purposeCodeTO = PurposeCodeTO.LMEQ;
            break;
            case LMFI: purposeCodeTO = PurposeCodeTO.LMFI;
            break;
            case LMRK: purposeCodeTO = PurposeCodeTO.LMRK;
            break;
            case LREB: purposeCodeTO = PurposeCodeTO.LREB;
            break;
            case LREV: purposeCodeTO = PurposeCodeTO.LREV;
            break;
            case LSFL: purposeCodeTO = PurposeCodeTO.LSFL;
            break;
            case ESTX: purposeCodeTO = PurposeCodeTO.ESTX;
            break;
            case FWLV: purposeCodeTO = PurposeCodeTO.FWLV;
            break;
            case GSTX: purposeCodeTO = PurposeCodeTO.GSTX;
            break;
            case HSTX: purposeCodeTO = PurposeCodeTO.HSTX;
            break;
            case INTX: purposeCodeTO = PurposeCodeTO.INTX;
            break;
            case NITX: purposeCodeTO = PurposeCodeTO.NITX;
            break;
            case PTXP: purposeCodeTO = PurposeCodeTO.PTXP;
            break;
            case RDTX: purposeCodeTO = PurposeCodeTO.RDTX;
            break;
            case TAXS: purposeCodeTO = PurposeCodeTO.TAXS;
            break;
            case VATX: purposeCodeTO = PurposeCodeTO.VATX;
            break;
            case WHLD: purposeCodeTO = PurposeCodeTO.WHLD;
            break;
            case TAXR: purposeCodeTO = PurposeCodeTO.TAXR;
            break;
            case B112: purposeCodeTO = PurposeCodeTO.B112;
            break;
            case BR12: purposeCodeTO = PurposeCodeTO.BR12;
            break;
            case TLRF: purposeCodeTO = PurposeCodeTO.TLRF;
            break;
            case TLRR: purposeCodeTO = PurposeCodeTO.TLRR;
            break;
            case AIRB: purposeCodeTO = PurposeCodeTO.AIRB;
            break;
            case BUSB: purposeCodeTO = PurposeCodeTO.BUSB;
            break;
            case FERB: purposeCodeTO = PurposeCodeTO.FERB;
            break;
            case RLWY: purposeCodeTO = PurposeCodeTO.RLWY;
            break;
            case TRPT: purposeCodeTO = PurposeCodeTO.TRPT;
            break;
            case CBTV: purposeCodeTO = PurposeCodeTO.CBTV;
            break;
            case ELEC: purposeCodeTO = PurposeCodeTO.ELEC;
            break;
            case ENRG: purposeCodeTO = PurposeCodeTO.ENRG;
            break;
            case GASB: purposeCodeTO = PurposeCodeTO.GASB;
            break;
            case NWCH: purposeCodeTO = PurposeCodeTO.NWCH;
            break;
            case NWCM: purposeCodeTO = PurposeCodeTO.NWCM;
            break;
            case OTLC: purposeCodeTO = PurposeCodeTO.OTLC;
            break;
            case PHON: purposeCodeTO = PurposeCodeTO.PHON;
            break;
            case UBIL: purposeCodeTO = PurposeCodeTO.UBIL;
            break;
            case WTER: purposeCodeTO = PurposeCodeTO.WTER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + purposeCodeBO );
        }

        return purposeCodeTO;
    }

    protected PaymentTargetTO paymentTargetBOToPaymentTargetTO(PaymentTargetBO paymentTargetBO) {
        if ( paymentTargetBO == null ) {
            return null;
        }

        PaymentTargetTO paymentTargetTO = new PaymentTargetTO();

        paymentTargetTO.setPaymentId( paymentTargetBO.getPaymentId() );
        paymentTargetTO.setEndToEndIdentification( paymentTargetBO.getEndToEndIdentification() );
        paymentTargetTO.setInstructedAmount( amountBOToAmountTO( paymentTargetBO.getInstructedAmount() ) );
        paymentTargetTO.setCreditorAccount( accountReferenceBOToAccountReferenceTO( paymentTargetBO.getCreditorAccount() ) );
        paymentTargetTO.setCreditorAgent( paymentTargetBO.getCreditorAgent() );
        paymentTargetTO.setCreditorName( paymentTargetBO.getCreditorName() );
        paymentTargetTO.setCreditorAddress( addressBOToAddressTO( paymentTargetBO.getCreditorAddress() ) );
        paymentTargetTO.setPurposeCode( purposeCodeBOToPurposeCodeTO( paymentTargetBO.getPurposeCode() ) );
        paymentTargetTO.setRemittanceInformationUnstructured( paymentTargetBO.getRemittanceInformationUnstructured() );
        paymentTargetTO.setRemittanceInformationStructured( remittanceInformationStructuredBOToRemittanceInformationStructuredTO( paymentTargetBO.getRemittanceInformationStructured() ) );

        return paymentTargetTO;
    }

    protected List<PaymentTargetTO> paymentTargetBOListToPaymentTargetTOList(List<PaymentTargetBO> list) {
        if ( list == null ) {
            return null;
        }

        List<PaymentTargetTO> list1 = new ArrayList<PaymentTargetTO>( list.size() );
        for ( PaymentTargetBO paymentTargetBO : list ) {
            list1.add( paymentTargetBOToPaymentTargetTO( paymentTargetBO ) );
        }

        return list1;
    }
}
