/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.service.TokenStorageService;
import java.io.IOException;
import java.util.Base64;

public class TokenStorageServiceImpl
implements TokenStorageService {
    ObjectMapper mapper;

    public SCAResponseTO fromBytes(byte[] tokenBytes) throws IOException {
        String type = this.readType(tokenBytes);
        if (SCAConsentResponseTO.class.getSimpleName().equals(type)) {
            return (SCAResponseTO)this.mapper.readValue(tokenBytes, SCAConsentResponseTO.class);
        }
        if (SCALoginResponseTO.class.getSimpleName().equals(type)) {
            return (SCAResponseTO)this.mapper.readValue(tokenBytes, SCALoginResponseTO.class);
        }
        if (SCAPaymentResponseTO.class.getSimpleName().equals(type)) {
            return (SCAResponseTO)this.mapper.readValue(tokenBytes, SCAPaymentResponseTO.class);
        }
        return null;
    }

    public byte[] toBytes(SCAResponseTO response) throws IOException {
        return this.mapper.writeValueAsBytes((Object)response);
    }

    public <T extends SCAResponseTO> T fromBytes(byte[] tokenBytes, Class<T> klass) throws IOException {
        String type = this.readType(tokenBytes);
        if (!klass.getSimpleName().equals(type)) {
            return null;
        }
        return (T)((SCAResponseTO)this.mapper.readValue(tokenBytes, klass));
    }

    private String readType(byte[] tokenBytes) throws IOException {
        JsonNode jsonNode = this.mapper.readTree(tokenBytes);
        JsonNode objectType = jsonNode.get("objectType");
        if (objectType == null) {
            return null;
        }
        return objectType.toString();
    }

    public String toBase64String(SCAResponseTO response) throws IOException {
        return Base64.getEncoder().encodeToString(this.toBytes(response));
    }
}

