/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRecoveryService;
import de.adorsys.ledgers.middleware.impl.converter.RecoveryPointMapperTO;
import de.adorsys.ledgers.sca.domain.RecoveryPointBO;
import de.adorsys.ledgers.sca.service.RecoveryPointService;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareRecoveryPointServiceImpl
implements MiddlewareRecoveryService {
    private final RecoveryPointService pointService;
    private final RecoveryPointMapperTO mapper;

    public void createRecoveryPoint(String branchId, RecoveryPointTO recoveryPoint) {
        RecoveryPointBO recoveryPointBO = this.mapper.toBO(recoveryPoint);
        recoveryPointBO.setBranchId(branchId);
        this.pointService.createRecoveryPoint(recoveryPointBO);
    }

    public List<RecoveryPointTO> getAll(String branchId) {
        return this.mapper.toTOs(this.pointService.getAllByBranch(branchId));
    }

    public RecoveryPointTO getPointById(String branchId, Long id) {
        return this.mapper.toTO(this.pointService.getById(id.longValue(), branchId));
    }

    public void deleteById(String branchId, Long id) {
        this.pointService.deleteRecoveryPoint(id.longValue(), branchId);
    }

    public MiddlewareRecoveryPointServiceImpl(RecoveryPointService pointService, RecoveryPointMapperTO mapper) {
        this.pointService = pointService;
        this.mapper = mapper;
    }
}

