/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.domain.sca.OpTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.LoginKeyDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.ScaInfoBO;
import de.adorsys.ledgers.um.api.domain.TokenUsageBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareOnlineBankingServiceImpl
implements MiddlewareOnlineBankingService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareOnlineBankingServiceImpl.class);
    private static final String NO_USER_MESSAGE = "No user message";
    private final UserMapper userTOMapper = (UserMapper)Mappers.getMapper(UserMapper.class);
    private final UserService userService;
    private final BearerTokenMapper bearerTokenMapper;
    private final SCAOperationService scaOperationService;
    private final SCAUtils scaUtils;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    @Value(value="${default.token.lifetime.seconds:600}")
    private int defaultLoginTokenExpireInSeconds;

    public SCALoginResponseTO authorise(String login, String pin, UserRoleTO role) {
        UserBO user = this.user(login);
        LoginKeyDataTO keyData = new LoginKeyDataTO(user.getId(), LocalDateTime.now());
        String opId = keyData.toOpId();
        BearerTokenBO loginTokenBO = this.proceedToLogin(user, pin, role, opId, opId);
        return this.authorizeResponse(loginTokenBO);
    }

    @Transactional(noRollbackFor={ScaModuleException.class})
    public SCALoginResponseTO authoriseForConsent(String login, String pin, String consentId, String authorisationId, OpTypeTO opType) {
        OpTypeBO opTypeBO = OpTypeBO.valueOf((String)opType.name());
        UserBO user = this.user(login);
        this.scaOperationService.checkIfExistsOrNew(new AuthCodeDataBO(user.getLogin(), null, consentId, null, NO_USER_MESSAGE, this.defaultLoginTokenExpireInSeconds, opTypeBO, authorisationId, 0));
        try {
            BearerTokenBO loginTokenBO = this.proceedToLogin(user, pin, UserRoleTO.CUSTOMER, consentId, authorisationId);
            return this.resolveLoginResponseForConsentLogin(consentId, authorisationId, opTypeBO, user, loginTokenBO);
        }
        catch (MiddlewareModuleException e) {
            throw this.scaOperationService.updateFailedCount(authorisationId, true);
        }
    }

    public SCALoginResponseTO authoriseForConsentWithToken(ScaInfoTO scaInfo, String consentId, String authorisationId, OpTypeTO opType) {
        OpTypeBO opTypeBO = OpTypeBO.valueOf((String)opType.name());
        UserBO user = this.user(scaInfo.getUserLogin());
        BearerTokenBO loginTokenBO = this.proceedToLogin(this.scaInfoMapper.toScaInfoBO(scaInfo), authorisationId);
        return this.resolveLoginResponseForConsentLogin(consentId, authorisationId, opTypeBO, user, loginTokenBO);
    }

    @NotNull
    private SCALoginResponseTO resolveLoginResponseForConsentLogin(String consentId, String authorisationId, OpTypeBO opTypeBO, UserBO user, BearerTokenBO loginTokenBO) {
        if (!this.scaRequired(user)) {
            return this.authorizeResponse(loginTokenBO);
        }
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), null, consentId, null, NO_USER_MESSAGE, this.defaultLoginTokenExpireInSeconds, opTypeBO, authorisationId, 0);
        SCAOperationBO scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUIDENTIFIED);
        SCALoginResponseTO response = this.toScaResponse(user, NO_USER_MESSAGE, scaOperationBO);
        BearerTokenBO scaTokenBO = this.authorizationService.scaToken(loginTokenBO.getAccessTokenObject().buildScaInfoBO());
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(scaTokenBO));
        return response;
    }

    private BearerTokenBO proceedToLogin(ScaInfoBO scaInfo, String authorisationId) {
        return Optional.ofNullable(this.authorizationService.authorizeNewAuthorizationId(scaInfo, authorisationId)).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("Unknown credentials.").build());
    }

    public BearerTokenTO validate(String accessToken) {
        return this.bearerTokenMapper.toBearerTokenTO(this.authorizationService.validate(accessToken, new Date()));
    }

    public UserTO register(String login, String email, String pin, UserRoleTO role) {
        UserTO user = new UserTO(login, email, pin);
        user.getUserRoles().add(role);
        UserBO userBO = this.userTOMapper.toUserBO(user);
        return this.userTOMapper.toUserTO(this.userService.create(userBO));
    }

    public SCALoginResponseTO generateLoginAuthCode(ScaInfoTO scaInfoTO, String userMessage, int validitySeconds) {
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        SCAOperationBO scaOperationBO = this.scaOperationService.loadAuthCode(scaInfoTO.getAuthorisationId());
        LoginKeyDataTO keyData = LoginKeyDataTO.fromOpId((String)scaOperationBO.getOpId());
        String opId = scaOperationBO.getOpId();
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), scaInfoTO.getScaMethodId(), opId, opId, userMessage, validitySeconds, OpTypeBO.LOGIN, scaInfoTO.getAuthorisationId(), 0);
        scaOperationBO = this.scaOperationService.generateAuthCode(authCodeData, user, ScaStatusBO.SCAMETHODSELECTED);
        SCALoginResponseTO scaResponse = this.toScaResponse(user, keyData.messageTemplate(), scaOperationBO);
        BearerTokenBO loginToken = this.authorizationService.loginToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO));
        scaResponse.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(loginToken));
        return scaResponse;
    }

    public SCALoginResponseTO authenticateForLogin(ScaInfoTO scaInfoTO) {
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        SCAOperationBO scaOperationBO = this.scaOperationService.loadAuthCode(scaInfoTO.getAuthorisationId());
        LoginKeyDataTO keyData = LoginKeyDataTO.fromOpId((String)scaOperationBO.getOpId());
        String authorisationId = scaInfoTO.getAuthorisationId();
        ScaValidationBO scaValidationBO = this.scaOperationService.validateAuthCode(authorisationId, authorisationId, authorisationId, scaInfoTO.getAuthCode(), 0);
        SCALoginResponseTO scaResponse = this.toScaResponse(user, keyData.messageTemplate(), scaOperationBO);
        if (scaValidationBO.isValidAuthCode()) {
            BearerTokenBO scaToken = this.authorizationService.scaToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO));
            scaResponse.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(scaToken));
            scaResponse.setAuthConfirmationCode(scaValidationBO.getAuthConfirmationCode());
        }
        return scaResponse;
    }

    public SCALoginResponseTO authorizeForUser(String login, String pin, String userLogin) {
        boolean isValid = this.authorizationService.validateCredentials(login, pin, UserRoleBO.SYSTEM);
        if (!isValid) {
            throw MiddlewareModuleException.builder().devMsg("Your credentials or role does not comply to request you're executing!").errorCode(MiddlewareErrorCode.AUTHENTICATION_FAILURE).build();
        }
        SCALoginResponseTO response = new SCALoginResponseTO();
        response.setScaStatus(ScaStatusTO.EXEMPTED);
        UserBO user = this.user(userLogin);
        BearerTokenBO scaTokenBO = this.authorizationService.scaToken(new ScaInfoBO(user.getId(), null, null, UserRoleBO.CUSTOMER, null, null, TokenUsageBO.DIRECT_ACCESS, user.getLogin()));
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(scaTokenBO));
        response.setScaId(scaTokenBO.getAccessTokenObject().getScaId());
        response.setExpiresInSeconds(scaTokenBO.getExpires_in());
        response.setStatusDate(LocalDateTime.now());
        return response;
    }

    private SCALoginResponseTO toScaResponse(UserBO user, String userMessage, SCAOperationBO a) {
        SCALoginResponseTO response = new SCALoginResponseTO();
        UserTO userTO = this.scaUtils.user(user);
        response.setAuthorisationId(a.getId());
        response.setChosenScaMethod(this.scaUtils.getScaMethod(userTO, a.getScaMethodId()));
        response.setChallengeData(null);
        response.setExpiresInSeconds(a.getValiditySeconds());
        response.setScaId(a.getOpId());
        response.setPsuMessage(userMessage);
        response.setScaMethods(userTO.getScaUserData());
        response.setScaStatus(ScaStatusTO.valueOf((String)a.getScaStatus().name()));
        response.setStatusDate(a.getStatusTime());
        return response;
    }

    private boolean scaRequired(UserBO user) {
        return this.scaUtils.hasSCA(user);
    }

    private SCALoginResponseTO authorizeResponse(BearerTokenBO loginTokenBO) {
        SCALoginResponseTO response = new SCALoginResponseTO();
        response.setScaStatus(ScaStatusTO.EXEMPTED);
        BearerTokenBO scaTokenBO = this.authorizationService.scaToken(loginTokenBO.getAccessTokenObject().buildScaInfoBO());
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(scaTokenBO));
        response.setScaId(scaTokenBO.getAccessTokenObject().getScaId());
        response.setExpiresInSeconds(scaTokenBO.getExpires_in());
        response.setStatusDate(LocalDateTime.now());
        response.setAuthorisationId(loginTokenBO.getAccessTokenObject().getAuthorisationId());
        return response;
    }

    private UserBO user(String login) {
        return this.userService.findByLogin(login);
    }

    private BearerTokenBO proceedToLogin(UserBO user, String pin, UserRoleTO role, String scaId, String authorisationId) {
        UserRoleBO roleBo = UserRoleBO.valueOf((String)role.name());
        return Optional.ofNullable(this.authorizationService.authorise(user.getLogin(), pin, roleBo, scaId, authorisationId)).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("Unknown credentials.").build());
    }

    public MiddlewareOnlineBankingServiceImpl(UserService userService, BearerTokenMapper bearerTokenMapper, SCAOperationService scaOperationService, SCAUtils scaUtils, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService) {
        this.userService = userService;
        this.bearerTokenMapper = bearerTokenMapper;
        this.scaOperationService = scaOperationService;
        this.scaUtils = scaUtils;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
    }
}

