/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountTransactionService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.ConsentKeyDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.AisConsentBOMapper;
import de.adorsys.ledgers.middleware.impl.converter.AmountMapper;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseResolver;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.domain.ScaValidationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.ScaInfoBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import de.adorsys.ledgers.util.exception.ScaModuleException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareAccountManagementServiceImpl
implements MiddlewareAccountManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareAccountManagementServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private final UserMapper userMapper;
    private final DepositAccountService depositAccountService;
    private final DepositAccountTransactionService transactionService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentConverter paymentConverter;
    private final UserService userService;
    private final AisConsentBOMapper aisConsentMapper;
    private final BearerTokenMapper bearerTokenMapper;
    private final SCAOperationService scaOperationService;
    private final SCAUtils scaUtils;
    private final AccessService accessService;
    private final AmountMapper amountMapper;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    private final PageMapper pageMapper;
    private final ScaResponseResolver scaResponseResolver;
    @Value(value="${default.token.lifetime.seconds:600}")
    private int defaultLoginTokenExpireInSeconds;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public List<AccountDetailsTO> getAccountsByIbanAndCurrency(String iban, String currency) {
        return this.accountDetailsMapper.toAccountDetailsList(this.depositAccountService.getAccountsByIbanAndParamCurrency(iban, currency));
    }

    public void createDepositAccount(String userId, ScaInfoTO scaInfoTO, AccountDetailsTO depositAccount) {
        if (depositAccount.getCurrency() == null) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg("Can not create new account without currency set! Please set currency to continue.").build();
        }
        UserBO user = this.userService.findById(userId);
        this.checkPresentAccountsAndOwner(depositAccount.getIban(), user);
        DepositAccountBO accountToCreate = this.accountDetailsMapper.toDepositAccountBO(depositAccount);
        DepositAccountBO createdAccount = this.depositAccountService.createNewAccount(accountToCreate, user.getLogin(), user.getBranch());
        this.accessService.updateAccountAccessNewAccount(createdAccount, user);
    }

    public AccountDetailsTO getDepositAccountById(String accountId, LocalDateTime time, boolean withBalance) {
        DepositAccountDetailsBO accountDetailsBO = this.depositAccountService.getAccountDetailsById(accountId, time, true);
        return this.accountDetailsMapper.toAccountDetailsTO(accountDetailsBO);
    }

    @Deprecated
    public AccountDetailsTO getDepositAccountByIban(String iban, LocalDateTime time, boolean withBalance) {
        return this.accountDetailsMapper.toAccountDetailsTO(this.depositAccountService.getDetailsByIban(iban, time, withBalance));
    }

    public List<AccountDetailsTO> getAllAccountDetailsByUserLogin(String userLogin) {
        log.info("Retrieving accounts by user login {}", (Object)userLogin);
        UserBO userBO = this.userService.findByLogin(userLogin);
        List accountAccess = userBO.getAccountAccesses();
        log.info("{} accounts accesses were found", (Object)accountAccess.size());
        List<DepositAccountBO> details = accountAccess.stream().filter(a -> a.getAccessType() == AccessTypeBO.OWNER).map(a -> this.depositAccountService.getAccountByIbanAndCurrency(a.getIban(), a.getCurrency())).collect(Collectors.toList());
        log.info("{} were accounts were filtered as OWN", (Object)details.size());
        return this.accountDetailsMapper.toAccountDetailsList(details);
    }

    public TransactionTO getTransactionById(String accountId, String transactionId) {
        TransactionDetailsBO transaction = this.depositAccountService.getTransactionById(accountId, transactionId);
        return this.paymentConverter.toTransactionTO(transaction);
    }

    public List<TransactionTO> getTransactionsByDates(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        log.info("Start retrieving transactions for {}", (Object)accountId);
        long start = System.nanoTime();
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = dateTo == null ? this.accessService.getTimeAtEndOfTheDay(today) : this.accessService.getTimeAtEndOfTheDay(dateTo);
        List transactions = this.depositAccountService.getTransactionsByDates(accountId, dateTimeFrom, dateTimeTo);
        log.info("Retrieved {} transactions in {} secs", (Object)transactions.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return this.paymentConverter.toTransactionTOList(transactions);
    }

    public CustomPageImpl<TransactionTO> getTransactionsByDatesPaged(String accountId, LocalDate dateFrom, LocalDate dateTo, CustomPageableImpl pageable) {
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = dateTo == null ? this.accessService.getTimeAtEndOfTheDay(today) : this.accessService.getTimeAtEndOfTheDay(dateTo);
        return this.pageMapper.toCustomPageImpl(this.depositAccountService.getTransactionsByDatesPaged(accountId, dateTimeFrom, dateTimeTo, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.paymentConverter::toTransactionTO));
    }

    public boolean confirmFundsAvailability(FundsConfirmationRequestTO request) {
        FundsConfirmationRequestBO requestBO = this.accountDetailsMapper.toFundsConfirmationRequestBO(request);
        return this.depositAccountService.confirmationOfFunds(requestBO);
    }

    public void createDepositAccount(ScaInfoTO scaInfoTO, String accountNumberPrefix, String accountNumberSuffix, AccountDetailsTO accDetails) {
        String accNbr = accountNumberPrefix + accountNumberSuffix;
        List accounts = this.depositAccountService.findByAccountNumberPrefix(accountNumberPrefix);
        this.validateInput(scaInfoTO.getUserId(), accounts, accountNumberPrefix, accountNumberSuffix);
        accDetails.setIban(accNbr);
        this.createDepositAccount(scaInfoTO.getUserId(), scaInfoTO, accDetails);
    }

    private void validateInput(String userId, List<DepositAccountBO> accounts, String accountNumberPrefix, String accountNumberSuffix) {
        String accNbr;
        if (accounts.isEmpty()) {
            return;
        }
        List<AccountAccessTO> accountAccesses = this.userMapper.toAccountAccessListTO(this.userService.findById(userId).getAccountAccesses());
        if (CollectionUtils.isNotEmpty(accountAccesses)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg(String.format("Account prefix %s is gone.", accountNumberPrefix)).build();
        }
        List<String> ownedAccounts = this.accessService.filterOwnedAccounts(accountAccesses);
        if (ownedAccounts.contains(accNbr = accountNumberPrefix + accountNumberSuffix)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg(String.format("Account with suffix %S and prefix %s already exist", accountNumberPrefix, accountNumberSuffix)).build();
        }
        for (DepositAccountBO a : accounts) {
            if (!ownedAccounts.contains(a.getIban())) continue;
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg(String.format("User not owner of account with iban %s that also holds the requested prefix %s", a.getIban(), accountNumberPrefix)).build();
        }
    }

    public List<AccountDetailsTO> listDepositAccounts(String userId) {
        UserBO user = this.accessService.loadCurrentUser(userId);
        UserTO userTO = this.userMapper.toUserTO(user);
        List accountAccesses = userTO.getAccountAccesses();
        if (accountAccesses == null || accountAccesses.isEmpty()) {
            return Collections.emptyList();
        }
        return accountAccesses.stream().map(a -> this.depositAccountService.getAccountDetailsByIbanAndCurrency(a.getIban(), a.getCurrency(), LocalDateTime.now(), true)).map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public List<AccountDetailsTO> listDepositAccountsByBranch(String userId) {
        UserBO user = this.accessService.loadCurrentUser(userId);
        List depositAccounts = this.depositAccountService.findDetailsByBranch(user.getBranch());
        return depositAccounts.stream().map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public CustomPageImpl<AccountDetailsTO> listDepositAccountsByBranchPaged(String userId, String queryParam, CustomPageableImpl pageable) {
        UserBO user = this.accessService.loadCurrentUser(userId);
        return this.pageMapper.toCustomPageImpl(this.depositAccountService.findDetailsByBranchPaged(user.getBranch(), queryParam, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.accountDetailsMapper::toAccountDetailsTO));
    }

    public CustomPageImpl<AccountDetailsExtendedTO> getAccountsByBranchAndMultipleParams(String countryCode, String branchId, String branchLogin, String iban, Boolean blocked, CustomPageableImpl pageable) {
        Map branchIds = this.userService.findBranchIdsByMultipleParameters(countryCode, branchId, branchLogin);
        Page page = this.depositAccountService.findByBranchIdsAndMultipleParams(branchIds.keySet(), iban, blocked, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(d -> this.accountDetailsMapper.toAccountDetailsExtendedTO((DepositAccountBO)d, (String)branchIds.get(d.getBranch())));
        return this.pageMapper.toCustomPageImpl(page);
    }

    public String iban(String id) {
        return this.depositAccountService.readIbanById(id);
    }

    public SCAConsentResponseTO startSCA(ScaInfoTO scaInfoTO, String consentId, AisConsentTO aisConsent) {
        BearerTokenBO bearerToken = this.checkAisConsent(this.scaInfoMapper.toScaInfoBO(scaInfoTO), aisConsent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsent);
        SCAConsentResponseTO response = this.prepareSCA(scaInfoTO, this.scaUtils.userBO(scaInfoTO.getUserId()), aisConsent, consentKeyData);
        if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
            response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(bearerToken));
        }
        return response;
    }

    public SCAConsentResponseTO loadSCAForAisConsent(String userId, String consentId, String authorisationId) {
        UserBO user = this.scaUtils.userBO(userId);
        AisConsentBO consent = this.userService.loadConsent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        SCAOperationBO scaOperationBO = this.scaUtils.loadAuthCode(authorisationId);
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consent.getAccess(), user.getAccountAccesses());
        SCAConsentResponseTO response = this.toScaConsentResponse(this.userMapper.toUserTO(user), consent, consentKeyData.template(), scaOperationBO);
        response.setMultilevelScaRequired(this.multilevelScaEnable && scaWeight < 100);
        return response;
    }

    public SCAConsentResponseTO selectSCAMethodForAisConsent(String userId, String consentId, String authorisationId, String scaMethodId) {
        UserBO userBO = this.scaUtils.userBO(userId);
        AisConsentBO consent = this.userService.loadConsent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        String template = consentKeyData.template();
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consent.getAccess(), userBO.getAccountAccesses());
        AuthCodeDataBO a = new AuthCodeDataBO(userBO.getLogin(), scaMethodId, consentId, template, template, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CONSENT, authorisationId, scaWeight);
        SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(a, userBO, ScaStatusBO.SCAMETHODSELECTED);
        SCAConsentResponseTO response = this.toScaConsentResponse(this.userMapper.toUserTO(userBO), consent, consentKeyData.template(), scaOperationBO);
        response.setMultilevelScaRequired(this.multilevelScaEnable && scaWeight < 100);
        return response;
    }

    @Transactional(noRollbackFor={ScaModuleException.class})
    public SCAConsentResponseTO authorizeConsent(ScaInfoTO scaInfoTO, String consentId) {
        AisConsentBO consent = this.userService.loadConsent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consent.getAccess(), userBO.getAccountAccesses());
        ScaValidationBO scaValidationBO = this.scaOperationService.validateAuthCode(scaInfoTO.getAuthorisationId(), consentId, consentKeyData.template(), scaInfoTO.getAuthCode(), scaWeight);
        UserTO userTO = this.scaUtils.user(userBO);
        SCAOperationBO scaOperationBO = this.scaUtils.loadAuthCode(scaInfoTO.getAuthorisationId());
        SCAConsentResponseTO response = this.toScaConsentResponse(userTO, consent, consentKeyData.template(), scaOperationBO);
        response.setAuthConfirmationCode(scaValidationBO.getAuthConfirmationCode());
        if (!this.scaOperationService.authenticationCompleted(consentId, OpTypeBO.CONSENT)) {
            response.setPartiallyAuthorised(this.multilevelScaEnable);
            response.setMultilevelScaRequired(this.multilevelScaEnable);
        }
        BearerTokenBO consentToken = this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), consent);
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(consentToken));
        return response;
    }

    public SCAConsentResponseTO grantAisConsent(ScaInfoTO scaInfoTO, AisConsentTO aisConsent) {
        AisConsentTO piisConsentTO = this.cleanupForPIIS(aisConsent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(piisConsentTO);
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(piisConsentTO);
        BearerTokenBO consentToken = this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), consentBO);
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(consentToken));
        response.setAuthorisationId(this.scaUtils.authorisationId(scaInfoTO));
        response.setConsentId(aisConsent.getId());
        response.setPsuMessage(consentKeyData.exemptedTemplate());
        response.setScaStatus(ScaStatusTO.EXEMPTED);
        response.setStatusDate(LocalDateTime.now());
        return response;
    }

    public void depositCash(ScaInfoTO scaInfoTO, String accountId, AmountTO amount) {
        DepositAccountDetailsBO account = this.depositAccountService.getAccountDetailsById(accountId, LocalDateTime.now(), false);
        if (!account.isEnabled()) {
            throw (MiddlewareModuleException)MiddlewareModuleException.blockedSupplier((MiddlewareErrorCode)MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE, (String)account.getAccount().getIban(), (boolean)account.getAccount().isBlocked()).get();
        }
        this.transactionService.depositCash(accountId, this.amountMapper.toAmountBO(amount), scaInfoTO.getUserLogin());
    }

    public List<AccountAccessTO> getAccountAccesses(String userId) {
        UserBO user = this.userService.findById(userId);
        UserTO userTO = this.userMapper.toUserTO(user);
        return userTO.getAccountAccesses();
    }

    public void deleteTransactions(String userId, UserRoleTO userRole, String accountId) {
        log.info("User {} attempting delete postings for account: {}", (Object)userId, (Object)accountId);
        long start = this.checkPermissionAndStartCount(userId, userRole, accountId);
        this.depositAccountService.deleteTransactions(accountId);
        log.info("Deleting postings for account: {} Successful, in {} seconds", (Object)accountId, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public void deleteAccount(String userId, UserRoleTO userRole, String accountId) {
        log.info("User {} attempting delete account: {}", (Object)userId, (Object)accountId);
        long start = this.checkPermissionAndStartCount(userId, userRole, accountId);
        this.depositAccountService.deleteAccount(accountId);
        log.info("Deleting account: {} Successful, in {} seconds", (Object)accountId, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    private long checkPermissionAndStartCount(String userId, UserRoleTO userRole, String accountId) {
        long start = System.nanoTime();
        if (userRole == UserRoleTO.STAFF && !this.hasAccess(userId, accountId)) {
            throw MiddlewareModuleException.builder().devMsg("You dont have permission to modify this account").errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).build();
        }
        log.info("Permission checked for account {} -> OK", (Object)accountId);
        return start;
    }

    private boolean hasAccess(String userId, String accountId) {
        return this.userService.findById(userId).getAccountAccesses().stream().anyMatch(a -> a.getAccountId().equals(accountId));
    }

    public void deleteUser(String userId, UserRoleTO userRole, String userToDeleteId) {
        log.info("User {} attempting delete user: {}", (Object)userId, (Object)userToDeleteId);
        long start = System.nanoTime();
        if (userRole == UserRoleTO.STAFF && !this.userService.findById(userToDeleteId).getBranch().equals(userId)) {
            throw MiddlewareModuleException.builder().devMsg("You dont have permission to modify this user").errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).build();
        }
        this.depositAccountService.deleteUser(userToDeleteId);
        log.info("Deleting user: {} Successful, in {} seconds", (Object)userToDeleteId, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public AccountReportTO getAccountReport(String accountId) {
        long start = System.nanoTime();
        AccountDetailsTO details = this.getDepositAccountById(accountId, LocalDateTime.now(), true);
        log.info("Loaded details with balances in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        start = System.nanoTime();
        List<UserTO> users = this.userMapper.toUserTOList(this.userService.findUsersByIban(details.getIban()));
        log.info("Loaded users in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        return new AccountReportTO(details, users);
    }

    public boolean changeStatus(String accountId, boolean isSystemBlock) {
        DepositAccountBO account = this.depositAccountService.getAccountById(accountId);
        boolean lockStatusToSet = isSystemBlock ? !account.isSystemBlocked() : !account.isBlocked();
        this.depositAccountService.changeAccountsBlockedStatus(Collections.singleton(accountId), isSystemBlock, lockStatusToSet);
        return lockStatusToSet;
    }

    private void checkPresentAccountsAndOwner(String iban, UserBO user) {
        if (!user.isEnabled()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.USER_IS_BLOCKED).devMsg("User is blocked, cannot create new account.").build();
        }
        List accountsPresentByIban = this.depositAccountService.getAccountsByIbanAndParamCurrency(iban, "");
        if (CollectionUtils.isNotEmpty((Collection)accountsPresentByIban) && !user.getLogin().equals(((DepositAccountBO)accountsPresentByIban.get(0)).getName())) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg("The IBAN you're trying to create account for is already busy by another user").build();
        }
    }

    private AisConsentTO cleanupForPIIS(AisConsentTO aisConsentTo) {
        aisConsentTo.getAccess().setAllPsd2(null);
        aisConsentTo.getAccess().setAvailableAccounts(null);
        aisConsentTo.getAccess().setAccounts(Collections.emptyList());
        aisConsentTo.getAccess().setTransactions(Collections.emptyList());
        return aisConsentTo;
    }

    private BearerTokenBO checkAisConsent(ScaInfoBO scaInfoBO, AisConsentTO aisConsent) {
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(aisConsent);
        return this.authorizationService.consentToken(scaInfoBO, consentBO);
    }

    private boolean scaRequired(UserBO user) {
        return this.scaUtils.hasSCA(user);
    }

    private SCAConsentResponseTO prepareSCA(ScaInfoTO scaInfoTO, UserBO user, AisConsentTO aisConsent, ConsentKeyDataTO consentKeyData) {
        String consentKeyDataTemplate = consentKeyData.template();
        UserTO userTo = this.scaUtils.user(user);
        String authorisationId = this.scaUtils.authorisationId(scaInfoTO);
        if (!this.scaRequired(user)) {
            SCAConsentResponseTO response = new SCAConsentResponseTO();
            response.setAuthorisationId(authorisationId);
            response.setConsentId(aisConsent.getId());
            response.setPsuMessage(consentKeyData.exemptedTemplate());
            response.setScaStatus(ScaStatusTO.EXEMPTED);
            response.setStatusDate(LocalDateTime.now());
            return response;
        }
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(aisConsent);
        consentBO = this.userService.storeConsent(consentBO);
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consentBO.getAccess(), user.getAccountAccesses());
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), null, aisConsent.getId(), consentKeyDataTemplate, consentKeyDataTemplate, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CONSENT, authorisationId, scaWeight);
        SCAOperationBO scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUAUTHENTICATED);
        SCAConsentResponseTO response = this.toScaConsentResponse(userTo, consentBO, consentKeyDataTemplate, scaOperationBO);
        response.setMultilevelScaRequired(this.multilevelScaEnable && scaWeight < 100);
        return response;
    }

    private SCAConsentResponseTO toScaConsentResponse(UserTO user, AisConsentBO consent, String messageTemplate, SCAOperationBO operation) {
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        this.scaResponseResolver.completeResponse(response, operation, user, messageTemplate, null);
        response.setConsentId(consent.getId());
        return response;
    }

    public MiddlewareAccountManagementServiceImpl(UserMapper userMapper, DepositAccountService depositAccountService, DepositAccountTransactionService transactionService, AccountDetailsMapper accountDetailsMapper, PaymentConverter paymentConverter, UserService userService, AisConsentBOMapper aisConsentMapper, BearerTokenMapper bearerTokenMapper, SCAOperationService scaOperationService, SCAUtils scaUtils, AccessService accessService, AmountMapper amountMapper, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService, PageMapper pageMapper, ScaResponseResolver scaResponseResolver) {
        this.userMapper = userMapper;
        this.depositAccountService = depositAccountService;
        this.transactionService = transactionService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.paymentConverter = paymentConverter;
        this.userService = userService;
        this.aisConsentMapper = aisConsentMapper;
        this.bearerTokenMapper = bearerTokenMapper;
        this.scaOperationService = scaOperationService;
        this.scaUtils = scaUtils;
        this.accessService = accessService;
        this.amountMapper = amountMapper;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
        this.pageMapper = pageMapper;
        this.scaResponseResolver = scaResponseResolver;
    }
}

