/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.service.DepositAccountInitService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.general.BbanStructure;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.AppManagementService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.service.upload.UploadBalanceService;
import de.adorsys.ledgers.middleware.impl.service.upload.UploadDepositAccountService;
import de.adorsys.ledgers.middleware.impl.service.upload.UploadPaymentService;
import de.adorsys.ledgers.middleware.impl.service.upload.UploadUserService;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.service.UserService;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppManagementServiceImpl
implements AppManagementService {
    private static final Logger log = LoggerFactory.getLogger(AppManagementServiceImpl.class);
    private static final ExecutorService FIXED_THREAD_POOL = Executors.newFixedThreadPool(20);
    private final DepositAccountInitService depositAccountInitService;
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final UploadUserService uploadUserService;
    private final UploadDepositAccountService uploadDepositAccountService;
    private final UploadBalanceService uploadBalanceService;
    private final UploadPaymentService uploadPaymentService;
    private final MiddlewareUserManagementService middlewareUserManagementService;

    @Transactional
    public void initApp() {
        log.info("Initiating Ledgers");
        long start = System.nanoTime();
        this.depositAccountInitService.initConfigData();
        log.info("Initiation completed in {} seconds", (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start));
    }

    @Transactional
    public void removeBranch(String userId, UserRoleTO userRole, String branchId) {
        log.info("User {} attempting delete branch {}", (Object)userId, (Object)branchId);
        long start = System.nanoTime();
        this.isExistingBranch(branchId);
        this.isPermittedToRemoveBranch(userId, userRole, branchId);
        log.info("Permission checked -> OK");
        this.depositAccountService.deleteBranch(branchId);
        log.info("Deleting branch {} Successful, in {} seconds", (Object)branchId, (Object)TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - start));
    }

    public void uploadData(UploadedDataTO data, ScaInfoTO info) {
        String branchId = this.userService.findById(info.getUserId()).getBranch();
        List<UserTO> uploadedUsers = this.uploadUserService.uploadUsers(data.getUsers(), branchId);
        this.uploadDepositAccountService.uploadDepositAccounts(uploadedUsers, data.getDetails(), info);
        CompletableFuture.runAsync(() -> this.uploadBalanceService.uploadBalances(data, info), FIXED_THREAD_POOL).thenRunAsync(() -> this.uploadPaymentService.uploadPayments(data, info));
    }

    public boolean changeBlockedStatus(String userId, boolean isSystemBlock) {
        boolean lockStatusToSet;
        UserBO user = this.userService.findById(userId);
        boolean bl = isSystemBlock ? !user.isSystemBlocked() : (lockStatusToSet = !user.isBlocked());
        if (user.getUserRoles().contains(UserRoleBO.STAFF)) {
            CompletableFuture.runAsync(() -> this.userService.setBranchBlockedStatus(userId, isSystemBlock, lockStatusToSet), FIXED_THREAD_POOL).thenRunAsync(() -> this.depositAccountService.changeAccountsBlockedStatus(userId, isSystemBlock, lockStatusToSet));
            return lockStatusToSet;
        }
        return this.middlewareUserManagementService.changeStatus(userId, isSystemBlock);
    }

    public String generateNextBban(BbanStructure structure) {
        String bban = structure.generateRandomBban();
        while (this.userService.isPresentBranchCode(structure.getCountryPrefix() + "_" + bban)) {
            bban = structure.generateRandomBban();
        }
        return bban;
    }

    private void isPermittedToRemoveBranch(String userId, UserRoleTO userRole, String branchId) {
        if (userRole == UserRoleTO.STAFF && !this.userService.findById(userId).getBranch().equals(branchId)) {
            throw MiddlewareModuleException.builder().devMsg("Insufficient permission to remove branch!").errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).build();
        }
    }

    private void isExistingBranch(String branchId) {
        if (this.userService.countUsersByBranch(branchId) <= 0) {
            throw MiddlewareModuleException.builder().devMsg(String.format("Branch with id %s not found!", branchId)).errorCode(MiddlewareErrorCode.BRANCH_NOT_FOUND).build();
        }
    }

    public AppManagementServiceImpl(DepositAccountInitService depositAccountInitService, UserService userService, DepositAccountService depositAccountService, UploadUserService uploadUserService, UploadDepositAccountService uploadDepositAccountService, UploadBalanceService uploadBalanceService, UploadPaymentService uploadPaymentService, MiddlewareUserManagementService middlewareUserManagementService) {
        this.depositAccountInitService = depositAccountInitService;
        this.userService = userService;
        this.depositAccountService = depositAccountService;
        this.uploadUserService = uploadUserService;
        this.uploadDepositAccountService = uploadDepositAccountService;
        this.uploadBalanceService = uploadBalanceService;
        this.uploadPaymentService = uploadPaymentService;
        this.middlewareUserManagementService = middlewareUserManagementService;
    }
}

