/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AccessService {
    private final UserService userService;

    public void updateAccountAccessNewAccount(DepositAccountBO createdAccount, UserBO user) {
        AccountAccessBO accountAccess = this.createAccountAccess(createdAccount.getIban(), createdAccount.getCurrency(), AccessTypeBO.OWNER, createdAccount.getId());
        this.updateAccountAccess(user, accountAccess);
        if (StringUtils.isNotBlank((CharSequence)user.getBranch())) {
            UserBO branch = this.userService.findById(user.getBranch());
            this.updateAccountAccess(branch, accountAccess);
        }
    }

    public void updateAccountAccess(UserBO user, AccountAccessBO access) {
        if (!this.containsAccess(user.getAccountAccesses(), access.getAccountId())) {
            user.getAccountAccesses().add(access);
        } else {
            user.getAccountAccesses().stream().filter(a -> a.getAccountId().equals(access.getAccountId())).findFirst().ifPresent(a -> {
                a.setAccessType(access.getAccessType());
                a.setScaWeight(access.getScaWeight());
                a.setAccountId(access.getAccountId());
            });
        }
        this.userService.updateAccountAccess(user.getLogin(), user.getAccountAccesses());
    }

    private boolean containsAccess(List<AccountAccessBO> accesses, String accountId) {
        return accesses.stream().anyMatch(a -> accountId.equals(a.getAccountId()));
    }

    public UserBO loadCurrentUser(String userId) {
        return this.userService.findById(userId);
    }

    public List<String> filterOwnedAccounts(List<AccountAccessTO> accountAccesses) {
        return accountAccesses == null ? Collections.emptyList() : accountAccesses.stream().filter(a -> AccessTypeBO.OWNER.name().equals(a.getAccessType().name())).map(AccountAccessTO::getIban).collect(Collectors.toList());
    }

    public AccountAccessBO createAccountAccess(String accNbr, Currency currency, AccessTypeBO accessType, String accountId) {
        AccountAccessBO accountAccess = new AccountAccessBO();
        accountAccess.setAccessType(accessType);
        accountAccess.setIban(accNbr);
        accountAccess.setCurrency(currency);
        accountAccess.setAccountId(accountId);
        accountAccess.setScaWeight(100);
        return accountAccess;
    }

    public LocalDateTime getTimeAtEndOfTheDay(LocalDate date) {
        return date.atTime(23, 59, 59, 99);
    }

    public int resolveScaWeightByDebtorAccount(List<AccountAccessBO> accountAccesses, String debtorAccount) {
        return accountAccesses.stream().filter(ac -> StringUtils.equalsIgnoreCase((CharSequence)ac.getIban(), (CharSequence)debtorAccount)).map(AccountAccessBO::getScaWeight).min(Comparator.comparingInt(Integer::intValue)).orElse(0);
    }

    public int resolveMinimalScaWeightForConsent(AisAccountAccessInfoBO access, List<AccountAccessBO> accountAccesses) {
        Set combinedAccounts = Stream.of(access.getAccounts(), access.getBalances(), access.getTransactions()).flatMap(Collection::stream).collect(Collectors.toSet());
        return accountAccesses.stream().filter(ac -> combinedAccounts.contains(ac.getIban())).min(Comparator.comparing(AccountAccessBO::getScaWeight)).map(AccountAccessBO::getScaWeight).orElse(0);
    }

    public boolean userHasAccessToAccount(UserTO user, String iban) {
        return user.getAccountAccesses().stream().anyMatch(a -> a.getIban().equals(iban));
    }

    public AccessService(UserService userService) {
        this.userService = userService;
    }
}

