/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.sca;

import de.adorsys.ledgers.middleware.api.domain.sca.ChallengeDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaDataInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaMethodTypeTO;
import de.adorsys.ledgers.middleware.impl.sca.AbstractScaChallengeData;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component
public class PhotoOtpScaChallengeData
extends AbstractScaChallengeData {
    private static final Logger log = LoggerFactory.getLogger(PhotoOtpScaChallengeData.class);
    private static final String IMAGE_TAN_PATH = "photo-tan-1.png";

    @Override
    public ChallengeDataTO getChallengeData(ScaDataInfoTO template) {
        ChallengeDataTO data = super.getChallengeData(template);
        data.setImage(this.resolveImage());
        return data;
    }

    public ScaMethodTypeTO getScaMethodType() {
        return ScaMethodTypeTO.PHOTO_OTP;
    }

    private byte[] resolveImage() {
        try {
            ClassPathResource resource = new ClassPathResource(IMAGE_TAN_PATH);
            return IOUtils.toByteArray((InputStream)resource.getInputStream());
        }
        catch (IOException e) {
            log.error("Can't read image tan", (Throwable)e);
            return new byte[0];
        }
    }
}

