package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisAccountAccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.um.api.domain.AccessTokenBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.TokenUsageBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2020-04-27T12:16:21+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_242 (Private Build)"
)
@Component
public class BearerTokenMapperImpl implements BearerTokenMapper {

    @Override
    public BearerTokenBO toBearerTokenBO(BearerTokenTO token) {
        if ( token == null ) {
            return null;
        }

        BearerTokenBO bearerTokenBO = new BearerTokenBO();

        bearerTokenBO.setAccess_token( token.getAccess_token() );
        bearerTokenBO.setToken_type( token.getToken_type() );
        bearerTokenBO.setExpires_in( token.getExpires_in() );
        bearerTokenBO.setRefresh_token( token.getRefresh_token() );
        bearerTokenBO.setAccessTokenObject( accessTokenTOToAccessTokenBO( token.getAccessTokenObject() ) );

        return bearerTokenBO;
    }

    @Override
    public BearerTokenTO toBearerTokenTO(BearerTokenBO token) {
        if ( token == null ) {
            return null;
        }

        BearerTokenTO bearerTokenTO = new BearerTokenTO();

        bearerTokenTO.setAccess_token( token.getAccess_token() );
        bearerTokenTO.setToken_type( token.getToken_type() );
        bearerTokenTO.setExpires_in( token.getExpires_in() );
        bearerTokenTO.setRefresh_token( token.getRefresh_token() );
        bearerTokenTO.setAccessTokenObject( accessTokenBOToAccessTokenTO( token.getAccessTokenObject() ) );

        return bearerTokenTO;
    }

    protected AisAccountAccessTypeBO aisAccountAccessTypeTOToAisAccountAccessTypeBO(AisAccountAccessTypeTO aisAccountAccessTypeTO) {
        if ( aisAccountAccessTypeTO == null ) {
            return null;
        }

        AisAccountAccessTypeBO aisAccountAccessTypeBO;

        switch ( aisAccountAccessTypeTO ) {
            case ALL_ACCOUNTS: aisAccountAccessTypeBO = AisAccountAccessTypeBO.ALL_ACCOUNTS;
            break;
            case ALL_ACCOUNTS_WITH_BALANCES: aisAccountAccessTypeBO = AisAccountAccessTypeBO.ALL_ACCOUNTS_WITH_BALANCES;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + aisAccountAccessTypeTO );
        }

        return aisAccountAccessTypeBO;
    }

    protected AisAccountAccessInfoBO aisAccountAccessInfoTOToAisAccountAccessInfoBO(AisAccountAccessInfoTO aisAccountAccessInfoTO) {
        if ( aisAccountAccessInfoTO == null ) {
            return null;
        }

        AisAccountAccessInfoBO aisAccountAccessInfoBO = new AisAccountAccessInfoBO();

        List<String> list = aisAccountAccessInfoTO.getAccounts();
        if ( list != null ) {
            aisAccountAccessInfoBO.setAccounts( new ArrayList<String>( list ) );
        }
        List<String> list1 = aisAccountAccessInfoTO.getBalances();
        if ( list1 != null ) {
            aisAccountAccessInfoBO.setBalances( new ArrayList<String>( list1 ) );
        }
        List<String> list2 = aisAccountAccessInfoTO.getTransactions();
        if ( list2 != null ) {
            aisAccountAccessInfoBO.setTransactions( new ArrayList<String>( list2 ) );
        }
        aisAccountAccessInfoBO.setAvailableAccounts( aisAccountAccessTypeTOToAisAccountAccessTypeBO( aisAccountAccessInfoTO.getAvailableAccounts() ) );
        aisAccountAccessInfoBO.setAllPsd2( aisAccountAccessTypeTOToAisAccountAccessTypeBO( aisAccountAccessInfoTO.getAllPsd2() ) );

        return aisAccountAccessInfoBO;
    }

    protected AisConsentBO aisConsentTOToAisConsentBO(AisConsentTO aisConsentTO) {
        if ( aisConsentTO == null ) {
            return null;
        }

        AisConsentBO aisConsentBO = new AisConsentBO();

        aisConsentBO.setId( aisConsentTO.getId() );
        aisConsentBO.setUserId( aisConsentTO.getUserId() );
        aisConsentBO.setTppId( aisConsentTO.getTppId() );
        aisConsentBO.setFrequencyPerDay( aisConsentTO.getFrequencyPerDay() );
        aisConsentBO.setAccess( aisAccountAccessInfoTOToAisAccountAccessInfoBO( aisConsentTO.getAccess() ) );
        aisConsentBO.setValidUntil( aisConsentTO.getValidUntil() );
        aisConsentBO.setRecurringIndicator( aisConsentTO.isRecurringIndicator() );

        return aisConsentBO;
    }

    protected UserRoleBO userRoleTOToUserRoleBO(UserRoleTO userRoleTO) {
        if ( userRoleTO == null ) {
            return null;
        }

        UserRoleBO userRoleBO;

        switch ( userRoleTO ) {
            case CUSTOMER: userRoleBO = UserRoleBO.CUSTOMER;
            break;
            case STAFF: userRoleBO = UserRoleBO.STAFF;
            break;
            case TECHNICAL: userRoleBO = UserRoleBO.TECHNICAL;
            break;
            case SYSTEM: userRoleBO = UserRoleBO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRoleTO );
        }

        return userRoleBO;
    }

    protected TokenUsageBO tokenUsageTOToTokenUsageBO(TokenUsageTO tokenUsageTO) {
        if ( tokenUsageTO == null ) {
            return null;
        }

        TokenUsageBO tokenUsageBO;

        switch ( tokenUsageTO ) {
            case LOGIN: tokenUsageBO = TokenUsageBO.LOGIN;
            break;
            case DIRECT_ACCESS: tokenUsageBO = TokenUsageBO.DIRECT_ACCESS;
            break;
            case DELEGATED_ACCESS: tokenUsageBO = TokenUsageBO.DELEGATED_ACCESS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + tokenUsageTO );
        }

        return tokenUsageBO;
    }

    protected AccessTokenBO accessTokenTOToAccessTokenBO(AccessTokenTO accessTokenTO) {
        if ( accessTokenTO == null ) {
            return null;
        }

        AccessTokenBO accessTokenBO = new AccessTokenBO();

        accessTokenBO.setSub( accessTokenTO.getSub() );
        accessTokenBO.setJti( accessTokenTO.getJti() );
        accessTokenBO.setLogin( accessTokenTO.getLogin() );
        accessTokenBO.setConsent( aisConsentTOToAisConsentBO( accessTokenTO.getConsent() ) );
        accessTokenBO.setRole( userRoleTOToUserRoleBO( accessTokenTO.getRole() ) );
        accessTokenBO.setIat( accessTokenTO.getIat() );
        accessTokenBO.setExp( accessTokenTO.getExp() );
        Map<String, String> map = accessTokenTO.getAct();
        if ( map != null ) {
            accessTokenBO.setAct( new HashMap<String, String>( map ) );
        }
        accessTokenBO.setScaId( accessTokenTO.getScaId() );
        accessTokenBO.setAuthorisationId( accessTokenTO.getAuthorisationId() );
        accessTokenBO.setTokenUsage( tokenUsageTOToTokenUsageBO( accessTokenTO.getTokenUsage() ) );

        return accessTokenBO;
    }

    protected AisAccountAccessTypeTO aisAccountAccessTypeBOToAisAccountAccessTypeTO(AisAccountAccessTypeBO aisAccountAccessTypeBO) {
        if ( aisAccountAccessTypeBO == null ) {
            return null;
        }

        AisAccountAccessTypeTO aisAccountAccessTypeTO;

        switch ( aisAccountAccessTypeBO ) {
            case ALL_ACCOUNTS: aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS;
            break;
            case ALL_ACCOUNTS_WITH_BALANCES: aisAccountAccessTypeTO = AisAccountAccessTypeTO.ALL_ACCOUNTS_WITH_BALANCES;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + aisAccountAccessTypeBO );
        }

        return aisAccountAccessTypeTO;
    }

    protected AisAccountAccessInfoTO aisAccountAccessInfoBOToAisAccountAccessInfoTO(AisAccountAccessInfoBO aisAccountAccessInfoBO) {
        if ( aisAccountAccessInfoBO == null ) {
            return null;
        }

        AisAccountAccessInfoTO aisAccountAccessInfoTO = new AisAccountAccessInfoTO();

        List<String> list = aisAccountAccessInfoBO.getAccounts();
        if ( list != null ) {
            aisAccountAccessInfoTO.setAccounts( new ArrayList<String>( list ) );
        }
        List<String> list1 = aisAccountAccessInfoBO.getBalances();
        if ( list1 != null ) {
            aisAccountAccessInfoTO.setBalances( new ArrayList<String>( list1 ) );
        }
        List<String> list2 = aisAccountAccessInfoBO.getTransactions();
        if ( list2 != null ) {
            aisAccountAccessInfoTO.setTransactions( new ArrayList<String>( list2 ) );
        }
        aisAccountAccessInfoTO.setAvailableAccounts( aisAccountAccessTypeBOToAisAccountAccessTypeTO( aisAccountAccessInfoBO.getAvailableAccounts() ) );
        aisAccountAccessInfoTO.setAllPsd2( aisAccountAccessTypeBOToAisAccountAccessTypeTO( aisAccountAccessInfoBO.getAllPsd2() ) );

        return aisAccountAccessInfoTO;
    }

    protected AisConsentTO aisConsentBOToAisConsentTO(AisConsentBO aisConsentBO) {
        if ( aisConsentBO == null ) {
            return null;
        }

        AisConsentTO aisConsentTO = new AisConsentTO();

        aisConsentTO.setId( aisConsentBO.getId() );
        aisConsentTO.setUserId( aisConsentBO.getUserId() );
        aisConsentTO.setTppId( aisConsentBO.getTppId() );
        aisConsentTO.setFrequencyPerDay( aisConsentBO.getFrequencyPerDay() );
        aisConsentTO.setAccess( aisAccountAccessInfoBOToAisAccountAccessInfoTO( aisConsentBO.getAccess() ) );
        aisConsentTO.setValidUntil( aisConsentBO.getValidUntil() );
        aisConsentTO.setRecurringIndicator( aisConsentBO.isRecurringIndicator() );

        return aisConsentTO;
    }

    protected UserRoleTO userRoleBOToUserRoleTO(UserRoleBO userRoleBO) {
        if ( userRoleBO == null ) {
            return null;
        }

        UserRoleTO userRoleTO;

        switch ( userRoleBO ) {
            case CUSTOMER: userRoleTO = UserRoleTO.CUSTOMER;
            break;
            case STAFF: userRoleTO = UserRoleTO.STAFF;
            break;
            case TECHNICAL: userRoleTO = UserRoleTO.TECHNICAL;
            break;
            case SYSTEM: userRoleTO = UserRoleTO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRoleBO );
        }

        return userRoleTO;
    }

    protected TokenUsageTO tokenUsageBOToTokenUsageTO(TokenUsageBO tokenUsageBO) {
        if ( tokenUsageBO == null ) {
            return null;
        }

        TokenUsageTO tokenUsageTO;

        switch ( tokenUsageBO ) {
            case LOGIN: tokenUsageTO = TokenUsageTO.LOGIN;
            break;
            case DIRECT_ACCESS: tokenUsageTO = TokenUsageTO.DIRECT_ACCESS;
            break;
            case DELEGATED_ACCESS: tokenUsageTO = TokenUsageTO.DELEGATED_ACCESS;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + tokenUsageBO );
        }

        return tokenUsageTO;
    }

    protected AccessTokenTO accessTokenBOToAccessTokenTO(AccessTokenBO accessTokenBO) {
        if ( accessTokenBO == null ) {
            return null;
        }

        AccessTokenTO accessTokenTO = new AccessTokenTO();

        accessTokenTO.setSub( accessTokenBO.getSub() );
        accessTokenTO.setJti( accessTokenBO.getJti() );
        accessTokenTO.setLogin( accessTokenBO.getLogin() );
        accessTokenTO.setConsent( aisConsentBOToAisConsentTO( accessTokenBO.getConsent() ) );
        accessTokenTO.setRole( userRoleBOToUserRoleTO( accessTokenBO.getRole() ) );
        accessTokenTO.setIat( accessTokenBO.getIat() );
        accessTokenTO.setExp( accessTokenBO.getExp() );
        Map<String, String> map = accessTokenBO.getAct();
        if ( map != null ) {
            accessTokenTO.setAct( new HashMap<String, String>( map ) );
        }
        accessTokenTO.setScaId( accessTokenBO.getScaId() );
        accessTokenTO.setAuthorisationId( accessTokenBO.getAuthorisationId() );
        accessTokenTO.setTokenUsage( tokenUsageBOToTokenUsageTO( accessTokenBO.getTokenUsage() ) );

        return accessTokenTO;
    }
}
