/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AdditionalAccountInformationTO;
import de.adorsys.ledgers.middleware.api.domain.general.RecoveryPointTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserExtendedTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareRecoveryService;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AdditionalAccountInformationMapper;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.AccountIdentifierTypeBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareUserManagementServiceImpl
implements MiddlewareUserManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareUserManagementServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private static final ExecutorService FIXED_THREAD_POOL = Executors.newFixedThreadPool(20);
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final AccessService accessService;
    private final UserMapper userTOMapper = (UserMapper)Mappers.getMapper(UserMapper.class);
    private final PageMapper pageMapper;
    private final AdditionalAccountInformationMapper additionalInfoMapper;
    private final MiddlewareRecoveryService recoveryService;
    @Value(value="${ledgers.sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public UserTO create(UserTO user) {
        UserBO createdUser = this.userService.create(this.userTOMapper.toUserBO(user));
        if (createdUser.getUserRoles().contains(UserRoleBO.STAFF)) {
            RecoveryPointTO point = new RecoveryPointTO();
            point.setDescription(String.format("Registered %s user", user.getLogin()));
            this.recoveryService.createRecoveryPoint(createdUser.getBranch(), point);
        }
        return this.userTOMapper.toUserTO(createdUser);
    }

    public UserTO findById(String id) {
        return this.userTOMapper.toUserTO(this.userService.findById(id));
    }

    public UserTO findByUserLogin(String userLogin) {
        return this.userTOMapper.toUserTO(this.userService.findByLogin(userLogin));
    }

    public UserTO updateScaData(String userLogin, List<ScaUserDataTO> scaDataList) {
        UserBO userBO = this.userService.updateScaData(this.userTOMapper.toScaUserDataListBO(scaDataList), userLogin);
        return this.userTOMapper.toUserTO(userBO);
    }

    public void updateAccountAccess(ScaInfoTO scaInfo, String userId, AccountAccessTO access) {
        DepositAccountBO account = this.depositAccountService.getAccountById(access.getAccountId());
        this.checkAccountIsEnabled(account);
        UserTO initiator = this.findById(scaInfo.getUserId());
        this.checkInitiatorIsPermittedToOperateAccount(access, initiator);
        UserTO user = this.findById(userId);
        this.checkUserIsNotABranchAndIsSameBranchAsAccount(user, account);
        this.checkInitiatorIsPermittedToOperateUser(scaInfo, initiator, user);
        AccountAccessBO newAccess = this.userTOMapper.toAccountAccessBO(access);
        newAccess.updateAccessFields(account.getIban(), account.getCurrency());
        this.accessService.updateAccountAccess(this.userTOMapper.toUserBO(user), newAccess);
        if (initiator.getUserRoles().contains(UserRoleTO.SYSTEM) && StringUtils.isNotBlank((CharSequence)user.getBranch())) {
            UserBO branch = this.userService.findById(user.getBranch());
            this.accessService.updateAccountAccess(branch, newAccess);
        }
    }

    private void checkUserIsNotABranchAndIsSameBranchAsAccount(UserTO user, DepositAccountBO account) {
        String devMsg = null;
        if (user.getUserRoles().contains(UserRoleTO.STAFF)) {
            devMsg = String.format("Requested user: %s is a TPP, thus can not possess access on account that does not belong to one of its users!", user.getLogin());
        }
        if (!user.getBranch().equals(account.getBranch())) {
            devMsg = String.format("Requested user: %s is from different branch than account: %s!", user.getLogin(), account.getIban());
        }
        if (devMsg != null) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(devMsg).build();
        }
    }

    private void checkInitiatorIsPermittedToOperateUser(ScaInfoTO scaInfo, UserTO initiator, UserTO user) {
        if (initiator.getUserRoles().contains(UserRoleTO.STAFF) && !initiator.getBranch().equals(user.getBranch())) {
            log.error("User id: {} with Branch: {} is not from initiator: {}", new Object[]{user.getId(), user.getBranch(), initiator.getLogin()});
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Requested user: %s is not a part of the initiator: %s", user.getLogin(), scaInfo.getUserLogin())).build();
        }
    }

    private void checkInitiatorIsPermittedToOperateAccount(AccountAccessTO access, UserTO initiator) {
        if (initiator.getUserRoles().contains(UserRoleTO.STAFF) && !this.accessService.userHasAccessToAccount(initiator, access.getIban())) {
            log.error("Branch: {} has no access to account: {}", (Object)initiator.getLogin(), (Object)access.getIban());
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Current Branch does have no access to the requested account: %s", access.getIban())).build();
        }
    }

    private void checkAccountIsEnabled(DepositAccountBO account) {
        if (!account.isEnabled()) {
            throw (MiddlewareModuleException)((Object)MiddlewareModuleException.blockedSupplier((MiddlewareErrorCode)MiddlewareErrorCode.INSUFFICIENT_PERMISSION, (String)account.getIban(), (boolean)account.isBlocked()).get());
        }
    }

    public List<UserTO> listUsers(int page, int size) {
        long start = System.nanoTime();
        List<UserTO> users = this.userTOMapper.toUserTOList(this.userService.listUsers(page, size));
        log.info("Retrieving: {} users in {} seconds", (Object)users.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return users;
    }

    public CustomPageImpl<UserTO> getUsersByBranchAndRoles(String countryCode, String branchId, String branchLogin, String userLogin, List<UserRoleTO> roles, Boolean blocked, CustomPageableImpl pageable) {
        return this.pageMapper.toCustomPageImpl(this.userService.findUsersByMultipleParamsPaged(countryCode, branchId, branchLogin, userLogin, this.userTOMapper.toUserRoleBO(roles), blocked, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.userTOMapper::toUserTO));
    }

    public List<String> getBranchUserLogins(String branchId) {
        return this.userService.findUserLoginsByBranch(branchId);
    }

    public CustomPageImpl<UserTO> getUsersByRoles(List<UserRoleTO> roles, CustomPageableImpl pageable) {
        return this.pageMapper.toCustomPageImpl(this.userService.getUsersByRoles(this.userTOMapper.toUserRoleBO(roles), (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.userTOMapper::toUserTO));
    }

    public CustomPageImpl<UserExtendedTO> getUsersByBranchAndRolesExtended(String countryCode, String branchId, String branchLogin, String userLogin, List<UserRoleTO> roles, Boolean blocked, CustomPageableImpl pageable) {
        return this.pageMapper.toCustomPageImpl(this.userService.findUsersByMultipleParamsPaged(countryCode, branchId, branchLogin, userLogin, this.userTOMapper.toUserRoleBO(roles), blocked, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.userTOMapper::toUserExtendedTO));
    }

    public int countUsersByBranch(String branch) {
        return this.userService.countUsersByBranch(branch);
    }

    public UserTO updateUser(String branchId, UserTO user) {
        String userId = Optional.ofNullable(user.getId()).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).devMsg("User id is not present in request!").build());
        if (this.userService.findById(userId).getBranch().equals(branchId)) {
            UserBO userBO = this.userTOMapper.toUserBO(user);
            return this.userTOMapper.toUserTO(this.userService.updateUser(userBO));
        }
        throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User doesn't belong to your branch!").build();
    }

    public void updatePassword(String userId, String password) {
        this.userService.updatePassword(userId, password);
    }

    public boolean checkMultilevelScaRequired(String login, String iban) {
        if (!this.multilevelScaEnable) {
            return false;
        }
        UserBO user = this.userService.findByLogin(login);
        if (!user.hasAccessToAccount(iban)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User doesn't have access to the requested account").build();
        }
        return this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), iban) < 100;
    }

    public boolean checkMultilevelScaRequired(String login, List<AccountReferenceTO> references) {
        if (!this.multilevelScaEnable) {
            return false;
        }
        UserBO user = this.userService.findByLogin(login);
        if (CollectionUtils.isEmpty(references)) {
            return user.getAccountAccesses().stream().anyMatch(a -> a.getScaWeight() < 100);
        }
        boolean allMatch = references.stream().allMatch(r -> Optional.ofNullable(r.getCurrency()).map(c -> user.hasAccessToAccount(r.getIban(), c)).orElse(user.hasAccessToAccount(r.getIban())));
        if (!allMatch) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User doesn't have access to the requested account").build();
        }
        return user.getAccountAccesses().stream().filter(a -> this.contained((AccountAccessBO)a, references)).anyMatch(a -> a.getScaWeight() < 100);
    }

    public List<AdditionalAccountInformationTO> getAdditionalInformation(ScaInfoTO scaInfoHolder, AccountIdentifierTypeTO accountIdentifierType, String accountIdentifier) {
        List info = AccountIdentifierTypeBO.valueOf((String)accountIdentifierType.name()).getAdditionalAccountInfo(accountIdentifier, arg_0 -> ((UserService)this.userService).findOwnersByIban(arg_0), arg_0 -> ((UserService)this.userService).findOwnersByAccountId(arg_0));
        return this.additionalInfoMapper.toAdditionalAccountInformationTOs(info);
    }

    public boolean changeStatus(String userId, boolean isSystemBlock) {
        UserBO user = this.userService.findById(userId);
        if (!user.getUserRoles().contains(UserRoleBO.CUSTOMER)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("Only customers can be blocked or unblocked.").build();
        }
        boolean lockStatusToSet = isSystemBlock ? !user.isSystemBlocked() : !user.isBlocked();
        this.userService.setUserBlockedStatus(userId, isSystemBlock, lockStatusToSet);
        Set depositAccountIdsToChangeStatus = user.getAccountAccesses().stream().map(AccountAccessBO::getAccountId).collect(Collectors.toSet());
        this.depositAccountService.changeAccountsBlockedStatus(depositAccountIdsToChangeStatus, isSystemBlock, lockStatusToSet);
        return lockStatusToSet;
    }

    public void editBasicSelf(String userId, UserTO user) {
        if (!user.getId().equals(userId)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("You are not allowed to perform operations on different users!").build();
        }
        UserBO storedUser = this.userService.findById(userId);
        storedUser.setLogin(user.getLogin());
        storedUser.setEmail(user.getEmail());
        storedUser.setPin(user.getPin());
        this.userService.updateUser(storedUser);
    }

    public void revertDatabase(String userId, long recoveryPointId) {
        long start = System.nanoTime();
        log.info("Started reverting state for {}", (Object)userId);
        RecoveryPointTO point = this.recoveryService.getPointById(userId, Long.valueOf(recoveryPointId));
        this.systemBlockBranch(userId, true);
        log.info("All branch data is LOCKED in {}seconds", (Object)((double)(System.nanoTime() - start) / 1.0E9));
        this.depositAccountService.rollBackBranch(userId, point.getRollBackTime());
        this.systemBlockBranch(userId, false);
        log.info("Reverted data and unlocked branch in {}s", (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    private void systemBlockBranch(String branchId, boolean statusToSet) {
        CompletableFuture.runAsync(() -> this.userService.setBranchBlockedStatus(branchId, true, statusToSet), FIXED_THREAD_POOL).thenRunAsync(() -> this.depositAccountService.changeAccountsBlockedStatus(branchId, true, statusToSet));
    }

    private boolean contained(AccountAccessBO access, List<AccountReferenceTO> references) {
        return references.stream().anyMatch(r -> Optional.ofNullable(r.getCurrency()).map(c -> access.getCurrency().equals(c) && access.getIban().equalsIgnoreCase(r.getIban())).orElse(access.getIban().equalsIgnoreCase(r.getIban())));
    }

    public MiddlewareUserManagementServiceImpl(UserService userService, DepositAccountService depositAccountService, AccessService accessService, PageMapper pageMapper, AdditionalAccountInformationMapper additionalInfoMapper, MiddlewareRecoveryService recoveryService) {
        this.userService = userService;
        this.depositAccountService = depositAccountService;
        this.accessService = accessService;
        this.pageMapper = pageMapper;
        this.additionalInfoMapper = additionalInfoMapper;
        this.recoveryService = recoveryService;
    }
}

