/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaMethodTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class UserMapperImpl
implements UserMapper {
    @Override
    public UserTO toUserTO(UserBO user) {
        if (user == null) {
            return null;
        }
        UserTO userTO = new UserTO();
        userTO.setId(user.getId());
        userTO.setLogin(user.getLogin());
        userTO.setEmail(user.getEmail());
        userTO.setPin(user.getPin());
        userTO.setScaUserData(this.toScaUserDataListTO(user.getScaUserData()));
        userTO.setAccountAccesses(this.toAccountAccessListTO(user.getAccountAccesses()));
        userTO.setUserRoles(this.userRoleBOCollectionToUserRoleTOCollection(user.getUserRoles()));
        userTO.setBranch(user.getBranch());
        return userTO;
    }

    @Override
    public UserBO toUserBO(UserTO user) {
        if (user == null) {
            return null;
        }
        UserBO userBO = new UserBO();
        userBO.setId(user.getId());
        userBO.setLogin(user.getLogin());
        userBO.setEmail(user.getEmail());
        userBO.setPin(user.getPin());
        userBO.setScaUserData(this.toScaUserDataListBO(user.getScaUserData()));
        userBO.setAccountAccesses(this.toAccountAccessListBO(user.getAccountAccesses()));
        userBO.setUserRoles(this.userRoleTOCollectionToUserRoleBOCollection(user.getUserRoles()));
        userBO.setBranch(user.getBranch());
        return userBO;
    }

    @Override
    public List<UserTO> toUserTOList(List<UserBO> listUsers) {
        if (listUsers == null) {
            return null;
        }
        ArrayList<UserTO> list = new ArrayList<UserTO>(listUsers.size());
        for (UserBO userBO : listUsers) {
            list.add(this.toUserTO(userBO));
        }
        return list;
    }

    @Override
    public List<UserBO> toUserBOList(List<UserTO> listUsers) {
        if (listUsers == null) {
            return null;
        }
        ArrayList<UserBO> list = new ArrayList<UserBO>(listUsers.size());
        for (UserTO userTO : listUsers) {
            list.add(this.toUserBO(userTO));
        }
        return list;
    }

    @Override
    public ScaUserDataBO toScaUserDataBO(ScaUserDataTO userData) {
        if (userData == null) {
            return null;
        }
        ScaUserDataBO scaUserDataBO = new ScaUserDataBO();
        scaUserDataBO.setId(userData.getId());
        scaUserDataBO.setScaMethod(this.scaMethodTypeTOToScaMethodTypeBO(userData.getScaMethod()));
        scaUserDataBO.setMethodValue(userData.getMethodValue());
        scaUserDataBO.setUsesStaticTan(userData.isUsesStaticTan());
        scaUserDataBO.setStaticTan(userData.getStaticTan());
        scaUserDataBO.setValid(userData.isValid());
        return scaUserDataBO;
    }

    @Override
    public ScaUserDataTO toScaUserDataTO(ScaUserDataBO bo) {
        if (bo == null) {
            return null;
        }
        ScaUserDataTO scaUserDataTO = new ScaUserDataTO();
        scaUserDataTO.setId(bo.getId());
        scaUserDataTO.setScaMethod(this.scaMethodTypeBOToScaMethodTypeTO(bo.getScaMethod()));
        scaUserDataTO.setMethodValue(bo.getMethodValue());
        scaUserDataTO.setUsesStaticTan(bo.isUsesStaticTan());
        scaUserDataTO.setStaticTan(bo.getStaticTan());
        scaUserDataTO.setValid(bo.isValid());
        return scaUserDataTO;
    }

    @Override
    public List<ScaUserDataBO> toScaUserDataListBO(List<ScaUserDataTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ScaUserDataBO> list1 = new ArrayList<ScaUserDataBO>(list.size());
        for (ScaUserDataTO scaUserDataTO : list) {
            list1.add(this.toScaUserDataBO(scaUserDataTO));
        }
        return list1;
    }

    @Override
    public List<ScaUserDataTO> toScaUserDataListTO(List<ScaUserDataBO> bos) {
        if (bos == null) {
            return null;
        }
        ArrayList<ScaUserDataTO> list = new ArrayList<ScaUserDataTO>(bos.size());
        for (ScaUserDataBO scaUserDataBO : bos) {
            list.add(this.toScaUserDataTO(scaUserDataBO));
        }
        return list;
    }

    @Override
    public AccountAccessBO toAccountAccessBO(AccountAccessTO userData) {
        if (userData == null) {
            return null;
        }
        AccountAccessBO accountAccessBO = new AccountAccessBO();
        accountAccessBO.setId(userData.getId());
        accountAccessBO.setIban(userData.getIban());
        accountAccessBO.setCurrency(userData.getCurrency());
        accountAccessBO.setAccessType(this.accessTypeTOToAccessTypeBO(userData.getAccessType()));
        accountAccessBO.setScaWeight(userData.getScaWeight());
        accountAccessBO.setAccountId(userData.getAccountId());
        return accountAccessBO;
    }

    @Override
    public AccountAccessTO toAccountAccessTO(AccountAccessBO bo) {
        if (bo == null) {
            return null;
        }
        AccountAccessTO accountAccessTO = new AccountAccessTO();
        accountAccessTO.setId(bo.getId());
        accountAccessTO.setIban(bo.getIban());
        accountAccessTO.setCurrency(bo.getCurrency());
        accountAccessTO.setAccessType(this.accessTypeBOToAccessTypeTO(bo.getAccessType()));
        accountAccessTO.setScaWeight(bo.getScaWeight());
        accountAccessTO.setAccountId(bo.getAccountId());
        return accountAccessTO;
    }

    @Override
    public List<AccountAccessBO> toAccountAccessListBO(List<AccountAccessTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<AccountAccessBO> list1 = new ArrayList<AccountAccessBO>(list.size());
        for (AccountAccessTO accountAccessTO : list) {
            list1.add(this.toAccountAccessBO(accountAccessTO));
        }
        return list1;
    }

    @Override
    public List<AccountAccessTO> toAccountAccessListTO(List<AccountAccessBO> bos) {
        if (bos == null) {
            return null;
        }
        ArrayList<AccountAccessTO> list = new ArrayList<AccountAccessTO>(bos.size());
        for (AccountAccessBO accountAccessBO : bos) {
            list.add(this.toAccountAccessTO(accountAccessBO));
        }
        return list;
    }

    @Override
    public List<UserRoleTO> toUserRoleTO(List<UserRoleBO> userRoles) {
        if (userRoles == null) {
            return null;
        }
        ArrayList<UserRoleTO> list = new ArrayList<UserRoleTO>(userRoles.size());
        for (UserRoleBO userRoleBO : userRoles) {
            list.add(this.userRoleBOToUserRoleTO(userRoleBO));
        }
        return list;
    }

    @Override
    public List<UserRoleBO> toUserRoleBO(List<UserRoleTO> userRoles) {
        if (userRoles == null) {
            return null;
        }
        ArrayList<UserRoleBO> list = new ArrayList<UserRoleBO>(userRoles.size());
        for (UserRoleTO userRoleTO : userRoles) {
            list.add(this.userRoleTOToUserRoleBO(userRoleTO));
        }
        return list;
    }

    protected UserRoleTO userRoleBOToUserRoleTO(UserRoleBO userRoleBO) {
        UserRoleTO userRoleTO;
        if (userRoleBO == null) {
            return null;
        }
        switch (userRoleBO) {
            case CUSTOMER: {
                userRoleTO = UserRoleTO.CUSTOMER;
                break;
            }
            case STAFF: {
                userRoleTO = UserRoleTO.STAFF;
                break;
            }
            case TECHNICAL: {
                userRoleTO = UserRoleTO.TECHNICAL;
                break;
            }
            case SYSTEM: {
                userRoleTO = UserRoleTO.SYSTEM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + userRoleBO);
            }
        }
        return userRoleTO;
    }

    protected Collection<UserRoleTO> userRoleBOCollectionToUserRoleTOCollection(Collection<UserRoleBO> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<UserRoleTO> collection1 = new ArrayList<UserRoleTO>(collection.size());
        for (UserRoleBO userRoleBO : collection) {
            collection1.add(this.userRoleBOToUserRoleTO(userRoleBO));
        }
        return collection1;
    }

    protected UserRoleBO userRoleTOToUserRoleBO(UserRoleTO userRoleTO) {
        UserRoleBO userRoleBO;
        if (userRoleTO == null) {
            return null;
        }
        switch (userRoleTO) {
            case CUSTOMER: {
                userRoleBO = UserRoleBO.CUSTOMER;
                break;
            }
            case STAFF: {
                userRoleBO = UserRoleBO.STAFF;
                break;
            }
            case TECHNICAL: {
                userRoleBO = UserRoleBO.TECHNICAL;
                break;
            }
            case SYSTEM: {
                userRoleBO = UserRoleBO.SYSTEM;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + userRoleTO);
            }
        }
        return userRoleBO;
    }

    protected Collection<UserRoleBO> userRoleTOCollectionToUserRoleBOCollection(Collection<UserRoleTO> collection) {
        if (collection == null) {
            return null;
        }
        ArrayList<UserRoleBO> collection1 = new ArrayList<UserRoleBO>(collection.size());
        for (UserRoleTO userRoleTO : collection) {
            collection1.add(this.userRoleTOToUserRoleBO(userRoleTO));
        }
        return collection1;
    }

    protected ScaMethodTypeBO scaMethodTypeTOToScaMethodTypeBO(ScaMethodTypeTO scaMethodTypeTO) {
        ScaMethodTypeBO scaMethodTypeBO;
        if (scaMethodTypeTO == null) {
            return null;
        }
        switch (scaMethodTypeTO) {
            case EMAIL: {
                scaMethodTypeBO = ScaMethodTypeBO.EMAIL;
                break;
            }
            case MOBILE: {
                scaMethodTypeBO = ScaMethodTypeBO.MOBILE;
                break;
            }
            case CHIP_OTP: {
                scaMethodTypeBO = ScaMethodTypeBO.CHIP_OTP;
                break;
            }
            case PHOTO_OTP: {
                scaMethodTypeBO = ScaMethodTypeBO.PHOTO_OTP;
                break;
            }
            case PUSH_OTP: {
                scaMethodTypeBO = ScaMethodTypeBO.PUSH_OTP;
                break;
            }
            case SMS_OTP: {
                scaMethodTypeBO = ScaMethodTypeBO.SMS_OTP;
                break;
            }
            case APP_OTP: {
                scaMethodTypeBO = ScaMethodTypeBO.APP_OTP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaMethodTypeTO);
            }
        }
        return scaMethodTypeBO;
    }

    protected ScaMethodTypeTO scaMethodTypeBOToScaMethodTypeTO(ScaMethodTypeBO scaMethodTypeBO) {
        ScaMethodTypeTO scaMethodTypeTO;
        if (scaMethodTypeBO == null) {
            return null;
        }
        switch (scaMethodTypeBO) {
            case EMAIL: {
                scaMethodTypeTO = ScaMethodTypeTO.EMAIL;
                break;
            }
            case MOBILE: {
                scaMethodTypeTO = ScaMethodTypeTO.MOBILE;
                break;
            }
            case CHIP_OTP: {
                scaMethodTypeTO = ScaMethodTypeTO.CHIP_OTP;
                break;
            }
            case PHOTO_OTP: {
                scaMethodTypeTO = ScaMethodTypeTO.PHOTO_OTP;
                break;
            }
            case PUSH_OTP: {
                scaMethodTypeTO = ScaMethodTypeTO.PUSH_OTP;
                break;
            }
            case SMS_OTP: {
                scaMethodTypeTO = ScaMethodTypeTO.SMS_OTP;
                break;
            }
            case APP_OTP: {
                scaMethodTypeTO = ScaMethodTypeTO.APP_OTP;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + scaMethodTypeBO);
            }
        }
        return scaMethodTypeTO;
    }

    protected AccessTypeBO accessTypeTOToAccessTypeBO(AccessTypeTO accessTypeTO) {
        AccessTypeBO accessTypeBO;
        if (accessTypeTO == null) {
            return null;
        }
        switch (accessTypeTO) {
            case OWNER: {
                accessTypeBO = AccessTypeBO.OWNER;
                break;
            }
            case READ: {
                accessTypeBO = AccessTypeBO.READ;
                break;
            }
            case DISPOSE: {
                accessTypeBO = AccessTypeBO.DISPOSE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accessTypeTO);
            }
        }
        return accessTypeBO;
    }

    protected AccessTypeTO accessTypeBOToAccessTypeTO(AccessTypeBO accessTypeBO) {
        AccessTypeTO accessTypeTO;
        if (accessTypeBO == null) {
            return null;
        }
        switch (accessTypeBO) {
            case OWNER: {
                accessTypeTO = AccessTypeTO.OWNER;
                break;
            }
            case READ: {
                accessTypeTO = AccessTypeTO.READ;
                break;
            }
            case DISPOSE: {
                accessTypeTO = AccessTypeTO.DISPOSE;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accessTypeBO);
            }
        }
        return accessTypeTO;
    }
}

