/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentResultBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentResultTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;

@Mapper(componentModel="spring")
public interface PaymentConverter {
    public PaymentResultTO toPaymentResultTO(PaymentResultBO var1);

    public PaymentResultBO toPaymentResultBO(PaymentResultTO var1);

    public PaymentTypeBO toPaymentTypeBO(PaymentTypeTO var1);

    public PaymentTypeTO toPaymentTypeTO(PaymentTypeBO var1);

    default public Object toPaymentTO(PaymentBO payment) {
        if (payment.getPaymentType() == PaymentTypeBO.SINGLE) {
            return this.toSinglePaymentTO(payment, (PaymentTargetBO)payment.getTargets().get(0));
        }
        if (payment.getPaymentType() == PaymentTypeBO.PERIODIC) {
            return this.toPeriodicPaymentTO(payment, (PaymentTargetBO)payment.getTargets().get(0));
        }
        return this.toBulkPaymentTO(payment, (PaymentTargetBO)payment.getTargets().get(0));
    }

    @Mappings(value={@Mapping(source="payment.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus"), @Mapping(target="paymentProduct", expression="java(toPaymentProductTO(payment.getPaymentProduct()))")})
    public SinglePaymentTO toSinglePaymentTO(PaymentBO var1, PaymentTargetBO var2);

    @Mappings(value={@Mapping(source="payment.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus"), @Mapping(target="paymentProduct", expression="java(toPaymentProductTO(payment.getPaymentProduct()))")})
    public PeriodicPaymentTO toPeriodicPaymentTO(PaymentBO var1, PaymentTargetBO var2);

    @Mappings(value={@Mapping(source="payment.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus"), @Mapping(target="paymentProduct", expression="java(toPaymentProductTO(payment.getPaymentProduct()))"), @Mapping(target="payments", expression="java(payment.getTargets().stream().map(t -> toSingleBulkPartTO(payment, t)).collect(java.util.stream.Collectors.toList()))")})
    public BulkPaymentTO toBulkPaymentTO(PaymentBO var1, PaymentTargetBO var2);

    @Mappings(value={@Mapping(source="paymentTarget.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus"), @Mapping(target="paymentProduct", expression="java(toPaymentProductTO(payment.getPaymentProduct()))")})
    public SinglePaymentTO toSingleBulkPartTO(PaymentBO var1, PaymentTargetBO var2);

    default public PaymentProductTO toPaymentProductTO(String paymentProduct) {
        Optional paymentProductTO = PaymentProductTO.getByValue((String)paymentProduct);
        PaymentProductTO payment = null;
        if (paymentProductTO.isPresent()) {
            payment = (PaymentProductTO)paymentProductTO.get();
        }
        return payment;
    }

    public PaymentBO toPaymentBO(PaymentTO var1);

    @Mapping(target="paymentType", source="paymentType")
    public PaymentBO toPaymentBO(PaymentTO var1, PaymentTypeTO var2);

    public List<TransactionTO> toTransactionTOList(List<TransactionDetailsBO> var1);

    @Mapping(source="transactionAmount", target="amount")
    public TransactionTO toTransactionTO(TransactionDetailsBO var1);

    @Mapping(target="currency", source="currencyTo")
    public ExchangeRateTO toExchangeRateTO(ExchangeRateBO var1);

    @Mapping(target="transactionAmount", source="amount")
    public TransactionDetailsBO toTransactionDetailsBO(TransactionTO var1);

    default public List<PaymentTO> toPaymentTOList(List<PaymentBO> payments) {
        return payments.stream().map(this::toAbstractPaymentTO).collect(Collectors.toList());
    }

    public PaymentTO toAbstractPaymentTO(PaymentBO var1);
}

