/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountIdentifierTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AdditionalAccountInformationTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AdditionalAccountInformationMapper;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.AccountIdentifierTypeBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareUserManagementServiceImpl
implements MiddlewareUserManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareUserManagementServiceImpl.class);
    private static final int NANO_TO_SECOND = 1000000000;
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final AccessService accessService;
    private final UserMapper userTOMapper = (UserMapper)Mappers.getMapper(UserMapper.class);
    private final PageMapper pageMapper;
    private final AdditionalAccountInformationMapper additionalInfoMapper;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public UserTO create(UserTO user) {
        UserBO userBO = this.userTOMapper.toUserBO(user);
        return this.userTOMapper.toUserTO(this.userService.create(userBO));
    }

    public UserTO findById(String id) {
        return this.userTOMapper.toUserTO(this.userService.findById(id));
    }

    public UserTO findByUserLogin(String userLogin) {
        return this.userTOMapper.toUserTO(this.userService.findByLogin(userLogin));
    }

    public UserTO updateScaData(String userLogin, List<ScaUserDataTO> scaDataList) {
        UserBO userBO = this.userService.updateScaData(this.userTOMapper.toScaUserDataListBO(scaDataList), userLogin);
        return this.userTOMapper.toUserTO(userBO);
    }

    public void updateAccountAccess(ScaInfoTO scaInfo, String userId, AccountAccessTO access) {
        DepositAccountDetailsBO account = this.depositAccountService.getAccountDetailsByIbanAndCurrency(access.getIban(), access.getCurrency(), LocalDateTime.now(), false);
        if (!account.isEnabled()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format("Operation is Rejected as account: %s is %s", account.getAccount().getIban(), account.getAccount().getAccountStatus())).build();
        }
        UserTO branch = this.findById(scaInfo.getUserId());
        boolean tppHasAccessToAccount = this.accessService.userHasAccessToAccount(branch, access.getIban());
        if (!tppHasAccessToAccount) {
            log.error("Branch: {} has no access to account: {}", (Object)branch.getLogin(), (Object)access.getIban());
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Current Branch does have no access to the requested account: %s", access.getIban())).build();
        }
        UserTO user = this.findById(userId);
        if (!branch.getBranch().equals(user.getBranch())) {
            log.error("User id: {} with Branch: {} is not from branch: {}", new Object[]{user.getId(), user.getBranch(), branch.getLogin()});
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Requested user: %s is not a part of the branch: %s", user.getLogin(), scaInfo.getUserLogin())).build();
        }
        this.accessService.updateAccountAccess(this.userTOMapper.toUserBO(user), this.userTOMapper.toAccountAccessBO(access));
    }

    public List<UserTO> listUsers(int page, int size) {
        long start = System.nanoTime();
        List<UserTO> users = this.userTOMapper.toUserTOList(this.userService.listUsers(page, size));
        log.info("Retrieving: {} users in {} seconds", (Object)users.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return users;
    }

    public CustomPageImpl<UserTO> getUsersByBranchAndRoles(String branch, List<UserRoleTO> roles, String queryParam, CustomPageableImpl pageable) {
        return this.pageMapper.toCustomPageImpl(this.userService.findByBranchAndUserRolesIn(branch, this.userTOMapper.toUserRoleBO(roles), queryParam, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.userTOMapper::toUserTO));
    }

    public int countUsersByBranch(String branch) {
        return this.userService.countUsersByBranch(branch);
    }

    public UserTO updateUser(String branchId, UserTO user) {
        String userId = Optional.ofNullable(user.getId()).orElseThrow(() -> MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).devMsg("User id is not present in request!").build());
        if (this.userService.findById(userId).getBranch().equals(branchId)) {
            UserBO userBO = this.userTOMapper.toUserBO(user);
            return this.userTOMapper.toUserTO(this.userService.updateUser(userBO));
        }
        throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User doesn't belong to your branch!").build();
    }

    public boolean checkMultilevelScaRequired(String login, String iban) {
        if (!this.multilevelScaEnable) {
            return false;
        }
        UserBO user = this.userService.findByLogin(login);
        if (!user.hasAccessToAccount(iban)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User doesn't have access to the requested account").build();
        }
        return this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), iban) < 100;
    }

    public boolean checkMultilevelScaRequired(String login, List<AccountReferenceTO> references) {
        if (!this.multilevelScaEnable) {
            return false;
        }
        UserBO user = this.userService.findByLogin(login);
        if (CollectionUtils.isEmpty(references)) {
            return user.getAccountAccesses().stream().anyMatch(a -> a.getScaWeight() < 100);
        }
        boolean allMatch = references.stream().allMatch(r -> Optional.ofNullable(r.getCurrency()).map(c -> user.hasAccessToAccount(r.getIban(), c)).orElse(user.hasAccessToAccount(r.getIban())));
        if (!allMatch) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg("User doesn't have access to the requested account").build();
        }
        return user.getAccountAccesses().stream().filter(a -> this.contained((AccountAccessBO)a, references)).anyMatch(a -> a.getScaWeight() < 100);
    }

    public List<AdditionalAccountInformationTO> getAdditionalInformation(ScaInfoTO scaInfoHolder, AccountIdentifierTypeTO accountIdentifierType, String accountIdentifier) {
        List info = AccountIdentifierTypeBO.valueOf((String)accountIdentifierType.name()).getAdditionalAccountInfo(accountIdentifier, arg_0 -> ((UserService)this.userService).findOwnersByIban(arg_0), arg_0 -> ((UserService)this.userService).findOwnersByAccountId(arg_0));
        return this.additionalInfoMapper.toAdditionalAccountInformationTOs(info);
    }

    private boolean contained(AccountAccessBO access, List<AccountReferenceTO> references) {
        return references.stream().anyMatch(r -> Optional.ofNullable(r.getCurrency()).map(c -> access.getCurrency().equals(c) && access.getIban().equalsIgnoreCase(r.getIban())).orElse(access.getIban().equalsIgnoreCase(r.getIban())));
    }

    public MiddlewareUserManagementServiceImpl(UserService userService, DepositAccountService depositAccountService, AccessService accessService, PageMapper pageMapper, AdditionalAccountInformationMapper additionalInfoMapper) {
        this.userService = userService;
        this.depositAccountService = depositAccountService;
        this.accessService = accessService;
        this.pageMapper = pageMapper;
        this.additionalInfoMapper = additionalInfoMapper;
    }
}

