/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.sca;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.middleware.api.domain.sca.ChallengeDataTO;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.annotation.RequestScope;

@RequestScope
@Configuration
public class ChallengeDataConfig {
    private static final Logger log = LoggerFactory.getLogger(ChallengeDataConfig.class);
    private static final String DEFAULT_CHALLENGE_DATA_PATH = "classpath:sca_challenge_data.json";
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static final String FILE_PREFIX = "file:";
    @Value(value="${sca.challenge_data.path:}")
    private String customChallengeDataPath;
    @JsonAnySetter
    private Map<String, ChallengeDataTO> challengeDatas = new HashMap<String, ChallengeDataTO>();

    public ChallengeDataConfig(ObjectMapper mapper, ResourceLoader resourceLoader) {
        Resource resource = resourceLoader.getResource(this.resolveChallengeDataPath());
        try (InputStream is = resource.getInputStream();){
            String content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{content})) {
                this.challengeDatas = (Map)mapper.readValue(content, (TypeReference)new TypeReference<Map<String, ChallengeDataTO>>(){});
            }
        }
        catch (IOException e) {
            log.error("Could not read challenge data");
        }
    }

    @Bean
    @RequestScope
    public Map<String, ChallengeDataTO> challengeDatas() {
        return this.challengeDatas;
    }

    private String resolveChallengeDataPath() {
        if (StringUtils.isBlank((CharSequence)this.customChallengeDataPath)) {
            return DEFAULT_CHALLENGE_DATA_PATH;
        }
        if (this.customChallengeDataPath.startsWith(CLASSPATH_PREFIX) || this.customChallengeDataPath.startsWith(FILE_PREFIX)) {
            return this.customChallengeDataPath;
        }
        return FILE_PREFIX + this.customChallengeDataPath;
    }
}

