/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.config;

import java.util.HashSet;
import java.util.Set;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="payment-products")
public class PaymentProductsConfig {
    private Set<String> instant = new HashSet<String>();
    private Set<String> regular = new HashSet<String>();

    public boolean isNotSupportedPaymentProduct(String paymentProduct) {
        return !this.instant.contains(paymentProduct) && !this.regular.contains(paymentProduct);
    }

    public void setInstant(Set<String> instant) {
        this.instant = instant;
    }

    public void setRegular(Set<String> regular) {
        this.regular = regular;
    }

    public Set<String> getInstant() {
        return this.instant;
    }

    public Set<String> getRegular() {
        return this.regular;
    }
}

