package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AddressBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.domain.FrequencyCodeBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentResultBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.PurposeCodeBO;
import de.adorsys.ledgers.deposit.api.domain.RemittanceInformationStructuredBO;
import de.adorsys.ledgers.deposit.api.domain.ResultStatusBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentResultTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTargetTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PurposeCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.RemittanceInformationStructuredTO;
import de.adorsys.ledgers.middleware.api.domain.payment.ResultStatusTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-12-16T18:37:05+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_222 (Private Build)"
)
@Component
public class PaymentConverterImpl extends PaymentConverter {

    @Override
    public PaymentResultTO toPaymentResultTO(PaymentResultBO bo) {
        if ( bo == null ) {
            return null;
        }

        PaymentResultTO paymentResultTO = new PaymentResultTO();

        paymentResultTO.setResponseStatus( resultStatusBOToResultStatusTO( bo.getResponseStatus() ) );
        List list = bo.getMessages();
        if ( list != null ) {
            paymentResultTO.setMessages( new ArrayList( list ) );
        }
        paymentResultTO.setPaymentResult( bo.getPaymentResult() );

        return paymentResultTO;
    }

    @Override
    public PaymentResultBO toPaymentResultBO(PaymentResultTO to) {
        if ( to == null ) {
            return null;
        }

        PaymentResultBO paymentResultBO = new PaymentResultBO();

        paymentResultBO.setResponseStatus( resultStatusTOToResultStatusBO( to.getResponseStatus() ) );
        List list = to.getMessages();
        if ( list != null ) {
            paymentResultBO.setMessages( new ArrayList( list ) );
        }
        paymentResultBO.setPaymentResult( to.getPaymentResult() );

        return paymentResultBO;
    }

    @Override
    public PaymentTypeBO toPaymentTypeBO(PaymentTypeTO paymentType) {
        if ( paymentType == null ) {
            return null;
        }

        PaymentTypeBO paymentTypeBO;

        switch ( paymentType ) {
            case SINGLE: paymentTypeBO = PaymentTypeBO.SINGLE;
            break;
            case PERIODIC: paymentTypeBO = PaymentTypeBO.PERIODIC;
            break;
            case BULK: paymentTypeBO = PaymentTypeBO.BULK;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentType );
        }

        return paymentTypeBO;
    }

    @Override
    public PaymentTypeTO toPaymentTypeTO(PaymentTypeBO paymentType) {
        if ( paymentType == null ) {
            return null;
        }

        PaymentTypeTO paymentTypeTO;

        switch ( paymentType ) {
            case SINGLE: paymentTypeTO = PaymentTypeTO.SINGLE;
            break;
            case BULK: paymentTypeTO = PaymentTypeTO.BULK;
            break;
            case PERIODIC: paymentTypeTO = PaymentTypeTO.PERIODIC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + paymentType );
        }

        return paymentTypeTO;
    }

    @Override
    public SinglePaymentTO toSinglePaymentTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if ( payment == null && paymentTarget == null ) {
            return null;
        }

        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();

        if ( payment != null ) {
            singlePaymentTO.setPaymentId( payment.getPaymentId() );
            singlePaymentTO.setPaymentStatus( transactionStatusBOToTransactionStatusTO( payment.getTransactionStatus() ) );
            singlePaymentTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( payment.getDebtorAccount() ) );
            singlePaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
            singlePaymentTO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        }
        if ( paymentTarget != null ) {
            singlePaymentTO.setEndToEndIdentification( paymentTarget.getEndToEndIdentification() );
            singlePaymentTO.setInstructedAmount( amountBOToAmountTO( paymentTarget.getInstructedAmount() ) );
            singlePaymentTO.setCreditorAccount( accountReferenceBOToAccountReferenceTO( paymentTarget.getCreditorAccount() ) );
            singlePaymentTO.setCreditorAgent( paymentTarget.getCreditorAgent() );
            singlePaymentTO.setCreditorName( paymentTarget.getCreditorName() );
            singlePaymentTO.setCreditorAddress( addressBOToAddressTO( paymentTarget.getCreditorAddress() ) );
            singlePaymentTO.setRemittanceInformationUnstructured( paymentTarget.getRemittanceInformationUnstructured() );
        }
        singlePaymentTO.setPaymentProduct( toPaymentProductTO(payment.getPaymentProduct()) );

        return singlePaymentTO;
    }

    @Override
    public PeriodicPaymentTO toPeriodicPaymentTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if ( payment == null && paymentTarget == null ) {
            return null;
        }

        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();

        if ( payment != null ) {
            periodicPaymentTO.setPaymentId( payment.getPaymentId() );
            periodicPaymentTO.setPaymentStatus( transactionStatusBOToTransactionStatusTO( payment.getTransactionStatus() ) );
            periodicPaymentTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( payment.getDebtorAccount() ) );
            periodicPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
            periodicPaymentTO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
            periodicPaymentTO.setStartDate( payment.getStartDate() );
            periodicPaymentTO.setEndDate( payment.getEndDate() );
            periodicPaymentTO.setExecutionRule( payment.getExecutionRule() );
            periodicPaymentTO.setFrequency( frequencyCodeBOToFrequencyCodeTO( payment.getFrequency() ) );
            periodicPaymentTO.setDayOfExecution( payment.getDayOfExecution() );
        }
        if ( paymentTarget != null ) {
            periodicPaymentTO.setEndToEndIdentification( paymentTarget.getEndToEndIdentification() );
            periodicPaymentTO.setInstructedAmount( amountBOToAmountTO( paymentTarget.getInstructedAmount() ) );
            periodicPaymentTO.setCreditorAccount( accountReferenceBOToAccountReferenceTO( paymentTarget.getCreditorAccount() ) );
            periodicPaymentTO.setCreditorAgent( paymentTarget.getCreditorAgent() );
            periodicPaymentTO.setCreditorName( paymentTarget.getCreditorName() );
            periodicPaymentTO.setCreditorAddress( addressBOToAddressTO( paymentTarget.getCreditorAddress() ) );
            periodicPaymentTO.setRemittanceInformationUnstructured( paymentTarget.getRemittanceInformationUnstructured() );
        }
        periodicPaymentTO.setPaymentProduct( toPaymentProductTO(payment.getPaymentProduct()) );

        return periodicPaymentTO;
    }

    @Override
    public BulkPaymentTO toBulkPaymentTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if ( payment == null && paymentTarget == null ) {
            return null;
        }

        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();

        if ( payment != null ) {
            bulkPaymentTO.setPaymentId( payment.getPaymentId() );
            bulkPaymentTO.setPaymentStatus( transactionStatusBOToTransactionStatusTO( payment.getTransactionStatus() ) );
            bulkPaymentTO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
            bulkPaymentTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( payment.getDebtorAccount() ) );
            bulkPaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        }
        bulkPaymentTO.setPaymentProduct( toPaymentProductTO(payment.getPaymentProduct()) );
        bulkPaymentTO.setPayments( payment.getTargets().stream().map(t -> toSingleBulkPartTO(payment, t)).collect(java.util.stream.Collectors.toList()) );

        return bulkPaymentTO;
    }

    @Override
    public SinglePaymentTO toSingleBulkPartTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if ( payment == null && paymentTarget == null ) {
            return null;
        }

        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();

        if ( payment != null ) {
            singlePaymentTO.setPaymentStatus( transactionStatusBOToTransactionStatusTO( payment.getTransactionStatus() ) );
            singlePaymentTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( payment.getDebtorAccount() ) );
            singlePaymentTO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
            singlePaymentTO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        }
        if ( paymentTarget != null ) {
            singlePaymentTO.setPaymentId( paymentTarget.getPaymentId() );
            singlePaymentTO.setEndToEndIdentification( paymentTarget.getEndToEndIdentification() );
            singlePaymentTO.setInstructedAmount( amountBOToAmountTO( paymentTarget.getInstructedAmount() ) );
            singlePaymentTO.setCreditorAccount( accountReferenceBOToAccountReferenceTO( paymentTarget.getCreditorAccount() ) );
            singlePaymentTO.setCreditorAgent( paymentTarget.getCreditorAgent() );
            singlePaymentTO.setCreditorName( paymentTarget.getCreditorName() );
            singlePaymentTO.setCreditorAddress( addressBOToAddressTO( paymentTarget.getCreditorAddress() ) );
            singlePaymentTO.setRemittanceInformationUnstructured( paymentTarget.getRemittanceInformationUnstructured() );
        }
        singlePaymentTO.setPaymentProduct( toPaymentProductTO(payment.getPaymentProduct()) );

        return singlePaymentTO;
    }

    @Override
    public PaymentBO toPaymentBO(PaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        paymentBO.setPaymentId( payment.getPaymentId() );
        paymentBO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentBO.setPaymentType( toPaymentTypeBO( payment.getPaymentType() ) );
        paymentBO.setPaymentProduct( payment.getPaymentProduct() );
        paymentBO.setStartDate( payment.getStartDate() );
        paymentBO.setEndDate( payment.getEndDate() );
        paymentBO.setExecutionRule( payment.getExecutionRule() );
        paymentBO.setFrequency( frequencyCodeTOToFrequencyCodeBO( payment.getFrequency() ) );
        paymentBO.setDayOfExecution( payment.getDayOfExecution() );
        paymentBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( payment.getDebtorAccount() ) );
        paymentBO.setTransactionStatus( transactionStatusTOToTransactionStatusBO( payment.getTransactionStatus() ) );
        paymentBO.setTargets( paymentTargetTOListToPaymentTargetBOList( payment.getTargets() ) );

        return paymentBO;
    }

    @Override
    public PaymentBO toPaymentBO(SinglePaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        paymentBO.setTransactionStatus( transactionStatusTOToTransactionStatusBO( payment.getPaymentStatus() ) );
        paymentBO.setPaymentId( payment.getPaymentId() );
        paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( payment.getDebtorAccount() ) );

        paymentBO.setPaymentProduct( payment.getPaymentProduct().getValue() );
        paymentBO.setTargets( java.util.Collections.singletonList(toPaymentTarget(payment)) );
        paymentBO.setPaymentType( PaymentTypeBO.SINGLE );

        return paymentBO;
    }

    @Override
    public PaymentBO toPaymentBO(PeriodicPaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        paymentBO.setTransactionStatus( transactionStatusTOToTransactionStatusBO( payment.getPaymentStatus() ) );
        paymentBO.setPaymentId( payment.getPaymentId() );
        paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentBO.setRequestedExecutionTime( payment.getRequestedExecutionTime() );
        paymentBO.setStartDate( payment.getStartDate() );
        paymentBO.setEndDate( payment.getEndDate() );
        paymentBO.setExecutionRule( payment.getExecutionRule() );
        paymentBO.setFrequency( frequencyCodeTOToFrequencyCodeBO( payment.getFrequency() ) );
        paymentBO.setDayOfExecution( payment.getDayOfExecution() );
        paymentBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( payment.getDebtorAccount() ) );

        paymentBO.setPaymentProduct( payment.getPaymentProduct().getValue() );
        paymentBO.setTargets( java.util.Collections.singletonList(toPaymentTarget(payment)) );
        paymentBO.setPaymentType( PaymentTypeBO.PERIODIC );

        return paymentBO;
    }

    @Override
    public PaymentBO toPaymentBO(BulkPaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentBO paymentBO = new PaymentBO();

        paymentBO.setTransactionStatus( transactionStatusTOToTransactionStatusBO( payment.getPaymentStatus() ) );
        paymentBO.setTargets( toPaymentTarget( payment.getPayments() ) );
        paymentBO.setPaymentId( payment.getPaymentId() );
        paymentBO.setBatchBookingPreferred( payment.getBatchBookingPreferred() );
        paymentBO.setRequestedExecutionDate( payment.getRequestedExecutionDate() );
        paymentBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( payment.getDebtorAccount() ) );

        paymentBO.setPaymentProduct( payment.getPaymentProduct().getValue() );
        paymentBO.setRequestedExecutionTime( java.util.Optional.ofNullable(payment.getPayments()).map(l -> l.get(0).getRequestedExecutionTime()).orElse(null) );
        paymentBO.setPaymentType( PaymentTypeBO.BULK );

        return paymentBO;
    }

    @Override
    public PaymentTargetBO toPaymentTarget(SinglePaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();

        paymentTargetBO.setPaymentId( payment.getPaymentId() );
        paymentTargetBO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        paymentTargetBO.setInstructedAmount( amountTOToAmountBO( payment.getInstructedAmount() ) );
        paymentTargetBO.setCreditorAccount( accountReferenceTOToAccountReferenceBO( payment.getCreditorAccount() ) );
        paymentTargetBO.setCreditorAgent( payment.getCreditorAgent() );
        paymentTargetBO.setCreditorName( payment.getCreditorName() );
        paymentTargetBO.setCreditorAddress( addressTOToAddressBO( payment.getCreditorAddress() ) );
        paymentTargetBO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );

        return paymentTargetBO;
    }

    @Override
    public PaymentTargetBO toPaymentTarget(PeriodicPaymentTO payment) {
        if ( payment == null ) {
            return null;
        }

        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();

        paymentTargetBO.setPaymentId( payment.getPaymentId() );
        paymentTargetBO.setEndToEndIdentification( payment.getEndToEndIdentification() );
        paymentTargetBO.setInstructedAmount( amountTOToAmountBO( payment.getInstructedAmount() ) );
        paymentTargetBO.setCreditorAccount( accountReferenceTOToAccountReferenceBO( payment.getCreditorAccount() ) );
        paymentTargetBO.setCreditorAgent( payment.getCreditorAgent() );
        paymentTargetBO.setCreditorName( payment.getCreditorName() );
        paymentTargetBO.setCreditorAddress( addressTOToAddressBO( payment.getCreditorAddress() ) );
        paymentTargetBO.setRemittanceInformationUnstructured( payment.getRemittanceInformationUnstructured() );

        return paymentTargetBO;
    }

    @Override
    public List<PaymentTargetBO> toPaymentTarget(List<SinglePaymentTO> payment) {
        if ( payment == null ) {
            return null;
        }

        List<PaymentTargetBO> list = new ArrayList<PaymentTargetBO>( payment.size() );
        for ( SinglePaymentTO singlePaymentTO : payment ) {
            list.add( toPaymentTarget( singlePaymentTO ) );
        }

        return list;
    }

    @Override
    public List<TransactionTO> toTransactionTOList(List<TransactionDetailsBO> transactions) {
        if ( transactions == null ) {
            return null;
        }

        List<TransactionTO> list = new ArrayList<TransactionTO>( transactions.size() );
        for ( TransactionDetailsBO transactionDetailsBO : transactions ) {
            list.add( toTransactionTO( transactionDetailsBO ) );
        }

        return list;
    }

    @Override
    public TransactionTO toTransactionTO(TransactionDetailsBO transaction) {
        if ( transaction == null ) {
            return null;
        }

        TransactionTO transactionTO = new TransactionTO();

        transactionTO.setAmount( amountBOToAmountTO( transaction.getTransactionAmount() ) );
        transactionTO.setTransactionId( transaction.getTransactionId() );
        transactionTO.setEntryReference( transaction.getEntryReference() );
        transactionTO.setEndToEndId( transaction.getEndToEndId() );
        transactionTO.setMandateId( transaction.getMandateId() );
        transactionTO.setCheckId( transaction.getCheckId() );
        transactionTO.setCreditorId( transaction.getCreditorId() );
        transactionTO.setBookingDate( transaction.getBookingDate() );
        transactionTO.setValueDate( transaction.getValueDate() );
        transactionTO.setExchangeRate( exchangeRateBOListToExchangeRateTOList( transaction.getExchangeRate() ) );
        transactionTO.setCreditorName( transaction.getCreditorName() );
        transactionTO.setCreditorAccount( accountReferenceBOToAccountReferenceTO( transaction.getCreditorAccount() ) );
        transactionTO.setUltimateCreditor( transaction.getUltimateCreditor() );
        transactionTO.setDebtorName( transaction.getDebtorName() );
        transactionTO.setDebtorAccount( accountReferenceBOToAccountReferenceTO( transaction.getDebtorAccount() ) );
        transactionTO.setUltimateDebtor( transaction.getUltimateDebtor() );
        transactionTO.setRemittanceInformationUnstructured( transaction.getRemittanceInformationUnstructured() );
        transactionTO.setRemittanceInformationStructured( remittanceInformationStructuredBOToRemittanceInformationStructuredTO( transaction.getRemittanceInformationStructured() ) );
        if ( transaction.getPurposeCode() != null ) {
            transactionTO.setPurposeCode( transaction.getPurposeCode().name() );
        }
        transactionTO.setBankTransactionCode( transaction.getBankTransactionCode() );
        transactionTO.setProprietaryBankTransactionCode( transaction.getProprietaryBankTransactionCode() );

        return transactionTO;
    }

    @Override
    public TransactionDetailsBO toTransactionDetailsBO(TransactionTO transaction) {
        if ( transaction == null ) {
            return null;
        }

        TransactionDetailsBO transactionDetailsBO = new TransactionDetailsBO();

        transactionDetailsBO.setTransactionAmount( amountTOToAmountBO( transaction.getAmount() ) );
        transactionDetailsBO.setTransactionId( transaction.getTransactionId() );
        transactionDetailsBO.setEntryReference( transaction.getEntryReference() );
        transactionDetailsBO.setEndToEndId( transaction.getEndToEndId() );
        transactionDetailsBO.setMandateId( transaction.getMandateId() );
        transactionDetailsBO.setCheckId( transaction.getCheckId() );
        transactionDetailsBO.setCreditorId( transaction.getCreditorId() );
        transactionDetailsBO.setBookingDate( transaction.getBookingDate() );
        transactionDetailsBO.setValueDate( transaction.getValueDate() );
        transactionDetailsBO.setExchangeRate( exchangeRateTOListToExchangeRateBOList( transaction.getExchangeRate() ) );
        transactionDetailsBO.setCreditorName( transaction.getCreditorName() );
        transactionDetailsBO.setCreditorAccount( accountReferenceTOToAccountReferenceBO( transaction.getCreditorAccount() ) );
        transactionDetailsBO.setUltimateCreditor( transaction.getUltimateCreditor() );
        transactionDetailsBO.setDebtorName( transaction.getDebtorName() );
        transactionDetailsBO.setDebtorAccount( accountReferenceTOToAccountReferenceBO( transaction.getDebtorAccount() ) );
        transactionDetailsBO.setUltimateDebtor( transaction.getUltimateDebtor() );
        transactionDetailsBO.setRemittanceInformationStructured( remittanceInformationStructuredTOToRemittanceInformationStructuredBO( transaction.getRemittanceInformationStructured() ) );
        transactionDetailsBO.setRemittanceInformationUnstructured( transaction.getRemittanceInformationUnstructured() );
        if ( transaction.getPurposeCode() != null ) {
            transactionDetailsBO.setPurposeCode( Enum.valueOf( PurposeCodeBO.class, transaction.getPurposeCode() ) );
        }
        transactionDetailsBO.setBankTransactionCode( transaction.getBankTransactionCode() );
        transactionDetailsBO.setProprietaryBankTransactionCode( transaction.getProprietaryBankTransactionCode() );

        return transactionDetailsBO;
    }

    protected ResultStatusTO resultStatusBOToResultStatusTO(ResultStatusBO resultStatusBO) {
        if ( resultStatusBO == null ) {
            return null;
        }

        ResultStatusTO resultStatusTO;

        switch ( resultStatusBO ) {
            case SUCCESS: resultStatusTO = ResultStatusTO.SUCCESS;
            break;
            case TECHNICAL_FAILURE: resultStatusTO = ResultStatusTO.TECHNICAL_FAILURE;
            break;
            case UNAUTHORIZED_FAILURE: resultStatusTO = ResultStatusTO.UNAUTHORIZED_FAILURE;
            break;
            case LOGICAL_FAILURE: resultStatusTO = ResultStatusTO.LOGICAL_FAILURE;
            break;
            case NOT_SUPPORTED: resultStatusTO = ResultStatusTO.NOT_SUPPORTED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + resultStatusBO );
        }

        return resultStatusTO;
    }

    protected ResultStatusBO resultStatusTOToResultStatusBO(ResultStatusTO resultStatusTO) {
        if ( resultStatusTO == null ) {
            return null;
        }

        ResultStatusBO resultStatusBO;

        switch ( resultStatusTO ) {
            case SUCCESS: resultStatusBO = ResultStatusBO.SUCCESS;
            break;
            case TECHNICAL_FAILURE: resultStatusBO = ResultStatusBO.TECHNICAL_FAILURE;
            break;
            case UNAUTHORIZED_FAILURE: resultStatusBO = ResultStatusBO.UNAUTHORIZED_FAILURE;
            break;
            case LOGICAL_FAILURE: resultStatusBO = ResultStatusBO.LOGICAL_FAILURE;
            break;
            case NOT_SUPPORTED: resultStatusBO = ResultStatusBO.NOT_SUPPORTED;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + resultStatusTO );
        }

        return resultStatusBO;
    }

    protected TransactionStatusTO transactionStatusBOToTransactionStatusTO(TransactionStatusBO transactionStatusBO) {
        if ( transactionStatusBO == null ) {
            return null;
        }

        TransactionStatusTO transactionStatusTO;

        switch ( transactionStatusBO ) {
            case ACCC: transactionStatusTO = TransactionStatusTO.ACCC;
            break;
            case ACCP: transactionStatusTO = TransactionStatusTO.ACCP;
            break;
            case ACSC: transactionStatusTO = TransactionStatusTO.ACSC;
            break;
            case ACSP: transactionStatusTO = TransactionStatusTO.ACSP;
            break;
            case ACTC: transactionStatusTO = TransactionStatusTO.ACTC;
            break;
            case ACWC: transactionStatusTO = TransactionStatusTO.ACWC;
            break;
            case ACWP: transactionStatusTO = TransactionStatusTO.ACWP;
            break;
            case RCVD: transactionStatusTO = TransactionStatusTO.RCVD;
            break;
            case PDNG: transactionStatusTO = TransactionStatusTO.PDNG;
            break;
            case RJCT: transactionStatusTO = TransactionStatusTO.RJCT;
            break;
            case CANC: transactionStatusTO = TransactionStatusTO.CANC;
            break;
            case ACFC: transactionStatusTO = TransactionStatusTO.ACFC;
            break;
            case PATC: transactionStatusTO = TransactionStatusTO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatusBO );
        }

        return transactionStatusTO;
    }

    protected AccountReferenceTO accountReferenceBOToAccountReferenceTO(AccountReferenceBO accountReferenceBO) {
        if ( accountReferenceBO == null ) {
            return null;
        }

        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();

        accountReferenceTO.setIban( accountReferenceBO.getIban() );
        accountReferenceTO.setBban( accountReferenceBO.getBban() );
        accountReferenceTO.setPan( accountReferenceBO.getPan() );
        accountReferenceTO.setMaskedPan( accountReferenceBO.getMaskedPan() );
        accountReferenceTO.setMsisdn( accountReferenceBO.getMsisdn() );
        accountReferenceTO.setCurrency( accountReferenceBO.getCurrency() );

        return accountReferenceTO;
    }

    protected AmountTO amountBOToAmountTO(AmountBO amountBO) {
        if ( amountBO == null ) {
            return null;
        }

        AmountTO amountTO = new AmountTO();

        amountTO.setCurrency( amountBO.getCurrency() );
        amountTO.setAmount( amountBO.getAmount() );

        return amountTO;
    }

    protected AddressTO addressBOToAddressTO(AddressBO addressBO) {
        if ( addressBO == null ) {
            return null;
        }

        AddressTO addressTO = new AddressTO();

        addressTO.setStreet( addressBO.getStreet() );
        addressTO.setBuildingNumber( addressBO.getBuildingNumber() );
        addressTO.setCity( addressBO.getCity() );
        addressTO.setPostalCode( addressBO.getPostalCode() );
        addressTO.setCountry( addressBO.getCountry() );

        return addressTO;
    }

    protected FrequencyCodeTO frequencyCodeBOToFrequencyCodeTO(FrequencyCodeBO frequencyCodeBO) {
        if ( frequencyCodeBO == null ) {
            return null;
        }

        FrequencyCodeTO frequencyCodeTO;

        switch ( frequencyCodeBO ) {
            case DAILY: frequencyCodeTO = FrequencyCodeTO.DAILY;
            break;
            case WEEKLY: frequencyCodeTO = FrequencyCodeTO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeTO = FrequencyCodeTO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeTO = FrequencyCodeTO.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCodeTO = FrequencyCodeTO.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCodeBO );
        }

        return frequencyCodeTO;
    }

    protected FrequencyCodeBO frequencyCodeTOToFrequencyCodeBO(FrequencyCodeTO frequencyCodeTO) {
        if ( frequencyCodeTO == null ) {
            return null;
        }

        FrequencyCodeBO frequencyCodeBO;

        switch ( frequencyCodeTO ) {
            case DAILY: frequencyCodeBO = FrequencyCodeBO.DAILY;
            break;
            case WEEKLY: frequencyCodeBO = FrequencyCodeBO.WEEKLY;
            break;
            case EVERYTWOWEEKS: frequencyCodeBO = FrequencyCodeBO.EVERYTWOWEEKS;
            break;
            case MONTHLY: frequencyCodeBO = FrequencyCodeBO.MONTHLY;
            break;
            case EVERYTWOMONTHS: frequencyCodeBO = FrequencyCodeBO.EVERYTWOMONTHS;
            break;
            case QUARTERLY: frequencyCodeBO = FrequencyCodeBO.QUARTERLY;
            break;
            case SEMIANNUAL: frequencyCodeBO = FrequencyCodeBO.SEMIANNUAL;
            break;
            case ANNUAL: frequencyCodeBO = FrequencyCodeBO.ANNUAL;
            break;
            case MONTHLYVARIABLE: frequencyCodeBO = FrequencyCodeBO.MONTHLYVARIABLE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + frequencyCodeTO );
        }

        return frequencyCodeBO;
    }

    protected AccountReferenceBO accountReferenceTOToAccountReferenceBO(AccountReferenceTO accountReferenceTO) {
        if ( accountReferenceTO == null ) {
            return null;
        }

        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();

        accountReferenceBO.setIban( accountReferenceTO.getIban() );
        accountReferenceBO.setBban( accountReferenceTO.getBban() );
        accountReferenceBO.setPan( accountReferenceTO.getPan() );
        accountReferenceBO.setMaskedPan( accountReferenceTO.getMaskedPan() );
        accountReferenceBO.setMsisdn( accountReferenceTO.getMsisdn() );
        accountReferenceBO.setCurrency( accountReferenceTO.getCurrency() );

        return accountReferenceBO;
    }

    protected TransactionStatusBO transactionStatusTOToTransactionStatusBO(TransactionStatusTO transactionStatusTO) {
        if ( transactionStatusTO == null ) {
            return null;
        }

        TransactionStatusBO transactionStatusBO;

        switch ( transactionStatusTO ) {
            case ACCC: transactionStatusBO = TransactionStatusBO.ACCC;
            break;
            case ACCP: transactionStatusBO = TransactionStatusBO.ACCP;
            break;
            case ACSC: transactionStatusBO = TransactionStatusBO.ACSC;
            break;
            case ACSP: transactionStatusBO = TransactionStatusBO.ACSP;
            break;
            case ACTC: transactionStatusBO = TransactionStatusBO.ACTC;
            break;
            case ACWC: transactionStatusBO = TransactionStatusBO.ACWC;
            break;
            case ACWP: transactionStatusBO = TransactionStatusBO.ACWP;
            break;
            case RCVD: transactionStatusBO = TransactionStatusBO.RCVD;
            break;
            case PDNG: transactionStatusBO = TransactionStatusBO.PDNG;
            break;
            case RJCT: transactionStatusBO = TransactionStatusBO.RJCT;
            break;
            case CANC: transactionStatusBO = TransactionStatusBO.CANC;
            break;
            case ACFC: transactionStatusBO = TransactionStatusBO.ACFC;
            break;
            case PATC: transactionStatusBO = TransactionStatusBO.PATC;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + transactionStatusTO );
        }

        return transactionStatusBO;
    }

    protected AmountBO amountTOToAmountBO(AmountTO amountTO) {
        if ( amountTO == null ) {
            return null;
        }

        AmountBO amountBO = new AmountBO();

        amountBO.setCurrency( amountTO.getCurrency() );
        amountBO.setAmount( amountTO.getAmount() );

        return amountBO;
    }

    protected AddressBO addressTOToAddressBO(AddressTO addressTO) {
        if ( addressTO == null ) {
            return null;
        }

        AddressBO addressBO = new AddressBO();

        addressBO.setStreet( addressTO.getStreet() );
        addressBO.setBuildingNumber( addressTO.getBuildingNumber() );
        addressBO.setCity( addressTO.getCity() );
        addressBO.setPostalCode( addressTO.getPostalCode() );
        addressBO.setCountry( addressTO.getCountry() );

        return addressBO;
    }

    protected PurposeCodeBO purposeCodeTOToPurposeCodeBO(PurposeCodeTO purposeCodeTO) {
        if ( purposeCodeTO == null ) {
            return null;
        }

        PurposeCodeBO purposeCodeBO;

        switch ( purposeCodeTO ) {
            case BKDF: purposeCodeBO = PurposeCodeBO.BKDF;
            break;
            case BKFE: purposeCodeBO = PurposeCodeBO.BKFE;
            break;
            case BKFM: purposeCodeBO = PurposeCodeBO.BKFM;
            break;
            case BKIP: purposeCodeBO = PurposeCodeBO.BKIP;
            break;
            case BKPP: purposeCodeBO = PurposeCodeBO.BKPP;
            break;
            case CBLK: purposeCodeBO = PurposeCodeBO.CBLK;
            break;
            case CDCB: purposeCodeBO = PurposeCodeBO.CDCB;
            break;
            case CDCD: purposeCodeBO = PurposeCodeBO.CDCD;
            break;
            case CDCS: purposeCodeBO = PurposeCodeBO.CDCS;
            break;
            case CDDP: purposeCodeBO = PurposeCodeBO.CDDP;
            break;
            case CDOC: purposeCodeBO = PurposeCodeBO.CDOC;
            break;
            case CDQC: purposeCodeBO = PurposeCodeBO.CDQC;
            break;
            case ETUP: purposeCodeBO = PurposeCodeBO.ETUP;
            break;
            case FCOL: purposeCodeBO = PurposeCodeBO.FCOL;
            break;
            case MTUP: purposeCodeBO = PurposeCodeBO.MTUP;
            break;
            case ACCT: purposeCodeBO = PurposeCodeBO.ACCT;
            break;
            case CASH: purposeCodeBO = PurposeCodeBO.CASH;
            break;
            case COLL: purposeCodeBO = PurposeCodeBO.COLL;
            break;
            case CSDB: purposeCodeBO = PurposeCodeBO.CSDB;
            break;
            case DEPT: purposeCodeBO = PurposeCodeBO.DEPT;
            break;
            case INTC: purposeCodeBO = PurposeCodeBO.INTC;
            break;
            case LIMA: purposeCodeBO = PurposeCodeBO.LIMA;
            break;
            case NETT: purposeCodeBO = PurposeCodeBO.NETT;
            break;
            case BFWD: purposeCodeBO = PurposeCodeBO.BFWD;
            break;
            case CCIR: purposeCodeBO = PurposeCodeBO.CCIR;
            break;
            case CCPC: purposeCodeBO = PurposeCodeBO.CCPC;
            break;
            case CCPM: purposeCodeBO = PurposeCodeBO.CCPM;
            break;
            case CCSM: purposeCodeBO = PurposeCodeBO.CCSM;
            break;
            case CRDS: purposeCodeBO = PurposeCodeBO.CRDS;
            break;
            case CRPR: purposeCodeBO = PurposeCodeBO.CRPR;
            break;
            case CRSP: purposeCodeBO = PurposeCodeBO.CRSP;
            break;
            case CRTL: purposeCodeBO = PurposeCodeBO.CRTL;
            break;
            case EQPT: purposeCodeBO = PurposeCodeBO.EQPT;
            break;
            case EQUS: purposeCodeBO = PurposeCodeBO.EQUS;
            break;
            case EXPT: purposeCodeBO = PurposeCodeBO.EXPT;
            break;
            case EXTD: purposeCodeBO = PurposeCodeBO.EXTD;
            break;
            case FIXI: purposeCodeBO = PurposeCodeBO.FIXI;
            break;
            case FWBC: purposeCodeBO = PurposeCodeBO.FWBC;
            break;
            case FWCC: purposeCodeBO = PurposeCodeBO.FWCC;
            break;
            case FWSB: purposeCodeBO = PurposeCodeBO.FWSB;
            break;
            case FWSC: purposeCodeBO = PurposeCodeBO.FWSC;
            break;
            case MARG: purposeCodeBO = PurposeCodeBO.MARG;
            break;
            case MBSB: purposeCodeBO = PurposeCodeBO.MBSB;
            break;
            case MBSC: purposeCodeBO = PurposeCodeBO.MBSC;
            break;
            case MGCC: purposeCodeBO = PurposeCodeBO.MGCC;
            break;
            case MGSC: purposeCodeBO = PurposeCodeBO.MGSC;
            break;
            case OCCC: purposeCodeBO = PurposeCodeBO.OCCC;
            break;
            case OPBC: purposeCodeBO = PurposeCodeBO.OPBC;
            break;
            case OPCC: purposeCodeBO = PurposeCodeBO.OPCC;
            break;
            case OPSB: purposeCodeBO = PurposeCodeBO.OPSB;
            break;
            case OPSC: purposeCodeBO = PurposeCodeBO.OPSC;
            break;
            case OPTN: purposeCodeBO = PurposeCodeBO.OPTN;
            break;
            case OTCD: purposeCodeBO = PurposeCodeBO.OTCD;
            break;
            case REPO: purposeCodeBO = PurposeCodeBO.REPO;
            break;
            case RPBC: purposeCodeBO = PurposeCodeBO.RPBC;
            break;
            case RPCC: purposeCodeBO = PurposeCodeBO.RPCC;
            break;
            case RPSB: purposeCodeBO = PurposeCodeBO.RPSB;
            break;
            case RPSC: purposeCodeBO = PurposeCodeBO.RPSC;
            break;
            case RVPO: purposeCodeBO = PurposeCodeBO.RVPO;
            break;
            case SBSC: purposeCodeBO = PurposeCodeBO.SBSC;
            break;
            case SCIE: purposeCodeBO = PurposeCodeBO.SCIE;
            break;
            case SCIR: purposeCodeBO = PurposeCodeBO.SCIR;
            break;
            case SCRP: purposeCodeBO = PurposeCodeBO.SCRP;
            break;
            case SHBC: purposeCodeBO = PurposeCodeBO.SHBC;
            break;
            case SHCC: purposeCodeBO = PurposeCodeBO.SHCC;
            break;
            case SHSL: purposeCodeBO = PurposeCodeBO.SHSL;
            break;
            case SLEB: purposeCodeBO = PurposeCodeBO.SLEB;
            break;
            case SLOA: purposeCodeBO = PurposeCodeBO.SLOA;
            break;
            case SWBC: purposeCodeBO = PurposeCodeBO.SWBC;
            break;
            case SWCC: purposeCodeBO = PurposeCodeBO.SWCC;
            break;
            case SWPT: purposeCodeBO = PurposeCodeBO.SWPT;
            break;
            case SWSB: purposeCodeBO = PurposeCodeBO.SWSB;
            break;
            case SWSC: purposeCodeBO = PurposeCodeBO.SWSC;
            break;
            case TBAS: purposeCodeBO = PurposeCodeBO.TBAS;
            break;
            case TBBC: purposeCodeBO = PurposeCodeBO.TBBC;
            break;
            case TBCC: purposeCodeBO = PurposeCodeBO.TBCC;
            break;
            case TRCP: purposeCodeBO = PurposeCodeBO.TRCP;
            break;
            case AGRT: purposeCodeBO = PurposeCodeBO.AGRT;
            break;
            case AREN: purposeCodeBO = PurposeCodeBO.AREN;
            break;
            case BEXP: purposeCodeBO = PurposeCodeBO.BEXP;
            break;
            case BOCE: purposeCodeBO = PurposeCodeBO.BOCE;
            break;
            case COMC: purposeCodeBO = PurposeCodeBO.COMC;
            break;
            case CPYR: purposeCodeBO = PurposeCodeBO.CPYR;
            break;
            case GDDS: purposeCodeBO = PurposeCodeBO.GDDS;
            break;
            case GDSV: purposeCodeBO = PurposeCodeBO.GDSV;
            break;
            case GSCB: purposeCodeBO = PurposeCodeBO.GSCB;
            break;
            case LICF: purposeCodeBO = PurposeCodeBO.LICF;
            break;
            case MP2B: purposeCodeBO = PurposeCodeBO.MP2B;
            break;
            case POPE: purposeCodeBO = PurposeCodeBO.POPE;
            break;
            case ROYA: purposeCodeBO = PurposeCodeBO.ROYA;
            break;
            case SCVE: purposeCodeBO = PurposeCodeBO.SCVE;
            break;
            case SERV: purposeCodeBO = PurposeCodeBO.SERV;
            break;
            case SUBS: purposeCodeBO = PurposeCodeBO.SUBS;
            break;
            case SUPP: purposeCodeBO = PurposeCodeBO.SUPP;
            break;
            case TRAD: purposeCodeBO = PurposeCodeBO.TRAD;
            break;
            case CHAR: purposeCodeBO = PurposeCodeBO.CHAR;
            break;
            case COMT: purposeCodeBO = PurposeCodeBO.COMT;
            break;
            case MP2P: purposeCodeBO = PurposeCodeBO.MP2P;
            break;
            case ECPG: purposeCodeBO = PurposeCodeBO.ECPG;
            break;
            case ECPR: purposeCodeBO = PurposeCodeBO.ECPR;
            break;
            case ECPU: purposeCodeBO = PurposeCodeBO.ECPU;
            break;
            case EPAY: purposeCodeBO = PurposeCodeBO.EPAY;
            break;
            case CLPR: purposeCodeBO = PurposeCodeBO.CLPR;
            break;
            case COMP: purposeCodeBO = PurposeCodeBO.COMP;
            break;
            case DBTC: purposeCodeBO = PurposeCodeBO.DBTC;
            break;
            case GOVI: purposeCodeBO = PurposeCodeBO.GOVI;
            break;
            case HLRP: purposeCodeBO = PurposeCodeBO.HLRP;
            break;
            case HLST: purposeCodeBO = PurposeCodeBO.HLST;
            break;
            case INPC: purposeCodeBO = PurposeCodeBO.INPC;
            break;
            case INPR: purposeCodeBO = PurposeCodeBO.INPR;
            break;
            case INSC: purposeCodeBO = PurposeCodeBO.INSC;
            break;
            case INSU: purposeCodeBO = PurposeCodeBO.INSU;
            break;
            case INTE: purposeCodeBO = PurposeCodeBO.INTE;
            break;
            case LBRI: purposeCodeBO = PurposeCodeBO.LBRI;
            break;
            case LIFI: purposeCodeBO = PurposeCodeBO.LIFI;
            break;
            case LOAN: purposeCodeBO = PurposeCodeBO.LOAN;
            break;
            case LOAR: purposeCodeBO = PurposeCodeBO.LOAR;
            break;
            case PENO: purposeCodeBO = PurposeCodeBO.PENO;
            break;
            case PPTI: purposeCodeBO = PurposeCodeBO.PPTI;
            break;
            case RELG: purposeCodeBO = PurposeCodeBO.RELG;
            break;
            case RINP: purposeCodeBO = PurposeCodeBO.RINP;
            break;
            case TRFD: purposeCodeBO = PurposeCodeBO.TRFD;
            break;
            case FORW: purposeCodeBO = PurposeCodeBO.FORW;
            break;
            case FXNT: purposeCodeBO = PurposeCodeBO.FXNT;
            break;
            case ADMG: purposeCodeBO = PurposeCodeBO.ADMG;
            break;
            case ADVA: purposeCodeBO = PurposeCodeBO.ADVA;
            break;
            case BCDM: purposeCodeBO = PurposeCodeBO.BCDM;
            break;
            case BCFG: purposeCodeBO = PurposeCodeBO.BCFG;
            break;
            case BLDM: purposeCodeBO = PurposeCodeBO.BLDM;
            break;
            case BNET: purposeCodeBO = PurposeCodeBO.BNET;
            break;
            case CBFF: purposeCodeBO = PurposeCodeBO.CBFF;
            break;
            case CBFR: purposeCodeBO = PurposeCodeBO.CBFR;
            break;
            case CCRD: purposeCodeBO = PurposeCodeBO.CCRD;
            break;
            case CDBL: purposeCodeBO = PurposeCodeBO.CDBL;
            break;
            case CFEE: purposeCodeBO = PurposeCodeBO.CFEE;
            break;
            case CGDD: purposeCodeBO = PurposeCodeBO.CGDD;
            break;
            case CORT: purposeCodeBO = PurposeCodeBO.CORT;
            break;
            case COST: purposeCodeBO = PurposeCodeBO.COST;
            break;
            case CPKC: purposeCodeBO = PurposeCodeBO.CPKC;
            break;
            case DCRD: purposeCodeBO = PurposeCodeBO.DCRD;
            break;
            case DSMT: purposeCodeBO = PurposeCodeBO.DSMT;
            break;
            case DVPM: purposeCodeBO = PurposeCodeBO.DVPM;
            break;
            case EDUC: purposeCodeBO = PurposeCodeBO.EDUC;
            break;
            case FACT: purposeCodeBO = PurposeCodeBO.FACT;
            break;
            case FAND: purposeCodeBO = PurposeCodeBO.FAND;
            break;
            case FCPM: purposeCodeBO = PurposeCodeBO.FCPM;
            break;
            case FEES: purposeCodeBO = PurposeCodeBO.FEES;
            break;
            case GOVT: purposeCodeBO = PurposeCodeBO.GOVT;
            break;
            case ICCP: purposeCodeBO = PurposeCodeBO.ICCP;
            break;
            case IDCP: purposeCodeBO = PurposeCodeBO.IDCP;
            break;
            case IHRP: purposeCodeBO = PurposeCodeBO.IHRP;
            break;
            case INSM: purposeCodeBO = PurposeCodeBO.INSM;
            break;
            case IVPT: purposeCodeBO = PurposeCodeBO.IVPT;
            break;
            case MCDM: purposeCodeBO = PurposeCodeBO.MCDM;
            break;
            case MCFG: purposeCodeBO = PurposeCodeBO.MCFG;
            break;
            case MSVC: purposeCodeBO = PurposeCodeBO.MSVC;
            break;
            case NOWS: purposeCodeBO = PurposeCodeBO.NOWS;
            break;
            case OCDM: purposeCodeBO = PurposeCodeBO.OCDM;
            break;
            case OCFG: purposeCodeBO = PurposeCodeBO.OCFG;
            break;
            case OFEE: purposeCodeBO = PurposeCodeBO.OFEE;
            break;
            case OTHR: purposeCodeBO = PurposeCodeBO.OTHR;
            break;
            case PADD: purposeCodeBO = PurposeCodeBO.PADD;
            break;
            case PTSP: purposeCodeBO = PurposeCodeBO.PTSP;
            break;
            case RCKE: purposeCodeBO = PurposeCodeBO.RCKE;
            break;
            case RCPT: purposeCodeBO = PurposeCodeBO.RCPT;
            break;
            case REBT: purposeCodeBO = PurposeCodeBO.REBT;
            break;
            case REFU: purposeCodeBO = PurposeCodeBO.REFU;
            break;
            case RENT: purposeCodeBO = PurposeCodeBO.RENT;
            break;
            case REOD: purposeCodeBO = PurposeCodeBO.REOD;
            break;
            case RIMB: purposeCodeBO = PurposeCodeBO.RIMB;
            break;
            case RPNT: purposeCodeBO = PurposeCodeBO.RPNT;
            break;
            case RRBN: purposeCodeBO = PurposeCodeBO.RRBN;
            break;
            case RVPM: purposeCodeBO = PurposeCodeBO.RVPM;
            break;
            case SLPI: purposeCodeBO = PurposeCodeBO.SLPI;
            break;
            case SPLT: purposeCodeBO = PurposeCodeBO.SPLT;
            break;
            case STDY: purposeCodeBO = PurposeCodeBO.STDY;
            break;
            case TBAN: purposeCodeBO = PurposeCodeBO.TBAN;
            break;
            case TBIL: purposeCodeBO = PurposeCodeBO.TBIL;
            break;
            case TCSC: purposeCodeBO = PurposeCodeBO.TCSC;
            break;
            case TELI: purposeCodeBO = PurposeCodeBO.TELI;
            break;
            case TMPG: purposeCodeBO = PurposeCodeBO.TMPG;
            break;
            case TPRI: purposeCodeBO = PurposeCodeBO.TPRI;
            break;
            case TPRP: purposeCodeBO = PurposeCodeBO.TPRP;
            break;
            case TRNC: purposeCodeBO = PurposeCodeBO.TRNC;
            break;
            case TRVC: purposeCodeBO = PurposeCodeBO.TRVC;
            break;
            case WEBI: purposeCodeBO = PurposeCodeBO.WEBI;
            break;
            case ANNI: purposeCodeBO = PurposeCodeBO.ANNI;
            break;
            case CAFI: purposeCodeBO = PurposeCodeBO.CAFI;
            break;
            case CFDI: purposeCodeBO = PurposeCodeBO.CFDI;
            break;
            case CMDT: purposeCodeBO = PurposeCodeBO.CMDT;
            break;
            case DERI: purposeCodeBO = PurposeCodeBO.DERI;
            break;
            case DIVD: purposeCodeBO = PurposeCodeBO.DIVD;
            break;
            case FREX: purposeCodeBO = PurposeCodeBO.FREX;
            break;
            case HEDG: purposeCodeBO = PurposeCodeBO.HEDG;
            break;
            case INVS: purposeCodeBO = PurposeCodeBO.INVS;
            break;
            case PRME: purposeCodeBO = PurposeCodeBO.PRME;
            break;
            case SAVG: purposeCodeBO = PurposeCodeBO.SAVG;
            break;
            case SECU: purposeCodeBO = PurposeCodeBO.SECU;
            break;
            case SEPI: purposeCodeBO = PurposeCodeBO.SEPI;
            break;
            case TREA: purposeCodeBO = PurposeCodeBO.TREA;
            break;
            case UNIT: purposeCodeBO = PurposeCodeBO.UNIT;
            break;
            case FNET: purposeCodeBO = PurposeCodeBO.FNET;
            break;
            case FUTR: purposeCodeBO = PurposeCodeBO.FUTR;
            break;
            case ANTS: purposeCodeBO = PurposeCodeBO.ANTS;
            break;
            case CVCF: purposeCodeBO = PurposeCodeBO.CVCF;
            break;
            case DMEQ: purposeCodeBO = PurposeCodeBO.DMEQ;
            break;
            case DNTS: purposeCodeBO = PurposeCodeBO.DNTS;
            break;
            case HLTC: purposeCodeBO = PurposeCodeBO.HLTC;
            break;
            case HLTI: purposeCodeBO = PurposeCodeBO.HLTI;
            break;
            case HSPC: purposeCodeBO = PurposeCodeBO.HSPC;
            break;
            case ICRF: purposeCodeBO = PurposeCodeBO.ICRF;
            break;
            case LTCF: purposeCodeBO = PurposeCodeBO.LTCF;
            break;
            case MAFC: purposeCodeBO = PurposeCodeBO.MAFC;
            break;
            case MARF: purposeCodeBO = PurposeCodeBO.MARF;
            break;
            case MDCS: purposeCodeBO = PurposeCodeBO.MDCS;
            break;
            case VIEW: purposeCodeBO = PurposeCodeBO.VIEW;
            break;
            case CDEP: purposeCodeBO = PurposeCodeBO.CDEP;
            break;
            case SWFP: purposeCodeBO = PurposeCodeBO.SWFP;
            break;
            case SWPP: purposeCodeBO = PurposeCodeBO.SWPP;
            break;
            case SWRS: purposeCodeBO = PurposeCodeBO.SWRS;
            break;
            case SWUF: purposeCodeBO = PurposeCodeBO.SWUF;
            break;
            case ADCS: purposeCodeBO = PurposeCodeBO.ADCS;
            break;
            case AEMP: purposeCodeBO = PurposeCodeBO.AEMP;
            break;
            case ALLW: purposeCodeBO = PurposeCodeBO.ALLW;
            break;
            case ALMY: purposeCodeBO = PurposeCodeBO.ALMY;
            break;
            case BBSC: purposeCodeBO = PurposeCodeBO.BBSC;
            break;
            case BECH: purposeCodeBO = PurposeCodeBO.BECH;
            break;
            case BENE: purposeCodeBO = PurposeCodeBO.BENE;
            break;
            case BONU: purposeCodeBO = PurposeCodeBO.BONU;
            break;
            case CCHD: purposeCodeBO = PurposeCodeBO.CCHD;
            break;
            case COMM: purposeCodeBO = PurposeCodeBO.COMM;
            break;
            case CSLP: purposeCodeBO = PurposeCodeBO.CSLP;
            break;
            case GFRP: purposeCodeBO = PurposeCodeBO.GFRP;
            break;
            case GVEA: purposeCodeBO = PurposeCodeBO.GVEA;
            break;
            case GVEB: purposeCodeBO = PurposeCodeBO.GVEB;
            break;
            case GVEC: purposeCodeBO = PurposeCodeBO.GVEC;
            break;
            case GVED: purposeCodeBO = PurposeCodeBO.GVED;
            break;
            case GWLT: purposeCodeBO = PurposeCodeBO.GWLT;
            break;
            case HREC: purposeCodeBO = PurposeCodeBO.HREC;
            break;
            case PAYR: purposeCodeBO = PurposeCodeBO.PAYR;
            break;
            case PEFC: purposeCodeBO = PurposeCodeBO.PEFC;
            break;
            case PENS: purposeCodeBO = PurposeCodeBO.PENS;
            break;
            case PRCP: purposeCodeBO = PurposeCodeBO.PRCP;
            break;
            case RHBS: purposeCodeBO = PurposeCodeBO.RHBS;
            break;
            case SALA: purposeCodeBO = PurposeCodeBO.SALA;
            break;
            case SSBE: purposeCodeBO = PurposeCodeBO.SSBE;
            break;
            case LBIN: purposeCodeBO = PurposeCodeBO.LBIN;
            break;
            case LCOL: purposeCodeBO = PurposeCodeBO.LCOL;
            break;
            case LFEE: purposeCodeBO = PurposeCodeBO.LFEE;
            break;
            case LMEQ: purposeCodeBO = PurposeCodeBO.LMEQ;
            break;
            case LMFI: purposeCodeBO = PurposeCodeBO.LMFI;
            break;
            case LMRK: purposeCodeBO = PurposeCodeBO.LMRK;
            break;
            case LREB: purposeCodeBO = PurposeCodeBO.LREB;
            break;
            case LREV: purposeCodeBO = PurposeCodeBO.LREV;
            break;
            case LSFL: purposeCodeBO = PurposeCodeBO.LSFL;
            break;
            case ESTX: purposeCodeBO = PurposeCodeBO.ESTX;
            break;
            case FWLV: purposeCodeBO = PurposeCodeBO.FWLV;
            break;
            case GSTX: purposeCodeBO = PurposeCodeBO.GSTX;
            break;
            case HSTX: purposeCodeBO = PurposeCodeBO.HSTX;
            break;
            case INTX: purposeCodeBO = PurposeCodeBO.INTX;
            break;
            case NITX: purposeCodeBO = PurposeCodeBO.NITX;
            break;
            case PTXP: purposeCodeBO = PurposeCodeBO.PTXP;
            break;
            case RDTX: purposeCodeBO = PurposeCodeBO.RDTX;
            break;
            case TAXS: purposeCodeBO = PurposeCodeBO.TAXS;
            break;
            case VATX: purposeCodeBO = PurposeCodeBO.VATX;
            break;
            case WHLD: purposeCodeBO = PurposeCodeBO.WHLD;
            break;
            case TAXR: purposeCodeBO = PurposeCodeBO.TAXR;
            break;
            case B112: purposeCodeBO = PurposeCodeBO.B112;
            break;
            case BR12: purposeCodeBO = PurposeCodeBO.BR12;
            break;
            case TLRF: purposeCodeBO = PurposeCodeBO.TLRF;
            break;
            case TLRR: purposeCodeBO = PurposeCodeBO.TLRR;
            break;
            case AIRB: purposeCodeBO = PurposeCodeBO.AIRB;
            break;
            case BUSB: purposeCodeBO = PurposeCodeBO.BUSB;
            break;
            case FERB: purposeCodeBO = PurposeCodeBO.FERB;
            break;
            case RLWY: purposeCodeBO = PurposeCodeBO.RLWY;
            break;
            case TRPT: purposeCodeBO = PurposeCodeBO.TRPT;
            break;
            case CBTV: purposeCodeBO = PurposeCodeBO.CBTV;
            break;
            case ELEC: purposeCodeBO = PurposeCodeBO.ELEC;
            break;
            case ENRG: purposeCodeBO = PurposeCodeBO.ENRG;
            break;
            case GASB: purposeCodeBO = PurposeCodeBO.GASB;
            break;
            case NWCH: purposeCodeBO = PurposeCodeBO.NWCH;
            break;
            case NWCM: purposeCodeBO = PurposeCodeBO.NWCM;
            break;
            case OTLC: purposeCodeBO = PurposeCodeBO.OTLC;
            break;
            case PHON: purposeCodeBO = PurposeCodeBO.PHON;
            break;
            case UBIL: purposeCodeBO = PurposeCodeBO.UBIL;
            break;
            case WTER: purposeCodeBO = PurposeCodeBO.WTER;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + purposeCodeTO );
        }

        return purposeCodeBO;
    }

    protected RemittanceInformationStructuredBO remittanceInformationStructuredTOToRemittanceInformationStructuredBO(RemittanceInformationStructuredTO remittanceInformationStructuredTO) {
        if ( remittanceInformationStructuredTO == null ) {
            return null;
        }

        RemittanceInformationStructuredBO remittanceInformationStructuredBO = new RemittanceInformationStructuredBO();

        remittanceInformationStructuredBO.setReference( remittanceInformationStructuredTO.getReference() );
        remittanceInformationStructuredBO.setReferenceType( remittanceInformationStructuredTO.getReferenceType() );
        remittanceInformationStructuredBO.setReferenceIssuer( remittanceInformationStructuredTO.getReferenceIssuer() );

        return remittanceInformationStructuredBO;
    }

    protected PaymentTargetBO paymentTargetTOToPaymentTargetBO(PaymentTargetTO paymentTargetTO) {
        if ( paymentTargetTO == null ) {
            return null;
        }

        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();

        paymentTargetBO.setPaymentId( paymentTargetTO.getPaymentId() );
        paymentTargetBO.setEndToEndIdentification( paymentTargetTO.getEndToEndIdentification() );
        paymentTargetBO.setInstructedAmount( amountTOToAmountBO( paymentTargetTO.getInstructedAmount() ) );
        paymentTargetBO.setCreditorAccount( accountReferenceTOToAccountReferenceBO( paymentTargetTO.getCreditorAccount() ) );
        paymentTargetBO.setCreditorAgent( paymentTargetTO.getCreditorAgent() );
        paymentTargetBO.setCreditorName( paymentTargetTO.getCreditorName() );
        paymentTargetBO.setCreditorAddress( addressTOToAddressBO( paymentTargetTO.getCreditorAddress() ) );
        paymentTargetBO.setPurposeCode( purposeCodeTOToPurposeCodeBO( paymentTargetTO.getPurposeCode() ) );
        paymentTargetBO.setRemittanceInformationUnstructured( paymentTargetTO.getRemittanceInformationUnstructured() );
        paymentTargetBO.setRemittanceInformationStructured( remittanceInformationStructuredTOToRemittanceInformationStructuredBO( paymentTargetTO.getRemittanceInformationStructured() ) );

        return paymentTargetBO;
    }

    protected List<PaymentTargetBO> paymentTargetTOListToPaymentTargetBOList(List<PaymentTargetTO> list) {
        if ( list == null ) {
            return null;
        }

        List<PaymentTargetBO> list1 = new ArrayList<PaymentTargetBO>( list.size() );
        for ( PaymentTargetTO paymentTargetTO : list ) {
            list1.add( paymentTargetTOToPaymentTargetBO( paymentTargetTO ) );
        }

        return list1;
    }

    protected ExchangeRateTO exchangeRateBOToExchangeRateTO(ExchangeRateBO exchangeRateBO) {
        if ( exchangeRateBO == null ) {
            return null;
        }

        ExchangeRateTO exchangeRateTO = new ExchangeRateTO();

        exchangeRateTO.setCurrencyFrom( exchangeRateBO.getCurrencyFrom() );
        exchangeRateTO.setRateFrom( exchangeRateBO.getRateFrom() );
        exchangeRateTO.setRateTo( exchangeRateBO.getRateTo() );
        exchangeRateTO.setRateDate( exchangeRateBO.getRateDate() );
        exchangeRateTO.setRateContract( exchangeRateBO.getRateContract() );

        return exchangeRateTO;
    }

    protected List<ExchangeRateTO> exchangeRateBOListToExchangeRateTOList(List<ExchangeRateBO> list) {
        if ( list == null ) {
            return null;
        }

        List<ExchangeRateTO> list1 = new ArrayList<ExchangeRateTO>( list.size() );
        for ( ExchangeRateBO exchangeRateBO : list ) {
            list1.add( exchangeRateBOToExchangeRateTO( exchangeRateBO ) );
        }

        return list1;
    }

    protected RemittanceInformationStructuredTO remittanceInformationStructuredBOToRemittanceInformationStructuredTO(RemittanceInformationStructuredBO remittanceInformationStructuredBO) {
        if ( remittanceInformationStructuredBO == null ) {
            return null;
        }

        RemittanceInformationStructuredTO remittanceInformationStructuredTO = new RemittanceInformationStructuredTO();

        remittanceInformationStructuredTO.setReference( remittanceInformationStructuredBO.getReference() );
        remittanceInformationStructuredTO.setReferenceType( remittanceInformationStructuredBO.getReferenceType() );
        remittanceInformationStructuredTO.setReferenceIssuer( remittanceInformationStructuredBO.getReferenceIssuer() );

        return remittanceInformationStructuredTO;
    }

    protected ExchangeRateBO exchangeRateTOToExchangeRateBO(ExchangeRateTO exchangeRateTO) {
        if ( exchangeRateTO == null ) {
            return null;
        }

        ExchangeRateBO exchangeRateBO = new ExchangeRateBO();

        exchangeRateBO.setCurrencyFrom( exchangeRateTO.getCurrencyFrom() );
        exchangeRateBO.setRateFrom( exchangeRateTO.getRateFrom() );
        exchangeRateBO.setRateTo( exchangeRateTO.getRateTo() );
        exchangeRateBO.setRateDate( exchangeRateTO.getRateDate() );
        exchangeRateBO.setRateContract( exchangeRateTO.getRateContract() );

        return exchangeRateBO;
    }

    protected List<ExchangeRateBO> exchangeRateTOListToExchangeRateBOList(List<ExchangeRateTO> list) {
        if ( list == null ) {
            return null;
        }

        List<ExchangeRateBO> list1 = new ArrayList<ExchangeRateBO>( list.size() );
        for ( ExchangeRateTO exchangeRateTO : list ) {
            list1.add( exchangeRateTOToExchangeRateBO( exchangeRateTO ) );
        }

        return list1;
    }
}
