/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.upload;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Currency;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.springframework.stereotype.Service;

@Service
public class PaymentGenerationService {
    private static final String TEST_CREDITOR_IBAN = "DE68370400440000000000";
    private static final Random random = new Random();

    public Map<PaymentTypeTO, Object> generatePayments(AccountBalanceTO balance, String branch) {
        EnumMap<PaymentTypeTO, Object> map = new EnumMap<PaymentTypeTO, Object>(PaymentTypeTO.class);
        map.put(PaymentTypeTO.SINGLE, (Object)this.generateSinglePayment(balance, branch));
        map.put(PaymentTypeTO.BULK, (Object)this.generateBulkPayment(balance, branch));
        return map;
    }

    private BulkPaymentTO generateBulkPayment(AccountBalanceTO balance, String branch) {
        return new BulkPaymentTO(null, Boolean.valueOf(false), this.generateReference(balance.getIban(), balance.getAmount().getCurrency()), LocalDate.now(), TransactionStatusTO.RCVD, Arrays.asList(this.generateSinglePayment(balance, branch), this.generateSinglePayment(balance, branch)), PaymentProductTO.INSTANT_SEPA);
    }

    private SinglePaymentTO generateSinglePayment(AccountBalanceTO balance, String branch) {
        String endToEndId = this.generateEndToEndId(branch);
        return new SinglePaymentTO(null, endToEndId, this.generateReference(balance.getIban(), balance.getAmount().getCurrency()), this.generateAmount(balance), this.generateReference(TEST_CREDITOR_IBAN, balance.getAmount().getCurrency()), "adorsys GmbH & CO KG", "adorsys GmbH & CO KG", this.getTestCreditorAddress(), null, TransactionStatusTO.RCVD, PaymentProductTO.INSTANT_SEPA, LocalDate.now(), null);
    }

    private AmountTO generateAmount(AccountBalanceTO balance) {
        AmountTO amount = new AmountTO();
        amount.setCurrency(balance.getAmount().getCurrency());
        int balanceAmount = balance.getAmount().getAmount().intValue();
        int maxAmount = balanceAmount * 100 / 3;
        int rand = random.nextInt(maxAmount - 1) + 1;
        amount.setAmount(BigDecimal.valueOf((double)rand / 100.0));
        return amount;
    }

    private AddressTO getTestCreditorAddress() {
        return new AddressTO("F\u00fcrther Str.", "246a", "N\u00fcrnberg", "90429", "Germany");
    }

    private AccountReferenceTO generateReference(String iban, Currency currency) {
        AccountReferenceTO reference = new AccountReferenceTO();
        reference.setIban(iban);
        reference.setCurrency(currency);
        return reference;
    }

    private String generateEndToEndId(String branchId) {
        return String.join((CharSequence)"_", branchId, String.valueOf(LocalDateTime.now().toEpochSecond(ZoneOffset.UTC)) + random.nextInt(9), String.valueOf(ThreadLocalRandom.current().nextLong(10000L, 99999L)));
    }
}

