/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentCoreDataTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PainPaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.converter.ScaResponseResolver;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCancelPolicy;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCoreDataPolicy;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.util.Ids;
import de.adorsys.ledgers.util.exception.DepositModuleException;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewarePaymentServiceImpl
implements MiddlewarePaymentService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewarePaymentServiceImpl.class);
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final DepositAccountService accountService;
    private final PaymentConverter paymentConverter;
    private final BearerTokenMapper bearerTokenMapper;
    private final SCAUtils scaUtils;
    private final PaymentCoreDataPolicy coreDataPolicy;
    private final AccessService accessService;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    private final PainPaymentConverter painPaymentConverter;
    private final ScaResponseResolver scaResponseResolver;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public TransactionStatusTO getPaymentStatusById(String paymentId) {
        TransactionStatusBO paymentStatus = this.paymentService.getPaymentStatusById(paymentId);
        return TransactionStatusTO.valueOf((String)paymentStatus.name());
    }

    public SCAPaymentResponseTO initiatePaymentCancellation(ScaInfoTO scaInfoTO, String paymentId) {
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO paymentBO = this.loadPayment(paymentId);
        paymentBO.setRequestedExecutionTime(LocalTime.now().plusMinutes(10L));
        PaymentCancelPolicy.onCancel(paymentId, paymentBO.getTransactionStatus());
        return this.prepareScaAndResolveResponse(scaInfoTO, paymentBO, userBO, OpTypeBO.CANCEL_PAYMENT);
    }

    public String initiatePainPayment(ScaInfoTO scaInfoTO, String payment, PaymentTypeTO paymentType) {
        return this.painPaymentConverter.toPayload(this.checkPaymentAndPrepareResponse(scaInfoTO, this.painPaymentConverter.toPaymentBO(payment, paymentType)));
    }

    public SCAPaymentResponseTO initiatePayment(ScaInfoTO scaInfoTO, Object payment, PaymentTypeTO paymentType) {
        return this.checkPaymentAndPrepareResponse(scaInfoTO, this.paymentConverter.toPaymentBO(payment, paymentType.getPaymentClass()));
    }

    private SCAPaymentResponseTO checkPaymentAndPrepareResponse(ScaInfoTO scaInfoTO, PaymentBO paymentBO) {
        if (!paymentBO.isValidAmount()) {
            throw MiddlewareModuleException.builder().devMsg("Payment validation failed! Instructed amount is invalid.").errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).build();
        }
        DepositAccountBO debtorAccount = this.checkAccountStatusAndCurrencyMatch(paymentBO.getDebtorAccount());
        try {
            paymentBO.getTargets().forEach(t -> {
                DepositAccountBO acc = this.checkAccountStatusAndCurrencyMatch(t.getCreditorAccount());
                t.setCreditorAccount(acc.getReference());
            });
        }
        catch (MiddlewareModuleException e) {
            if (EnumSet.of(MiddlewareErrorCode.ACCOUNT_DISABLED, MiddlewareErrorCode.CURRENCY_MISMATCH).contains(e.getErrorCode())) {
                log.error(e.getDevMsg());
                throw e;
            }
        }
        catch (DepositModuleException e) {
            log.info("Creditor account is located in another ASPSP");
        }
        paymentBO.getDebtorAccount().setCurrency(debtorAccount.getCurrency());
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        TransactionStatusBO status = this.scaUtils.hasSCA(user) ? TransactionStatusBO.ACCP : TransactionStatusBO.ACTC;
        return this.prepareScaAndResolveResponse(scaInfoTO, this.persist(paymentBO, status), user, OpTypeBO.PAYMENT);
    }

    private SCAPaymentResponseTO prepareScaAndResolveResponse(ScaInfoTO scaInfoTO, PaymentBO payment, UserBO user, OpTypeBO opType) {
        boolean isScaRequired = this.scaRequired(user);
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        String authorisationId = this.scaUtils.authorisationId(scaInfoTO);
        String psuMessage = this.resolvePsuMessage(isScaRequired, payment, opType);
        BearerTokenTO token = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        ScaStatusTO scaStatus = this.scaResponseResolver.resolveScaStatus(scaInfoTO.getTokenUsage(), isScaRequired);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), payment.getDebtorAccount().getIban());
        this.scaResponseResolver.updateScaResponseFields(user, response, authorisationId, psuMessage, token, scaStatus, scaWeight);
        if (!isScaRequired) {
            this.executeExemptedInitiationOperation(payment, user, opType);
        } else {
            this.scaResponseResolver.prepareScaAndUpdateResponse(payment.getPaymentId(), response, authorisationId, psuMessage, scaWeight, user, opType);
        }
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    private void executeExemptedInitiationOperation(PaymentBO payment, UserBO user, OpTypeBO opType) {
        TransactionStatusBO transactionStatus = payment.getTransactionStatus();
        if (opType == OpTypeBO.PAYMENT) {
            transactionStatus = this.paymentService.executePayment(payment.getPaymentId(), user.getLogin());
        } else if (opType == OpTypeBO.CANCEL_PAYMENT) {
            transactionStatus = this.paymentService.cancelPayment(payment.getPaymentId());
        }
        payment.setTransactionStatus(transactionStatus);
    }

    private String resolvePsuMessage(boolean isScaRequired, PaymentBO payment, OpTypeBO opType) {
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        return isScaRequired ? paymentKeyData.template() : paymentKeyData.exemptedTemplate();
    }

    private PaymentBO persist(PaymentBO paymentBO, TransactionStatusBO status) {
        if (paymentBO.getPaymentId() == null) {
            paymentBO.setPaymentId(Ids.id());
        }
        return this.paymentService.initiatePayment(paymentBO, status);
    }

    public Object getPaymentById(String paymentId) {
        PaymentBO paymentResult = this.paymentService.getPaymentById(paymentId);
        return this.paymentConverter.toPaymentTO(paymentResult);
    }

    public String iban(String paymentId) {
        return this.paymentService.readIbanByPaymentId(paymentId);
    }

    public SCAPaymentResponseTO authorizePayment(ScaInfoTO scaInfoTO, String paymentId) {
        return this.authorizeOperation(scaInfoTO, paymentId, null, OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO authorizeCancelPayment(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        return this.authorizeOperation(scaInfoTO, paymentId, cancellationId, OpTypeBO.CANCEL_PAYMENT);
    }

    private SCAPaymentResponseTO authorizeOperation(ScaInfoTO scaInfoTO, String paymentId, String cancellationId, OpTypeBO opType) {
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        String authorisationId = opType == OpTypeBO.PAYMENT ? scaInfoTO.getAuthorisationId() : cancellationId;
        this.validateAuthCode(scaInfoTO.getUserId(), payment, authorisationId, scaInfoTO.getAuthCode(), paymentKeyData.template());
        if (this.scaOperationService.authenticationCompleted(paymentId, opType)) {
            if (opType == OpTypeBO.PAYMENT) {
                this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.ACTC);
                payment.setTransactionStatus(this.paymentService.executePayment(paymentId, scaInfoTO.getUserLogin()));
            } else {
                payment.setTransactionStatus(this.paymentService.cancelPayment(paymentId));
            }
        } else if (this.multilevelScaEnable) {
            payment.setTransactionStatus(this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.PATC));
        }
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        this.scaResponseResolver.updateScaResponseFields(userBO, response, authorisationId, paymentKeyData.template(), bearerToken, ScaStatusTO.FINALISED, scaWeight);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    public SCAPaymentResponseTO selectSCAMethodForPayment(ScaInfoTO scaInfoTO, String paymentId) {
        return this.selectSCAMethod(scaInfoTO, paymentId, null, OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO selectSCAMethodForCancelPayment(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        return this.selectSCAMethod(scaInfoTO, paymentId, cancellationId, OpTypeBO.CANCEL_PAYMENT);
    }

    private SCAPaymentResponseTO selectSCAMethod(ScaInfoTO scaInfoTO, String paymentId, String cancellationId, OpTypeBO opType) {
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO payment = this.loadPayment(paymentId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        String template = paymentKeyData.template();
        String authorisationId = opType == OpTypeBO.PAYMENT ? scaInfoTO.getAuthorisationId() : cancellationId;
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        this.scaResponseResolver.generateCodeAndUpdateResponse(paymentId, response, authorisationId, template, scaWeight, userBO, opType, scaInfoTO.getScaMethodId());
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        this.scaResponseResolver.updateScaResponseFields(userBO, response, authorisationId, template, bearerToken, ScaStatusTO.SCAMETHODSELECTED, scaWeight);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    public SCAPaymentResponseTO loadSCAForPaymentData(ScaInfoTO scaInfoTO, String paymentId) {
        return this.loadSca(scaInfoTO, paymentId, scaInfoTO.getAuthorisationId(), OpTypeBO.PAYMENT);
    }

    public SCAPaymentResponseTO loadSCAForCancelPaymentData(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        return this.loadSca(scaInfoTO, paymentId, cancellationId, OpTypeBO.CANCEL_PAYMENT);
    }

    private SCAPaymentResponseTO loadSca(ScaInfoTO scaInfoTO, String paymentId, String operationId, OpTypeBO opType) {
        SCAOperationBO scaOperation = this.scaOperationService.loadAuthCode(operationId);
        UserBO user = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(opType, payment);
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment.getDebtorAccount().getIban());
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), payment.getDebtorAccount().getIban());
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        this.scaResponseResolver.updateScaResponseFields(user, response, operationId, paymentKeyData.template(), bearerToken, ScaStatusTO.valueOf((String)scaOperation.getScaStatus().name()), scaWeight);
        this.scaResponseResolver.updateScaUserDataInResponse(user, scaOperation, (SCAResponseTO)response);
        return this.scaResponseResolver.updatePaymentRelatedResponseFields(response, payment);
    }

    private BearerTokenTO paymentAccountAccessToken(ScaInfoTO scaInfoTO, String iban) {
        AisConsentBO aisConsent = new AisConsentBO();
        AisAccountAccessInfoBO access = new AisAccountAccessInfoBO();
        aisConsent.setAccess(access);
        List<String> asList = Collections.singletonList(iban);
        access.setAccounts(asList);
        access.setTransactions(asList);
        access.setBalances(asList);
        aisConsent.setFrequencyPerDay(0);
        aisConsent.setRecurringIndicator(true);
        aisConsent.setUserId(scaInfoTO.getUserLogin());
        return this.bearerTokenMapper.toBearerTokenTO(this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), aisConsent));
    }

    private void validateAuthCode(String userId, PaymentBO payment, String authorisationId, String authCode, String template) {
        UserBO userBO = this.scaUtils.userBO(userId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        if (!this.scaOperationService.validateAuthCode(authorisationId, payment.getPaymentId(), template, authCode, scaWeight)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.AUTHENTICATION_FAILURE).devMsg("Wrong auth code").build();
        }
    }

    private PaymentBO loadPayment(String paymentId) {
        return this.paymentService.getPaymentById(paymentId);
    }

    private boolean scaRequired(UserBO user) {
        return this.scaUtils.hasSCA(user);
    }

    private DepositAccountBO checkAccountStatusAndCurrencyMatch(AccountReferenceBO reference) {
        DepositAccountBO account = Optional.ofNullable(reference.getCurrency()).map(c -> this.accountService.getAccountByIbanAndCurrency(reference.getIban(), c)).orElseGet(() -> this.getAccountByIbanErrorIfNotSingle(reference.getIban()));
        if (!account.isEnabled()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_DISABLED).devMsg(String.format("Account with IBAN: %s is %s", reference.getIban(), account.getAccountStatus())).build();
        }
        return account;
    }

    private DepositAccountBO getAccountByIbanErrorIfNotSingle(String iban) {
        List accounts = this.accountService.getAccountsByIbanAndParamCurrency(iban, "");
        if (accounts.size() != 1) {
            String msg = CollectionUtils.isEmpty((Collection)accounts) ? String.format("Account with IBAN: %s Not Found!", iban) : String.format("Initiation of payment for Account with IBAN: %s is impossible as it is a Multi-Currency-Account. %nPlease specify currency for sub-account to proceed.", iban);
            MiddlewareErrorCode errorCode = CollectionUtils.isEmpty((Collection)accounts) ? MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE : MiddlewareErrorCode.CURRENCY_MISMATCH;
            throw MiddlewareModuleException.builder().errorCode(errorCode).devMsg(msg).build();
        }
        return (DepositAccountBO)accounts.iterator().next();
    }

    public MiddlewarePaymentServiceImpl(DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, DepositAccountService accountService, PaymentConverter paymentConverter, BearerTokenMapper bearerTokenMapper, SCAUtils scaUtils, PaymentCoreDataPolicy coreDataPolicy, AccessService accessService, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService, PainPaymentConverter painPaymentConverter, ScaResponseResolver scaResponseResolver) {
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.accountService = accountService;
        this.paymentConverter = paymentConverter;
        this.bearerTokenMapper = bearerTokenMapper;
        this.scaUtils = scaUtils;
        this.coreDataPolicy = coreDataPolicy;
        this.accessService = accessService;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
        this.painPaymentConverter = painPaymentConverter;
        this.scaResponseResolver = scaResponseResolver;
    }
}

