/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JaxbConverter {
    private static final Logger log = LoggerFactory.getLogger(JaxbConverter.class);

    public <T> Optional<String> fromObject(T source) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{source.getClass()});
            Marshaller marshaller = jaxbContext.createMarshaller();
            StringWriter sw = new StringWriter();
            marshaller.marshal(source, (Writer)sw);
            return Optional.ofNullable(sw.toString());
        }
        catch (JAXBException e) {
            log.info("Couldn't convert object to xml: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    public <T> Optional<T> toObject(String xmlPayload, Class<T> targetClass) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{targetClass});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            return Optional.ofNullable(unmarshaller.unmarshal((Reader)new StringReader(xmlPayload)));
        }
        catch (JAXBException e) {
            log.info("Couldn't convert xml to object: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }
}

