/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AccountStatusBO;
import de.adorsys.ledgers.deposit.api.domain.AccountTypeBO;
import de.adorsys.ledgers.deposit.api.domain.AccountUsageBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceBO;
import de.adorsys.ledgers.deposit.api.domain.BalanceTypeBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountStatusTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.BalanceTypeTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.UsageTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class AccountDetailsMapperImpl
extends AccountDetailsMapper {
    @Override
    public AccountDetailsTO toAccountDetailsTO(DepositAccountBO details, List<BalanceBO> balances) {
        if (details == null && balances == null) {
            return null;
        }
        AccountDetailsTO accountDetailsTO = new AccountDetailsTO();
        if (details != null) {
            accountDetailsTO.setId(details.getId());
            accountDetailsTO.setIban(details.getIban());
            accountDetailsTO.setBban(details.getBban());
            accountDetailsTO.setPan(details.getPan());
            accountDetailsTO.setMaskedPan(details.getMaskedPan());
            accountDetailsTO.setMsisdn(details.getMsisdn());
            accountDetailsTO.setCurrency(details.getCurrency());
            accountDetailsTO.setName(details.getName());
            accountDetailsTO.setProduct(details.getProduct());
            accountDetailsTO.setAccountType(this.accountTypeBOToAccountTypeTO(details.getAccountType()));
            accountDetailsTO.setAccountStatus(this.accountStatusBOToAccountStatusTO(details.getAccountStatus()));
            accountDetailsTO.setBic(details.getBic());
            accountDetailsTO.setLinkedAccounts(details.getLinkedAccounts());
            accountDetailsTO.setUsageType(this.accountUsageBOToUsageTypeTO(details.getUsageType()));
            accountDetailsTO.setDetails(details.getDetails());
        }
        if (balances != null) {
            accountDetailsTO.setBalances(this.toAccountBalancesTO(balances));
        }
        return accountDetailsTO;
    }

    @Override
    public DepositAccountBO toDepositAccountBO(AccountDetailsTO details) {
        if (details == null) {
            return null;
        }
        DepositAccountBO depositAccountBO = new DepositAccountBO();
        depositAccountBO.setId(details.getId());
        depositAccountBO.setIban(details.getIban());
        depositAccountBO.setBban(details.getBban());
        depositAccountBO.setPan(details.getPan());
        depositAccountBO.setMaskedPan(details.getMaskedPan());
        depositAccountBO.setMsisdn(details.getMsisdn());
        depositAccountBO.setCurrency(details.getCurrency());
        depositAccountBO.setName(details.getName());
        depositAccountBO.setProduct(details.getProduct());
        depositAccountBO.setAccountType(this.accountTypeTOToAccountTypeBO(details.getAccountType()));
        depositAccountBO.setAccountStatus(this.accountStatusTOToAccountStatusBO(details.getAccountStatus()));
        depositAccountBO.setBic(details.getBic());
        depositAccountBO.setLinkedAccounts(details.getLinkedAccounts());
        depositAccountBO.setUsageType(this.usageTypeTOToAccountUsageBO(details.getUsageType()));
        depositAccountBO.setDetails(details.getDetails());
        return depositAccountBO;
    }

    @Override
    public List<AccountBalanceTO> toAccountBalancesTO(List<BalanceBO> balances) {
        if (balances == null) {
            return null;
        }
        ArrayList<AccountBalanceTO> list = new ArrayList<AccountBalanceTO>(balances.size());
        for (BalanceBO balanceBO : balances) {
            list.add(this.balanceBOToAccountBalanceTO(balanceBO));
        }
        return list;
    }

    @Override
    public FundsConfirmationRequestBO toFundsConfirmationRequestBO(FundsConfirmationRequestTO request) {
        if (request == null) {
            return null;
        }
        FundsConfirmationRequestBO fundsConfirmationRequestBO = new FundsConfirmationRequestBO();
        fundsConfirmationRequestBO.setPsuId(request.getPsuId());
        fundsConfirmationRequestBO.setPsuAccount(this.accountReferenceTOToAccountReferenceBO(request.getPsuAccount()));
        fundsConfirmationRequestBO.setInstructedAmount(this.amountTOToAmountBO(request.getInstructedAmount()));
        fundsConfirmationRequestBO.setCardNumber(request.getCardNumber());
        fundsConfirmationRequestBO.setPayee(request.getPayee());
        return fundsConfirmationRequestBO;
    }

    @Override
    public List<AccountDetailsTO> toAccountDetailsList(List<DepositAccountBO> accountsByIbanAndCurrency) {
        if (accountsByIbanAndCurrency == null) {
            return null;
        }
        ArrayList<AccountDetailsTO> list = new ArrayList<AccountDetailsTO>(accountsByIbanAndCurrency.size());
        for (DepositAccountBO depositAccountBO : accountsByIbanAndCurrency) {
            list.add(this.depositAccountBOToAccountDetailsTO(depositAccountBO));
        }
        return list;
    }

    protected AccountTypeTO accountTypeBOToAccountTypeTO(AccountTypeBO accountTypeBO) {
        AccountTypeTO accountTypeTO;
        if (accountTypeBO == null) {
            return null;
        }
        switch (accountTypeBO) {
            case CACC: {
                accountTypeTO = AccountTypeTO.CACC;
                break;
            }
            case CASH: {
                accountTypeTO = AccountTypeTO.CASH;
                break;
            }
            case CHAR: {
                accountTypeTO = AccountTypeTO.CHAR;
                break;
            }
            case CISH: {
                accountTypeTO = AccountTypeTO.CISH;
                break;
            }
            case COMM: {
                accountTypeTO = AccountTypeTO.COMM;
                break;
            }
            case CPAC: {
                accountTypeTO = AccountTypeTO.CPAC;
                break;
            }
            case LLSV: {
                accountTypeTO = AccountTypeTO.LLSV;
                break;
            }
            case LOAN: {
                accountTypeTO = AccountTypeTO.LOAN;
                break;
            }
            case MGLD: {
                accountTypeTO = AccountTypeTO.MGLD;
                break;
            }
            case MOMA: {
                accountTypeTO = AccountTypeTO.MOMA;
                break;
            }
            case NREX: {
                accountTypeTO = AccountTypeTO.NREX;
                break;
            }
            case ODFT: {
                accountTypeTO = AccountTypeTO.ODFT;
                break;
            }
            case ONDP: {
                accountTypeTO = AccountTypeTO.ONDP;
                break;
            }
            case OTHR: {
                accountTypeTO = AccountTypeTO.OTHR;
                break;
            }
            case SACC: {
                accountTypeTO = AccountTypeTO.SACC;
                break;
            }
            case SLRY: {
                accountTypeTO = AccountTypeTO.SLRY;
                break;
            }
            case SVGS: {
                accountTypeTO = AccountTypeTO.SVGS;
                break;
            }
            case TAXE: {
                accountTypeTO = AccountTypeTO.TAXE;
                break;
            }
            case TRAN: {
                accountTypeTO = AccountTypeTO.TRAN;
                break;
            }
            case TRAS: {
                accountTypeTO = AccountTypeTO.TRAS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountTypeBO);
            }
        }
        return accountTypeTO;
    }

    protected AccountStatusTO accountStatusBOToAccountStatusTO(AccountStatusBO accountStatusBO) {
        AccountStatusTO accountStatusTO;
        if (accountStatusBO == null) {
            return null;
        }
        switch (accountStatusBO) {
            case ENABLED: {
                accountStatusTO = AccountStatusTO.ENABLED;
                break;
            }
            case DELETED: {
                accountStatusTO = AccountStatusTO.DELETED;
                break;
            }
            case BLOCKED: {
                accountStatusTO = AccountStatusTO.BLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountStatusBO);
            }
        }
        return accountStatusTO;
    }

    protected UsageTypeTO accountUsageBOToUsageTypeTO(AccountUsageBO accountUsageBO) {
        UsageTypeTO usageTypeTO;
        if (accountUsageBO == null) {
            return null;
        }
        switch (accountUsageBO) {
            case PRIV: {
                usageTypeTO = UsageTypeTO.PRIV;
                break;
            }
            case ORGA: {
                usageTypeTO = UsageTypeTO.ORGA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountUsageBO);
            }
        }
        return usageTypeTO;
    }

    protected AccountTypeBO accountTypeTOToAccountTypeBO(AccountTypeTO accountTypeTO) {
        AccountTypeBO accountTypeBO;
        if (accountTypeTO == null) {
            return null;
        }
        switch (accountTypeTO) {
            case CACC: {
                accountTypeBO = AccountTypeBO.CACC;
                break;
            }
            case CASH: {
                accountTypeBO = AccountTypeBO.CASH;
                break;
            }
            case CHAR: {
                accountTypeBO = AccountTypeBO.CHAR;
                break;
            }
            case CISH: {
                accountTypeBO = AccountTypeBO.CISH;
                break;
            }
            case COMM: {
                accountTypeBO = AccountTypeBO.COMM;
                break;
            }
            case CPAC: {
                accountTypeBO = AccountTypeBO.CPAC;
                break;
            }
            case LLSV: {
                accountTypeBO = AccountTypeBO.LLSV;
                break;
            }
            case LOAN: {
                accountTypeBO = AccountTypeBO.LOAN;
                break;
            }
            case MGLD: {
                accountTypeBO = AccountTypeBO.MGLD;
                break;
            }
            case MOMA: {
                accountTypeBO = AccountTypeBO.MOMA;
                break;
            }
            case NREX: {
                accountTypeBO = AccountTypeBO.NREX;
                break;
            }
            case ODFT: {
                accountTypeBO = AccountTypeBO.ODFT;
                break;
            }
            case ONDP: {
                accountTypeBO = AccountTypeBO.ONDP;
                break;
            }
            case OTHR: {
                accountTypeBO = AccountTypeBO.OTHR;
                break;
            }
            case SACC: {
                accountTypeBO = AccountTypeBO.SACC;
                break;
            }
            case SLRY: {
                accountTypeBO = AccountTypeBO.SLRY;
                break;
            }
            case SVGS: {
                accountTypeBO = AccountTypeBO.SVGS;
                break;
            }
            case TAXE: {
                accountTypeBO = AccountTypeBO.TAXE;
                break;
            }
            case TRAN: {
                accountTypeBO = AccountTypeBO.TRAN;
                break;
            }
            case TRAS: {
                accountTypeBO = AccountTypeBO.TRAS;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountTypeTO);
            }
        }
        return accountTypeBO;
    }

    protected AccountStatusBO accountStatusTOToAccountStatusBO(AccountStatusTO accountStatusTO) {
        AccountStatusBO accountStatusBO;
        if (accountStatusTO == null) {
            return null;
        }
        switch (accountStatusTO) {
            case ENABLED: {
                accountStatusBO = AccountStatusBO.ENABLED;
                break;
            }
            case DELETED: {
                accountStatusBO = AccountStatusBO.DELETED;
                break;
            }
            case BLOCKED: {
                accountStatusBO = AccountStatusBO.BLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + accountStatusTO);
            }
        }
        return accountStatusBO;
    }

    protected AccountUsageBO usageTypeTOToAccountUsageBO(UsageTypeTO usageTypeTO) {
        AccountUsageBO accountUsageBO;
        if (usageTypeTO == null) {
            return null;
        }
        switch (usageTypeTO) {
            case PRIV: {
                accountUsageBO = AccountUsageBO.PRIV;
                break;
            }
            case ORGA: {
                accountUsageBO = AccountUsageBO.ORGA;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + usageTypeTO);
            }
        }
        return accountUsageBO;
    }

    protected AmountTO amountBOToAmountTO(AmountBO amountBO) {
        if (amountBO == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(amountBO.getCurrency());
        amountTO.setAmount(amountBO.getAmount());
        return amountTO;
    }

    protected BalanceTypeTO balanceTypeBOToBalanceTypeTO(BalanceTypeBO balanceTypeBO) {
        BalanceTypeTO balanceTypeTO;
        if (balanceTypeBO == null) {
            return null;
        }
        switch (balanceTypeBO) {
            case CLOSING_BOOKED: {
                balanceTypeTO = BalanceTypeTO.CLOSING_BOOKED;
                break;
            }
            case EXPECTED: {
                balanceTypeTO = BalanceTypeTO.EXPECTED;
                break;
            }
            case AUTHORISED: {
                balanceTypeTO = BalanceTypeTO.AUTHORISED;
                break;
            }
            case OPENING_BOOKED: {
                balanceTypeTO = BalanceTypeTO.OPENING_BOOKED;
                break;
            }
            case INTERIM_AVAILABLE: {
                balanceTypeTO = BalanceTypeTO.INTERIM_AVAILABLE;
                break;
            }
            case FORWARD_AVAILABLE: {
                balanceTypeTO = BalanceTypeTO.FORWARD_AVAILABLE;
                break;
            }
            case NONINVOICED: {
                balanceTypeTO = BalanceTypeTO.NONINVOICED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + balanceTypeBO);
            }
        }
        return balanceTypeTO;
    }

    protected AccountBalanceTO balanceBOToAccountBalanceTO(BalanceBO balanceBO) {
        if (balanceBO == null) {
            return null;
        }
        AccountBalanceTO accountBalanceTO = new AccountBalanceTO();
        accountBalanceTO.setAmount(this.amountBOToAmountTO(balanceBO.getAmount()));
        accountBalanceTO.setBalanceType(this.balanceTypeBOToBalanceTypeTO(balanceBO.getBalanceType()));
        accountBalanceTO.setLastChangeDateTime(balanceBO.getLastChangeDateTime());
        accountBalanceTO.setReferenceDate(balanceBO.getReferenceDate());
        accountBalanceTO.setLastCommittedTransaction(balanceBO.getLastCommittedTransaction());
        return accountBalanceTO;
    }

    protected AccountReferenceBO accountReferenceTOToAccountReferenceBO(AccountReferenceTO accountReferenceTO) {
        if (accountReferenceTO == null) {
            return null;
        }
        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();
        accountReferenceBO.setIban(accountReferenceTO.getIban());
        accountReferenceBO.setBban(accountReferenceTO.getBban());
        accountReferenceBO.setPan(accountReferenceTO.getPan());
        accountReferenceBO.setMaskedPan(accountReferenceTO.getMaskedPan());
        accountReferenceBO.setMsisdn(accountReferenceTO.getMsisdn());
        accountReferenceBO.setCurrency(accountReferenceTO.getCurrency());
        return accountReferenceBO;
    }

    protected AmountBO amountTOToAmountBO(AmountTO amountTO) {
        if (amountTO == null) {
            return null;
        }
        AmountBO amountBO = new AmountBO();
        amountBO.setCurrency(amountTO.getCurrency());
        amountBO.setAmount(amountTO.getAmount());
        return amountBO;
    }

    protected AccountDetailsTO depositAccountBOToAccountDetailsTO(DepositAccountBO depositAccountBO) {
        if (depositAccountBO == null) {
            return null;
        }
        AccountDetailsTO accountDetailsTO = new AccountDetailsTO();
        accountDetailsTO.setId(depositAccountBO.getId());
        accountDetailsTO.setIban(depositAccountBO.getIban());
        accountDetailsTO.setBban(depositAccountBO.getBban());
        accountDetailsTO.setPan(depositAccountBO.getPan());
        accountDetailsTO.setMaskedPan(depositAccountBO.getMaskedPan());
        accountDetailsTO.setMsisdn(depositAccountBO.getMsisdn());
        accountDetailsTO.setCurrency(depositAccountBO.getCurrency());
        accountDetailsTO.setName(depositAccountBO.getName());
        accountDetailsTO.setProduct(depositAccountBO.getProduct());
        accountDetailsTO.setAccountType(this.accountTypeBOToAccountTypeTO(depositAccountBO.getAccountType()));
        accountDetailsTO.setAccountStatus(this.accountStatusBOToAccountStatusTO(depositAccountBO.getAccountStatus()));
        accountDetailsTO.setBic(depositAccountBO.getBic());
        accountDetailsTO.setLinkedAccounts(depositAccountBO.getLinkedAccounts());
        accountDetailsTO.setUsageType(this.accountUsageBOToUsageTypeTO(depositAccountBO.getUsageType()));
        accountDetailsTO.setDetails(depositAccountBO.getDetails());
        return accountDetailsTO;
    }
}

