/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service.upload;

import de.adorsys.ledgers.middleware.api.domain.account.AccountBalanceTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.UploadedDataTO;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.impl.service.upload.ExpressionExecutionWrapper;
import de.adorsys.ledgers.middleware.impl.service.upload.PaymentGenerationService;
import java.math.BigDecimal;
import java.util.Currency;
import java.util.Map;
import java.util.Optional;
import org.springframework.stereotype.Service;

@Service
public class UploadPaymentService {
    private final MiddlewarePaymentService middlewarePaymentService;
    private final PaymentGenerationService paymentGenerationService;

    public void uploadPayments(UploadedDataTO data, ScaInfoTO info) {
        if (data.isGeneratePayments()) {
            data.getUsers().stream().flatMap(u -> u.getAccountAccesses().stream()).forEach(u -> this.generateAndExecutePayments((AccountAccessTO)u, data, info));
        } else {
            data.getPayments().forEach(p -> ExpressionExecutionWrapper.execute(() -> this.middlewarePaymentService.initiatePayment(info, p, PaymentTypeTO.SINGLE)));
        }
    }

    private void generateAndExecutePayments(AccountAccessTO access, UploadedDataTO data, ScaInfoTO info) {
        AccountBalanceTO debtorBalance = Optional.ofNullable(data.getBalances().get(access.getIban())).orElseGet(() -> this.buildAccountBalance(access.getIban(), Currency.getInstance("EUR"), BigDecimal.valueOf(100L)));
        Map<PaymentTypeTO, Object> payments = this.paymentGenerationService.generatePayments(debtorBalance, data.getBranch());
        payments.forEach((paymentType, payment) -> ExpressionExecutionWrapper.execute(() -> this.middlewarePaymentService.initiatePayment(info, payment, paymentType)));
    }

    private AccountBalanceTO buildAccountBalance(String iban, Currency currency, BigDecimal amount) {
        AccountBalanceTO balance = new AccountBalanceTO();
        balance.setAmount(new AmountTO(currency, amount));
        balance.setIban(iban);
        return balance;
    }

    public UploadPaymentService(MiddlewarePaymentService middlewarePaymentService, PaymentGenerationService paymentGenerationService) {
        this.middlewarePaymentService = middlewarePaymentService;
        this.paymentGenerationService = paymentGenerationService;
    }
}

