/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.service.MiddlewareResetPasswordService;
import de.adorsys.ledgers.security.GenerateCode;
import de.adorsys.ledgers.security.ResetPassword;
import de.adorsys.ledgers.security.SendCode;
import de.adorsys.ledgers.security.UpdatePassword;
import de.adorsys.ledgers.security.VerifyCode;
import de.adorsys.ledgers.um.api.service.ResetPasswordCodeGenerator;
import de.adorsys.ledgers.um.api.service.ResetPasswordCodeSender;
import de.adorsys.ledgers.um.api.service.ResetPasswordCodeVerifier;
import de.adorsys.ledgers.um.api.service.UpdatePasswordService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MiddlewareResetPasswordServiceImpl
implements MiddlewareResetPasswordService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareResetPasswordServiceImpl.class);
    private final ResetPasswordCodeGenerator resetPasswordCodeGenerator;
    private final ResetPasswordCodeSender resetPasswordCodeSender;
    private final ResetPasswordCodeVerifier resetPasswordCodeVerifier;
    private final UpdatePasswordService resetPasswordService;

    public SendCode sendCode(ResetPassword resetPassword) {
        GenerateCode result = this.resetPasswordCodeGenerator.generateCode(resetPassword);
        return this.resetPasswordCodeSender.sendCode(resetPassword.withCode(result.getCode()));
    }

    public UpdatePassword updatePassword(ResetPassword resetPassword) {
        VerifyCode result = this.resetPasswordCodeVerifier.verifyCode(resetPassword.getCode());
        return this.resetPasswordService.updatePassword(result.getUserId(), resetPassword.getNewPassword());
    }

    public MiddlewareResetPasswordServiceImpl(ResetPasswordCodeGenerator resetPasswordCodeGenerator, ResetPasswordCodeSender resetPasswordCodeSender, ResetPasswordCodeVerifier resetPasswordCodeVerifier, UpdatePasswordService resetPasswordService) {
        this.resetPasswordCodeGenerator = resetPasswordCodeGenerator;
        this.resetPasswordCodeSender = resetPasswordCodeSender;
        this.resetPasswordCodeVerifier = resetPasswordCodeVerifier;
        this.resetPasswordService = resetPasswordService;
    }
}

