/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentProductBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentCoreDataTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaDataInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.TokenUsageTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.api.service.ScaChallengeDataResolver;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCancelPolicy;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCoreDataPolicy;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.util.Ids;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewarePaymentServiceImpl
implements MiddlewarePaymentService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewarePaymentServiceImpl.class);
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final DepositAccountService accountService;
    private final PaymentConverter paymentConverter;
    private final BearerTokenMapper bearerTokenMapper;
    private final SCAUtils scaUtils;
    private final PaymentCancelPolicy cancelPolicy;
    private final PaymentCoreDataPolicy coreDataPolicy;
    private final AccessService accessService;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    private final ScaChallengeDataResolver scaChallengeDataResolver;
    private int defaultLoginTokenExpireInSeconds = 600;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public TransactionStatusTO getPaymentStatusById(String paymentId) {
        TransactionStatusBO paymentStatus = this.paymentService.getPaymentStatusById(paymentId);
        return TransactionStatusTO.valueOf((String)paymentStatus.name());
    }

    public SCAPaymentResponseTO initiatePaymentCancellation(ScaInfoTO scaInfoTO, String paymentId) {
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        PaymentBO paymentBO = this.loadPayment(paymentId);
        TransactionStatusTO originalTxStatus = TransactionStatusTO.valueOf((String)paymentBO.getTransactionStatus().name());
        this.cancelPolicy.onCancel(paymentId, originalTxStatus);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(paymentBO);
        SCAPaymentResponseTO response = this.prepareSCA(scaInfoTO, userBO, paymentBO, paymentKeyData, OpTypeBO.CANCEL_PAYMENT);
        if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
            TransactionStatusBO cancelPayment = this.paymentService.cancelPayment(paymentId);
            response.setTransactionStatus(TransactionStatusTO.valueOf((String)cancelPayment.name()));
        }
        return response;
    }

    public <T> SCAPaymentResponseTO initiatePayment(ScaInfoTO scaInfoTO, T payment, PaymentTypeTO paymentType) {
        PaymentBO paymentBO = this.paymentConverter.toPaymentBO(payment, paymentType.getPaymentClass());
        if (!paymentBO.isValidAmount()) {
            throw MiddlewareModuleException.builder().devMsg("Payment validation failed! Instructed amount is invalid.").errorCode(MiddlewareErrorCode.REQUEST_VALIDATION_FAILURE).build();
        }
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        this.accountService.getDepositAccountByIbanAndCheckStatus(paymentBO.getDebtorAccount().getIban(), LocalDateTime.now(), false);
        TransactionStatusBO status = this.scaUtils.hasSCA(userBO) ? TransactionStatusBO.ACCP : TransactionStatusBO.ACTC;
        paymentBO = this.persist(paymentBO, status);
        status = paymentBO.getTransactionStatus();
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setMultilevelScaRequired(this.multilevelScaEnable);
        if (TransactionStatusBO.RJCT.equals((Object)status)) {
            response.setScaStatus(ScaStatusTO.FAILED);
            response.setTransactionStatus(TransactionStatusTO.valueOf((String)status.name()));
            response.setPaymentId(paymentBO.getPaymentId());
            this.setPaymentProductAndType(paymentBO, response);
        } else {
            PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(paymentBO);
            response = this.prepareSCA(scaInfoTO, userBO, paymentBO, paymentKeyData, OpTypeBO.PAYMENT);
            if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
                status = this.paymentService.executePayment(paymentBO.getPaymentId(), userBO.getLogin());
                response.setTransactionStatus(TransactionStatusTO.valueOf((String)status.name()));
            }
        }
        return response;
    }

    private void setPaymentProductAndType(PaymentBO paymentBO, SCAPaymentResponseTO response) {
        response.setPaymentType(PaymentTypeTO.valueOf((String)paymentBO.getPaymentType().name()));
        if (paymentBO.getTargets() != null && !paymentBO.getTargets().isEmpty()) {
            PaymentProductBO paymentProduct = ((PaymentTargetBO)paymentBO.getTargets().iterator().next()).getPaymentProduct();
            response.setPaymentProduct((PaymentProductTO)PaymentProductTO.getByValue((String)paymentProduct.getValue()).orElse(null));
        }
    }

    private PaymentBO persist(PaymentBO paymentBO, TransactionStatusBO status) {
        if (paymentBO.getPaymentId() == null) {
            paymentBO.setPaymentId(Ids.id());
        }
        return this.paymentService.initiatePayment(paymentBO, status);
    }

    public Object getPaymentById(String paymentId) {
        PaymentBO paymentResult = this.paymentService.getPaymentById(paymentId);
        return this.paymentConverter.toPaymentTO(paymentResult);
    }

    public String iban(String paymentId) {
        return this.paymentService.readIbanByPaymentId(paymentId);
    }

    public SCAPaymentResponseTO authorizePayment(ScaInfoTO scaInfoTO, String paymentId) {
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(payment);
        TransactionStatusBO tx = payment.getTransactionStatus();
        this.validateAuthCode(scaInfoTO.getUserId(), payment, scaInfoTO.getAuthorisationId(), scaInfoTO.getAuthCode(), paymentKeyData.template());
        boolean authCompleted = this.scaOperationService.authenticationCompleted(paymentId, OpTypeBO.PAYMENT);
        UserTO user = this.scaUtils.user(scaInfoTO.getUserId());
        if (authCompleted) {
            tx = this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.ACTC);
            tx = this.paymentService.executePayment(paymentId, user.getLogin());
        } else if (this.multilevelScaEnable) {
            tx = this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.PATC);
        }
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment, user.getLogin());
        return this.toScaPaymentResponse(this.scaUtils.user(scaInfoTO.getUserId()), paymentId, tx, paymentKeyData, this.scaUtils.loadAuthCode(scaInfoTO.getAuthorisationId()), bearerToken);
    }

    private BearerTokenTO paymentAccountAccessToken(ScaInfoTO scaInfoTO, PaymentBO payment, String userName) {
        String iban = payment.getDebtorAccount().getIban();
        AisConsentBO aisConsent = new AisConsentBO();
        AisAccountAccessInfoBO access = new AisAccountAccessInfoBO();
        aisConsent.setAccess(access);
        List<String> asList = Collections.singletonList(iban);
        access.setAccounts(asList);
        access.setTransactions(asList);
        access.setBalances(asList);
        aisConsent.setFrequencyPerDay(0);
        aisConsent.setRecurringIndicator(true);
        aisConsent.setUserId(userName);
        return this.bearerTokenMapper.toBearerTokenTO(this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), aisConsent));
    }

    public SCAPaymentResponseTO loadSCAForPaymentData(ScaInfoTO scaInfoTO, String paymentId) {
        SCAOperationBO scaOperation = this.scaOperationService.loadAuthCode(scaInfoTO.getAuthorisationId());
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(payment);
        UserTO user = this.scaUtils.user(scaInfoTO.getUserId());
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment, user.getLogin());
        return this.toScaPaymentResponse(user, paymentId, payment.getTransactionStatus(), paymentKeyData, scaOperation, bearerToken);
    }

    public SCAPaymentResponseTO selectSCAMethodForPayment(ScaInfoTO scaInfoTO, String paymentId) {
        String opData;
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        UserTO userTO = this.scaUtils.user(userBO);
        PaymentBO payment = this.loadPayment(paymentId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(payment);
        String userMessage = opData = paymentKeyData.template();
        AuthCodeDataBO authCodeDataBO = new AuthCodeDataBO(userBO.getLogin(), scaInfoTO.getScaMethodId(), paymentId, opData, userMessage, this.defaultLoginTokenExpireInSeconds, OpTypeBO.PAYMENT, scaInfoTO.getAuthorisationId(), scaWeight);
        SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(authCodeDataBO, userBO, ScaStatusBO.SCAMETHODSELECTED);
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment, userTO.getLogin());
        return this.toScaPaymentResponse(userTO, paymentId, payment.getTransactionStatus(), paymentKeyData, scaOperationBO, bearerToken);
    }

    public SCAPaymentResponseTO loadSCAForCancelPaymentData(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        SCAOperationBO scaOperation = this.scaOperationService.loadAuthCode(cancellationId);
        UserTO user = this.scaUtils.user(scaInfoTO.getUserId());
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(payment);
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment, user.getLogin());
        return this.toScaPaymentResponse(user, paymentId, payment.getTransactionStatus(), paymentKeyData, scaOperation, bearerToken);
    }

    public SCAPaymentResponseTO selectSCAMethodForCancelPayment(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        String template;
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        UserTO userTO = this.scaUtils.user(userBO);
        PaymentBO payment = this.loadPayment(paymentId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(payment);
        String opData = template = paymentKeyData.template();
        String userMessage = template;
        AuthCodeDataBO authCodeDataBO = new AuthCodeDataBO(userBO.getLogin(), scaInfoTO.getScaMethodId(), paymentId, opData, userMessage, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CANCEL_PAYMENT, cancellationId, scaWeight);
        SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(authCodeDataBO, userBO, ScaStatusBO.SCAMETHODSELECTED);
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment, userTO.getLogin());
        return this.toScaPaymentResponse(userTO, paymentId, payment.getTransactionStatus(), paymentKeyData, scaOperationBO, bearerToken);
    }

    public SCAPaymentResponseTO authorizeCancelPayment(ScaInfoTO scaInfoTO, String paymentId, String cancellationId) {
        PaymentBO payment = this.loadPayment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(payment);
        this.validateAuthCode(scaInfoTO.getUserId(), payment, cancellationId, scaInfoTO.getAuthCode(), paymentKeyData.template());
        TransactionStatusBO tx = payment.getTransactionStatus();
        if (this.scaOperationService.authenticationCompleted(paymentId, OpTypeBO.CANCEL_PAYMENT)) {
            tx = this.paymentService.cancelPayment(paymentId);
        } else if (this.multilevelScaEnable) {
            tx = this.paymentService.updatePaymentStatus(paymentId, TransactionStatusBO.PATC);
        }
        UserTO user = this.scaUtils.user(scaInfoTO.getUserId());
        BearerTokenTO bearerToken = this.paymentAccountAccessToken(scaInfoTO, payment, user.getLogin());
        return this.toScaPaymentResponse(user, paymentId, tx, paymentKeyData, this.scaUtils.loadAuthCode(cancellationId), bearerToken);
    }

    private void validateAuthCode(String userId, PaymentBO payment, String authorisationId, String authCode, String template) {
        UserBO userBO = this.scaUtils.userBO(userId);
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(userBO.getAccountAccesses(), payment.getDebtorAccount().getIban());
        if (!this.scaOperationService.validateAuthCode(authorisationId, payment.getPaymentId(), template, authCode, scaWeight)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.AUTHENTICATION_FAILURE).devMsg("Wrong auth code").build();
        }
    }

    private PaymentBO loadPayment(String paymentId) {
        return this.paymentService.getPaymentById(paymentId);
    }

    private boolean scaRequired(PaymentBO payment, UserBO user, OpTypeBO opType) {
        return this.scaUtils.hasSCA(user);
    }

    private SCAPaymentResponseTO prepareSCA(ScaInfoTO scaInfoTO, UserBO user, PaymentBO payment, PaymentCoreDataTO paymentKeyData, OpTypeBO opType) {
        String paymentKeyDataTemplate;
        UserTO userTo = this.scaUtils.user(user);
        String authorisationId = this.scaUtils.authorisationId(scaInfoTO);
        String opData = paymentKeyDataTemplate = paymentKeyData.template();
        String userMessage = paymentKeyDataTemplate;
        BearerTokenTO paymentAccountAccessToken = this.paymentAccountAccessToken(scaInfoTO, payment, userTo.getLogin());
        if (!this.scaRequired(payment, user, opType)) {
            SCAPaymentResponseTO response = new SCAPaymentResponseTO();
            response.setAuthorisationId(authorisationId);
            response.setPaymentId(payment.getPaymentId());
            response.setPsuMessage(paymentKeyData.exemptedTemplate());
            response.setScaStatus(ScaStatusTO.EXEMPTED);
            response.setStatusDate(LocalDateTime.now());
            response.setTransactionStatus(TransactionStatusTO.valueOf((String)payment.getTransactionStatus().name()));
            response.setBearerToken(paymentAccountAccessToken);
            this.setPaymentProductAndType(payment, response);
            return response;
        }
        int scaWeight = this.accessService.resolveScaWeightByDebtorAccount(user.getAccountAccesses(), payment.getDebtorAccount().getIban());
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), null, payment.getPaymentId(), opData, userMessage, this.defaultLoginTokenExpireInSeconds, opType, authorisationId, scaWeight);
        TokenUsageTO tokenUsage = scaInfoTO.getTokenUsage();
        ScaStatusBO scaStatus = ScaStatusBO.PSUIDENTIFIED;
        if (TokenUsageTO.DELEGATED_ACCESS.equals((Object)tokenUsage)) {
            scaStatus = ScaStatusBO.PSUAUTHENTICATED;
        }
        SCAOperationBO scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, scaStatus);
        return this.toScaPaymentResponse(userTo, payment.getPaymentId(), payment.getTransactionStatus(), paymentKeyData, scaOperationBO, paymentAccountAccessToken);
    }

    private SCAPaymentResponseTO toScaPaymentResponse(UserTO user, String paymentId, TransactionStatusBO tx, PaymentCoreDataTO paymentKeyData, SCAOperationBO operation, BearerTokenTO paymentAccountAccessToken) {
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setAuthorisationId(operation.getId());
        ScaUserDataTO userData = this.scaUtils.getScaMethod(user, operation.getScaMethodId());
        response.setChosenScaMethod(userData);
        if (userData != null) {
            response.setChallengeData(this.scaChallengeDataResolver.resolveScaChallengeData(userData.getScaMethod()).getChallengeData(new ScaDataInfoTO(userData, operation.getTan())));
        }
        response.setExpiresInSeconds(operation.getValiditySeconds());
        response.setPaymentId(paymentId);
        response.setPsuMessage(paymentKeyData.template());
        response.setScaMethods(user.getScaUserData());
        response.setScaStatus(ScaStatusTO.valueOf((String)operation.getScaStatus().name()));
        response.setStatusDate(operation.getStatusTime());
        response.setTransactionStatus(TransactionStatusTO.valueOf((String)tx.name()));
        response.setPaymentProduct((PaymentProductTO)PaymentProductTO.getByValue((String)paymentKeyData.getPaymentProduct()).orElse(null));
        response.setBearerToken(paymentAccountAccessToken);
        return response;
    }

    public MiddlewarePaymentServiceImpl(DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, DepositAccountService accountService, PaymentConverter paymentConverter, BearerTokenMapper bearerTokenMapper, SCAUtils scaUtils, PaymentCancelPolicy cancelPolicy, PaymentCoreDataPolicy coreDataPolicy, AccessService accessService, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService, ScaChallengeDataResolver scaChallengeDataResolver) {
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.accountService = accountService;
        this.paymentConverter = paymentConverter;
        this.bearerTokenMapper = bearerTokenMapper;
        this.scaUtils = scaUtils;
        this.cancelPolicy = cancelPolicy;
        this.coreDataPolicy = coreDataPolicy;
        this.accessService = accessService;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
        this.scaChallengeDataResolver = scaChallengeDataResolver;
    }
}

