/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReportTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.ConsentKeyDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaDataInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.api.service.ScaChallengeDataResolver;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.AisConsentBOMapper;
import de.adorsys.ledgers.middleware.impl.converter.AmountMapper;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PageMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.ScaInfoMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.ScaInfoBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.AuthorizationService;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.domain.CustomPageImpl;
import de.adorsys.ledgers.util.domain.CustomPageableImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareAccountManagementServiceImpl
implements MiddlewareAccountManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareAccountManagementServiceImpl.class);
    private static final LocalDateTime BASE_TIME = LocalDateTime.MIN;
    private static final int NANO_TO_SECOND = 1000000000;
    private final UserMapper userMapper;
    private final DepositAccountService depositAccountService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentConverter paymentConverter;
    private final UserService userService;
    private final AisConsentBOMapper aisConsentMapper;
    private final BearerTokenMapper bearerTokenMapper;
    private final SCAOperationService scaOperationService;
    private final SCAUtils scaUtils;
    private final AccessService accessService;
    private int defaultLoginTokenExpireInSeconds = 600;
    private final AmountMapper amountMapper;
    private final ScaInfoMapper scaInfoMapper;
    private final AuthorizationService authorizationService;
    private final ScaChallengeDataResolver scaChallengeDataResolver;
    private final PageMapper pageMapper;
    @Value(value="${sca.multilevel.enabled:false}")
    private boolean multilevelScaEnable;

    public void createDepositAccount(String userId, ScaInfoTO scaInfoTO, AccountDetailsTO depositAccount) {
        UserBO user = this.userService.findById(userId);
        DepositAccountBO accountToCreate = this.accountDetailsMapper.toDepositAccountBO(depositAccount);
        DepositAccountBO createdAccount = this.depositAccountService.createDepositAccountForBranch(accountToCreate, user.getId(), user.getBranch());
        AccountAccessBO accountAccess = this.accessService.createAccountAccess(createdAccount.getIban(), AccessTypeBO.OWNER);
        this.accessService.updateAccountAccess(user, accountAccess);
        if (!user.getLogin().equals(scaInfoTO.getUserLogin())) {
            UserBO userBO = this.userService.findByLogin(scaInfoTO.getUserLogin());
            this.accessService.updateAccountAccess(userBO, accountAccess);
        }
    }

    public AccountDetailsTO getDepositAccountById(String accountId, LocalDateTime time, boolean withBalance) {
        DepositAccountDetailsBO accountDetailsBO = this.depositAccountService.getDepositAccountById(accountId, time, true);
        return this.accountDetailsMapper.toAccountDetailsTO(accountDetailsBO);
    }

    public AccountDetailsTO getDepositAccountByIban(String iban, LocalDateTime time, boolean withBalance) {
        DepositAccountDetailsBO depositAccountBO = this.depositAccountService.getDepositAccountByIban(iban, time, withBalance);
        return this.accountDetailsMapper.toAccountDetailsTO(depositAccountBO);
    }

    public List<AccountDetailsTO> getAllAccountDetailsByUserLogin(String userLogin) {
        log.info("Retrieving accounts by user login {}", (Object)userLogin);
        UserBO userBO = this.userService.findByLogin(userLogin);
        List accountAccess = userBO.getAccountAccesses();
        log.info("{} accounts were retrieved", (Object)accountAccess.size());
        List ibans = accountAccess.stream().filter(a -> a.getAccessType() == AccessTypeBO.OWNER).map(AccountAccessBO::getIban).collect(Collectors.toList());
        log.info("{} were accounts were filtered as OWN", (Object)ibans.size());
        List depositAccounts = this.depositAccountService.getDepositAccountsByIban(ibans, BASE_TIME, false);
        log.info("{} deposit accounts were found", (Object)depositAccounts.size());
        return depositAccounts.stream().map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public TransactionTO getTransactionById(String accountId, String transactionId) {
        TransactionDetailsBO transaction = this.depositAccountService.getTransactionById(accountId, transactionId);
        return this.paymentConverter.toTransactionTO(transaction);
    }

    public List<TransactionTO> getTransactionsByDates(String accountId, LocalDate dateFrom, LocalDate dateTo) {
        log.info("Start retrieving transactions for {}", (Object)accountId);
        long start = System.nanoTime();
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = dateTo == null ? this.accessService.getTimeAtEndOfTheDay(today) : this.accessService.getTimeAtEndOfTheDay(dateTo);
        List transactions = this.depositAccountService.getTransactionsByDates(accountId, dateTimeFrom, dateTimeTo);
        log.info("Retrieved {} transactions in {} secs", (Object)transactions.size(), (Object)((double)(System.nanoTime() - start) / 1.0E9));
        return this.paymentConverter.toTransactionTOList(transactions);
    }

    public CustomPageImpl<TransactionTO> getTransactionsByDatesPaged(String accountId, LocalDate dateFrom, LocalDate dateTo, CustomPageableImpl pageable) {
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = dateTo == null ? this.accessService.getTimeAtEndOfTheDay(today) : this.accessService.getTimeAtEndOfTheDay(dateTo);
        return this.pageMapper.toCustomPageImpl(this.depositAccountService.getTransactionsByDatesPaged(accountId, dateTimeFrom, dateTimeTo, (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.paymentConverter::toTransactionTO));
    }

    public boolean confirmFundsAvailability(FundsConfirmationRequestTO request) {
        FundsConfirmationRequestBO requestBO = this.accountDetailsMapper.toFundsConfirmationRequestBO(request);
        return this.depositAccountService.confirmationOfFunds(requestBO);
    }

    public void createDepositAccount(ScaInfoTO scaInfoTO, String accountNumberPrefix, String accountNumberSuffix, AccountDetailsTO accDetails) {
        String accNbr = accountNumberPrefix + accountNumberSuffix;
        List accounts = this.depositAccountService.findByAccountNumberPrefix(accountNumberPrefix);
        this.validateInput(scaInfoTO.getUserId(), accounts, accountNumberPrefix, accountNumberSuffix);
        accDetails.setIban(accNbr);
        this.createDepositAccount(scaInfoTO.getUserId(), scaInfoTO, accDetails);
    }

    private void validateInput(String userId, List<DepositAccountBO> accounts, String accountNumberPrefix, String accountNumberSuffix) {
        String accNbr;
        if (accounts.isEmpty()) {
            return;
        }
        List<AccountAccessTO> accountAccesses = this.userMapper.toAccountAccessListTO(this.userService.findById(userId).getAccountAccesses());
        if (accountAccesses == null || accountAccesses.isEmpty()) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg(String.format("Account prefix %s is gone.", accountNumberPrefix)).build();
        }
        List<String> ownedAccounts = this.accessService.filterOwnedAccounts(accountAccesses);
        if (ownedAccounts.contains(accNbr = accountNumberPrefix + accountNumberSuffix)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg(String.format("Account with suffix %S and prefix %s already exist", accountNumberPrefix, accountNumberSuffix)).build();
        }
        for (DepositAccountBO a : accounts) {
            if (!ownedAccounts.contains(a.getIban())) continue;
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.ACCOUNT_CREATION_VALIDATION_FAILURE).devMsg(String.format("User not owner of account with iban %s that also holds the requested prefix %s", a.getIban(), accountNumberPrefix)).build();
        }
    }

    public List<AccountDetailsTO> listDepositAccounts(String userId) {
        UserBO user = this.accessService.loadCurrentUser(userId);
        UserTO userTO = this.userMapper.toUserTO(user);
        List accountAccesses = userTO.getAccountAccesses();
        if (accountAccesses == null || accountAccesses.isEmpty()) {
            return Collections.emptyList();
        }
        List ibans = accountAccesses.stream().map(AccountAccessTO::getIban).collect(Collectors.toList());
        List depositAccounts = this.depositAccountService.getDepositAccountsByIban(ibans, LocalDateTime.now(), true);
        return depositAccounts.stream().map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public List<AccountDetailsTO> listDepositAccountsByBranch(String userId) {
        UserBO user = this.accessService.loadCurrentUser(userId);
        List depositAccounts = this.depositAccountService.findByBranch(user.getBranch());
        return depositAccounts.stream().map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public CustomPageImpl<AccountDetailsTO> listDepositAccountsByBranchPaged(String userId, CustomPageableImpl pageable) {
        UserBO user = this.accessService.loadCurrentUser(userId);
        return this.pageMapper.toCustomPageImpl(this.depositAccountService.findByBranchPaged(user.getBranch(), (Pageable)PageRequest.of((int)pageable.getPage(), (int)pageable.getSize())).map(this.accountDetailsMapper::toAccountDetailsTO));
    }

    public String iban(String id) {
        return this.depositAccountService.readIbanById(id);
    }

    public SCAConsentResponseTO startSCA(ScaInfoTO scaInfoTO, String consentId, AisConsentTO aisConsent) {
        BearerTokenBO bearerToken = this.checkAisConsent(this.scaInfoMapper.toScaInfoBO(scaInfoTO), aisConsent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsent);
        SCAConsentResponseTO response = this.prepareSCA(scaInfoTO, this.scaUtils.userBO(scaInfoTO.getUserId()), aisConsent, consentKeyData);
        if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
            response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(bearerToken));
        }
        return response;
    }

    public SCAConsentResponseTO loadSCAForAisConsent(String userId, String consentId, String authorisationId) {
        UserTO user = this.userMapper.toUserTO(this.scaUtils.userBO(userId));
        AisConsentBO consent = this.userService.loadConsent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        SCAOperationBO scaOperationBO = this.scaUtils.loadAuthCode(authorisationId);
        return this.toScaConsentResponse(user, consent, consentKeyData.template(), scaOperationBO);
    }

    public SCAConsentResponseTO selectSCAMethodForAisConsent(String userId, String consentId, String authorisationId, String scaMethodId) {
        UserBO userBO = this.scaUtils.userBO(userId);
        UserTO userTO = this.scaUtils.user(userBO);
        AisConsentBO consent = this.userService.loadConsent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        String template = consentKeyData.template();
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consent.getAccess(), userBO.getAccountAccesses());
        AuthCodeDataBO a = new AuthCodeDataBO(userBO.getLogin(), scaMethodId, consentId, template, template, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CONSENT, authorisationId, scaWeight);
        SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(a, userBO, ScaStatusBO.SCAMETHODSELECTED);
        return this.toScaConsentResponse(userTO, consent, consentKeyData.template(), scaOperationBO);
    }

    public SCAConsentResponseTO authorizeConsent(ScaInfoTO scaInfoTO, String consentId) {
        AisConsentBO consent = this.userService.loadConsent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        UserBO userBO = this.scaUtils.userBO(scaInfoTO.getUserId());
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consent.getAccess(), userBO.getAccountAccesses());
        boolean validAuthCode = this.scaOperationService.validateAuthCode(scaInfoTO.getAuthorisationId(), consentId, consentKeyData.template(), scaInfoTO.getAuthCode(), scaWeight);
        if (!validAuthCode) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.AUTHENTICATION_FAILURE).devMsg("Wrong auth code").build();
        }
        UserTO userTO = this.scaUtils.user(userBO);
        SCAOperationBO scaOperationBO = this.scaUtils.loadAuthCode(scaInfoTO.getAuthorisationId());
        SCAConsentResponseTO response = this.toScaConsentResponse(userTO, consent, consentKeyData.template(), scaOperationBO);
        if (this.scaOperationService.authenticationCompleted(consentId, OpTypeBO.CONSENT)) {
            BearerTokenBO consentToken = this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), consent);
            response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(consentToken));
        } else if (this.multilevelScaEnable) {
            response.setPartiallyAuthorised(true);
        }
        return response;
    }

    public SCAConsentResponseTO grantAisConsent(ScaInfoTO scaInfoTO, AisConsentTO aisConsent) {
        AisConsentTO piisConsentTO = this.cleanupForPIIS(aisConsent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(piisConsentTO);
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(piisConsentTO);
        BearerTokenBO consentToken = this.authorizationService.consentToken(this.scaInfoMapper.toScaInfoBO(scaInfoTO), consentBO);
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(consentToken));
        response.setAuthorisationId(this.scaUtils.authorisationId(scaInfoTO));
        response.setConsentId(aisConsent.getId());
        response.setPsuMessage(consentKeyData.exemptedTemplate());
        response.setScaStatus(ScaStatusTO.EXEMPTED);
        response.setStatusDate(LocalDateTime.now());
        return response;
    }

    public void depositCash(ScaInfoTO scaInfoTO, String accountId, AmountTO amount) {
        this.depositAccountService.getDepositAccountByIbanAndCheckStatus(this.iban(accountId), LocalDateTime.now(), false);
        this.depositAccountService.depositCash(accountId, this.amountMapper.toAmountBO(amount), scaInfoTO.getUserLogin());
    }

    public List<AccountAccessTO> getAccountAccesses(String userId) {
        UserBO user = this.userService.findById(userId);
        UserTO userTO = this.userMapper.toUserTO(user);
        return userTO.getAccountAccesses();
    }

    public void deleteTransactions(String userId, UserRoleTO userRole, String iban) {
        log.info("User {} attempting delete postings for iban: {}", (Object)userId, (Object)iban);
        long start = System.nanoTime();
        if (userRole == UserRoleTO.STAFF) {
            this.userService.findById(userId).getAccountAccesses().stream().filter(a -> a.getIban().equals(iban)).findAny().orElseThrow(() -> MiddlewareModuleException.builder().devMsg("You dont have permission to modify this account").errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).build());
        }
        log.info("Permission checked -> OK");
        this.depositAccountService.deleteTransactions(iban);
        log.info("Deleting postings for: {} Successful, in {} seconds", (Object)iban, (Object)((double)(System.nanoTime() - start) / 1.0E9));
    }

    public AccountReportTO getAccountReport(String accountId) {
        long start = System.nanoTime();
        AccountDetailsTO details = this.getDepositAccountById(accountId, LocalDateTime.now(), true);
        log.info("Loaded details with balances in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        start = System.nanoTime();
        List<UserTO> users = this.userMapper.toUserTOList(this.userService.findUsersByIban(details.getIban()));
        log.info("Loaded users in {} seconds", (Object)TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS));
        return new AccountReportTO(details, users);
    }

    private AisConsentTO cleanupForPIIS(AisConsentTO aisConsentTo) {
        aisConsentTo.getAccess().setAllPsd2(null);
        aisConsentTo.getAccess().setAvailableAccounts(null);
        aisConsentTo.getAccess().setAccounts(Collections.emptyList());
        aisConsentTo.getAccess().setTransactions(Collections.emptyList());
        return aisConsentTo;
    }

    private BearerTokenBO checkAisConsent(ScaInfoBO scaInfoBO, AisConsentTO aisConsent) {
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(aisConsent);
        return this.authorizationService.consentToken(scaInfoBO, consentBO);
    }

    private boolean scaRequired(UserBO user) {
        return this.scaUtils.hasSCA(user);
    }

    private SCAConsentResponseTO prepareSCA(ScaInfoTO scaInfoTO, UserBO user, AisConsentTO aisConsent, ConsentKeyDataTO consentKeyData) {
        String consentKeyDataTemplate = consentKeyData.template();
        UserTO userTo = this.scaUtils.user(user);
        String authorisationId = this.scaUtils.authorisationId(scaInfoTO);
        if (!this.scaRequired(user)) {
            SCAConsentResponseTO response = new SCAConsentResponseTO();
            response.setAuthorisationId(authorisationId);
            response.setConsentId(aisConsent.getId());
            response.setPsuMessage(consentKeyData.exemptedTemplate());
            response.setScaStatus(ScaStatusTO.EXEMPTED);
            response.setStatusDate(LocalDateTime.now());
            return response;
        }
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(aisConsent);
        consentBO = this.userService.storeConsent(consentBO);
        int scaWeight = this.accessService.resolveMinimalScaWeightForConsent(consentBO.getAccess(), user.getAccountAccesses());
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), aisConsent.getId(), aisConsent.getId(), consentKeyDataTemplate, consentKeyDataTemplate, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CONSENT, authorisationId, scaWeight);
        SCAOperationBO scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUAUTHENTICATED);
        return this.toScaConsentResponse(userTo, consentBO, consentKeyDataTemplate, scaOperationBO);
    }

    private SCAConsentResponseTO toScaConsentResponse(UserTO user, AisConsentBO consent, String messageTemplate, SCAOperationBO operation) {
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        response.setAuthorisationId(operation.getId());
        ScaUserDataTO userData = this.scaUtils.getScaMethod(user, operation.getScaMethodId());
        response.setChosenScaMethod(userData);
        if (userData != null) {
            response.setChallengeData(this.scaChallengeDataResolver.resolveScaChallengeData(userData.getScaMethod()).getChallengeData(new ScaDataInfoTO(userData, operation.getTan())));
        }
        response.setExpiresInSeconds(operation.getValiditySeconds());
        response.setConsentId(consent.getId());
        response.setPsuMessage(messageTemplate);
        response.setScaMethods(user.getScaUserData());
        response.setStatusDate(operation.getStatusTime());
        response.setScaStatus(ScaStatusTO.valueOf((String)operation.getScaStatus().name()));
        return response;
    }

    public MiddlewareAccountManagementServiceImpl(UserMapper userMapper, DepositAccountService depositAccountService, AccountDetailsMapper accountDetailsMapper, PaymentConverter paymentConverter, UserService userService, AisConsentBOMapper aisConsentMapper, BearerTokenMapper bearerTokenMapper, SCAOperationService scaOperationService, SCAUtils scaUtils, AccessService accessService, AmountMapper amountMapper, ScaInfoMapper scaInfoMapper, AuthorizationService authorizationService, ScaChallengeDataResolver scaChallengeDataResolver, PageMapper pageMapper) {
        this.userMapper = userMapper;
        this.depositAccountService = depositAccountService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.paymentConverter = paymentConverter;
        this.userService = userService;
        this.aisConsentMapper = aisConsentMapper;
        this.bearerTokenMapper = bearerTokenMapper;
        this.scaOperationService = scaOperationService;
        this.scaUtils = scaUtils;
        this.accessService = accessService;
        this.amountMapper = amountMapper;
        this.scaInfoMapper = scaInfoMapper;
        this.authorizationService = authorizationService;
        this.scaChallengeDataResolver = scaChallengeDataResolver;
        this.pageMapper = pageMapper;
    }
}

