/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.deposit.api.domain.AccountReferenceBO;
import de.adorsys.ledgers.deposit.api.domain.AddressBO;
import de.adorsys.ledgers.deposit.api.domain.AmountBO;
import de.adorsys.ledgers.deposit.api.domain.ExchangeRateBO;
import de.adorsys.ledgers.deposit.api.domain.FrequencyCodeBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentProductBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentResultBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.PurposeCodeBO;
import de.adorsys.ledgers.deposit.api.domain.ResultStatusBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.middleware.api.domain.account.AccountReferenceTO;
import de.adorsys.ledgers.middleware.api.domain.account.ExchangeRateTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.general.AddressTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.FrequencyCodeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentResultTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.ResultStatusTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class PaymentConverterImpl
extends PaymentConverter {
    @Override
    public PaymentResultTO toPaymentResultTO(PaymentResultBO bo) {
        if (bo == null) {
            return null;
        }
        PaymentResultTO paymentResultTO = new PaymentResultTO();
        paymentResultTO.setResponseStatus(this.resultStatusBOToResultStatusTO(bo.getResponseStatus()));
        List list = bo.getMessages();
        if (list != null) {
            paymentResultTO.setMessages(new ArrayList(list));
        }
        paymentResultTO.setPaymentResult(bo.getPaymentResult());
        return paymentResultTO;
    }

    @Override
    public PaymentResultBO toPaymentResultBO(PaymentResultTO to) {
        if (to == null) {
            return null;
        }
        PaymentResultBO paymentResultBO = new PaymentResultBO();
        paymentResultBO.setResponseStatus(this.resultStatusTOToResultStatusBO(to.getResponseStatus()));
        List list = to.getMessages();
        if (list != null) {
            paymentResultBO.setMessages(new ArrayList(list));
        }
        paymentResultBO.setPaymentResult(to.getPaymentResult());
        return paymentResultBO;
    }

    @Override
    public PaymentTypeBO toPaymentTypeBO(PaymentTypeTO paymentType) {
        PaymentTypeBO paymentTypeBO;
        if (paymentType == null) {
            return null;
        }
        switch (paymentType) {
            case SINGLE: {
                paymentTypeBO = PaymentTypeBO.SINGLE;
                break;
            }
            case PERIODIC: {
                paymentTypeBO = PaymentTypeBO.PERIODIC;
                break;
            }
            case BULK: {
                paymentTypeBO = PaymentTypeBO.BULK;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + paymentType);
            }
        }
        return paymentTypeBO;
    }

    @Override
    public PaymentTypeTO toPaymentTypeTO(PaymentTypeBO paymentType) {
        PaymentTypeTO paymentTypeTO;
        if (paymentType == null) {
            return null;
        }
        switch (paymentType) {
            case SINGLE: {
                paymentTypeTO = PaymentTypeTO.SINGLE;
                break;
            }
            case BULK: {
                paymentTypeTO = PaymentTypeTO.BULK;
                break;
            }
            case PERIODIC: {
                paymentTypeTO = PaymentTypeTO.PERIODIC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + paymentType);
            }
        }
        return paymentTypeTO;
    }

    @Override
    public PaymentProductBO toPaymentProductBO(PaymentProductTO paymentProduct) {
        PaymentProductBO paymentProductBO;
        if (paymentProduct == null) {
            return null;
        }
        switch (paymentProduct) {
            case SEPA: {
                paymentProductBO = PaymentProductBO.SEPA;
                break;
            }
            case INSTANT_SEPA: {
                paymentProductBO = PaymentProductBO.INSTANT_SEPA;
                break;
            }
            case TARGET2: {
                paymentProductBO = PaymentProductBO.TARGET2;
                break;
            }
            case CROSS_BORDER: {
                paymentProductBO = PaymentProductBO.CROSS_BORDER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + paymentProduct);
            }
        }
        return paymentProductBO;
    }

    @Override
    public PaymentProductTO toPaymentProductTO(PaymentProductBO paymentProduct) {
        PaymentProductTO paymentProductTO;
        if (paymentProduct == null) {
            return null;
        }
        switch (paymentProduct) {
            case SEPA: {
                paymentProductTO = PaymentProductTO.SEPA;
                break;
            }
            case INSTANT_SEPA: {
                paymentProductTO = PaymentProductTO.INSTANT_SEPA;
                break;
            }
            case TARGET2: {
                paymentProductTO = PaymentProductTO.TARGET2;
                break;
            }
            case CROSS_BORDER: {
                paymentProductTO = PaymentProductTO.CROSS_BORDER;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + paymentProduct);
            }
        }
        return paymentProductTO;
    }

    @Override
    public SinglePaymentTO toSinglePaymentTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if (payment == null && paymentTarget == null) {
            return null;
        }
        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();
        if (payment != null) {
            singlePaymentTO.setPaymentId(payment.getPaymentId());
            singlePaymentTO.setPaymentStatus(this.transactionStatusBOToTransactionStatusTO(payment.getTransactionStatus()));
            singlePaymentTO.setDebtorAccount(this.accountReferenceBOToAccountReferenceTO(payment.getDebtorAccount()));
            singlePaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
            singlePaymentTO.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        }
        if (paymentTarget != null) {
            singlePaymentTO.setEndToEndIdentification(paymentTarget.getEndToEndIdentification());
            singlePaymentTO.setInstructedAmount(this.amountBOToAmountTO(paymentTarget.getInstructedAmount()));
            singlePaymentTO.setCreditorAccount(this.accountReferenceBOToAccountReferenceTO(paymentTarget.getCreditorAccount()));
            singlePaymentTO.setCreditorAgent(paymentTarget.getCreditorAgent());
            singlePaymentTO.setCreditorName(paymentTarget.getCreditorName());
            singlePaymentTO.setCreditorAddress(this.addressBOToAddressTO(paymentTarget.getCreditorAddress()));
            singlePaymentTO.setRemittanceInformationUnstructured(paymentTarget.getRemittanceInformationUnstructured());
            singlePaymentTO.setPaymentProduct(this.toPaymentProductTO(paymentTarget.getPaymentProduct()));
        }
        return singlePaymentTO;
    }

    @Override
    public PeriodicPaymentTO toPeriodicPaymentTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if (payment == null && paymentTarget == null) {
            return null;
        }
        PeriodicPaymentTO periodicPaymentTO = new PeriodicPaymentTO();
        if (payment != null) {
            periodicPaymentTO.setPaymentId(payment.getPaymentId());
            periodicPaymentTO.setPaymentStatus(this.transactionStatusBOToTransactionStatusTO(payment.getTransactionStatus()));
            periodicPaymentTO.setDebtorAccount(this.accountReferenceBOToAccountReferenceTO(payment.getDebtorAccount()));
            periodicPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
            periodicPaymentTO.setRequestedExecutionTime(payment.getRequestedExecutionTime());
            periodicPaymentTO.setStartDate(payment.getStartDate());
            periodicPaymentTO.setEndDate(payment.getEndDate());
            periodicPaymentTO.setExecutionRule(payment.getExecutionRule());
            periodicPaymentTO.setFrequency(this.frequencyCodeBOToFrequencyCodeTO(payment.getFrequency()));
            periodicPaymentTO.setDayOfExecution(payment.getDayOfExecution());
        }
        if (paymentTarget != null) {
            periodicPaymentTO.setEndToEndIdentification(paymentTarget.getEndToEndIdentification());
            periodicPaymentTO.setInstructedAmount(this.amountBOToAmountTO(paymentTarget.getInstructedAmount()));
            periodicPaymentTO.setCreditorAccount(this.accountReferenceBOToAccountReferenceTO(paymentTarget.getCreditorAccount()));
            periodicPaymentTO.setCreditorAgent(paymentTarget.getCreditorAgent());
            periodicPaymentTO.setCreditorName(paymentTarget.getCreditorName());
            periodicPaymentTO.setCreditorAddress(this.addressBOToAddressTO(paymentTarget.getCreditorAddress()));
            periodicPaymentTO.setRemittanceInformationUnstructured(paymentTarget.getRemittanceInformationUnstructured());
            periodicPaymentTO.setPaymentProduct(this.toPaymentProductTO(paymentTarget.getPaymentProduct()));
        }
        return periodicPaymentTO;
    }

    @Override
    public BulkPaymentTO toBulkPaymentTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if (payment == null && paymentTarget == null) {
            return null;
        }
        BulkPaymentTO bulkPaymentTO = new BulkPaymentTO();
        if (payment != null) {
            bulkPaymentTO.setPaymentId(payment.getPaymentId());
            bulkPaymentTO.setPaymentStatus(this.transactionStatusBOToTransactionStatusTO(payment.getTransactionStatus()));
            bulkPaymentTO.setBatchBookingPreferred(payment.getBatchBookingPreferred());
            bulkPaymentTO.setDebtorAccount(this.accountReferenceBOToAccountReferenceTO(payment.getDebtorAccount()));
            bulkPaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        }
        bulkPaymentTO.setPaymentProduct(this.toPaymentProductTO(paymentTarget.getPaymentProduct()));
        bulkPaymentTO.setPayments(payment.getTargets().stream().map(t -> this.toSingleBulkPartTO(payment, (PaymentTargetBO)t)).collect(Collectors.toList()));
        return bulkPaymentTO;
    }

    @Override
    public SinglePaymentTO toSingleBulkPartTO(PaymentBO payment, PaymentTargetBO paymentTarget) {
        if (payment == null && paymentTarget == null) {
            return null;
        }
        SinglePaymentTO singlePaymentTO = new SinglePaymentTO();
        if (payment != null) {
            singlePaymentTO.setPaymentStatus(this.transactionStatusBOToTransactionStatusTO(payment.getTransactionStatus()));
            singlePaymentTO.setDebtorAccount(this.accountReferenceBOToAccountReferenceTO(payment.getDebtorAccount()));
            singlePaymentTO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
            singlePaymentTO.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        }
        if (paymentTarget != null) {
            singlePaymentTO.setPaymentId(paymentTarget.getPaymentId());
            singlePaymentTO.setEndToEndIdentification(paymentTarget.getEndToEndIdentification());
            singlePaymentTO.setInstructedAmount(this.amountBOToAmountTO(paymentTarget.getInstructedAmount()));
            singlePaymentTO.setCreditorAccount(this.accountReferenceBOToAccountReferenceTO(paymentTarget.getCreditorAccount()));
            singlePaymentTO.setCreditorAgent(paymentTarget.getCreditorAgent());
            singlePaymentTO.setCreditorName(paymentTarget.getCreditorName());
            singlePaymentTO.setCreditorAddress(this.addressBOToAddressTO(paymentTarget.getCreditorAddress()));
            singlePaymentTO.setRemittanceInformationUnstructured(paymentTarget.getRemittanceInformationUnstructured());
            singlePaymentTO.setPaymentProduct(this.toPaymentProductTO(paymentTarget.getPaymentProduct()));
        }
        return singlePaymentTO;
    }

    @Override
    public PaymentBO toPaymentBO(SinglePaymentTO payment) {
        if (payment == null) {
            return null;
        }
        PaymentBO paymentBO = new PaymentBO();
        paymentBO.setTransactionStatus(this.transactionStatusTOToTransactionStatusBO(payment.getPaymentStatus()));
        paymentBO.setPaymentId(payment.getPaymentId());
        paymentBO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        paymentBO.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        paymentBO.setDebtorAccount(this.accountReferenceTOToAccountReferenceBO(payment.getDebtorAccount()));
        paymentBO.setTargets(Collections.singletonList(this.toPaymentTarget(payment)));
        paymentBO.setPaymentType(PaymentTypeBO.SINGLE);
        return paymentBO;
    }

    @Override
    public PaymentBO toPaymentBO(PeriodicPaymentTO payment) {
        if (payment == null) {
            return null;
        }
        PaymentBO paymentBO = new PaymentBO();
        paymentBO.setTransactionStatus(this.transactionStatusTOToTransactionStatusBO(payment.getPaymentStatus()));
        paymentBO.setPaymentId(payment.getPaymentId());
        paymentBO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        paymentBO.setRequestedExecutionTime(payment.getRequestedExecutionTime());
        paymentBO.setStartDate(payment.getStartDate());
        paymentBO.setEndDate(payment.getEndDate());
        paymentBO.setExecutionRule(payment.getExecutionRule());
        paymentBO.setFrequency(this.frequencyCodeTOToFrequencyCodeBO(payment.getFrequency()));
        paymentBO.setDayOfExecution(payment.getDayOfExecution());
        paymentBO.setDebtorAccount(this.accountReferenceTOToAccountReferenceBO(payment.getDebtorAccount()));
        paymentBO.setTargets(Collections.singletonList(this.toPaymentTarget(payment)));
        paymentBO.setPaymentType(PaymentTypeBO.PERIODIC);
        return paymentBO;
    }

    @Override
    public PaymentBO toPaymentBO(BulkPaymentTO payment) {
        if (payment == null) {
            return null;
        }
        PaymentBO paymentBO = new PaymentBO();
        paymentBO.setTransactionStatus(this.transactionStatusTOToTransactionStatusBO(payment.getPaymentStatus()));
        paymentBO.setTargets(this.toPaymentTarget(payment.getPayments()));
        paymentBO.setPaymentId(payment.getPaymentId());
        paymentBO.setBatchBookingPreferred(payment.getBatchBookingPreferred());
        paymentBO.setRequestedExecutionDate(payment.getRequestedExecutionDate());
        paymentBO.setDebtorAccount(this.accountReferenceTOToAccountReferenceBO(payment.getDebtorAccount()));
        paymentBO.setRequestedExecutionTime((LocalTime)Optional.ofNullable(payment.getPayments()).map(l -> ((SinglePaymentTO)l.get(0)).getRequestedExecutionTime()).orElse(null));
        paymentBO.setPaymentType(PaymentTypeBO.BULK);
        return paymentBO;
    }

    @Override
    public PaymentTargetBO toPaymentTarget(SinglePaymentTO payment) {
        if (payment == null) {
            return null;
        }
        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();
        paymentTargetBO.setPaymentId(payment.getPaymentId());
        paymentTargetBO.setEndToEndIdentification(payment.getEndToEndIdentification());
        paymentTargetBO.setInstructedAmount(this.amountTOToAmountBO(payment.getInstructedAmount()));
        paymentTargetBO.setCreditorAccount(this.accountReferenceTOToAccountReferenceBO(payment.getCreditorAccount()));
        paymentTargetBO.setCreditorAgent(payment.getCreditorAgent());
        paymentTargetBO.setCreditorName(payment.getCreditorName());
        paymentTargetBO.setCreditorAddress(this.addressTOToAddressBO(payment.getCreditorAddress()));
        paymentTargetBO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        paymentTargetBO.setPaymentProduct(this.toPaymentProductBO(payment.getPaymentProduct()));
        return paymentTargetBO;
    }

    @Override
    public PaymentTargetBO toPaymentTarget(PeriodicPaymentTO payment) {
        if (payment == null) {
            return null;
        }
        PaymentTargetBO paymentTargetBO = new PaymentTargetBO();
        paymentTargetBO.setPaymentId(payment.getPaymentId());
        paymentTargetBO.setEndToEndIdentification(payment.getEndToEndIdentification());
        paymentTargetBO.setInstructedAmount(this.amountTOToAmountBO(payment.getInstructedAmount()));
        paymentTargetBO.setCreditorAccount(this.accountReferenceTOToAccountReferenceBO(payment.getCreditorAccount()));
        paymentTargetBO.setCreditorAgent(payment.getCreditorAgent());
        paymentTargetBO.setCreditorName(payment.getCreditorName());
        paymentTargetBO.setCreditorAddress(this.addressTOToAddressBO(payment.getCreditorAddress()));
        paymentTargetBO.setRemittanceInformationUnstructured(payment.getRemittanceInformationUnstructured());
        paymentTargetBO.setPaymentProduct(this.toPaymentProductBO(payment.getPaymentProduct()));
        return paymentTargetBO;
    }

    @Override
    public List<PaymentTargetBO> toPaymentTarget(List<SinglePaymentTO> payment) {
        if (payment == null) {
            return null;
        }
        ArrayList<PaymentTargetBO> list = new ArrayList<PaymentTargetBO>(payment.size());
        for (SinglePaymentTO singlePaymentTO : payment) {
            list.add(this.toPaymentTarget(singlePaymentTO));
        }
        return list;
    }

    @Override
    public List<TransactionTO> toTransactionTOList(List<TransactionDetailsBO> transactions) {
        if (transactions == null) {
            return null;
        }
        ArrayList<TransactionTO> list = new ArrayList<TransactionTO>(transactions.size());
        for (TransactionDetailsBO transactionDetailsBO : transactions) {
            list.add(this.toTransactionTO(transactionDetailsBO));
        }
        return list;
    }

    @Override
    public TransactionTO toTransactionTO(TransactionDetailsBO transaction) {
        if (transaction == null) {
            return null;
        }
        TransactionTO transactionTO = new TransactionTO();
        transactionTO.setAmount(this.amountBOToAmountTO(transaction.getTransactionAmount()));
        transactionTO.setTransactionId(transaction.getTransactionId());
        transactionTO.setEntryReference(transaction.getEntryReference());
        transactionTO.setEndToEndId(transaction.getEndToEndId());
        transactionTO.setMandateId(transaction.getMandateId());
        transactionTO.setCheckId(transaction.getCheckId());
        transactionTO.setCreditorId(transaction.getCreditorId());
        transactionTO.setBookingDate(transaction.getBookingDate());
        transactionTO.setValueDate(transaction.getValueDate());
        transactionTO.setExchangeRate(this.exchangeRateBOListToExchangeRateTOList(transaction.getExchangeRate()));
        transactionTO.setCreditorName(transaction.getCreditorName());
        transactionTO.setCreditorAccount(this.accountReferenceBOToAccountReferenceTO(transaction.getCreditorAccount()));
        transactionTO.setUltimateCreditor(transaction.getUltimateCreditor());
        transactionTO.setDebtorName(transaction.getDebtorName());
        transactionTO.setDebtorAccount(this.accountReferenceBOToAccountReferenceTO(transaction.getDebtorAccount()));
        transactionTO.setUltimateDebtor(transaction.getUltimateDebtor());
        transactionTO.setRemittanceInformationUnstructured(transaction.getRemittanceInformationUnstructured());
        transactionTO.setRemittanceInformationStructured(transaction.getRemittanceInformationStructured());
        if (transaction.getPurposeCode() != null) {
            transactionTO.setPurposeCode(transaction.getPurposeCode().name());
        }
        transactionTO.setBankTransactionCode(transaction.getBankTransactionCode());
        transactionTO.setProprietaryBankTransactionCode(transaction.getProprietaryBankTransactionCode());
        return transactionTO;
    }

    @Override
    public TransactionDetailsBO toTransactionDetailsBO(TransactionTO transaction) {
        if (transaction == null) {
            return null;
        }
        TransactionDetailsBO transactionDetailsBO = new TransactionDetailsBO();
        transactionDetailsBO.setTransactionAmount(this.amountTOToAmountBO(transaction.getAmount()));
        transactionDetailsBO.setTransactionId(transaction.getTransactionId());
        transactionDetailsBO.setEntryReference(transaction.getEntryReference());
        transactionDetailsBO.setEndToEndId(transaction.getEndToEndId());
        transactionDetailsBO.setMandateId(transaction.getMandateId());
        transactionDetailsBO.setCheckId(transaction.getCheckId());
        transactionDetailsBO.setCreditorId(transaction.getCreditorId());
        transactionDetailsBO.setBookingDate(transaction.getBookingDate());
        transactionDetailsBO.setValueDate(transaction.getValueDate());
        transactionDetailsBO.setExchangeRate(this.exchangeRateTOListToExchangeRateBOList(transaction.getExchangeRate()));
        transactionDetailsBO.setCreditorName(transaction.getCreditorName());
        transactionDetailsBO.setCreditorAccount(this.accountReferenceTOToAccountReferenceBO(transaction.getCreditorAccount()));
        transactionDetailsBO.setUltimateCreditor(transaction.getUltimateCreditor());
        transactionDetailsBO.setDebtorName(transaction.getDebtorName());
        transactionDetailsBO.setDebtorAccount(this.accountReferenceTOToAccountReferenceBO(transaction.getDebtorAccount()));
        transactionDetailsBO.setUltimateDebtor(transaction.getUltimateDebtor());
        transactionDetailsBO.setRemittanceInformationStructured(transaction.getRemittanceInformationStructured());
        transactionDetailsBO.setRemittanceInformationUnstructured(transaction.getRemittanceInformationUnstructured());
        if (transaction.getPurposeCode() != null) {
            transactionDetailsBO.setPurposeCode(Enum.valueOf(PurposeCodeBO.class, transaction.getPurposeCode()));
        }
        transactionDetailsBO.setBankTransactionCode(transaction.getBankTransactionCode());
        transactionDetailsBO.setProprietaryBankTransactionCode(transaction.getProprietaryBankTransactionCode());
        return transactionDetailsBO;
    }

    protected ResultStatusTO resultStatusBOToResultStatusTO(ResultStatusBO resultStatusBO) {
        ResultStatusTO resultStatusTO;
        if (resultStatusBO == null) {
            return null;
        }
        switch (resultStatusBO) {
            case SUCCESS: {
                resultStatusTO = ResultStatusTO.SUCCESS;
                break;
            }
            case TECHNICAL_FAILURE: {
                resultStatusTO = ResultStatusTO.TECHNICAL_FAILURE;
                break;
            }
            case UNAUTHORIZED_FAILURE: {
                resultStatusTO = ResultStatusTO.UNAUTHORIZED_FAILURE;
                break;
            }
            case LOGICAL_FAILURE: {
                resultStatusTO = ResultStatusTO.LOGICAL_FAILURE;
                break;
            }
            case NOT_SUPPORTED: {
                resultStatusTO = ResultStatusTO.NOT_SUPPORTED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + resultStatusBO);
            }
        }
        return resultStatusTO;
    }

    protected ResultStatusBO resultStatusTOToResultStatusBO(ResultStatusTO resultStatusTO) {
        ResultStatusBO resultStatusBO;
        if (resultStatusTO == null) {
            return null;
        }
        switch (resultStatusTO) {
            case SUCCESS: {
                resultStatusBO = ResultStatusBO.SUCCESS;
                break;
            }
            case TECHNICAL_FAILURE: {
                resultStatusBO = ResultStatusBO.TECHNICAL_FAILURE;
                break;
            }
            case UNAUTHORIZED_FAILURE: {
                resultStatusBO = ResultStatusBO.UNAUTHORIZED_FAILURE;
                break;
            }
            case LOGICAL_FAILURE: {
                resultStatusBO = ResultStatusBO.LOGICAL_FAILURE;
                break;
            }
            case NOT_SUPPORTED: {
                resultStatusBO = ResultStatusBO.NOT_SUPPORTED;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + resultStatusTO);
            }
        }
        return resultStatusBO;
    }

    protected TransactionStatusTO transactionStatusBOToTransactionStatusTO(TransactionStatusBO transactionStatusBO) {
        TransactionStatusTO transactionStatusTO;
        if (transactionStatusBO == null) {
            return null;
        }
        switch (transactionStatusBO) {
            case ACCC: {
                transactionStatusTO = TransactionStatusTO.ACCC;
                break;
            }
            case ACCP: {
                transactionStatusTO = TransactionStatusTO.ACCP;
                break;
            }
            case ACSC: {
                transactionStatusTO = TransactionStatusTO.ACSC;
                break;
            }
            case ACSP: {
                transactionStatusTO = TransactionStatusTO.ACSP;
                break;
            }
            case ACTC: {
                transactionStatusTO = TransactionStatusTO.ACTC;
                break;
            }
            case ACWC: {
                transactionStatusTO = TransactionStatusTO.ACWC;
                break;
            }
            case ACWP: {
                transactionStatusTO = TransactionStatusTO.ACWP;
                break;
            }
            case RCVD: {
                transactionStatusTO = TransactionStatusTO.RCVD;
                break;
            }
            case PDNG: {
                transactionStatusTO = TransactionStatusTO.PDNG;
                break;
            }
            case RJCT: {
                transactionStatusTO = TransactionStatusTO.RJCT;
                break;
            }
            case CANC: {
                transactionStatusTO = TransactionStatusTO.CANC;
                break;
            }
            case ACFC: {
                transactionStatusTO = TransactionStatusTO.ACFC;
                break;
            }
            case PATC: {
                transactionStatusTO = TransactionStatusTO.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatusBO);
            }
        }
        return transactionStatusTO;
    }

    protected AccountReferenceTO accountReferenceBOToAccountReferenceTO(AccountReferenceBO accountReferenceBO) {
        if (accountReferenceBO == null) {
            return null;
        }
        AccountReferenceTO accountReferenceTO = new AccountReferenceTO();
        accountReferenceTO.setIban(accountReferenceBO.getIban());
        accountReferenceTO.setBban(accountReferenceBO.getBban());
        accountReferenceTO.setPan(accountReferenceBO.getPan());
        accountReferenceTO.setMaskedPan(accountReferenceBO.getMaskedPan());
        accountReferenceTO.setMsisdn(accountReferenceBO.getMsisdn());
        accountReferenceTO.setCurrency(accountReferenceBO.getCurrency());
        return accountReferenceTO;
    }

    protected AmountTO amountBOToAmountTO(AmountBO amountBO) {
        if (amountBO == null) {
            return null;
        }
        AmountTO amountTO = new AmountTO();
        amountTO.setCurrency(amountBO.getCurrency());
        amountTO.setAmount(amountBO.getAmount());
        return amountTO;
    }

    protected AddressTO addressBOToAddressTO(AddressBO addressBO) {
        if (addressBO == null) {
            return null;
        }
        AddressTO addressTO = new AddressTO();
        addressTO.setStreet(addressBO.getStreet());
        addressTO.setBuildingNumber(addressBO.getBuildingNumber());
        addressTO.setCity(addressBO.getCity());
        addressTO.setPostalCode(addressBO.getPostalCode());
        addressTO.setCountry(addressBO.getCountry());
        return addressTO;
    }

    protected FrequencyCodeTO frequencyCodeBOToFrequencyCodeTO(FrequencyCodeBO frequencyCodeBO) {
        FrequencyCodeTO frequencyCodeTO;
        if (frequencyCodeBO == null) {
            return null;
        }
        switch (frequencyCodeBO) {
            case DAILY: {
                frequencyCodeTO = FrequencyCodeTO.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCodeTO = FrequencyCodeTO.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCodeTO = FrequencyCodeTO.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCodeTO = FrequencyCodeTO.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCodeTO = FrequencyCodeTO.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCodeTO = FrequencyCodeTO.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCodeTO = FrequencyCodeTO.ANNUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequencyCodeBO);
            }
        }
        return frequencyCodeTO;
    }

    protected TransactionStatusBO transactionStatusTOToTransactionStatusBO(TransactionStatusTO transactionStatusTO) {
        TransactionStatusBO transactionStatusBO;
        if (transactionStatusTO == null) {
            return null;
        }
        switch (transactionStatusTO) {
            case ACCC: {
                transactionStatusBO = TransactionStatusBO.ACCC;
                break;
            }
            case ACCP: {
                transactionStatusBO = TransactionStatusBO.ACCP;
                break;
            }
            case ACSC: {
                transactionStatusBO = TransactionStatusBO.ACSC;
                break;
            }
            case ACSP: {
                transactionStatusBO = TransactionStatusBO.ACSP;
                break;
            }
            case ACTC: {
                transactionStatusBO = TransactionStatusBO.ACTC;
                break;
            }
            case ACWC: {
                transactionStatusBO = TransactionStatusBO.ACWC;
                break;
            }
            case ACWP: {
                transactionStatusBO = TransactionStatusBO.ACWP;
                break;
            }
            case RCVD: {
                transactionStatusBO = TransactionStatusBO.RCVD;
                break;
            }
            case PDNG: {
                transactionStatusBO = TransactionStatusBO.PDNG;
                break;
            }
            case RJCT: {
                transactionStatusBO = TransactionStatusBO.RJCT;
                break;
            }
            case CANC: {
                transactionStatusBO = TransactionStatusBO.CANC;
                break;
            }
            case ACFC: {
                transactionStatusBO = TransactionStatusBO.ACFC;
                break;
            }
            case PATC: {
                transactionStatusBO = TransactionStatusBO.PATC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + transactionStatusTO);
            }
        }
        return transactionStatusBO;
    }

    protected AccountReferenceBO accountReferenceTOToAccountReferenceBO(AccountReferenceTO accountReferenceTO) {
        if (accountReferenceTO == null) {
            return null;
        }
        AccountReferenceBO accountReferenceBO = new AccountReferenceBO();
        accountReferenceBO.setIban(accountReferenceTO.getIban());
        accountReferenceBO.setBban(accountReferenceTO.getBban());
        accountReferenceBO.setPan(accountReferenceTO.getPan());
        accountReferenceBO.setMaskedPan(accountReferenceTO.getMaskedPan());
        accountReferenceBO.setMsisdn(accountReferenceTO.getMsisdn());
        accountReferenceBO.setCurrency(accountReferenceTO.getCurrency());
        return accountReferenceBO;
    }

    protected FrequencyCodeBO frequencyCodeTOToFrequencyCodeBO(FrequencyCodeTO frequencyCodeTO) {
        FrequencyCodeBO frequencyCodeBO;
        if (frequencyCodeTO == null) {
            return null;
        }
        switch (frequencyCodeTO) {
            case DAILY: {
                frequencyCodeBO = FrequencyCodeBO.DAILY;
                break;
            }
            case WEEKLY: {
                frequencyCodeBO = FrequencyCodeBO.WEEKLY;
                break;
            }
            case EVERYTWOWEEKS: {
                frequencyCodeBO = FrequencyCodeBO.EVERYTWOWEEKS;
                break;
            }
            case MONTHLY: {
                frequencyCodeBO = FrequencyCodeBO.MONTHLY;
                break;
            }
            case EVERYTWOMONTHS: {
                frequencyCodeBO = FrequencyCodeBO.EVERYTWOMONTHS;
                break;
            }
            case QUARTERLY: {
                frequencyCodeBO = FrequencyCodeBO.QUARTERLY;
                break;
            }
            case SEMIANNUAL: {
                frequencyCodeBO = FrequencyCodeBO.SEMIANNUAL;
                break;
            }
            case ANNUAL: {
                frequencyCodeBO = FrequencyCodeBO.ANNUAL;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected enum constant: " + frequencyCodeTO);
            }
        }
        return frequencyCodeBO;
    }

    protected AmountBO amountTOToAmountBO(AmountTO amountTO) {
        if (amountTO == null) {
            return null;
        }
        AmountBO amountBO = new AmountBO();
        amountBO.setCurrency(amountTO.getCurrency());
        amountBO.setAmount(amountTO.getAmount());
        return amountBO;
    }

    protected AddressBO addressTOToAddressBO(AddressTO addressTO) {
        if (addressTO == null) {
            return null;
        }
        AddressBO addressBO = new AddressBO();
        addressBO.setStreet(addressTO.getStreet());
        addressBO.setBuildingNumber(addressTO.getBuildingNumber());
        addressBO.setCity(addressTO.getCity());
        addressBO.setPostalCode(addressTO.getPostalCode());
        addressBO.setCountry(addressTO.getCountry());
        return addressBO;
    }

    protected ExchangeRateTO exchangeRateBOToExchangeRateTO(ExchangeRateBO exchangeRateBO) {
        if (exchangeRateBO == null) {
            return null;
        }
        ExchangeRateTO exchangeRateTO = new ExchangeRateTO();
        exchangeRateTO.setCurrencyFrom(exchangeRateBO.getCurrencyFrom());
        exchangeRateTO.setRateFrom(exchangeRateBO.getRateFrom());
        exchangeRateTO.setRateTo(exchangeRateBO.getRateTo());
        exchangeRateTO.setRateDate(exchangeRateBO.getRateDate());
        exchangeRateTO.setRateContract(exchangeRateBO.getRateContract());
        return exchangeRateTO;
    }

    protected List<ExchangeRateTO> exchangeRateBOListToExchangeRateTOList(List<ExchangeRateBO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ExchangeRateTO> list1 = new ArrayList<ExchangeRateTO>(list.size());
        for (ExchangeRateBO exchangeRateBO : list) {
            list1.add(this.exchangeRateBOToExchangeRateTO(exchangeRateBO));
        }
        return list1;
    }

    protected ExchangeRateBO exchangeRateTOToExchangeRateBO(ExchangeRateTO exchangeRateTO) {
        if (exchangeRateTO == null) {
            return null;
        }
        ExchangeRateBO exchangeRateBO = new ExchangeRateBO();
        exchangeRateBO.setCurrencyFrom(exchangeRateTO.getCurrencyFrom());
        exchangeRateBO.setRateFrom(exchangeRateTO.getRateFrom());
        exchangeRateBO.setRateTo(exchangeRateTO.getRateTo());
        exchangeRateBO.setRateDate(exchangeRateTO.getRateDate());
        exchangeRateBO.setRateContract(exchangeRateTO.getRateContract());
        return exchangeRateBO;
    }

    protected List<ExchangeRateBO> exchangeRateTOListToExchangeRateBOList(List<ExchangeRateTO> list) {
        if (list == null) {
            return null;
        }
        ArrayList<ExchangeRateBO> list1 = new ArrayList<ExchangeRateBO>(list.size());
        for (ExchangeRateTO exchangeRateTO : list) {
            list1.add(this.exchangeRateTOToExchangeRateBO(exchangeRateTO));
        }
        return list1;
    }
}

