/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentProductBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentResultBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTargetBO;
import de.adorsys.ledgers.deposit.api.domain.PaymentTypeBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.BulkPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentProductTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentResultTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PeriodicPaymentTO;
import de.adorsys.ledgers.middleware.api.domain.payment.SinglePaymentTO;
import java.util.List;
import java.util.Map;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.springframework.beans.factory.annotation.Autowired;

@Mapper(componentModel="spring")
public abstract class PaymentConverter {
    @Autowired
    private ObjectMapper mapper;

    public abstract PaymentResultTO toPaymentResultTO(PaymentResultBO var1);

    public abstract PaymentResultBO toPaymentResultBO(PaymentResultTO var1);

    public abstract PaymentTypeBO toPaymentTypeBO(PaymentTypeTO var1);

    public abstract PaymentTypeTO toPaymentTypeTO(PaymentTypeBO var1);

    public abstract PaymentProductBO toPaymentProductBO(PaymentProductTO var1);

    public abstract PaymentProductTO toPaymentProductTO(PaymentProductBO var1);

    public Object toPaymentTO(PaymentBO payment) {
        if (payment.getPaymentType() == PaymentTypeBO.SINGLE) {
            return this.toSinglePaymentTO(payment, (PaymentTargetBO)payment.getTargets().get(0));
        }
        if (payment.getPaymentType() == PaymentTypeBO.PERIODIC) {
            return this.toPeriodicPaymentTO(payment, (PaymentTargetBO)payment.getTargets().get(0));
        }
        return this.toBulkPaymentTO(payment, (PaymentTargetBO)payment.getTargets().get(0));
    }

    @Mappings(value={@Mapping(source="payment.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus")})
    public abstract SinglePaymentTO toSinglePaymentTO(PaymentBO var1, PaymentTargetBO var2);

    @Mappings(value={@Mapping(source="payment.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus")})
    public abstract PeriodicPaymentTO toPeriodicPaymentTO(PaymentBO var1, PaymentTargetBO var2);

    @Mappings(value={@Mapping(source="payment.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus"), @Mapping(target="paymentProduct", expression="java(toPaymentProductTO(paymentTarget.getPaymentProduct()))"), @Mapping(target="payments", expression="java(payment.getTargets().stream().map(t -> toSingleBulkPartTO(payment, t)).collect(java.util.stream.Collectors.toList()))")})
    public abstract BulkPaymentTO toBulkPaymentTO(PaymentBO var1, PaymentTargetBO var2);

    @Mappings(value={@Mapping(source="paymentTarget.paymentId", target="paymentId"), @Mapping(source="payment.transactionStatus", target="paymentStatus")})
    public abstract SinglePaymentTO toSingleBulkPartTO(PaymentBO var1, PaymentTargetBO var2);

    public <T> PaymentBO toPaymentBO(Object payment, Class<T> tClass) {
        Object o = payment;
        if (o instanceof Map) {
            Map map = (Map)o;
            if (map.size() == 1) {
                map = (Map)map.values().iterator().next();
            }
            o = map;
        }
        if (tClass.equals(SinglePaymentTO.class)) {
            return this.toPaymentBO((SinglePaymentTO)this.mapper.convertValue(o, tClass));
        }
        if (tClass.equals(PeriodicPaymentTO.class)) {
            return this.toPaymentBO((PeriodicPaymentTO)this.mapper.convertValue(o, tClass));
        }
        if (tClass.equals(BulkPaymentTO.class)) {
            BulkPaymentTO paymentTO = (BulkPaymentTO)this.mapper.convertValue(o, tClass);
            PaymentBO paymentBO = this.toPaymentBO(paymentTO);
            paymentBO.getTargets().forEach(t -> {
                if (t.getPaymentProduct() == null) {
                    t.setPaymentProduct(this.toPaymentProductBO(paymentTO.getPaymentProduct()));
                }
            });
            return paymentBO;
        }
        throw new IllegalStateException(String.format("Unknown payment type %s", tClass.getName()));
    }

    @Mappings(value={@Mapping(target="paymentType", expression="java(PaymentTypeBO.SINGLE)"), @Mapping(source="paymentStatus", target="transactionStatus"), @Mapping(target="targets", expression="java(java.util.Collections.singletonList(toPaymentTarget(payment)))")})
    public abstract PaymentBO toPaymentBO(SinglePaymentTO var1);

    @Mappings(value={@Mapping(target="paymentType", expression="java(PaymentTypeBO.PERIODIC)"), @Mapping(source="paymentStatus", target="transactionStatus"), @Mapping(target="targets", expression="java(java.util.Collections.singletonList(toPaymentTarget(payment)))")})
    public abstract PaymentBO toPaymentBO(PeriodicPaymentTO var1);

    @Mappings(value={@Mapping(target="paymentType", expression="java(PaymentTypeBO.BULK)"), @Mapping(target="requestedExecutionTime", expression="java(java.util.Optional.ofNullable(payment.getPayments()).map(l -> l.get(0).getRequestedExecutionTime()).orElse(null))"), @Mapping(source="paymentStatus", target="transactionStatus"), @Mapping(target="targets", source="payment.payments")})
    public abstract PaymentBO toPaymentBO(BulkPaymentTO var1);

    public abstract PaymentTargetBO toPaymentTarget(SinglePaymentTO var1);

    public abstract PaymentTargetBO toPaymentTarget(PeriodicPaymentTO var1);

    public abstract List<PaymentTargetBO> toPaymentTarget(List<SinglePaymentTO> var1);

    public abstract List<TransactionTO> toTransactionTOList(List<TransactionDetailsBO> var1);

    @Mapping(source="transactionAmount", target="amount")
    public abstract TransactionTO toTransactionTO(TransactionDetailsBO var1);

    @Mapping(target="transactionAmount", source="amount")
    public abstract TransactionDetailsBO toTransactionDetailsBO(TransactionTO var1);
}

