/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaInfoTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.service.UserService;
import java.time.LocalDateTime;
import java.util.List;
import org.mapstruct.factory.Mappers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareUserManagementServiceImpl
implements MiddlewareUserManagementService {
    private static final Logger log = LoggerFactory.getLogger(MiddlewareUserManagementServiceImpl.class);
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final AccessService accessService;
    private final UserMapper userTOMapper = (UserMapper)Mappers.getMapper(UserMapper.class);

    public UserTO create(UserTO user) {
        UserBO userBO = this.userTOMapper.toUserBO(user);
        return this.userTOMapper.toUserTO(this.userService.create(userBO));
    }

    public UserTO findById(String id) {
        return this.userTOMapper.toUserTO(this.userService.findById(id));
    }

    public UserTO findByUserLogin(String userLogin) {
        return this.userTOMapper.toUserTO(this.userService.findByLogin(userLogin));
    }

    public UserTO updateScaData(String userLogin, List<ScaUserDataTO> scaDataList) {
        UserBO userBO = this.userService.updateScaData(this.userTOMapper.toScaUserDataListBO(scaDataList), userLogin);
        return this.userTOMapper.toUserTO(userBO);
    }

    public void updateAccountAccess(ScaInfoTO scaInfo, String userId, AccountAccessTO access) {
        this.depositAccountService.getDepositAccountByIban(access.getIban(), LocalDateTime.now(), false);
        UserTO branch = this.findById(scaInfo.getUserId());
        boolean tppHasAccessToAccount = this.accessService.userHasAccessToAccount(branch, access.getIban());
        if (!tppHasAccessToAccount) {
            log.error("Branch: {} has no access to account: {}", (Object)branch.getLogin(), (Object)access.getIban());
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Current Branch does have no access to the requested account: %s", access.getIban())).build();
        }
        UserTO user = this.findById(userId);
        if (!branch.getBranch().equals(user.getBranch())) {
            log.error("User id: {} with Branch: {} is not from branch: {}", new Object[]{user.getId(), user.getBranch(), branch.getLogin()});
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.INSUFFICIENT_PERMISSION).devMsg(String.format("Requested user: %s is not a part of the branch: %s", user.getLogin(), scaInfo.getUserLogin())).build();
        }
        this.accessService.updateAccountAccess(this.userTOMapper.toUserBO(user), this.userTOMapper.toAccountAccessBO(access));
    }

    public List<UserTO> listUsers(int page, int size) {
        return this.userTOMapper.toUserTOList(this.userService.listUsers(page, size));
    }

    public List<UserTO> getUsersByBranchAndRoles(String branch, List<UserRoleTO> roles) {
        List users = this.userService.findByBranchAndUserRolesIn(branch, this.userTOMapper.toUserRoleBO(roles));
        return this.userTOMapper.toUserTOList(users);
    }

    public int countUsersByBranch(String branch) {
        return this.userService.countUsersByBranch(branch);
    }

    public MiddlewareUserManagementServiceImpl(UserService userService, DepositAccountService depositAccountService, AccessService accessService) {
        this.userService = userService;
        this.depositAccountService = depositAccountService;
        this.accessService = accessService;
    }
}

