/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.policies;

import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import de.adorsys.ledgers.middleware.api.exception.MiddlewareModuleException;
import java.util.EnumSet;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class PaymentCancelPolicy {
    private final Set<TransactionStatusTO> FINAL_STATUSES = EnumSet.of(TransactionStatusTO.ACSC, TransactionStatusTO.RJCT, TransactionStatusTO.CANC);

    public void onCancel(String paymentId, TransactionStatusTO originalTxStatus) {
        if (this.FINAL_STATUSES.contains(originalTxStatus)) {
            throw MiddlewareModuleException.builder().errorCode(MiddlewareErrorCode.PAYMENT_PROCESSING_FAILURE).devMsg(String.format("Request for payment cancellation is forbidden as the payment with id:%s has status:%s", paymentId, originalTxStatus)).build();
        }
    }
}

