package de.adorsys.ledgers.middleware.impl.converter;

import de.adorsys.ledgers.middleware.api.domain.um.AccessTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaMethodTypeTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.ScaMethodTypeBO;
import de.adorsys.ledgers.um.api.domain.ScaUserDataBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2019-07-05T14:45:39+0000",
    comments = "version: 1.3.0.Final, compiler: javac, environment: Java 1.8.0_151 (Oracle Corporation)"
)
@Component
public class UserMapperImpl implements UserMapper {

    @Override
    public UserTO toUserTO(UserBO user) {
        if ( user == null ) {
            return null;
        }

        UserTO userTO = new UserTO();

        userTO.setId( user.getId() );
        userTO.setLogin( user.getLogin() );
        userTO.setEmail( user.getEmail() );
        userTO.setPin( user.getPin() );
        userTO.setScaUserData( toScaUserDataListTO( user.getScaUserData() ) );
        userTO.setAccountAccesses( toAccountAccessListTO( user.getAccountAccesses() ) );
        userTO.setUserRoles( userRoleBOCollectionToUserRoleTOCollection( user.getUserRoles() ) );
        userTO.setBranch( user.getBranch() );

        return userTO;
    }

    @Override
    public UserBO toUserBO(UserTO user) {
        if ( user == null ) {
            return null;
        }

        UserBO userBO = new UserBO();

        userBO.setId( user.getId() );
        userBO.setLogin( user.getLogin() );
        userBO.setEmail( user.getEmail() );
        userBO.setPin( user.getPin() );
        userBO.setScaUserData( toScaUserDataListBO( user.getScaUserData() ) );
        userBO.setAccountAccesses( toAccountAccessListBO( user.getAccountAccesses() ) );
        userBO.setUserRoles( userRoleTOCollectionToUserRoleBOCollection( user.getUserRoles() ) );
        userBO.setBranch( user.getBranch() );

        return userBO;
    }

    @Override
    public List<UserTO> toUserTOList(List<UserBO> listUsers) {
        if ( listUsers == null ) {
            return null;
        }

        List<UserTO> list = new ArrayList<UserTO>( listUsers.size() );
        for ( UserBO userBO : listUsers ) {
            list.add( toUserTO( userBO ) );
        }

        return list;
    }

    @Override
    public List<UserBO> toUserBOList(List<UserTO> listUsers) {
        if ( listUsers == null ) {
            return null;
        }

        List<UserBO> list = new ArrayList<UserBO>( listUsers.size() );
        for ( UserTO userTO : listUsers ) {
            list.add( toUserBO( userTO ) );
        }

        return list;
    }

    @Override
    public ScaUserDataBO toScaUserDataBO(ScaUserDataTO userData) {
        if ( userData == null ) {
            return null;
        }

        ScaUserDataBO scaUserDataBO = new ScaUserDataBO();

        scaUserDataBO.setId( userData.getId() );
        scaUserDataBO.setScaMethod( scaMethodTypeTOToScaMethodTypeBO( userData.getScaMethod() ) );
        scaUserDataBO.setMethodValue( userData.getMethodValue() );

        return scaUserDataBO;
    }

    @Override
    public ScaUserDataTO toScaUserDataTO(ScaUserDataBO bo) {
        if ( bo == null ) {
            return null;
        }

        ScaUserDataTO scaUserDataTO = new ScaUserDataTO();

        scaUserDataTO.setId( bo.getId() );
        scaUserDataTO.setScaMethod( scaMethodTypeBOToScaMethodTypeTO( bo.getScaMethod() ) );
        scaUserDataTO.setMethodValue( bo.getMethodValue() );

        return scaUserDataTO;
    }

    @Override
    public List<ScaUserDataBO> toScaUserDataListBO(List<ScaUserDataTO> list) {
        if ( list == null ) {
            return null;
        }

        List<ScaUserDataBO> list1 = new ArrayList<ScaUserDataBO>( list.size() );
        for ( ScaUserDataTO scaUserDataTO : list ) {
            list1.add( toScaUserDataBO( scaUserDataTO ) );
        }

        return list1;
    }

    @Override
    public List<ScaUserDataTO> toScaUserDataListTO(List<ScaUserDataBO> bos) {
        if ( bos == null ) {
            return null;
        }

        List<ScaUserDataTO> list = new ArrayList<ScaUserDataTO>( bos.size() );
        for ( ScaUserDataBO scaUserDataBO : bos ) {
            list.add( toScaUserDataTO( scaUserDataBO ) );
        }

        return list;
    }

    @Override
    public AccountAccessBO toAccountAccessBO(AccountAccessTO userData) {
        if ( userData == null ) {
            return null;
        }

        AccountAccessBO accountAccessBO = new AccountAccessBO();

        accountAccessBO.setId( userData.getId() );
        accountAccessBO.setIban( userData.getIban() );
        accountAccessBO.setAccessType( accessTypeTOToAccessTypeBO( userData.getAccessType() ) );

        return accountAccessBO;
    }

    @Override
    public AccountAccessTO toAccountAccessTO(AccountAccessBO bo) {
        if ( bo == null ) {
            return null;
        }

        AccountAccessTO accountAccessTO = new AccountAccessTO();

        accountAccessTO.setId( bo.getId() );
        accountAccessTO.setIban( bo.getIban() );
        accountAccessTO.setAccessType( accessTypeBOToAccessTypeTO( bo.getAccessType() ) );

        return accountAccessTO;
    }

    @Override
    public List<AccountAccessBO> toAccountAccessListBO(List<AccountAccessTO> list) {
        if ( list == null ) {
            return null;
        }

        List<AccountAccessBO> list1 = new ArrayList<AccountAccessBO>( list.size() );
        for ( AccountAccessTO accountAccessTO : list ) {
            list1.add( toAccountAccessBO( accountAccessTO ) );
        }

        return list1;
    }

    @Override
    public List<AccountAccessTO> toAccountAccessListTO(List<AccountAccessBO> bos) {
        if ( bos == null ) {
            return null;
        }

        List<AccountAccessTO> list = new ArrayList<AccountAccessTO>( bos.size() );
        for ( AccountAccessBO accountAccessBO : bos ) {
            list.add( toAccountAccessTO( accountAccessBO ) );
        }

        return list;
    }

    @Override
    public List<UserRoleTO> toUserRoleTO(List<UserRoleBO> userRoles) {
        if ( userRoles == null ) {
            return null;
        }

        List<UserRoleTO> list = new ArrayList<UserRoleTO>( userRoles.size() );
        for ( UserRoleBO userRoleBO : userRoles ) {
            list.add( userRoleBOToUserRoleTO( userRoleBO ) );
        }

        return list;
    }

    @Override
    public List<UserRoleBO> toUserRoleBO(List<UserRoleTO> userRoles) {
        if ( userRoles == null ) {
            return null;
        }

        List<UserRoleBO> list = new ArrayList<UserRoleBO>( userRoles.size() );
        for ( UserRoleTO userRoleTO : userRoles ) {
            list.add( userRoleTOToUserRoleBO( userRoleTO ) );
        }

        return list;
    }

    protected UserRoleTO userRoleBOToUserRoleTO(UserRoleBO userRoleBO) {
        if ( userRoleBO == null ) {
            return null;
        }

        UserRoleTO userRoleTO;

        switch ( userRoleBO ) {
            case CUSTOMER: userRoleTO = UserRoleTO.CUSTOMER;
            break;
            case STAFF: userRoleTO = UserRoleTO.STAFF;
            break;
            case TECHNICAL: userRoleTO = UserRoleTO.TECHNICAL;
            break;
            case SYSTEM: userRoleTO = UserRoleTO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRoleBO );
        }

        return userRoleTO;
    }

    protected Collection<UserRoleTO> userRoleBOCollectionToUserRoleTOCollection(Collection<UserRoleBO> collection) {
        if ( collection == null ) {
            return null;
        }

        Collection<UserRoleTO> collection1 = new ArrayList<UserRoleTO>( collection.size() );
        for ( UserRoleBO userRoleBO : collection ) {
            collection1.add( userRoleBOToUserRoleTO( userRoleBO ) );
        }

        return collection1;
    }

    protected UserRoleBO userRoleTOToUserRoleBO(UserRoleTO userRoleTO) {
        if ( userRoleTO == null ) {
            return null;
        }

        UserRoleBO userRoleBO;

        switch ( userRoleTO ) {
            case CUSTOMER: userRoleBO = UserRoleBO.CUSTOMER;
            break;
            case STAFF: userRoleBO = UserRoleBO.STAFF;
            break;
            case TECHNICAL: userRoleBO = UserRoleBO.TECHNICAL;
            break;
            case SYSTEM: userRoleBO = UserRoleBO.SYSTEM;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + userRoleTO );
        }

        return userRoleBO;
    }

    protected Collection<UserRoleBO> userRoleTOCollectionToUserRoleBOCollection(Collection<UserRoleTO> collection) {
        if ( collection == null ) {
            return null;
        }

        Collection<UserRoleBO> collection1 = new ArrayList<UserRoleBO>( collection.size() );
        for ( UserRoleTO userRoleTO : collection ) {
            collection1.add( userRoleTOToUserRoleBO( userRoleTO ) );
        }

        return collection1;
    }

    protected ScaMethodTypeBO scaMethodTypeTOToScaMethodTypeBO(ScaMethodTypeTO scaMethodTypeTO) {
        if ( scaMethodTypeTO == null ) {
            return null;
        }

        ScaMethodTypeBO scaMethodTypeBO;

        switch ( scaMethodTypeTO ) {
            case EMAIL: scaMethodTypeBO = ScaMethodTypeBO.EMAIL;
            break;
            case MOBILE: scaMethodTypeBO = ScaMethodTypeBO.MOBILE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaMethodTypeTO );
        }

        return scaMethodTypeBO;
    }

    protected ScaMethodTypeTO scaMethodTypeBOToScaMethodTypeTO(ScaMethodTypeBO scaMethodTypeBO) {
        if ( scaMethodTypeBO == null ) {
            return null;
        }

        ScaMethodTypeTO scaMethodTypeTO;

        switch ( scaMethodTypeBO ) {
            case EMAIL: scaMethodTypeTO = ScaMethodTypeTO.EMAIL;
            break;
            case MOBILE: scaMethodTypeTO = ScaMethodTypeTO.MOBILE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + scaMethodTypeBO );
        }

        return scaMethodTypeTO;
    }

    protected AccessTypeBO accessTypeTOToAccessTypeBO(AccessTypeTO accessTypeTO) {
        if ( accessTypeTO == null ) {
            return null;
        }

        AccessTypeBO accessTypeBO;

        switch ( accessTypeTO ) {
            case OWNER: accessTypeBO = AccessTypeBO.OWNER;
            break;
            case READ: accessTypeBO = AccessTypeBO.READ;
            break;
            case DISPOSE: accessTypeBO = AccessTypeBO.DISPOSE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accessTypeTO );
        }

        return accessTypeBO;
    }

    protected AccessTypeTO accessTypeBOToAccessTypeTO(AccessTypeBO accessTypeBO) {
        if ( accessTypeBO == null ) {
            return null;
        }

        AccessTypeTO accessTypeTO;

        switch ( accessTypeBO ) {
            case OWNER: accessTypeTO = AccessTypeTO.OWNER;
            break;
            case READ: accessTypeTO = AccessTypeTO.READ;
            break;
            case DISPOSE: accessTypeTO = AccessTypeTO.DISPOSE;
            break;
            default: throw new IllegalArgumentException( "Unexpected enum constant: " + accessTypeBO );
        }

        return accessTypeTO;
    }
}
