/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.exception.DepositAccountNotFoundException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.UserAlreadyExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareUserManagementService;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.exception.UserAlreadyExistsException;
import de.adorsys.ledgers.um.api.exception.UserNotFoundException;
import de.adorsys.ledgers.um.api.service.UserService;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareUserManagementServiceImpl
implements MiddlewareUserManagementService {
    private static final Logger logger = LoggerFactory.getLogger(MiddlewareUserManagementServiceImpl.class);
    private final UserService userService;
    private final DepositAccountService depositAccountService;
    private final UserMapper userTOMapper;

    @Autowired
    public MiddlewareUserManagementServiceImpl(UserService userService, UserMapper userTOMapper, DepositAccountService depositAccountService) {
        this.userService = userService;
        this.userTOMapper = userTOMapper;
        this.depositAccountService = depositAccountService;
    }

    public UserTO create(UserTO user) throws UserAlreadyExistsMiddlewareException {
        UserBO userBO = this.userTOMapper.toUserBO(user);
        try {
            return this.userTOMapper.toUserTO(this.userService.create(userBO));
        }
        catch (UserAlreadyExistsException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserAlreadyExistsMiddlewareException(user, (Throwable)e);
        }
    }

    public UserTO findById(String id) throws UserNotFoundMiddlewareException {
        try {
            return this.userTOMapper.toUserTO(this.userService.findById(id));
        }
        catch (UserNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public UserTO findByUserLogin(String userLogin) throws UserNotFoundMiddlewareException {
        try {
            return this.userTOMapper.toUserTO(this.userService.findByLogin(userLogin));
        }
        catch (UserNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public UserTO updateScaData(String userLogin, List<ScaUserDataTO> scaDataList) throws UserNotFoundMiddlewareException {
        try {
            UserBO userBO = this.userService.updateScaData(this.userTOMapper.toScaUserDataListBO(scaDataList), userLogin);
            return this.userTOMapper.toUserTO(userBO);
        }
        catch (UserNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public UserTO updateAccountAccess(String userLogin, List<AccountAccessTO> accounts) throws UserNotFoundMiddlewareException {
        try {
            for (AccountAccessTO account : accounts) {
                this.depositAccountService.getDepositAccountByIban(account.getIban(), LocalDateTime.now(), false);
            }
            UserBO userBO = this.userService.updateAccountAccess(userLogin, this.userTOMapper.toAccountAccessListBO(accounts));
            return this.userTOMapper.toUserTO(userBO);
        }
        catch (DepositAccountNotFoundException | UserNotFoundException e) {
            logger.error(e.getMessage(), e);
            throw new UserNotFoundMiddlewareException(e.getMessage(), e);
        }
    }

    public List<UserTO> listUsers(int page, int size) {
        return this.userTOMapper.toUserTOList(this.userService.listUsers(page, size));
    }
}

