/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.PaymentBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionStatusBO;
import de.adorsys.ledgers.deposit.api.exception.DepositAccountNotFoundException;
import de.adorsys.ledgers.deposit.api.exception.PaymentNotFoundException;
import de.adorsys.ledgers.deposit.api.exception.PaymentWithIdExistsException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountPaymentService;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentCoreDataTO;
import de.adorsys.ledgers.middleware.api.domain.payment.PaymentTypeTO;
import de.adorsys.ledgers.middleware.api.domain.payment.TransactionStatusTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAPaymentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.AccountMiddlewareUncheckedException;
import de.adorsys.ledgers.middleware.api.exception.AccountNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.NoAccessMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentProcessingMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentWithIdMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAMethodNotSupportedMiddleException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationExpiredMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationUsedOrStolenMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationValidationMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserScaDataNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewarePaymentService;
import de.adorsys.ledgers.middleware.impl.converter.AccessTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCancelPolicy;
import de.adorsys.ledgers.middleware.impl.policies.PaymentCoreDataPolicy;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.exception.SCAMethodNotSupportedException;
import de.adorsys.ledgers.sca.exception.SCAOperationExpiredException;
import de.adorsys.ledgers.sca.exception.SCAOperationNotFoundException;
import de.adorsys.ledgers.sca.exception.SCAOperationUsedOrStolenException;
import de.adorsys.ledgers.sca.exception.SCAOperationValidationException;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AccessTokenBO;
import de.adorsys.ledgers.um.api.domain.AisAccountAccessInfoBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.exception.InsufficientPermissionException;
import de.adorsys.ledgers.um.api.exception.UserScaDataNotFoundException;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.Ids;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewarePaymentServiceImpl
implements MiddlewarePaymentService {
    private static final String PAYMENT_WITH_ID_S_NOT_FOUND = "Payment with id %s, not found";
    private static final Logger logger = LoggerFactory.getLogger(MiddlewarePaymentServiceImpl.class);
    private final DepositAccountPaymentService paymentService;
    private final SCAOperationService scaOperationService;
    private final DepositAccountService accountService;
    private final PaymentConverter paymentConverter;
    private final AccessTokenTO accessTokenTO;
    private final BearerTokenMapper bearerTokenMapper;
    private final AccessTokenMapper accessTokenMapper;
    private final UserService userService;
    private final SCAUtils scaUtils;
    private final PaymentCancelPolicy cancelPolicy;
    private final PaymentCoreDataPolicy coreDataPolicy;
    private int defaultLoginTokenExpireInSeconds = 600;

    public MiddlewarePaymentServiceImpl(DepositAccountPaymentService paymentService, SCAOperationService scaOperationService, DepositAccountService accountService, PaymentConverter paymentConverter, AccessTokenTO accessTokenTO, BearerTokenMapper bearerTokenMapper, AccessTokenMapper accessTokenMapper, UserService userService, SCAUtils scaUtils, PaymentCancelPolicy cancelPolicy, PaymentCoreDataPolicy coreDataPolicy) {
        this.paymentService = paymentService;
        this.scaOperationService = scaOperationService;
        this.accountService = accountService;
        this.paymentConverter = paymentConverter;
        this.accessTokenTO = accessTokenTO;
        this.bearerTokenMapper = bearerTokenMapper;
        this.accessTokenMapper = accessTokenMapper;
        this.userService = userService;
        this.scaUtils = scaUtils;
        this.cancelPolicy = cancelPolicy;
        this.coreDataPolicy = coreDataPolicy;
    }

    public TransactionStatusTO getPaymentStatusById(String paymentId) throws PaymentNotFoundMiddlewareException {
        try {
            TransactionStatusBO paymentStatus = this.paymentService.getPaymentStatusById(paymentId);
            return TransactionStatusTO.valueOf((String)paymentStatus.name());
        }
        catch (PaymentNotFoundException e) {
            logger.error("Payment with id=" + paymentId + " not found", (Throwable)e);
            throw new PaymentNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public SCAPaymentResponseTO initiatePaymentCancellation(String paymentId) throws PaymentNotFoundMiddlewareException, PaymentProcessingMiddlewareException {
        UserBO userBO = this.scaUtils.userBO();
        PaymentBO paymentBO = this.payment(paymentId);
        TransactionStatusTO originalTxStatus = TransactionStatusTO.valueOf((String)paymentBO.getTransactionStatus().name());
        this.cancelPolicy.onCancel(paymentId, originalTxStatus);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(paymentBO);
        SCAPaymentResponseTO response = this.prepareSCA(userBO, paymentBO, paymentKeyData, OpTypeBO.CANCEL_PAYMENT);
        if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
            try {
                TransactionStatusBO cancelPayment = this.paymentService.cancelPayment(paymentId);
                response.setTransactionStatus(TransactionStatusTO.valueOf((String)cancelPayment.name()));
            }
            catch (PaymentNotFoundException e) {
                throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
            }
        }
        return response;
    }

    public <T> SCAPaymentResponseTO initiatePayment(T payment, PaymentTypeTO paymentType) throws AccountNotFoundMiddlewareException, NoAccessMiddlewareException, PaymentWithIdMiddlewareException {
        PaymentBO paymentBO = this.paymentConverter.toPaymentBO(payment, paymentType.getPaymentClass());
        UserBO userBO = this.scaUtils.userBO();
        this.checkDepositAccount(paymentBO);
        TransactionStatusBO status = this.scaUtils.hasSCA(userBO) ? TransactionStatusBO.ACCP : TransactionStatusBO.ACTC;
        paymentBO = this.persist(paymentBO, status);
        status = paymentBO.getTransactionStatus();
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        if (TransactionStatusBO.RJCT.equals((Object)status)) {
            response.setScaStatus(ScaStatusTO.FAILED);
            response.setTransactionStatus(TransactionStatusTO.valueOf((String)status.name()));
            response.setPaymentId(paymentBO.getPaymentId());
        } else {
            PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(paymentBO);
            response = this.prepareSCA(userBO, paymentBO, paymentKeyData, OpTypeBO.PAYMENT);
            if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
                try {
                    status = this.paymentService.updatePaymentStatusToAuthorised(paymentBO.getPaymentId());
                    response.setTransactionStatus(TransactionStatusTO.valueOf((String)status.name()));
                    status = this.paymentService.executePayment(paymentBO.getPaymentId(), userBO.getLogin());
                    response.setTransactionStatus(TransactionStatusTO.valueOf((String)status.name()));
                    BearerTokenTO paymentAccountAccessToken = this.paymentAccountAccessToken(paymentBO);
                    response.setBearerToken(paymentAccountAccessToken);
                }
                catch (PaymentNotFoundException e) {
                    throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
                }
            }
        }
        return response;
    }

    private PaymentBO persist(PaymentBO paymentBO, TransactionStatusBO status) throws PaymentWithIdMiddlewareException {
        if (paymentBO.getPaymentId() == null) {
            paymentBO.setPaymentId(Ids.id());
        }
        try {
            return this.paymentService.initiatePayment(paymentBO, status);
        }
        catch (PaymentWithIdExistsException e) {
            throw new PaymentWithIdMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    private void checkDepositAccount(PaymentBO paymentBO) throws AccountNotFoundMiddlewareException {
        try {
            this.accountService.getDepositAccountByIban(paymentBO.getDebtorAccount().getIban(), LocalDateTime.now(), false);
        }
        catch (DepositAccountNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountNotFoundMiddlewareException(e.getMessage());
        }
    }

    public Object getPaymentById(String paymentId) throws PaymentNotFoundMiddlewareException {
        try {
            PaymentBO paymentResult = this.paymentService.getPaymentById(paymentId);
            return this.paymentConverter.toPaymentTO(paymentResult);
        }
        catch (PaymentNotFoundException e) {
            logger.error(String.format("Payment with id= %s, not found", paymentId), (Throwable)e);
            throw new PaymentNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public String iban(String paymentId) {
        return this.paymentService.readIbanByPaymentId(paymentId);
    }

    public SCAPaymentResponseTO authorizePayment(String paymentId, String authorisationId, String authCode) throws SCAOperationNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationExpiredMiddlewareException, SCAOperationUsedOrStolenMiddlewareException, PaymentNotFoundMiddlewareException {
        PaymentBO payment = this.payment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(payment);
        TransactionStatusBO tx = payment.getTransactionStatus();
        try {
            this.validateAuthCode(payment, authorisationId, authCode, paymentKeyData.template());
            if (this.scaOperationService.authenticationCompleted(paymentId, OpTypeBO.PAYMENT)) {
                tx = this.paymentService.updatePaymentStatusToAuthorised(paymentId);
                tx = this.paymentService.executePayment(paymentId, this.accessTokenTO.getLogin());
            }
            BearerTokenTO bearerToken = this.paymentAccountAccessToken(payment);
            SCAPaymentResponseTO response = this.toScaPaymentResponse(this.scaUtils.user(), paymentId, tx, paymentKeyData, this.scaUtils.loadAuthCode(authorisationId));
            response.setBearerToken(bearerToken);
            return response;
        }
        catch (PaymentNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    private BearerTokenTO paymentAccountAccessToken(PaymentBO payment) {
        String iban = payment.getDebtorAccount().getIban();
        try {
            AisConsentBO aisConsent = new AisConsentBO();
            AisAccountAccessInfoBO access = new AisAccountAccessInfoBO();
            aisConsent.setAccess(access);
            List<String> asList = Arrays.asList(iban);
            access.setAccounts(asList);
            access.setTransactions(asList);
            access.setBalances(asList);
            aisConsent.setFrequencyPerDay(0);
            aisConsent.setRecurringIndicator(true);
            aisConsent.setUserId(this.accessTokenTO.getLogin());
            AccessTokenBO accessTokenBO = this.accessTokenMapper.toAccessTokenBO(this.accessTokenTO);
            return this.bearerTokenMapper.toBearerTokenTO(this.userService.consentToken(accessTokenBO, aisConsent));
        }
        catch (InsufficientPermissionException e) {
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    public SCAPaymentResponseTO loadSCAForPaymentData(String paymentId, String authorisationId) throws PaymentNotFoundMiddlewareException, SCAOperationExpiredMiddlewareException {
        SCAOperationBO a;
        try {
            a = this.scaOperationService.loadAuthCode(authorisationId);
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationExpiredMiddlewareException(e.getMessage(), (Throwable)e);
        }
        PaymentBO payment = this.payment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(payment);
        return this.toScaPaymentResponse(this.scaUtils.user(), paymentId, payment.getTransactionStatus(), paymentKeyData, a);
    }

    public SCAPaymentResponseTO selectSCAMethodForPayment(String paymentId, String authorisationId, String scaMethodId) throws PaymentNotFoundMiddlewareException, SCAMethodNotSupportedMiddleException, UserScaDataNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationNotFoundMiddlewareException {
        String opData;
        UserBO userBO = this.scaUtils.userBO();
        UserTO userTO = this.scaUtils.user(userBO);
        PaymentBO payment = this.payment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getPaymentCoreData(payment);
        String userMessage = opData = paymentKeyData.template();
        AuthCodeDataBO a = new AuthCodeDataBO(userBO.getLogin(), scaMethodId, paymentId, opData, userMessage, this.defaultLoginTokenExpireInSeconds, OpTypeBO.PAYMENT, authorisationId);
        try {
            SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(a, userBO, ScaStatusBO.SCAMETHODSELECTED);
            return this.toScaPaymentResponse(userTO, paymentId, payment.getTransactionStatus(), paymentKeyData, scaOperationBO);
        }
        catch (SCAMethodNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAMethodNotSupportedMiddleException((Throwable)e);
        }
        catch (UserScaDataNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserScaDataNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            throw new SCAOperationValidationMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public SCAPaymentResponseTO loadSCAForCancelPaymentData(String paymentId, String cancellationId) throws PaymentNotFoundMiddlewareException, SCAOperationExpiredMiddlewareException {
        SCAOperationBO a;
        try {
            a = this.scaOperationService.loadAuthCode(cancellationId);
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationExpiredMiddlewareException(e.getMessage(), (Throwable)e);
        }
        UserTO user = this.scaUtils.user();
        PaymentBO payment = this.payment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(payment);
        return this.toScaPaymentResponse(user, paymentId, payment.getTransactionStatus(), paymentKeyData, a);
    }

    public SCAPaymentResponseTO selectSCAMethodForCancelPayment(String paymentId, String cancellationId, String scaMethodId) throws PaymentNotFoundMiddlewareException, SCAMethodNotSupportedMiddleException, UserScaDataNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationNotFoundMiddlewareException {
        String template;
        UserBO userBO = this.scaUtils.userBO();
        UserTO userTO = this.scaUtils.user(userBO);
        PaymentBO payment = this.payment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(payment);
        String opData = template = paymentKeyData.template();
        String userMessage = template;
        AuthCodeDataBO a = new AuthCodeDataBO(userBO.getLogin(), scaMethodId, paymentId, opData, userMessage, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CANCEL_PAYMENT, cancellationId);
        try {
            SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(a, userBO, ScaStatusBO.SCAMETHODSELECTED);
            return this.toScaPaymentResponse(userTO, paymentId, payment.getTransactionStatus(), paymentKeyData, scaOperationBO);
        }
        catch (SCAMethodNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAMethodNotSupportedMiddleException((Throwable)e);
        }
        catch (UserScaDataNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserScaDataNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            throw new SCAOperationValidationMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public SCAPaymentResponseTO authorizeCancelPayment(String paymentId, String cancellationId, String authCode) throws SCAOperationNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationExpiredMiddlewareException, SCAOperationUsedOrStolenMiddlewareException, PaymentNotFoundMiddlewareException {
        PaymentBO payment = this.payment(paymentId);
        PaymentCoreDataTO paymentKeyData = this.coreDataPolicy.getCancelPaymentCoreData(payment);
        try {
            this.validateAuthCode(payment, cancellationId, authCode, paymentKeyData.template());
            TransactionStatusBO tx = payment.getTransactionStatus();
            if (this.scaOperationService.authenticationCompleted(paymentId, OpTypeBO.CANCEL_PAYMENT)) {
                tx = this.paymentService.cancelPayment(paymentId);
            }
            SCAPaymentResponseTO response = this.toScaPaymentResponse(this.scaUtils.user(), paymentId, tx, paymentKeyData, this.scaUtils.loadAuthCode(cancellationId));
            BearerTokenTO bearerToken = this.paymentAccountAccessToken(payment);
            response.setBearerToken(bearerToken);
            return response;
        }
        catch (PaymentNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    private void validateAuthCode(PaymentBO payment, String authorisationId, String authCode, String template) throws SCAOperationNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationUsedOrStolenMiddlewareException, SCAOperationExpiredMiddlewareException {
        try {
            if (!this.scaOperationService.validateAuthCode(authorisationId, payment.getPaymentId(), template, authCode)) {
                throw new SCAOperationValidationMiddlewareException("Wrong auth code");
            }
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            throw new SCAOperationValidationMiddlewareException((Throwable)e);
        }
        catch (SCAOperationUsedOrStolenException e) {
            throw new SCAOperationUsedOrStolenMiddlewareException((Throwable)e);
        }
        catch (SCAOperationExpiredException e) {
            throw new SCAOperationExpiredMiddlewareException((Throwable)e);
        }
    }

    private PaymentBO payment(String paymentId) throws PaymentNotFoundMiddlewareException {
        try {
            return this.paymentService.getPaymentById(paymentId);
        }
        catch (PaymentNotFoundException e) {
            String message = String.format(PAYMENT_WITH_ID_S_NOT_FOUND, paymentId);
            logger.error(message, (Throwable)e);
            throw new PaymentNotFoundMiddlewareException(message, (Throwable)e);
        }
    }

    private boolean scaRequired(PaymentBO payment, UserBO user, OpTypeBO opType) {
        return this.scaUtils.hasSCA(user);
    }

    private SCAPaymentResponseTO prepareSCA(UserBO user, PaymentBO payment, PaymentCoreDataTO paymentKeyData, OpTypeBO opType) {
        SCAOperationBO scaOperationBO;
        String paymentKeyDataTemplate;
        UserTO userTo = this.scaUtils.user(user);
        String authorisationId = Ids.id();
        String opData = paymentKeyDataTemplate = paymentKeyData.template();
        String userMessage = paymentKeyDataTemplate;
        if (!this.scaRequired(payment, user, opType)) {
            SCAPaymentResponseTO response = new SCAPaymentResponseTO();
            response.setAuthorisationId(authorisationId);
            response.setPaymentId(payment.getPaymentId());
            response.setPsuMessage(paymentKeyData.exemptedTemplate());
            response.setScaStatus(ScaStatusTO.EXEMPTED);
            response.setStatusDate(LocalDateTime.now());
            response.setTransactionStatus(TransactionStatusTO.valueOf((String)payment.getTransactionStatus().name()));
            return response;
        }
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), null, payment.getPaymentId(), opData, userMessage, this.defaultLoginTokenExpireInSeconds, opType, authorisationId);
        if (userTo.getScaUserData().size() == 1) {
            ScaUserDataTO chosenScaMethod = (ScaUserDataTO)userTo.getScaUserData().iterator().next();
            authCodeData.setScaUserDataId(chosenScaMethod.getId());
            try {
                scaOperationBO = this.scaOperationService.generateAuthCode(authCodeData, user, ScaStatusBO.SCAMETHODSELECTED);
            }
            catch (SCAMethodNotSupportedException | SCAOperationNotFoundException | SCAOperationValidationException | UserScaDataNotFoundException e) {
                throw new AccountMiddlewareUncheckedException(e.getMessage(), e);
            }
        } else {
            scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUAUTHENTICATED);
        }
        return this.toScaPaymentResponse(userTo, payment.getPaymentId(), payment.getTransactionStatus(), paymentKeyData, scaOperationBO);
    }

    private SCAPaymentResponseTO toScaPaymentResponse(UserTO user, String paymentId, TransactionStatusBO tx, PaymentCoreDataTO paymentKeyData, SCAOperationBO a) {
        SCAPaymentResponseTO response = new SCAPaymentResponseTO();
        response.setAuthorisationId(a.getId());
        response.setChosenScaMethod(this.scaUtils.getScaMethod(user, a.getScaMethodId()));
        response.setChallengeData(null);
        response.setExpiresInSeconds(a.getValiditySeconds());
        response.setPaymentId(paymentId);
        response.setPsuMessage(paymentKeyData.template());
        response.setScaMethods(user.getScaUserData());
        response.setScaStatus(ScaStatusTO.valueOf((String)a.getScaStatus().name()));
        response.setStatusDate(a.getStatusTime());
        response.setTransactionStatus(TransactionStatusTO.valueOf((String)tx.name()));
        return response;
    }
}

