/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.middleware.api.domain.sca.SCALoginResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.LoginKeyDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.AccountMiddlewareUncheckedException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAMethodNotSupportedMiddleException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationExpiredMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationUsedOrStolenMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationValidationMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserAlreadyExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserScaDataNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareOnlineBankingService;
import de.adorsys.ledgers.middleware.impl.converter.AccessTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.MiddlewarePaymentServiceImpl;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.exception.SCAMethodNotSupportedException;
import de.adorsys.ledgers.sca.exception.SCAOperationExpiredException;
import de.adorsys.ledgers.sca.exception.SCAOperationNotFoundException;
import de.adorsys.ledgers.sca.exception.SCAOperationUsedOrStolenException;
import de.adorsys.ledgers.sca.exception.SCAOperationValidationException;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.domain.UserRoleBO;
import de.adorsys.ledgers.um.api.exception.InsufficientPermissionException;
import de.adorsys.ledgers.um.api.exception.UserAlreadyExistsException;
import de.adorsys.ledgers.um.api.exception.UserNotFoundException;
import de.adorsys.ledgers.um.api.exception.UserScaDataNotFoundException;
import de.adorsys.ledgers.um.api.service.UserService;
import java.time.LocalDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareOnlineBankingServiceImpl
implements MiddlewareOnlineBankingService {
    private static final Logger logger = LoggerFactory.getLogger(MiddlewarePaymentServiceImpl.class);
    private final UserService userService;
    private final UserMapper userTOMapper;
    private final BearerTokenMapper bearerTokenMapper;
    private final AccessTokenMapper accessTokenMapper;
    private final SCAOperationService scaOperationService;
    private final SCAUtils scaUtils;
    private final AccessTokenTO accessTokenTO;
    private int defaultLoginTokenExpireInSeconds = 600;

    public MiddlewareOnlineBankingServiceImpl(UserService userService, UserMapper userTOMapper, BearerTokenMapper bearerTokenMapper, AccessTokenMapper accessTokenMapper, SCAOperationService scaOperationService, SCAUtils scaUtils, AccessTokenTO accessTokenTO) {
        this.userService = userService;
        this.userTOMapper = userTOMapper;
        this.bearerTokenMapper = bearerTokenMapper;
        this.accessTokenMapper = accessTokenMapper;
        this.scaOperationService = scaOperationService;
        this.scaUtils = scaUtils;
        this.accessTokenTO = accessTokenTO;
    }

    public SCALoginResponseTO authorise(String login, String pin, UserRoleTO role) throws UserNotFoundMiddlewareException, InsufficientPermissionMiddlewareException {
        try {
            UserRoleBO roleBo = UserRoleBO.valueOf((String)role.name());
            UserBO user = this.userService.findByLogin(login);
            LoginKeyDataTO keyData = new LoginKeyDataTO(user.getId(), LocalDateTime.now());
            String opId = keyData.toOpId();
            String scaId = keyData.toOpId();
            String opData = opId;
            String authorisationId = opId;
            BearerTokenBO loginTokenBO = this.userService.authorise(login, pin, roleBo, scaId, scaId);
            if (loginTokenBO != null) {
                SCAOperationBO scaOperationBO;
                if (!this.scaRequired(user, OpTypeBO.LOGIN)) {
                    SCALoginResponseTO response = new SCALoginResponseTO();
                    response.setScaStatus(ScaStatusTO.EXEMPTED);
                    BearerTokenBO scaTokenBO = this.userService.scaToken(loginTokenBO.getAccessTokenObject());
                    response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(scaTokenBO));
                    response.setScaId(scaTokenBO.getAccessTokenObject().getScaId());
                    response.setExpiresInSeconds(scaTokenBO.getExpires_in());
                    response.setStatusDate(LocalDateTime.now());
                    return response;
                }
                UserTO userTo = this.scaUtils.user(user);
                String scaUserDataId = null;
                AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), scaUserDataId, scaId, opData, keyData.messageTemplate(), this.defaultLoginTokenExpireInSeconds, OpTypeBO.LOGIN, authorisationId);
                if (userTo.getScaUserData().size() == 1) {
                    ScaUserDataTO chosenScaMethod = (ScaUserDataTO)userTo.getScaUserData().iterator().next();
                    authCodeData.setScaUserDataId(chosenScaMethod.getId());
                    try {
                        scaOperationBO = this.scaOperationService.generateAuthCode(authCodeData, user, ScaStatusBO.SCAMETHODSELECTED);
                    }
                    catch (SCAMethodNotSupportedException | SCAOperationNotFoundException | SCAOperationValidationException | UserScaDataNotFoundException e) {
                        throw new AccountMiddlewareUncheckedException(e.getMessage(), e);
                    }
                } else {
                    scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUIDENTIFIED);
                }
                SCALoginResponseTO response = this.toScaResponse(user, keyData, scaOperationBO);
                this.userService.loginToken(loginTokenBO.getAccessTokenObject(), response.getAuthorisationId());
                response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(loginTokenBO));
                return response;
            }
        }
        catch (UserNotFoundException e) {
            throw new UserNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (InsufficientPermissionException e) {
            throw new InsufficientPermissionMiddlewareException(e.getMessage(), (Throwable)e);
        }
        throw new InsufficientPermissionMiddlewareException("Unknown credentials.");
    }

    public BearerTokenTO validate(String accessToken) throws UserNotFoundMiddlewareException, InsufficientPermissionMiddlewareException {
        try {
            return this.bearerTokenMapper.toBearerTokenTO(this.userService.validate(accessToken, new Date()));
        }
        catch (UserNotFoundException e) {
            throw new UserNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (InsufficientPermissionException e) {
            throw new InsufficientPermissionMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public UserTO register(String login, String email, String pin, UserRoleTO role) throws UserAlreadyExistsMiddlewareException {
        UserTO user = new UserTO(login, email, pin);
        user.getUserRoles().add(role);
        UserBO userBO = this.userTOMapper.toUserBO(user);
        try {
            return this.userTOMapper.toUserTO(this.userService.create(userBO));
        }
        catch (UserAlreadyExistsException e) {
            throw new UserAlreadyExistsMiddlewareException(user, (Throwable)e);
        }
    }

    public SCALoginResponseTO generateLoginAuthCode(String scaUserDataId, String authorisationId, String userMessage, int validitySeconds) throws SCAOperationNotFoundMiddlewareException, InsufficientPermissionMiddlewareException, SCAMethodNotSupportedMiddleException, UserScaDataNotFoundMiddlewareException, SCAOperationValidationMiddlewareException {
        try {
            String opId;
            UserBO user = this.scaUtils.userBO();
            SCAOperationBO scaOperationBO = this.scaOperationService.loadAuthCode(authorisationId);
            LoginKeyDataTO keyData = LoginKeyDataTO.fromOpId((String)scaOperationBO.getOpId());
            String opData = opId = scaOperationBO.getOpId();
            AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), scaUserDataId, opId, opData, userMessage, validitySeconds, OpTypeBO.LOGIN, authorisationId);
            scaOperationBO = this.scaOperationService.generateAuthCode(authCodeData, user, ScaStatusBO.SCAMETHODSELECTED);
            SCALoginResponseTO scaResponse = this.toScaResponse(user, keyData, scaOperationBO);
            BearerTokenBO loginToken = this.userService.loginToken(this.accessTokenMapper.toAccessTokenBO(this.accessTokenTO), authorisationId);
            scaResponse.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(loginToken));
            return scaResponse;
        }
        catch (SCAMethodNotSupportedException e) {
            throw new SCAMethodNotSupportedMiddleException((Throwable)e);
        }
        catch (UserScaDataNotFoundException e) {
            throw new UserScaDataNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAOperationNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAOperationValidationMiddlewareException((Throwable)e);
        }
        catch (InsufficientPermissionException e) {
            throw new InsufficientPermissionMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    public SCALoginResponseTO authenticateForLogin(String authorisationId, String authCode) throws SCAOperationNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationExpiredMiddlewareException, SCAOperationUsedOrStolenMiddlewareException, InsufficientPermissionMiddlewareException {
        try {
            UserBO user = this.scaUtils.userBO();
            SCAOperationBO scaOperationBO = this.scaOperationService.loadAuthCode(authorisationId);
            LoginKeyDataTO keyData = LoginKeyDataTO.fromOpId((String)scaOperationBO.getOpId());
            boolean valid = this.scaOperationService.validateAuthCode(authorisationId, authorisationId, authorisationId, authCode);
            SCALoginResponseTO scaResponse = this.toScaResponse(user, keyData, scaOperationBO);
            if (valid) {
                BearerTokenBO scaToken = this.userService.scaToken(this.accessTokenMapper.toAccessTokenBO(this.accessTokenTO));
                scaResponse.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(scaToken));
            }
            return scaResponse;
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            throw new SCAOperationValidationMiddlewareException((Throwable)e);
        }
        catch (SCAOperationExpiredException e) {
            throw new SCAOperationExpiredMiddlewareException((Throwable)e);
        }
        catch (SCAOperationUsedOrStolenException e) {
            throw new SCAOperationUsedOrStolenMiddlewareException((Throwable)e);
        }
        catch (InsufficientPermissionException e) {
            throw new InsufficientPermissionMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    private SCALoginResponseTO toScaResponse(UserBO user, LoginKeyDataTO keyData, SCAOperationBO a) {
        SCALoginResponseTO response = new SCALoginResponseTO();
        UserTO userTO = this.scaUtils.user(user);
        response.setAuthorisationId(a.getId());
        response.setChosenScaMethod(this.scaUtils.getScaMethod(userTO, a.getScaMethodId()));
        response.setChallengeData(null);
        response.setExpiresInSeconds(a.getValiditySeconds());
        response.setScaId(a.getOpId());
        response.setPsuMessage(keyData.messageTemplate());
        response.setScaMethods(userTO.getScaUserData());
        response.setScaStatus(ScaStatusTO.valueOf((String)a.getScaStatus().name()));
        response.setStatusDate(a.getStatusTime());
        return response;
    }

    private boolean scaRequired(UserBO user, OpTypeBO opType) {
        return this.scaUtils.hasSCA(user);
    }
}

