/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.impl.service;

import de.adorsys.ledgers.deposit.api.domain.DepositAccountBO;
import de.adorsys.ledgers.deposit.api.domain.DepositAccountDetailsBO;
import de.adorsys.ledgers.deposit.api.domain.FundsConfirmationRequestBO;
import de.adorsys.ledgers.deposit.api.domain.TransactionDetailsBO;
import de.adorsys.ledgers.deposit.api.exception.DepositAccountNotFoundException;
import de.adorsys.ledgers.deposit.api.exception.TransactionNotFoundException;
import de.adorsys.ledgers.deposit.api.service.DepositAccountService;
import de.adorsys.ledgers.middleware.api.domain.account.AccountDetailsTO;
import de.adorsys.ledgers.middleware.api.domain.account.FundsConfirmationRequestTO;
import de.adorsys.ledgers.middleware.api.domain.account.TransactionTO;
import de.adorsys.ledgers.middleware.api.domain.payment.AmountTO;
import de.adorsys.ledgers.middleware.api.domain.payment.ConsentKeyDataTO;
import de.adorsys.ledgers.middleware.api.domain.sca.SCAConsentResponseTO;
import de.adorsys.ledgers.middleware.api.domain.sca.ScaStatusTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccessTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.AisConsentTO;
import de.adorsys.ledgers.middleware.api.domain.um.BearerTokenTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserTO;
import de.adorsys.ledgers.middleware.api.exception.AccountMiddlewareUncheckedException;
import de.adorsys.ledgers.middleware.api.exception.AccountNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithPrefixGoneMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AccountWithSuffixExistsMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.AisConsentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.InsufficientPermissionMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.PaymentNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAMethodNotSupportedMiddleException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationExpiredMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationUsedOrStolenMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.SCAOperationValidationMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.TransactionNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.exception.UserScaDataNotFoundMiddlewareException;
import de.adorsys.ledgers.middleware.api.service.MiddlewareAccountManagementService;
import de.adorsys.ledgers.middleware.impl.converter.AccessTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.AccountDetailsMapper;
import de.adorsys.ledgers.middleware.impl.converter.AisConsentBOMapper;
import de.adorsys.ledgers.middleware.impl.converter.AmountMapper;
import de.adorsys.ledgers.middleware.impl.converter.BearerTokenMapper;
import de.adorsys.ledgers.middleware.impl.converter.PaymentConverter;
import de.adorsys.ledgers.middleware.impl.converter.UserMapper;
import de.adorsys.ledgers.middleware.impl.service.AccessService;
import de.adorsys.ledgers.middleware.impl.service.SCAUtils;
import de.adorsys.ledgers.sca.domain.AuthCodeDataBO;
import de.adorsys.ledgers.sca.domain.OpTypeBO;
import de.adorsys.ledgers.sca.domain.SCAOperationBO;
import de.adorsys.ledgers.sca.domain.ScaStatusBO;
import de.adorsys.ledgers.sca.exception.SCAMethodNotSupportedException;
import de.adorsys.ledgers.sca.exception.SCAOperationExpiredException;
import de.adorsys.ledgers.sca.exception.SCAOperationNotFoundException;
import de.adorsys.ledgers.sca.exception.SCAOperationUsedOrStolenException;
import de.adorsys.ledgers.sca.exception.SCAOperationValidationException;
import de.adorsys.ledgers.sca.service.SCAOperationService;
import de.adorsys.ledgers.um.api.domain.AccessTypeBO;
import de.adorsys.ledgers.um.api.domain.AccountAccessBO;
import de.adorsys.ledgers.um.api.domain.AisConsentBO;
import de.adorsys.ledgers.um.api.domain.BearerTokenBO;
import de.adorsys.ledgers.um.api.domain.UserBO;
import de.adorsys.ledgers.um.api.exception.ConsentNotFoundException;
import de.adorsys.ledgers.um.api.exception.InsufficientPermissionException;
import de.adorsys.ledgers.um.api.exception.UserNotFoundException;
import de.adorsys.ledgers.um.api.exception.UserScaDataNotFoundException;
import de.adorsys.ledgers.um.api.service.UserService;
import de.adorsys.ledgers.util.Ids;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MiddlewareAccountManagementServiceImpl
implements MiddlewareAccountManagementService {
    private static final Logger logger = LoggerFactory.getLogger(MiddlewareAccountManagementServiceImpl.class);
    private static final LocalDateTime BASE_TIME = LocalDateTime.MIN;
    private final DepositAccountService depositAccountService;
    private final AccountDetailsMapper accountDetailsMapper;
    private final PaymentConverter paymentConverter;
    private final UserService userService;
    private final UserMapper userMapper;
    private final AisConsentBOMapper aisConsentMapper;
    private final BearerTokenMapper bearerTokenMapper;
    private final AccessTokenMapper accessTokenMapper;
    private final AccessTokenTO accessToken;
    private final SCAOperationService scaOperationService;
    private final SCAUtils scaUtils;
    private final AccessService accessService;
    private int defaultLoginTokenExpireInSeconds = 600;
    private final AmountMapper amountMapper;

    public MiddlewareAccountManagementServiceImpl(DepositAccountService depositAccountService, AccountDetailsMapper accountDetailsMapper, PaymentConverter paymentConverter, UserService userService, UserMapper userMapper, AisConsentBOMapper aisConsentMapper, BearerTokenMapper bearerTokenMapper, AccessTokenMapper accessTokenMapper, AccessTokenTO accessToken, SCAOperationService scaOperationService, SCAUtils scaUtils, AccessService accessService, AmountMapper amountMapper) {
        this.depositAccountService = depositAccountService;
        this.accountDetailsMapper = accountDetailsMapper;
        this.paymentConverter = paymentConverter;
        this.userService = userService;
        this.userMapper = userMapper;
        this.aisConsentMapper = aisConsentMapper;
        this.bearerTokenMapper = bearerTokenMapper;
        this.accessTokenMapper = accessTokenMapper;
        this.accessToken = accessToken;
        this.scaOperationService = scaOperationService;
        this.scaUtils = scaUtils;
        this.accessService = accessService;
        this.amountMapper = amountMapper;
    }

    public void createDepositAccount(AccountDetailsTO depositAccount) throws UserNotFoundMiddlewareException {
        this.createDepositAccount(depositAccount, Collections.emptyList());
    }

    public void createDepositAccount(AccountDetailsTO depositAccount, List<AccountAccessTO> accountAccesss) throws UserNotFoundMiddlewareException {
        try {
            HashMap<String, UserBO> persistBuffer = new HashMap<String, UserBO>();
            DepositAccountBO depositAccountBO = this.depositAccountService.createDepositAccount(this.accountDetailsMapper.toDepositAccountBO(depositAccount), this.accessToken.getSub());
            if (accountAccesss != null) {
                this.accessService.addAccess(accountAccesss, depositAccountBO, persistBuffer);
            }
        }
        catch (DepositAccountNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
        catch (UserNotFoundException e) {
            throw new UserNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public AccountDetailsTO getDepositAccountById(String accountId, LocalDateTime time, boolean withBalance) throws AccountNotFoundMiddlewareException {
        try {
            DepositAccountDetailsBO accountDetailsBO = this.depositAccountService.getDepositAccountById(accountId, time, true);
            return this.accountDetailsMapper.toAccountDetailsTO(accountDetailsBO);
        }
        catch (DepositAccountNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public AccountDetailsTO getDepositAccountByIban(String iban, LocalDateTime time, boolean withBalance) throws AccountNotFoundMiddlewareException {
        try {
            DepositAccountDetailsBO depositAccountBO = this.depositAccountService.getDepositAccountByIban(iban, time, withBalance);
            return this.accountDetailsMapper.toAccountDetailsTO(depositAccountBO);
        }
        catch (DepositAccountNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public List<AccountDetailsTO> getAllAccountDetailsByUserLogin(String userLogin) throws UserNotFoundMiddlewareException, AccountNotFoundMiddlewareException {
        logger.info("Retrieving accounts by user login {}", (Object)userLogin);
        try {
            UserBO userBO = this.userService.findByLogin(userLogin);
            List accountAccess = userBO.getAccountAccesses();
            logger.info("{} accounts were retrieved", (Object)accountAccess.size());
            List ibans = accountAccess.stream().filter(a -> a.getAccessType() == AccessTypeBO.OWNER).map(AccountAccessBO::getIban).collect(Collectors.toList());
            logger.info("{} were accounts were filtered as OWN", (Object)ibans.size());
            List depositAccounts = this.depositAccountService.getDepositAccountsByIban(ibans, BASE_TIME, false);
            logger.info("{} deposit accounts were found", (Object)depositAccounts.size());
            return depositAccounts.stream().map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
        }
        catch (UserNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserNotFoundMiddlewareException(e.getMessage());
        }
        catch (DepositAccountNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new AccountNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public TransactionTO getTransactionById(String accountId, String transactionId) throws TransactionNotFoundMiddlewareException {
        try {
            TransactionDetailsBO transaction = this.depositAccountService.getTransactionById(accountId, transactionId);
            return this.paymentConverter.toTransactionTO(transaction);
        }
        catch (TransactionNotFoundException e) {
            throw new TransactionNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public List<TransactionTO> getTransactionsByDates(String accountId, LocalDate dateFrom, LocalDate dateTo) throws AccountNotFoundMiddlewareException {
        LocalDate today = LocalDate.now();
        LocalDateTime dateTimeFrom = dateFrom == null ? today.atStartOfDay() : dateFrom.atStartOfDay();
        LocalDateTime dateTimeTo = dateTo == null ? this.accessService.getTimeAtEndOfTheDay(today) : this.accessService.getTimeAtEndOfTheDay(dateTo);
        try {
            List transactions = this.depositAccountService.getTransactionsByDates(accountId, dateTimeFrom, dateTimeTo);
            return this.paymentConverter.toTransactionTOList(transactions);
        }
        catch (DepositAccountNotFoundException e) {
            throw new AccountNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean confirmFundsAvailability(FundsConfirmationRequestTO request) throws AccountNotFoundMiddlewareException {
        try {
            FundsConfirmationRequestBO requestBO = this.accountDetailsMapper.toFundsConfirmationRequestBO(request);
            return this.depositAccountService.confirmationOfFunds(requestBO);
        }
        catch (DepositAccountNotFoundException e) {
            throw new AccountNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public void createDepositAccount(String accountNumberPrefix, String accountNumberSuffix, AccountDetailsTO accDetails) throws AccountWithPrefixGoneMiddlewareException, AccountWithSuffixExistsMiddlewareException {
        String accNbr = accountNumberPrefix + accountNumberSuffix;
        List accounts = this.depositAccountService.findByAccountNumberPrefix(accountNumberPrefix);
        this.validateInput(accounts, accountNumberPrefix, accountNumberSuffix);
        accDetails.setIban(accNbr);
        ArrayList<AccountAccessTO> accountAccesses = new ArrayList<AccountAccessTO>();
        if (this.accessToken.getRole() == UserRoleTO.CUSTOMER) {
            UserTO userTO = new UserTO();
            userTO.setId(this.accessToken.getSub());
            userTO.setLogin(this.accessToken.getLogin());
            accountAccesses.add(this.accessService.createAccountAccess(accNbr, userTO));
        }
        try {
            this.createDepositAccount(accDetails, accountAccesses);
        }
        catch (UserNotFoundMiddlewareException e) {
            throw new AccountMiddlewareUncheckedException(String.format("Can not find user with id %s and login", this.accessToken.getSub(), this.accessToken.getLogin()));
        }
    }

    private void validateInput(List<DepositAccountBO> accounts, String accountNumberPrefix, String accountNumberSuffix) throws AccountWithPrefixGoneMiddlewareException, AccountWithSuffixExistsMiddlewareException {
        String accNbr;
        if (accounts.isEmpty()) {
            return;
        }
        List accountAccesses = this.accessToken.getAccountAccesses();
        if (accountAccesses == null || accountAccesses.isEmpty()) {
            throw new AccountWithPrefixGoneMiddlewareException(String.format("Account prefix %s is gone.", accountNumberPrefix));
        }
        List<String> ownedAccounts = this.accessService.filterOwnedAccounts(accountAccesses);
        if (ownedAccounts.contains(accNbr = accountNumberPrefix + accountNumberSuffix)) {
            throw new AccountWithSuffixExistsMiddlewareException(String.format("Account with suffix %S and prefix %s already exist", accountNumberPrefix, accountNumberSuffix));
        }
        for (DepositAccountBO a : accounts) {
            if (!ownedAccounts.contains(a.getIban())) continue;
            throw new AccountWithSuffixExistsMiddlewareException(String.format("User not owner of account with iban %s that also holds the requested prefix %s", a.getIban(), accountNumberPrefix));
        }
    }

    public void grantAccessToDepositAccount(AccountAccessTO accountAccess) throws AccountNotFoundMiddlewareException, InsufficientPermissionMiddlewareException {
        UserBO userBo = this.accessService.loadCurrentUser();
        List<String> ownedAccounts = this.accessService.filterOwnedAccounts(this.accessToken.getAccountAccesses());
        if (!ownedAccounts.contains(accountAccess.getIban())) {
            throw new InsufficientPermissionMiddlewareException(userBo.getId(), userBo.getLogin(), accountAccess.getIban());
        }
        this.accessService.addAccess(userBo, this.userMapper.toAccountAccessBO(accountAccess), new HashMap<String, UserBO>());
    }

    public List<AccountDetailsTO> listOfDepositAccounts() {
        List depositAccounts;
        UserBO user = this.accessService.loadCurrentUser();
        UserTO userTO = this.userMapper.toUserTO(user);
        List accountAccesses = userTO.getAccountAccesses();
        if (accountAccesses == null || accountAccesses.isEmpty()) {
            return Collections.emptyList();
        }
        List ibans = accountAccesses.stream().map(AccountAccessTO::getIban).collect(Collectors.toList());
        try {
            depositAccounts = this.depositAccountService.getDepositAccountsByIban(ibans, LocalDateTime.now(), true);
        }
        catch (DepositAccountNotFoundException e) {
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
        return depositAccounts.stream().map(this.accountDetailsMapper::toAccountDetailsTO).collect(Collectors.toList());
    }

    public String iban(String id) {
        return this.depositAccountService.readIbanById(id);
    }

    public SCAConsentResponseTO startSCA(String consentId, AisConsentTO aisConsent) throws InsufficientPermissionMiddlewareException {
        BearerTokenBO bearerToken = this.checkAisConsent(aisConsent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsent);
        SCAConsentResponseTO response = this.prepareSCA(this.scaUtils.userBO(), aisConsent, consentKeyData);
        if (ScaStatusTO.EXEMPTED.equals((Object)response.getScaStatus())) {
            response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(bearerToken));
        }
        return response;
    }

    public SCAConsentResponseTO loadSCAForAisConsent(String consentId, String authorisationId) throws SCAOperationExpiredMiddlewareException, AisConsentNotFoundMiddlewareException {
        UserTO user = this.scaUtils.user();
        AisConsentBO consent = this.consent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        SCAOperationBO scaOperationBO = this.scaUtils.loadAuthCode(authorisationId);
        return this.toScaConsentResponse(user, consent, consentKeyData.template(), scaOperationBO);
    }

    public SCAConsentResponseTO selectSCAMethodForAisConsent(String consentId, String authorisationId, String scaMethodId) throws PaymentNotFoundMiddlewareException, SCAMethodNotSupportedMiddleException, UserScaDataNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationNotFoundMiddlewareException, AisConsentNotFoundMiddlewareException {
        UserBO userBO = this.scaUtils.userBO();
        UserTO userTO = this.scaUtils.user(userBO);
        AisConsentBO consent = this.consent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        String template = consentKeyData.template();
        AuthCodeDataBO a = new AuthCodeDataBO(userBO.getLogin(), scaMethodId, consentId, template, template, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CONSENT, authorisationId);
        try {
            SCAOperationBO scaOperationBO = this.scaOperationService.generateAuthCode(a, userBO, ScaStatusBO.SCAMETHODSELECTED);
            return this.toScaConsentResponse(userTO, consent, consentKeyData.template(), scaOperationBO);
        }
        catch (SCAMethodNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAMethodNotSupportedMiddleException((Throwable)e);
        }
        catch (UserScaDataNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new UserScaDataNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            throw new SCAOperationValidationMiddlewareException(e.getMessage(), (Throwable)e);
        }
        catch (SCAOperationNotFoundException e) {
            throw new SCAOperationNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public SCAConsentResponseTO authorizeConsent(String consentId, String authorisationId, String authCode) throws SCAOperationNotFoundMiddlewareException, SCAOperationValidationMiddlewareException, SCAOperationExpiredMiddlewareException, SCAOperationUsedOrStolenMiddlewareException, AisConsentNotFoundMiddlewareException {
        AisConsentBO consent = this.consent(consentId);
        AisConsentTO aisConsentTO = this.aisConsentMapper.toAisConsentTO(consent);
        ConsentKeyDataTO consentKeyData = new ConsentKeyDataTO(aisConsentTO);
        try {
            boolean validAuthCode = this.scaOperationService.validateAuthCode(authorisationId, consentId, consentKeyData.template(), authCode);
            if (!validAuthCode) {
                throw new SCAOperationValidationMiddlewareException("Wrong auth code");
            }
            UserBO userBO = this.scaUtils.userBO();
            UserTO userTO = this.scaUtils.user(userBO);
            SCAOperationBO scaOperationBO = this.scaUtils.loadAuthCode(authorisationId);
            SCAConsentResponseTO response = this.toScaConsentResponse(userTO, consent, consentKeyData.template(), scaOperationBO);
            if (this.scaOperationService.authenticationCompleted(consentId, OpTypeBO.CONSENT)) {
                BearerTokenBO consentToken = this.userService.consentToken(this.accessTokenMapper.toAccessTokenBO(this.accessToken), consent);
                response.setBearerToken(this.bearerTokenMapper.toBearerTokenTO(consentToken));
            }
            return response;
        }
        catch (SCAOperationNotFoundException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAOperationNotFoundMiddlewareException((Throwable)e);
        }
        catch (SCAOperationValidationException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAOperationValidationMiddlewareException((Throwable)e);
        }
        catch (SCAOperationExpiredException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAOperationExpiredMiddlewareException((Throwable)e);
        }
        catch (SCAOperationUsedOrStolenException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new SCAOperationUsedOrStolenMiddlewareException((Throwable)e);
        }
        catch (InsufficientPermissionException e) {
            throw new AccountMiddlewareUncheckedException(e.getMessage(), (Throwable)e);
        }
    }

    public BearerTokenTO grantAisConsent(AisConsentTO aisConsent) throws InsufficientPermissionMiddlewareException {
        try {
            BearerTokenBO consentToken = this.userService.consentToken(this.accessTokenMapper.toAccessTokenBO(this.accessToken), this.aisConsentMapper.toAisConsentBO(aisConsent));
            return this.bearerTokenMapper.toBearerTokenTO(consentToken);
        }
        catch (InsufficientPermissionException e) {
            throw new InsufficientPermissionMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    private BearerTokenBO checkAisConsent(AisConsentTO aisConsent) throws InsufficientPermissionMiddlewareException {
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(aisConsent);
        try {
            return this.userService.consentToken(this.accessTokenMapper.toAccessTokenBO(this.accessToken), consentBO);
        }
        catch (InsufficientPermissionException e) {
            throw new InsufficientPermissionMiddlewareException("Not enougth permission for requested consent.", (Throwable)e);
        }
    }

    private boolean scaRequired(AisConsentTO aisConsent, UserBO user, OpTypeBO opType) {
        return this.scaUtils.hasSCA(user);
    }

    private SCAConsentResponseTO prepareSCA(UserBO user, AisConsentTO aisConsent, ConsentKeyDataTO consentKeyData) {
        SCAOperationBO scaOperationBO;
        String consentKeyDataTemplate = consentKeyData.template();
        UserTO userTo = this.scaUtils.user(user);
        String authorisationId = Ids.id();
        if (!this.scaRequired(aisConsent, user, OpTypeBO.CONSENT)) {
            SCAConsentResponseTO response = new SCAConsentResponseTO();
            response.setAuthorisationId(authorisationId);
            response.setConsentId(aisConsent.getId());
            response.setPsuMessage(consentKeyData.exemptedTemplate());
            response.setScaStatus(ScaStatusTO.EXEMPTED);
            response.setStatusDate(LocalDateTime.now());
            return response;
        }
        AuthCodeDataBO authCodeData = new AuthCodeDataBO(user.getLogin(), aisConsent.getId(), aisConsent.getId(), consentKeyDataTemplate, consentKeyDataTemplate, this.defaultLoginTokenExpireInSeconds, OpTypeBO.CONSENT, authorisationId);
        AisConsentBO consentBO = this.aisConsentMapper.toAisConsentBO(aisConsent);
        consentBO = this.userService.storeConsent(consentBO);
        if (userTo.getScaUserData().size() == 1) {
            ScaUserDataTO chosenScaMethod = (ScaUserDataTO)userTo.getScaUserData().iterator().next();
            authCodeData.setScaUserDataId(chosenScaMethod.getId());
            try {
                scaOperationBO = this.scaOperationService.generateAuthCode(authCodeData, user, ScaStatusBO.SCAMETHODSELECTED);
            }
            catch (SCAMethodNotSupportedException | SCAOperationNotFoundException | SCAOperationValidationException | UserScaDataNotFoundException e) {
                throw new AccountMiddlewareUncheckedException(e.getMessage(), e);
            }
        } else {
            scaOperationBO = this.scaOperationService.createAuthCode(authCodeData, ScaStatusBO.PSUAUTHENTICATED);
        }
        return this.toScaConsentResponse(userTo, consentBO, consentKeyDataTemplate, scaOperationBO);
    }

    private SCAConsentResponseTO toScaConsentResponse(UserTO user, AisConsentBO consent, String messageTemplate, SCAOperationBO operation) {
        SCAConsentResponseTO response = new SCAConsentResponseTO();
        response.setAuthorisationId(operation.getId());
        response.setChosenScaMethod(this.scaUtils.getScaMethod(user, operation.getScaMethodId()));
        response.setChallengeData(null);
        response.setExpiresInSeconds(operation.getValiditySeconds());
        response.setConsentId(consent.getId());
        response.setPsuMessage(messageTemplate);
        response.setScaMethods(user.getScaUserData());
        response.setStatusDate(operation.getStatusTime());
        response.setScaStatus(ScaStatusTO.valueOf((String)operation.getScaStatus().name()));
        return response;
    }

    private AisConsentBO consent(String consentId) throws AisConsentNotFoundMiddlewareException {
        try {
            return this.userService.loadConsent(consentId);
        }
        catch (ConsentNotFoundException e) {
            throw new AisConsentNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }

    public void depositCash(String accountId, AmountTO amount) throws AccountNotFoundMiddlewareException {
        try {
            this.depositAccountService.depositCash(accountId, this.amountMapper.toAmountBO(amount), this.accessToken.getLogin());
        }
        catch (DepositAccountNotFoundException e) {
            throw new AccountNotFoundMiddlewareException(e.getMessage(), (Throwable)e);
        }
    }
}

