/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.domain.um;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.adorsys.ledgers.middleware.api.domain.um.AccountAccessTO;
import de.adorsys.ledgers.middleware.api.domain.um.ScaUserDataTO;
import de.adorsys.ledgers.middleware.api.domain.um.UserRoleTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.CollectionUtils;

public class UserTO {
    private String id;
    @NotNull
    private String login;
    @NotNull
    private String email;
    @NotNull
    private String pin;
    private List<ScaUserDataTO> scaUserData = new ArrayList<ScaUserDataTO>();
    private List<AccountAccessTO> accountAccesses = new ArrayList<AccountAccessTO>();
    private Collection<UserRoleTO> userRoles = new ArrayList<UserRoleTO>();
    private String branch;

    @JsonIgnore
    public boolean userHasRoles() {
        return CollectionUtils.isEmpty(this.userRoles);
    }

    public UserTO(String login, String email, String pin) {
        this.login = login;
        this.email = email;
        this.pin = pin;
    }

    @JsonIgnore
    public UserTO updateUserBranch(String newBranch) {
        this.branch = newBranch;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public String getPin() {
        return this.pin;
    }

    public List<ScaUserDataTO> getScaUserData() {
        return this.scaUserData;
    }

    public List<AccountAccessTO> getAccountAccesses() {
        return this.accountAccesses;
    }

    public Collection<UserRoleTO> getUserRoles() {
        return this.userRoles;
    }

    public String getBranch() {
        return this.branch;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public void setScaUserData(List<ScaUserDataTO> scaUserData) {
        this.scaUserData = scaUserData;
    }

    public void setAccountAccesses(List<AccountAccessTO> accountAccesses) {
        this.accountAccesses = accountAccesses;
    }

    public void setUserRoles(Collection<UserRoleTO> userRoles) {
        this.userRoles = userRoles;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public UserTO() {
    }

    public UserTO(String id, String login, String email, String pin, List<ScaUserDataTO> scaUserData, List<AccountAccessTO> accountAccesses, Collection<UserRoleTO> userRoles, String branch) {
        this.id = id;
        this.login = login;
        this.email = email;
        this.pin = pin;
        this.scaUserData = scaUserData;
        this.accountAccesses = accountAccesses;
        this.userRoles = userRoles;
        this.branch = branch;
    }
}

