/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.ledgers.middleware.api.exception;

import de.adorsys.ledgers.middleware.api.exception.MiddlewareErrorCode;
import java.util.function.Supplier;

public class MiddlewareModuleException
extends RuntimeException {
    private final MiddlewareErrorCode errorCode;
    private final String devMsg;

    public static Supplier<MiddlewareModuleException> blockedSupplier(MiddlewareErrorCode code, String iban, boolean isRegularBlock) {
        return () -> MiddlewareModuleException.builder().errorCode(code).devMsg(String.format("Operation is Rejected as account: %s is %s", iban, isRegularBlock ? "BLOCKED" : "TEMPORARILY BLOCKED BY SYSTEM")).build();
    }

    MiddlewareModuleException(MiddlewareErrorCode errorCode, String devMsg) {
        this.errorCode = errorCode;
        this.devMsg = devMsg;
    }

    public static MiddlewareModuleExceptionBuilder builder() {
        return new MiddlewareModuleExceptionBuilder();
    }

    private MiddlewareModuleException() {
        this.errorCode = null;
        this.devMsg = null;
    }

    public MiddlewareErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getDevMsg() {
        return this.devMsg;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MiddlewareModuleException)) {
            return false;
        }
        MiddlewareModuleException other = (MiddlewareModuleException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MiddlewareErrorCode this$errorCode = this.getErrorCode();
        MiddlewareErrorCode other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !((Object)((Object)this$errorCode)).equals((Object)other$errorCode)) {
            return false;
        }
        String this$devMsg = this.getDevMsg();
        String other$devMsg = other.getDevMsg();
        return !(this$devMsg == null ? other$devMsg != null : !this$devMsg.equals(other$devMsg));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MiddlewareModuleException;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MiddlewareErrorCode $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : ((Object)((Object)$errorCode)).hashCode());
        String $devMsg = this.getDevMsg();
        result = result * 59 + ($devMsg == null ? 43 : $devMsg.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "MiddlewareModuleException(errorCode=" + (Object)((Object)this.getErrorCode()) + ", devMsg=" + this.getDevMsg() + ")";
    }

    public static class MiddlewareModuleExceptionBuilder {
        private MiddlewareErrorCode errorCode;
        private String devMsg;

        MiddlewareModuleExceptionBuilder() {
        }

        public MiddlewareModuleExceptionBuilder errorCode(MiddlewareErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public MiddlewareModuleExceptionBuilder devMsg(String devMsg) {
            this.devMsg = devMsg;
            return this;
        }

        public MiddlewareModuleException build() {
            return new MiddlewareModuleException(this.errorCode, this.devMsg);
        }

        public String toString() {
            return "MiddlewareModuleException.MiddlewareModuleExceptionBuilder(errorCode=" + (Object)((Object)this.errorCode) + ", devMsg=" + this.devMsg + ")";
        }
    }
}

